/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.Stateable;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAView;
import de.malban.util.syntax.entities.ASM6809FileMaster;
import de.malban.util.syntax.entities.C6809FileMaster;
import de.malban.vide.vedi.CloseButton;
import de.malban.vide.vedi.CloseEvent;
import de.malban.vide.vedi.CloseListener;
import de.malban.vide.vedi.CustomOutputStream;
import de.malban.vide.vedi.EditorPanel;
import de.malban.vide.vedi.FlushEvent;
import de.malban.vide.vedi.FlushListener;
import de.malban.vide.vedi.VediSettings;
import de.malban.vide.vedi.panels.BinaryPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public abstract class VEdiFoundationPanel
extends JPanel
implements Windowable,
Stateable {
    private static int UID_BASE = 0;
    public final int UID = UID_BASE++;
    protected VediSettings settings = new VediSettings();
    protected CSAView mParent = null;
    protected JMenuItem mParentMenuItem = null;
    protected int mClassSetting = 0;
    protected boolean wrapped = false;
    ASM6809FileMaster asmInfo;
    C6809FileMaster cInfo;
    public CustomOutputStream asmMessagesOut = new CustomOutputStream();
    public CustomOutputStream asmErrorOut;
    public CustomOutputStream asmListOut;
    public CustomOutputStream asmSymbolOut;
    PrintStream asmList;
    PrintStream asmMessages = new PrintStream(this.asmMessagesOut);
    PrintStream asmError;
    PrintStream asmSymbol;
    public static final int ASM_MESSAGE_INFO = 0;
    public static final int ASM_MESSAGE_ERROR = 1;
    public static final int ASM_MESSAGE_WARNING = 2;
    public static final int ASM_MESSAGE_OPTIMIZATION = 3;
    public static final int ASM_LIST = 2;
    public static final int ASM_SYMBOL = 3;

    public JFrame getFrame() {
        return (CSAMainFrame)this.mParent;
    }

    @Override
    public abstract String getID();

    public static VEdiFoundationPanel getVedi(Component o) {
        do {
            if (!(o instanceof VEdiFoundationPanel)) continue;
            return (VEdiFoundationPanel)o;
        } while ((o = o.getParent()) != null);
        return null;
    }

    @Override
    public Serializable getAdditionalStateinfo() {
        return null;
    }

    @Override
    public void setAdditionalStateinfo(Serializable ser) {
    }

    @Override
    public void closing() {
        this.deinit();
    }

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText(this.getID());
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public abstract void deinit();

    public abstract void init();

    public ASM6809FileMaster getAsmInfo() {
        return this.asmInfo;
    }

    public C6809FileMaster getCInfo() {
        return this.cInfo;
    }

    protected void initSyntax() {
        this.asmInfo = ASM6809FileMaster.getInstance(this.UID);
        this.cInfo = C6809FileMaster.getInstance(this.UID);
    }

    protected void deinitSyntax() {
        ASM6809FileMaster.removeInstance(this.UID);
        C6809FileMaster.removeInstance(this.UID);
    }

    public VEdiFoundationPanel() {
        this.asmMessagesOut.setCallback(new FlushListener(){

            @Override
            public void wasFlushed(final FlushEvent ev) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VEdiFoundationPanel.this.printASMMessage(ev.newlyFlushedText, 0);
                    }
                });
            }
        });
        this.asmErrorOut = new CustomOutputStream();
        this.asmError = new PrintStream(this.asmErrorOut);
        this.asmErrorOut.setCallback(new FlushListener(){
            int stateType = 1;

            @Override
            public void wasFlushed(final FlushEvent ev) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ev.newlyFlushedText.indexOf("++++++") >= 0) {
                            stateType = 2;
                        }
                        if (ev.newlyFlushedText.indexOf("******") >= 0) {
                            stateType = 1;
                        }
                        if (ev.newlyFlushedText.indexOf("######") >= 0) {
                            stateType = 3;
                        }
                        VEdiFoundationPanel.this.printASMMessage(ev.newlyFlushedText, stateType);
                    }
                });
            }
        });
        this.asmListOut = new CustomOutputStream();
        this.asmList = new PrintStream(this.asmListOut);
        this.asmListOut.setCallback(new FlushListener(){

            @Override
            public void wasFlushed(final FlushEvent ev) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VEdiFoundationPanel.this.printASMList(ev.newlyFlushedText, 2);
                    }
                });
            }
        });
        this.asmSymbolOut = new CustomOutputStream();
        this.asmSymbol = new PrintStream(this.asmSymbolOut);
        this.asmSymbolOut.setCallback(new FlushListener(){

            @Override
            public void wasFlushed(final FlushEvent ev) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VEdiFoundationPanel.this.printASMList(ev.newlyFlushedText, 3);
                    }
                });
            }
        });
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    protected void addCloseButton(JTabbedPane jTabbedPane1, String name) {
        int index = jTabbedPane1.indexOfTab(name);
        JPanel pnlTab = new JPanel(new GridBagLayout());
        pnlTab.setOpaque(false);
        JLabel lblTitle = new JLabel(name + "  ");
        CloseButton btnClose = new CloseButton();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        pnlTab.add((Component)lblTitle, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        pnlTab.add((Component)btnClose, gbc);
        jTabbedPane1.setTabComponentAt(index, pnlTab);
        btnClose.addCloseListerner(new MyCloseListener(name, jTabbedPane1));
    }

    public String getSettingsName() {
        return "Vedi.ser";
    }

    protected boolean loadSettings() {
        if (!this.isLoadSettings()) {
            return true;
        }
        try {
            VediSettings s;
            this.settings = s = (VediSettings)CSAMainFrame.deserialize(Global.mainPathPrefix + "serialize" + File.separator + this.getSettingsName());
            this.settings.adjustOS();
            if (this.settings == null) {
                return false;
            }
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isLoadSettings() {
        return true;
    }

    protected boolean saveSettings() {
        if (!this.isLoadSettings()) {
            return true;
        }
        try {
            this.settings.relativePaths();
            CSAMainFrame.serialize(this.settings, Global.mainPathPrefix + "serialize" + File.separator + this.getSettingsName());
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public abstract void printMessage(String var1);

    public abstract void printWarning(String var1);

    public abstract void printError(String var1);

    public abstract void printASMList(String var1, int var2);

    public abstract void printASMMessage(String var1, int var2);

    protected abstract boolean closeRequested(String var1);

    public abstract void doQuickHelp(String var1, String var2);

    public abstract void tabChanged(boolean var1);

    public abstract void changeFileName(String var1, String var2);

    public abstract void processIncludeLine(String var1);

    public abstract void processWord(String var1);

    public abstract void requestSearchFocus();

    protected abstract void deselectInTree(String var1);

    public abstract void run();

    public abstract void debug();

    public Point getEditorPos() {
        Point p = new Point();
        return p;
    }

    public class MyCloseListener
    implements CloseListener {
        private String tabName;
        JTabbedPane jTabbedPane1;

        public MyCloseListener(String tabName, JTabbedPane j) {
            this.tabName = tabName;
            this.jTabbedPane1 = j;
        }

        @Override
        public void renameTo(String newFilename) {
            this.tabName = newFilename;
        }

        public String getTabName() {
            return this.tabName;
        }

        @Override
        public boolean closeRequested(CloseEvent evt) {
            int index = this.jTabbedPane1.indexOfTab(this.getTabName());
            if (index >= 0 && VEdiFoundationPanel.this.closeRequested(this.tabName)) {
                JPanel edi;
                Component comp = this.jTabbedPane1.getComponentAt(index);
                if (comp instanceof EditorPanel) {
                    edi = (EditorPanel)comp;
                    ((EditorPanel)edi).stopColoring();
                }
                if (comp instanceof BinaryPanel) {
                    edi = (BinaryPanel)comp;
                    ((BinaryPanel)edi).deinit();
                }
                VEdiFoundationPanel.this.deselectInTree(this.getTabName());
                this.jTabbedPane1.removeTabAt(index);
                evt.source.removeCloseListerner(this);
                evt.source.removeUIListerner();
            }
            return true;
        }
    }
}

