/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi;

import de.malban.util.Utility;
import de.malban.util.UtilityFiles;
import de.malban.vide.vedi.Bookmark;
import de.malban.vide.vedi.DebugCommentList;
import de.malban.vide.vedi.EditorFileSettings;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class VediSettings
implements Serializable {
    public int pos1 = 0;
    public int pos2 = 0;
    public int pos3 = 0;
    public int inventoryPos = 0;
    public String vec32PortName = "";
    public String vec32UsbMount = "";
    public boolean showMacroDefinition = false;
    public boolean showEQULabel = false;
    public boolean showEqualLabel = false;
    public boolean showSetLabel = false;
    public boolean showStructLabel = false;
    public boolean showInStructLabel = false;
    public boolean showLineLabel = false;
    public boolean showDataLabel = false;
    public boolean showMacroLabel = false;
    public boolean showFunctionLabel = true;
    public boolean showUserLabel = true;
    public String v4eVolumeName = "";
    public boolean v4eEnabled = false;
    public boolean piTrexEnabled = false;
    int fontSize = 12;
    public HashMap<Integer, Bookmark> bookmarks = new HashMap();
    public HashMap<String, DebugCommentList> allDebugComments = new HashMap();
    ArrayList<EditorFileSettings> currentOpenFiles = new ArrayList();
    ArrayList<EditorFileSettings> recentOpenFiles = new ArrayList();
    ArrayList<P> recentProject = new ArrayList();
    P currentProject;

    public void setOpenPosition(String fn, int pos) {
        EditorFileSettings set = this.getOpen(fn = Utility.makeVideRelative(fn));
        if (set != null) {
            set.position = pos;
        }
    }

    public EditorFileSettings getOpen(String fn) {
        fn = Utility.makeVideRelative(fn);
        for (EditorFileSettings set : this.currentOpenFiles) {
            if (!set.filename.toLowerCase().equals(fn.toLowerCase())) continue;
            return set;
        }
        return null;
    }

    public EditorFileSettings getRecent(String fn) {
        fn = Utility.makeVideRelative(fn);
        for (EditorFileSettings set : this.recentOpenFiles) {
            if (!set.filename.toLowerCase().equals(fn.toLowerCase())) continue;
            return set;
        }
        return null;
    }

    public boolean openContains(String fn) {
        return this.getOpen(fn) != null;
    }

    public boolean recentContains(String fn) {
        return this.getRecent(fn) != null;
    }

    public EditorFileSettings addOpen(String fn, int pos) {
        EditorFileSettings edi = this.getOpen(fn = Utility.makeVideRelative(fn));
        if (edi == null) {
            edi = new EditorFileSettings();
            this.currentOpenFiles.add(edi);
        }
        edi.filename = fn;
        edi.position = pos;
        this.removeRecent(fn);
        this.addRecent(fn, pos);
        return edi;
    }

    public EditorFileSettings addRecent(String fn, int pos) {
        EditorFileSettings edi = this.getOpen(fn = Utility.makeVideRelative(fn));
        if (edi == null) {
            edi = new EditorFileSettings();
            this.recentOpenFiles.add(edi);
        }
        edi.filename = fn;
        edi.position = pos;
        return edi;
    }

    public boolean removeOpen(String fn) {
        fn = Utility.makeVideRelative(fn);
        for (EditorFileSettings set : this.currentOpenFiles) {
            if (!set.filename.equals(fn)) continue;
            this.currentOpenFiles.remove(set);
            return true;
        }
        return false;
    }

    public boolean removeRecent(String fn) {
        fn = Utility.makeVideRelative(fn);
        for (EditorFileSettings set : this.recentOpenFiles) {
            if (!set.filename.equals(fn)) continue;
            this.recentOpenFiles.remove(set);
            return true;
        }
        return false;
    }

    public void addProject(String n, String c, String pp) {
        P _new = new P(n, c, pp);
        for (P p : this.recentProject) {
            if (!p.equals(_new)) continue;
            return;
        }
        this.recentProject.add(_new);
    }

    public void setCurrentProject(String n, String c, String p) {
        this.currentProject = new P(n, c, p);
    }

    public void adjustOS() {
        if (this.currentProject != null) {
            this.currentProject.mFullPath = UtilityFiles.convertSeperator(this.currentProject.mFullPath);
        }
        for (P p : this.recentProject) {
            p.mFullPath = UtilityFiles.convertSeperator(p.mFullPath);
        }
        for (EditorFileSettings set : this.currentOpenFiles) {
            set.filename = UtilityFiles.convertSeperator(set.filename);
        }
        for (EditorFileSettings set : this.recentOpenFiles) {
            set.filename = UtilityFiles.convertSeperator(set.filename);
        }
        Set<Map.Entry<Integer, Bookmark>> entries = this.bookmarks.entrySet();
        for (Map.Entry<Integer, Bookmark> entry : entries) {
            Bookmark value = entry.getValue();
            value.fullFilename = UtilityFiles.convertSeperator(value.fullFilename);
        }
    }

    public void relativePaths() {
        if (this.currentProject != null) {
            this.currentProject.mFullPath = Utility.makeVideRelative(this.currentProject.mFullPath);
        }
        for (P p : this.recentProject) {
            p.mFullPath = Utility.makeVideRelative(p.mFullPath);
        }
        for (EditorFileSettings set : this.currentOpenFiles) {
            set.filename = Utility.makeVideRelative(set.filename);
        }
        for (EditorFileSettings set : this.recentOpenFiles) {
            set.filename = Utility.makeVideRelative(set.filename);
        }
        Set<Map.Entry<Integer, Bookmark>> entries = this.bookmarks.entrySet();
        for (Map.Entry<Integer, Bookmark> entry : entries) {
            Bookmark value = entry.getValue();
            value.fullFilename = Utility.makeVideRelative(value.fullFilename);
        }
    }

    public static class P
    implements Serializable {
        String mName;
        String mClass;
        String mFullPath;

        public P(String n, String c, String p) {
            this.mName = n;
            this.mClass = c;
            this.mFullPath = p;
        }

        public String toString() {
            Path p = Paths.get(this.mName, new String[0]);
            return p.getFileName().toString();
        }

        public boolean equals(P other) {
            return other.mName.equals(this.mName);
        }
    }
}

