/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi.peeper;

import de.malban.util.XMLSupport;
import de.malban.vide.dissy.DASM6809;
import de.malban.vide.vedi.peeper.ASMLine;
import de.malban.vide.vedi.peeper.PeepRule;

public class OnePeepRule {
    public static final int RULE_NONE = 0;
    public static final int RULE_MNEMONIC_CONTAINS = 1;
    public static final int RULE_FIRST_OPERAND_EQUALS = 2;
    public static final int RULE_SECOND_OPERAND_EQUALS = 3;
    public static final int RULE_FIRST_REG_CONTAINS = 4;
    public static final int RULE_SECOND_REG_CONTAINS = 5;
    public static final int RULE_IS_LOAD = 6;
    public static final int RULE_OPERAND_ALL_EQUALS = 7;
    public static final int RULE_OPERAND_ALL_CONTAINS = 8;
    public static final int RULE_STORE_LOAD_REG_EQUALS = 9;
    public static final int RULE_ORG_LINE_CONTAINS = 10;
    public static final int RULE_IS_STORE = 11;
    public static final int RULE_IS_LEA = 12;
    public static final int RULE_FIRST_REG_NOTCONTAINS = 13;
    public static final int RULE_SECOND_REG_NOTCONTAINS = 14;
    public static final int RULE_NO_INDEX_CHANGE = 15;
    public static final int RULE_STORE_LOAD_REG_NOTEQUALS = 16;
    public static final int RULE_FIRST_OPERAND_NOTEQUALS = 17;
    public static final int RULE_SECOND_OPERAND_NOTEQUALS = 18;
    public static final int RULE_NO_BRANCH = 19;
    public static final int RULE_NO_REGISTER_CHANGE = 20;
    public static final int RULE_IS_IMMEDIATE = 21;
    public static final int RULE_IS_EXTENED = 22;
    public static final int RULE_PAGE_EQUALS = 23;
    public static final int RULE_FIRST_OPERAND_STARTSWITH = 24;
    public static final String[] TYPES = new String[]{"RULE_NONE", "RULE_MNEMONIC_CONTAINS", "RULE_FIRST_OPERAND_EQUALS", "RULE_SECOND_OPERAND_EQUALS", "RULE_FIRST_REG_CONTAINS", "RULE_SECOND_REG_CONTAINS", "RULE_IS_LOAD", "RULE_OPERAND_ALL_EQUALS", "RULE_OPERAND_ALL_CONTAINS", "RULE_STORE_LOAD_REG_EQUALS", "RULE_ORG_LINE_CONTAINS", "RULE_IS_STORE", "RULE_IS_LEA", "RULE_FIRST_REG_NOTCONTAINS", "RULE_SECOND_REG_NOTCONTAINS", "RULE_NO_INDEX_CHANGE", "RULE_STORE_LOAD_REG_NOTEQUALS", "RULE_FIRST_OPERAND_NOTEQUALS", "RULE_SECOND_OPERAND_NOTEQUALS", "RULE_NO_BRANCH", "RULE_NO_REGISTER_CHANGE", "RULE_IS_IMMEDIATE", "RULE_IS_EXTENED", "RULE_PAGE_EQUALS", "RULE_FIRST_OPERAND_STARTSWITH"};
    int type = 0;
    String compareValue = "";
    int order = 0;

    OnePeepRule doClone() {
        OnePeepRule ret = new OnePeepRule();
        ret.type = this.type;
        ret.compareValue = this.compareValue;
        ret.order = this.order;
        return ret;
    }

    private OnePeepRule() {
    }

    public OnePeepRule(int t, int o) {
        this.type = t;
        this.compareValue = "";
        this.order = o;
    }

    public OnePeepRule(int t, String c, int o) {
        this.type = t;
        this.compareValue = c;
        this.order = o;
    }

    boolean isTrue(ASMLine line, PeepRule r) {
        String realValue = r.getValue(this.compareValue).toLowerCase();
        if (this.type == 0) {
            return true;
        }
        if (realValue == null) {
            return false;
        }
        switch (this.type) {
            case 1: {
                return line.mnenomic.contains(realValue);
            }
            case 2: {
                return line.first.equals(realValue);
            }
            case 24: {
                return line.first.startsWith(realValue);
            }
            case 3: {
                return line.second.equals(realValue);
            }
            case 17: {
                return !line.first.equals(realValue);
            }
            case 18: {
                return !line.second.equals(realValue);
            }
            case 4: {
                return line.firstReg.contains(realValue);
            }
            case 5: {
                return line.secondReg.contains(realValue);
            }
            case 13: {
                return !line.firstReg.contains(realValue);
            }
            case 14: {
                return !line.secondReg.contains(realValue);
            }
            case 6: {
                return line.isLoad;
            }
            case 7: {
                return line.operandAll.equals(realValue);
            }
            case 8: {
                return line.operandAll.contains(realValue);
            }
            case 9: {
                return line.storeLoadReg.equals(realValue);
            }
            case 16: {
                return !line.storeLoadReg.equals(realValue);
            }
            case 10: {
                return line.org.contains(realValue);
            }
            case 11: {
                return line.isStore;
            }
            case 12: {
                return line.isLea;
            }
            case 15: {
                return !line.isIndexChange;
            }
            case 19: {
                return !line.isBranch;
            }
            case 20: {
                return line.isRegSave;
            }
            case 21: {
                return line.isImmediate;
            }
            case 22: {
                return line.isExtended;
            }
            case 23: {
                return line.page == DASM6809.toNumber(realValue);
            }
        }
        return false;
    }

    public static OnePeepRule readRuleFromXML(StringBuilder xml, XMLSupport xmlSupport) {
        if (xml == null) {
            return null;
        }
        if (xml.length() == 0) {
            return null;
        }
        OnePeepRule rule = new OnePeepRule();
        if (rule.fromXML(xml, xmlSupport)) {
            return rule;
        }
        return null;
    }

    public boolean toXML(StringBuilder s, String tag) {
        s.append("<").append(tag).append(">\n");
        boolean ok = true;
        ok &= XMLSupport.addElement(s, "type", this.type);
        ok &= XMLSupport.addElement(s, "order", this.order);
        s.append("</").append(tag).append(">\n");
        return ok &= XMLSupport.addElement(s, "compareValue", this.compareValue);
    }

    public boolean fromXML(StringBuilder xml, XMLSupport xmlSupport) {
        int errorCode = 0;
        this.type = xmlSupport.getIntElement("type", xml);
        errorCode |= xmlSupport.errorCode;
        this.order = xmlSupport.getIntElement("order", xml);
        errorCode |= xmlSupport.errorCode;
        this.compareValue = xmlSupport.getStringElement("compareValue", xml);
        return (errorCode |= xmlSupport.errorCode) == 0;
    }
}

