/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi.peeper;

import de.malban.util.UtilityString;
import de.malban.util.XMLSupport;
import de.malban.vide.vedi.peeper.ASMLine;
import de.malban.vide.vedi.peeper.CombinedPeepRule;
import de.malban.vide.vedi.peeper.OneResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class PeepRule {
    int order;
    boolean active = true;
    String name;
    String longName;
    String comment = "";
    int finalAdd = 0;
    int invalidLineBetween = 0;
    int linesTillRuleActive = 0;
    ArrayList<CombinedPeepRule> rules = new ArrayList();
    ArrayList<OneResult> results = new ArrayList();
    ArrayList<ASMLine> inputLines = null;
    ArrayList<ASMLine> outPutOnly = null;
    ArrayList<ASMLine> labelLinesOnly = null;
    ArrayList<ASMLine> orgInput = null;

    PeepRule doClone() {
        PeepRule ret = new PeepRule();
        ret.order = this.order;
        ret.active = this.active;
        ret.name = this.name;
        ret.longName = this.longName;
        ret.comment = this.comment;
        ret.finalAdd = this.finalAdd;
        ret.invalidLineBetween = this.invalidLineBetween;
        ret.linesTillRuleActive = this.linesTillRuleActive;
        for (CombinedPeepRule rule : this.rules) {
            ret.rules.add(rule.doClone());
        }
        for (OneResult result : this.results) {
            ret.results.add(result.doClone());
        }
        ret.reorderRuleList();
        ret.reorderResultList();
        return ret;
    }

    void unClone(PeepRule ret) {
        ret.order = this.order;
        ret.active = this.active;
        ret.name = this.name;
        ret.longName = this.longName;
        ret.comment = this.comment;
        ret.finalAdd = this.finalAdd;
        ret.invalidLineBetween = this.invalidLineBetween;
        ret.linesTillRuleActive = this.linesTillRuleActive;
        ret.rules.clear();
        for (CombinedPeepRule rule : this.rules) {
            ret.rules.add(rule.doClone());
        }
        ret.results.clear();
        for (OneResult result : this.results) {
            ret.results.add(result.doClone());
        }
        ret.reorderRuleList();
        ret.reorderResultList();
    }

    private PeepRule() {
    }

    public PeepRule(int o, String n, String c, int fa, ArrayList<CombinedPeepRule> ru, ArrayList<OneResult> res) {
        this.order = o;
        this.name = n;
        this.longName = c;
        this.rules = ru;
        this.results = res;
        this.finalAdd = fa;
        this.reorderRuleList();
        this.reorderResultList();
    }

    public int getLoadedLines() {
        if (this.inputLines == null) {
            return 0;
        }
        return this.inputLines.size();
    }

    public String getValue(String t) {
        if (!t.startsWith("%")) {
            return t;
        }
        if (t.length() < 3) {
            return null;
        }
        t = t.substring(1);
        String lineNoS = t.substring(0, 1);
        t = t.substring(1);
        int lineNo = UtilityString.IntX(lineNoS, -1);
        if (lineNo == -1) {
            return null;
        }
        if (lineNo > this.inputLines.size()) {
            return null;
        }
        ASMLine l = this.inputLines.get(lineNo);
        if (t.startsWith("m")) {
            return l.mnenomic;
        }
        if (t.startsWith("o1")) {
            return l.first;
        }
        if (t.startsWith("o2")) {
            return l.second;
        }
        if (t.startsWith("r1")) {
            return l.first;
        }
        if (t.startsWith("r2")) {
            return l.second;
        }
        if (t.startsWith("oAll")) {
            return l.operandAll;
        }
        if (t.startsWith("rsl")) {
            return l.storeLoadReg;
        }
        if (t.startsWith("org")) {
            return l.org;
        }
        if (t.startsWith("comment")) {
            return l.comment;
        }
        return null;
    }

    public String getValueOrg(String t) {
        if (!t.startsWith("%")) {
            return t;
        }
        if (t.length() < 3) {
            return null;
        }
        t = t.substring(1);
        String lineNoS = t.substring(0, 1);
        t = t.substring(1);
        int lineNo = UtilityString.IntX(lineNoS, -1);
        if (lineNo == -1) {
            return null;
        }
        if (lineNo > this.inputLines.size()) {
            return null;
        }
        ASMLine l = this.inputLines.get(lineNo);
        if (t.startsWith("m")) {
            return l.mnenomic;
        }
        if (t.startsWith("o1")) {
            return l.firstOrg;
        }
        if (t.startsWith("o2")) {
            return l.secondOrg;
        }
        if (t.startsWith("r1")) {
            return l.first;
        }
        if (t.startsWith("r2")) {
            return l.second;
        }
        if (t.startsWith("oAll")) {
            return l.operandAllOrg;
        }
        if (t.startsWith("rsl")) {
            return l.storeLoadReg;
        }
        if (t.startsWith("org")) {
            return l.org;
        }
        if (t.startsWith("comment")) {
            return l.comment;
        }
        return null;
    }

    public static PeepRule readRuleFromXML(StringBuilder xml, XMLSupport xmlSupport) {
        if (xml == null) {
            return null;
        }
        if (xml.length() == 0) {
            return null;
        }
        PeepRule rule = new PeepRule();
        if (rule.fromXML(xml, xmlSupport)) {
            return rule;
        }
        return null;
    }

    public boolean toXML(StringBuilder s, String tag) {
        s.append("<").append(tag).append(">\n");
        boolean ok = true;
        ok &= XMLSupport.addElement(s, "name", this.name);
        ok &= XMLSupport.addElement(s, "longName", this.longName);
        ok &= XMLSupport.addElement(s, "order", this.order);
        ok &= XMLSupport.addElement(s, "finalAdd", this.finalAdd);
        ok &= XMLSupport.addElement(s, "active", this.active);
        ok &= XMLSupport.addElement(s, "comment", this.comment);
        for (CombinedPeepRule rule : this.rules) {
            ok &= rule.toXML(s, "CombinedPeepRule");
        }
        for (OneResult result : this.results) {
            ok &= result.toXML(s, "OneResult");
        }
        s.append("</").append(tag).append(">\n");
        return ok;
    }

    public boolean fromXML(StringBuilder xml, XMLSupport xmlSupport) {
        int errorCode = 0;
        this.rules = new ArrayList();
        this.name = xmlSupport.getStringElement("name", xml);
        errorCode |= xmlSupport.errorCode;
        this.longName = xmlSupport.getStringElement("longName", xml);
        errorCode |= xmlSupport.errorCode;
        this.comment = xmlSupport.getStringElement("comment", xml);
        errorCode |= xmlSupport.errorCode;
        this.order = xmlSupport.getIntElement("order", xml);
        errorCode |= xmlSupport.errorCode;
        this.finalAdd = xmlSupport.getIntElement("finalAdd", xml);
        errorCode |= xmlSupport.errorCode;
        this.active = xmlSupport.getBooleanElement("active", xml);
        errorCode |= xmlSupport.errorCode;
        CombinedPeepRule rule = null;
        do {
            xmlSupport.errorCode = 0;
            xmlSupport.beQuiet(true);
            rule = CombinedPeepRule.readRuleFromXML(xmlSupport.getXMLElement("CombinedPeepRule", xml), xmlSupport);
            xmlSupport.beQuiet(false);
            if (rule != null) {
                errorCode |= xmlSupport.errorCode;
                this.rules.add(rule);
                continue;
            }
            xmlSupport.errorCode = 0;
        } while (rule != null);
        OneResult result = null;
        do {
            xmlSupport.errorCode = 0;
            xmlSupport.beQuiet(true);
            result = OneResult.readResultFromXML(xmlSupport.getXMLElement("OneResult", xml), xmlSupport);
            xmlSupport.beQuiet(false);
            if (result != null) {
                errorCode |= xmlSupport.errorCode;
                this.results.add(result);
                continue;
            }
            xmlSupport.errorCode = 0;
        } while (result != null);
        if (errorCode != 0) {
            this.rules = new ArrayList();
            this.results = new ArrayList();
            return false;
        }
        this.reorderRuleList();
        return true;
    }

    void reorderRuleList() {
        for (CombinedPeepRule rule : this.rules) {
            rule.reorderList();
        }
        Collections.sort(this.rules, new Comparator<CombinedPeepRule>(){

            @Override
            public int compare(CombinedPeepRule rule1, CombinedPeepRule rule2) {
                return rule1.line - rule2.line;
            }
        });
    }

    void reorderResultList() {
        Collections.sort(this.results, new Comparator<OneResult>(){

            @Override
            public int compare(OneResult result1, OneResult result2) {
                return result1.line - result2.line;
            }
        });
    }

    public void setLines(ArrayList<ASMLine> il) {
        this.invalidLineBetween = 0;
        this.inputLines = new ArrayList();
        this.labelLinesOnly = new ArrayList();
        this.outPutOnly = new ArrayList();
        this.orgInput = new ArrayList();
        for (ASMLine l : il) {
            this.orgInput.add(l);
            if (l.label.length() != 0) {
                this.labelLinesOnly.add(l);
            } else {
                this.labelLinesOnly.add(null);
            }
            if (l.mnenomic.length() == 0) {
                this.outPutOnly.add(l);
                continue;
            }
            this.outPutOnly.add(null);
            this.inputLines.add(l);
        }
    }

    boolean isRuleValid() {
        boolean valid = true;
        for (CombinedPeepRule rule : this.rules) {
            int line = rule.line;
            if (this.inputLines.size() <= line) {
                return false;
            }
            valid = rule.isTrue(this.inputLines.get(line), this);
            if (valid) continue;
            return false;
        }
        if (valid) {
            int counter = 0;
            int uid = -1;
            int lastMatchedLine = 0;
            for (ASMLine org2 : this.inputLines) {
                if (++counter != this.finalAdd + 1) continue;
                uid = org2.uid;
                break;
            }
            for (ASMLine org2 : this.orgInput) {
                ++lastMatchedLine;
                if (org2.mnenomic.length() == 0) {
                    ++this.invalidLineBetween;
                }
                if (org2.uid != uid) continue;
                break;
            }
            for (int i = 0; i < lastMatchedLine; ++i) {
                if (this.labelLinesOnly.get(i) == null) continue;
                return false;
            }
        }
        return valid;
    }

    void addResult(ArrayList<String> outLines) {
        int lastMatchedLine = 0;
        int counter = 0;
        int uid = -1;
        outLines.add("; Applied peep: " + this.name + " (" + this.longName + ")");
        for (ASMLine aSMLine : this.inputLines) {
            if (++counter != this.finalAdd + 1) continue;
            uid = aSMLine.uid;
            break;
        }
        for (ASMLine aSMLine : this.orgInput) {
            ++lastMatchedLine;
            if (aSMLine.uid != uid) continue;
            break;
        }
        for (int i = 0; i < lastMatchedLine; ++i) {
            if (this.outPutOnly.get(i) == null) continue;
            outLines.add(this.outPutOnly.get((int)i).org);
        }
        for (OneResult oneResult : this.results) {
            outLines.add(oneResult.getResultString(this));
        }
        for (int i = 0; i < lastMatchedLine; ++i) {
            String string = UtilityString.replace(this.orgInput.get((int)i).org, "#ENR#", "$ENR$");
            outLines.add("; ORG>" + string);
        }
    }

    public int getFinalAdd() {
        return this.finalAdd + this.invalidLineBetween;
    }
}

