/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi.project;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.HotKey;
import de.malban.gui.components.ModalInternalFrame;
import de.malban.util.Utility;
import de.malban.vide.script.ExecutionDescriptor;
import de.malban.vide.script.ExportData;
import de.malban.vide.script.ExportDataPool;
import de.malban.vide.script.ScriptDataPanel;
import de.malban.vide.vedi.VediPanel;
import de.malban.vide.vedi.project.FileProperties;
import de.malban.vide.vedi.project.FilePropertiesPool;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class FilePropertiesPanel
extends JPanel {
    private ExportDataPool mExportDataPool;
    private FileProperties mFileProperties = new FileProperties();
    private FilePropertiesPool mFilePropertiesPool;
    private int mClassSetting = 0;
    String type = "";
    String pathFull = "";
    String pathOnly = "";
    String relFull = "";
    String relOnly = "";
    String filenameOnly = "";
    String filenameBaseOnly = "";
    VediPanel vedi = null;
    private JButton jButtonAction;
    public JButton jButtonCancel;
    public JButton jButtonCreate;
    private JButton jButtonDelete;
    private JButton jButtonNew;
    private JButton jButtonPost;
    private JButton jButtonPre;
    private JButton jButtonSave;
    private JButton jButtonSaveAsNew;
    private JCheckBox jCheckBox1;
    private JComboBox jComboBoxActionClass;
    private JComboBox jComboBoxActionName;
    private JComboBox jComboBoxKlasse;
    private JComboBox jComboBoxName;
    private JComboBox jComboBoxPostClass;
    private JComboBox jComboBoxPostName;
    private JComboBox jComboBoxPreClass;
    private JComboBox jComboBoxPreName;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private JTextArea jTextAreaDescription;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextFieldFlags;
    private JTextField jTextFieldKlasse;
    private JTextField jTextFieldName;
    private JTextField jTextFieldParam1;
    private JTextField jTextFieldParam2;
    private JTextField jTextFieldParam3;
    private JTextField jTextFieldVersion;
    ModalInternalFrame modelDialog;

    public FilePropertiesPanel() {
        this.initComponents();
        this.mFilePropertiesPool = new FilePropertiesPool();
        this.resetConfigPool(false, "");
        this.jPanel1.setVisible(false);
        if (Global.getOSName().toUpperCase().contains("MAC")) {
            HotKey.addMacDefaults(this.jTextField1);
            HotKey.addMacDefaults(this.jTextField2);
            HotKey.addMacDefaults(this.jTextFieldVersion);
            HotKey.addMacDefaults(this.jTextFieldFlags);
            HotKey.addMacDefaults(this.jTextFieldParam1);
            HotKey.addMacDefaults(this.jTextFieldParam2);
            HotKey.addMacDefaults(this.jTextFieldParam3);
        }
    }

    public void setFile(String path) {
        Path p = Paths.get(path, new String[0]);
        this.pathFull = p.toString();
        this.relFull = Utility.makeVideRelative(this.pathFull);
        this.pathOnly = p.getParent().toString();
        this.relOnly = Utility.makeVideRelative(this.pathOnly);
        if (this.pathOnly.length() != 0) {
            this.pathOnly = this.pathOnly + File.separator;
        }
        if (this.relOnly.length() != 0) {
            this.relOnly = this.relOnly + File.separator;
        }
        this.filenameOnly = p.getFileName().toString();
        if (this.filenameOnly.contains(".")) {
            this.filenameBaseOnly = this.filenameOnly.substring(0, this.filenameOnly.indexOf("."));
            this.type = this.filenameOnly.substring(this.filenameOnly.indexOf(".") + 1);
        } else {
            this.filenameBaseOnly = this.filenameOnly;
        }
        this.mFilePropertiesPool = new FilePropertiesPool(this.pathOnly, this.filenameBaseOnly + "FileProperty.xml");
        this.mFileProperties = this.mFilePropertiesPool.get(this.filenameOnly);
        if (this.mFileProperties == null) {
            this.mFileProperties = new FileProperties();
            this.mFileProperties.mClass = "FileProperty";
            this.mFileProperties.mName = this.filenameOnly;
        } else {
            this.jButtonCreate.setText("ok");
            this.jButtonCreate.setName("ok");
        }
        this.jTextField2.setText(this.relFull);
        this.mFileProperties.mFilename = this.relFull;
        this.jTextField1.setText(this.type);
        this.setAllFromCurrent();
    }

    public void setVedi(VediPanel v) {
        this.vedi = v;
    }

    private void resetConfigPool(boolean select, String klasseToSet) {
        ++this.mClassSetting;
        Collection<String> collectionKlasse = this.mFilePropertiesPool.getKlassenHashMap().values();
        Iterator<String> iterKlasse = collectionKlasse.iterator();
        int i = 0;
        String klasse = "";
        this.jComboBoxKlasse.removeAllItems();
        while (iterKlasse.hasNext()) {
            String item = iterKlasse.next();
            this.jComboBoxKlasse.addItem(item);
            if (select) {
                if (klasseToSet.length() == 0) {
                    if (i == 0) {
                        this.jComboBoxKlasse.setSelectedIndex(i);
                        this.jTextFieldKlasse.setText(item);
                        klasse = item;
                    }
                } else if (klasseToSet.equalsIgnoreCase(item)) {
                    this.jComboBoxKlasse.setSelectedIndex(i);
                    this.jTextFieldKlasse.setText(item);
                    klasse = item;
                }
            }
            ++i;
        }
        if (select && klasse.length() == 0 && this.jComboBoxKlasse.getItemCount() > 0) {
            this.jComboBoxKlasse.setSelectedIndex(0);
            this.jTextFieldKlasse.setText(this.jComboBoxKlasse.getSelectedItem().toString());
            klasse = this.jComboBoxKlasse.getSelectedItem().toString();
        }
        if (!select) {
            this.jComboBoxKlasse.setSelectedIndex(-1);
        }
        Collection<FileProperties> colC = this.mFilePropertiesPool.getMapForKlasse(klasse).values();
        Iterator<FileProperties> iterC = colC.iterator();
        this.jComboBoxName.removeAllItems();
        i = 0;
        while (iterC.hasNext()) {
            FileProperties item = iterC.next();
            this.jComboBoxName.addItem(item.mName);
            if (i == 0 && select) {
                this.jComboBoxName.setSelectedIndex(0);
                this.mFileProperties = this.mFilePropertiesPool.get(item.mName);
                this.setAllFromCurrent();
            }
            ++i;
        }
        if (!select) {
            this.jComboBoxName.setSelectedIndex(-1);
        }
        --this.mClassSetting;
    }

    private void clearAll() {
        ++this.mClassSetting;
        this.mFileProperties = new FileProperties();
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void setAllFromCurrent() {
        ++this.mClassSetting;
        this.jComboBoxKlasse.setSelectedItem(this.mFileProperties.mClass);
        this.jTextFieldKlasse.setText(this.mFileProperties.mClass);
        this.jComboBoxName.setSelectedItem(this.mFileProperties.mName);
        this.jTextFieldName.setText(this.mFileProperties.mName);
        this.jTextFieldFlags.setText("" + this.mFileProperties.mFlags);
        this.jTextFieldVersion.setText("" + this.mFileProperties.mVersion);
        this.jTextAreaDescription.setText("" + this.mFileProperties.mDescription);
        this.jTextFieldParam1.setText("" + this.mFileProperties.mParemeter1);
        this.jTextFieldParam2.setText("" + this.mFileProperties.mParemeter2);
        this.jTextFieldParam3.setText("" + this.mFileProperties.mParemeter3);
        this.jTextField2.setText(this.mFileProperties.mFilename);
        this.jCheckBox1.setSelected(this.mFileProperties.mNoInternalProcessing);
        this.initScripts();
        --this.mClassSetting;
    }

    private void readAllToCurrent() {
        this.mFileProperties.mFlags = this.jTextFieldFlags.getText();
        this.mFileProperties.mVersion = this.jTextFieldVersion.getText();
        this.mFileProperties.mDescription = this.jTextAreaDescription.getText();
        this.mFileProperties.mParemeter1 = this.jTextFieldParam1.getText();
        this.mFileProperties.mParemeter2 = this.jTextFieldParam2.getText();
        this.mFileProperties.mParemeter3 = this.jTextFieldParam3.getText();
        this.mFileProperties.mFilename = this.jTextField2.getText();
        this.mFileProperties.mNoInternalProcessing = this.jCheckBox1.isSelected();
        this.mFileProperties.mPreScriptClass = "";
        if (this.jComboBoxPreClass.getSelectedIndex() != -1) {
            this.mFileProperties.mPreScriptClass = this.jComboBoxPreClass.getSelectedItem().toString();
        }
        this.mFileProperties.mPreScriptName = "";
        if (this.jComboBoxPreName.getSelectedIndex() != -1) {
            this.mFileProperties.mPreScriptName = this.jComboBoxPreName.getSelectedItem().toString();
        }
        this.mFileProperties.mPostScriptClass = "";
        if (this.jComboBoxPostClass.getSelectedIndex() != -1) {
            this.mFileProperties.mPostScriptClass = this.jComboBoxPostClass.getSelectedItem().toString();
        }
        this.mFileProperties.mPostScriptName = "";
        if (this.jComboBoxPostName.getSelectedIndex() != -1) {
            this.mFileProperties.mPostScriptName = this.jComboBoxPostName.getSelectedItem().toString();
        }
        this.mFileProperties.mActionScriptClass = "";
        if (this.jComboBoxActionClass.getSelectedIndex() != -1) {
            this.mFileProperties.mActionScriptClass = this.jComboBoxActionClass.getSelectedItem().toString();
        }
        this.mFileProperties.mActionScriptName = "";
        if (this.jComboBoxActionName.getSelectedIndex() != -1) {
            this.mFileProperties.mActionScriptName = this.jComboBoxActionName.getSelectedItem().toString();
        }
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel3 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextField2 = new JTextField();
        this.jLabel5 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaDescription = new JTextArea();
        this.jLabel6 = new JLabel();
        this.jTextFieldParam1 = new JTextField();
        this.jTextFieldParam2 = new JTextField();
        this.jLabel7 = new JLabel();
        this.jTextFieldParam3 = new JTextField();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jComboBoxPostName = new JComboBox();
        this.jComboBoxPreName = new JComboBox();
        this.jComboBoxPreClass = new JComboBox();
        this.jComboBoxPostClass = new JComboBox();
        this.jButtonPost = new JButton();
        this.jButtonPre = new JButton();
        this.jButtonAction = new JButton();
        this.jComboBoxActionClass = new JComboBox();
        this.jComboBoxActionName = new JComboBox();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jTextFieldVersion = new JTextField();
        this.jLabel13 = new JLabel();
        this.jTextFieldFlags = new JTextField();
        this.jCheckBox1 = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.jButtonCreate = new JButton();
        this.jButtonCancel = new JButton();
        this.jPanel1 = new JPanel();
        this.jComboBoxKlasse = new JComboBox();
        this.jComboBoxName = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jTextFieldKlasse = new JTextField();
        this.jButtonNew = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonSaveAsNew = new JButton();
        this.jButtonDelete = new JButton();
        this.jLabel1.setText("Filename");
        this.jTextField1.setEditable(false);
        this.jTextField1.setPreferredSize(new Dimension(6, 21));
        this.jLabel2.setText("Typ");
        this.jTextField2.setEditable(false);
        this.jTextField2.setPreferredSize(new Dimension(6, 21));
        this.jLabel5.setText("Description");
        this.jTextAreaDescription.setColumns(20);
        this.jTextAreaDescription.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextAreaDescription);
        this.jLabel6.setText("Parameter");
        this.jTextFieldParam1.setPreferredSize(new Dimension(6, 21));
        this.jTextFieldParam2.setPreferredSize(new Dimension(6, 21));
        this.jLabel7.setText("Parameter");
        this.jTextFieldParam3.setPreferredSize(new Dimension(6, 21));
        this.jLabel8.setText("Parameter");
        this.jLabel9.setText("Pre build commands");
        this.jLabel10.setText("Post build commands");
        this.jComboBoxPostName.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxPreName.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxPreClass.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxPreClass.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilePropertiesPanel.this.jComboBoxPreClassItemStateChanged(evt);
            }
        });
        this.jComboBoxPostClass.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxPostClass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilePropertiesPanel.this.jComboBoxPostClassActionPerformed(evt);
            }
        });
        this.jButtonPost.setLabel("configure script");
        this.jButtonPost.setPreferredSize(new Dimension(90, 21));
        this.jButtonPost.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilePropertiesPanel.this.jButtonPostActionPerformed(evt);
            }
        });
        this.jButtonPre.setLabel("configure script");
        this.jButtonPre.setPreferredSize(new Dimension(90, 21));
        this.jButtonPre.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilePropertiesPanel.this.jButtonPreActionPerformed(evt);
            }
        });
        this.jButtonAction.setLabel("configure script");
        this.jButtonAction.setPreferredSize(new Dimension(90, 21));
        this.jButtonAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilePropertiesPanel.this.jButtonActionActionPerformed(evt);
            }
        });
        this.jComboBoxActionClass.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxActionClass.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilePropertiesPanel.this.jComboBoxActionClassItemStateChanged(evt);
            }
        });
        this.jComboBoxActionClass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilePropertiesPanel.this.jComboBoxActionClassActionPerformed(evt);
            }
        });
        this.jComboBoxActionName.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel11.setText("Action script");
        this.jLabel12.setText("Version");
        this.jTextFieldVersion.setText("1.0");
        this.jTextFieldVersion.setPreferredSize(new Dimension(22, 21));
        this.jTextFieldVersion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilePropertiesPanel.this.jTextFieldVersionActionPerformed(evt);
            }
        });
        this.jLabel13.setText("Flags");
        this.jTextFieldFlags.setToolTipText("<html>\nIf using \"C\" these flags are applied to the gcc \"later\" than the ones in the project settings.<br>\nThis with gcc usually means that these flags here have priority over the flags given by the project.\n</html>");
        this.jTextFieldFlags.setPreferredSize(new Dimension(6, 21));
        this.jCheckBox1.setText("no internal processing");
        this.jCheckBox1.setToolTipText("if selected no internal procressing (assembling) is done");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(5, 5, 5).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel5).addComponent(this.jLabel6).addComponent(this.jLabel7).addComponent(this.jLabel8).addComponent(this.jLabel11).addComponent(this.jLabel9).addComponent(this.jLabel10).addComponent(this.jLabel13)).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(218, 218, 218).addComponent(this.jLabel12).addGap(12, 12, 12).addComponent(this.jTextFieldVersion, -2, 58, -2).addContainerGap(285, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addGap(4, 4, 4).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldFlags, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldParam3, -2, 153, -2).addComponent(this.jTextFieldParam2, -2, 153, -2).addComponent(this.jTextFieldParam1, -2, 153, -2).addComponent(this.jTextField1, -2, 43, -2)).addGap(0, 456, Short.MAX_VALUE)).addComponent(this.jTextField2, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxActionName, -2, 144, -2).addComponent(this.jComboBoxPreName, -2, 144, -2).addComponent(this.jComboBoxPostName, -2, 144, -2).addComponent(this.jCheckBox1)).addGap(10, 10, 10).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxActionClass, -2, 144, -2).addComponent(this.jComboBoxPreClass, -2, 144, -2).addComponent(this.jComboBoxPostClass, -2, 144, -2)).addGap(19, 19, 19).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButtonPre, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonAction, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonPost, -1, -1, Short.MAX_VALUE))))))));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jTextField2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jLabel12).addComponent(this.jTextFieldVersion, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jScrollPane1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldFlags, -2, -1, -2).addComponent(this.jLabel13)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 20, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jTextFieldParam1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent(this.jTextFieldParam2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addComponent(this.jTextFieldParam3, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel11).addComponent(this.jComboBoxActionName, -2, -1, -2).addComponent(this.jComboBoxActionClass, -2, -1, -2).addComponent(this.jButtonAction, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9).addComponent(this.jComboBoxPreName, -2, -1, -2).addComponent(this.jComboBoxPreClass, -2, -1, -2).addComponent(this.jButtonPre, -2, -1, -2)).addGap(6, 6, 6).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel10).addComponent(this.jButtonPost, -2, -1, -2).addComponent(this.jComboBoxPostClass, -2, -1, -2).addComponent(this.jComboBoxPostName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox1).addContainerGap(140, Short.MAX_VALUE)));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addGap(2, 2, 2)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.jTabbedPane1.addTab("File Settings", this.jPanel3);
        this.jButtonCreate.setText("create");
        this.jButtonCreate.setName("create");
        this.jButtonCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilePropertiesPanel.this.jButtonCreateActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("cancel");
        this.jButtonCancel.setName("cancel");
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jComboBoxKlasse.setPreferredSize(new Dimension(28, 19));
        this.jComboBoxKlasse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilePropertiesPanel.this.jComboBoxKlasseActionPerformed(evt);
            }
        });
        this.jComboBoxName.setPreferredSize(new Dimension(28, 19));
        this.jComboBoxName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilePropertiesPanel.this.jComboBoxNameActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Name");
        this.jLabel4.setText("Class");
        this.jButtonNew.setText("New");
        this.jButtonNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilePropertiesPanel.this.jButtonNewActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilePropertiesPanel.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonSaveAsNew.setText("Save as new");
        this.jButtonSaveAsNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilePropertiesPanel.this.jButtonSaveAsNewActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilePropertiesPanel.this.jButtonDeleteActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel3)).addGap(28, 28, 28).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldKlasse, -1, 244, Short.MAX_VALUE).addComponent(this.jTextFieldName)).addGap(5, 5, 5).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jComboBoxKlasse, 0, 208, Short.MAX_VALUE).addComponent(this.jComboBoxName, 0, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSave).addComponent(this.jButtonNew)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSaveAsNew).addComponent(this.jButtonDelete)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonSave).addComponent(this.jButtonSaveAsNew))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButtonNew).addComponent(this.jComboBoxKlasse, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxName, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jTextFieldKlasse, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldName, -2, -1, -2)))))));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jButtonCancel).addGap(116, 116, 116).addComponent(this.jButtonCreate).addContainerGap()).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(338, 338, 338).addComponent(this.jPanel1, -2, 34, -2).addContainerGap(338, Short.MAX_VALUE))));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonCreate)).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(7, 7, 7).addComponent(this.jPanel1, -2, 9, -2).addContainerGap(-1, Short.MAX_VALUE))));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jTabbedPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2)));
    }

    private void jButtonNewActionPerformed(ActionEvent evt) {
        ++this.mClassSetting;
        this.mFileProperties = new FileProperties();
        this.clearAll();
        this.resetConfigPool(false, "");
        --this.mClassSetting;
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        this.readAllToCurrent();
        this.mFilePropertiesPool.put(this.mFileProperties);
        this.mFilePropertiesPool.save();
        ++this.mClassSetting;
        String klasse = this.jTextFieldKlasse.getText();
        this.resetConfigPool(true, klasse);
        this.jComboBoxName.setSelectedItem(this.mFileProperties.mName);
        --this.mClassSetting;
    }

    private void jButtonSaveAsNewActionPerformed(ActionEvent evt) {
        this.mFileProperties = new FileProperties();
        this.readAllToCurrent();
        this.mFilePropertiesPool.putAsNew(this.mFileProperties);
        this.mFilePropertiesPool.save();
        ++this.mClassSetting;
        String klasse = this.jTextFieldKlasse.getText();
        this.resetConfigPool(true, klasse);
        this.jComboBoxName.setSelectedItem(this.mFileProperties.mName);
        --this.mClassSetting;
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.readAllToCurrent();
        this.mFilePropertiesPool.remove(this.mFileProperties);
        this.mFilePropertiesPool.save();
        ++this.mClassSetting;
        String klasse = this.jTextFieldKlasse.getText();
        this.resetConfigPool(true, klasse);
        if (this.jComboBoxName.getSelectedIndex() == -1) {
            this.clearAll();
        }
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mFileProperties = this.mFilePropertiesPool.get(key);
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void jComboBoxKlasseActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        ++this.mClassSetting;
        String selected = this.jComboBoxKlasse.getSelectedItem().toString();
        this.clearAll();
        this.resetConfigPool(true, selected);
        this.jTextFieldKlasse.setText(this.jComboBoxKlasse.getSelectedItem().toString());
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mFileProperties = this.mFilePropertiesPool.get(key);
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void jComboBoxNameActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mFileProperties = this.mFilePropertiesPool.get(key);
        this.setAllFromCurrent();
    }

    private void jButtonCreateActionPerformed(ActionEvent evt) {
        this.readAllToCurrent();
        this.mFilePropertiesPool.put(this.mFileProperties);
        this.mFilePropertiesPool.save();
    }

    private void jComboBoxActionClassItemStateChanged(ItemEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        this.mFileProperties.mActionScriptClass = this.jComboBoxActionClass.getSelectedIndex() != -1 ? this.jComboBoxActionClass.getSelectedItem().toString() : "";
        this.initScripts();
    }

    private void jButtonActionActionPerformed(ActionEvent evt) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        ScriptDataPanel sdp = new ScriptDataPanel();
        sdp.setVedi(this.vedi);
        ModalInternalFrame modal = null;
        if (Paths.get(this.mFileProperties.mFilename, new String[0]).getParent() == null) {
            return;
        }
        String path = Paths.get(this.mFileProperties.mFilename, new String[0]).getParent().toString();
        String filenameOnly = Paths.get(this.mFileProperties.mFilename, new String[0]).getFileName().toString();
        ExecutionDescriptor ed = new ExecutionDescriptor(ExecutionDescriptor.ED_TYPE_FILE_ACTION, "", filenameOnly, "FilePropertiesPanel", Utility.makeVideAbsolute(path));
        sdp.setSelected(this.mFileProperties.mActionScriptClass, this.mFileProperties.mActionScriptName, ed);
        modal = new ModalInternalFrame("Scripter", frame.getRootPane(), (Component)frame, (Container)sdp, "done");
        modal.setVisible(true);
        this.mFileProperties.mActionScriptClass = sdp.getSelectedClass();
        this.mFileProperties.mActionScriptName = sdp.getSelectedName();
        this.initScripts();
    }

    private void jButtonPreActionPerformed(ActionEvent evt) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        ScriptDataPanel sdp = new ScriptDataPanel();
        sdp.setVedi(this.vedi);
        ModalInternalFrame modal = null;
        if (Paths.get(this.mFileProperties.mFilename, new String[0]).getParent() == null) {
            return;
        }
        String path = Paths.get(this.mFileProperties.mFilename, new String[0]).getParent().toString();
        String filenameOnly = Paths.get(this.mFileProperties.mFilename, new String[0]).getFileName().toString();
        ExecutionDescriptor ed = new ExecutionDescriptor(ExecutionDescriptor.ED_TYPE_FILE_PRE, "", filenameOnly, "FilePropertiesPanel", Utility.makeVideAbsolute(path));
        sdp.setSelected(this.mFileProperties.mPreScriptClass, this.mFileProperties.mPreScriptName, ed);
        modal = new ModalInternalFrame("Scripter", frame.getRootPane(), (Component)frame, (Container)sdp, "done");
        modal.setVisible(true);
        this.mFileProperties.mPreScriptClass = sdp.getSelectedClass();
        this.mFileProperties.mPreScriptName = sdp.getSelectedName();
        this.initScripts();
    }

    private void jButtonPostActionPerformed(ActionEvent evt) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        ScriptDataPanel sdp = new ScriptDataPanel();
        sdp.setVedi(this.vedi);
        ModalInternalFrame modal = null;
        if (Paths.get(this.mFileProperties.mFilename, new String[0]).getParent() == null) {
            return;
        }
        String path = Paths.get(this.mFileProperties.mFilename, new String[0]).getParent().toString();
        String filenameOnly = Paths.get(this.mFileProperties.mFilename, new String[0]).getFileName().toString();
        ExecutionDescriptor ed = new ExecutionDescriptor(ExecutionDescriptor.ED_TYPE_FILE_POST, "", filenameOnly, "FilePropertiesPanel", Utility.makeVideAbsolute(path));
        sdp.setSelected(this.mFileProperties.mPostScriptClass, this.mFileProperties.mPostScriptName, ed);
        modal = new ModalInternalFrame("Scripter", frame.getRootPane(), (Component)frame, (Container)sdp, "done");
        modal.setVisible(true);
        this.mFileProperties.mPostScriptClass = sdp.getSelectedClass();
        this.mFileProperties.mPostScriptName = sdp.getSelectedName();
        this.initScripts();
    }

    private void jComboBoxPostClassActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        this.mFileProperties.mPostScriptClass = this.jComboBoxPostClass.getSelectedIndex() != -1 ? this.jComboBoxPostClass.getSelectedItem().toString() : "";
        this.initScripts();
    }

    private void jComboBoxPreClassItemStateChanged(ItemEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        this.mFileProperties.mPreScriptClass = this.jComboBoxPreClass.getSelectedIndex() != -1 ? this.jComboBoxPreClass.getSelectedItem().toString() : "";
        this.initScripts();
    }

    private void jTextFieldVersionActionPerformed(ActionEvent evt) {
    }

    private void jComboBoxActionClassActionPerformed(ActionEvent evt) {
    }

    public static boolean showNewFilesProperties() {
        ModalInternalFrame modal;
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        FilePropertiesPanel panel = new FilePropertiesPanel();
        ArrayList<JButton> eb = new ArrayList<JButton>();
        eb.add(panel.jButtonCreate);
        eb.add(panel.jButtonCancel);
        panel.modelDialog = modal = new ModalInternalFrame("New file properties", frame.getRootPane(), frame, panel, null, null, eb);
        modal.setVisible(true);
        String result = modal.getNamedExit();
        if (result.equals("create")) {
            panel.readAllToCurrent();
            return true;
        }
        return false;
    }

    public static boolean showEditFileProperties(String filename) {
        ModalInternalFrame modal;
        Path p = Paths.get(filename, new String[0]);
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        FilePropertiesPanel panel = new FilePropertiesPanel();
        panel.setFile(filename);
        ArrayList<JButton> eb = new ArrayList<JButton>();
        eb.add(panel.jButtonCreate);
        eb.add(panel.jButtonCancel);
        panel.modelDialog = modal = new ModalInternalFrame(p.getFileName().toString(), frame.getRootPane(), frame, panel, null, null, eb);
        modal.setVisible(true);
        String result = modal.getNamedExit();
        if (result.equals("ok")) {
            panel.readAllToCurrent();
            return true;
        }
        return false;
    }

    public static boolean showEditFileProperties(String filename, VediPanel v) {
        ModalInternalFrame modal;
        Path p = Paths.get(filename, new String[0]);
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        FilePropertiesPanel panel = new FilePropertiesPanel();
        panel.setVedi(v);
        panel.setFile(filename);
        ArrayList<JButton> eb = new ArrayList<JButton>();
        eb.add(panel.jButtonCreate);
        eb.add(panel.jButtonCancel);
        panel.modelDialog = modal = new ModalInternalFrame(p.getFileName().toString(), frame.getRootPane(), frame, panel, null, null, eb);
        modal.setVisible(true);
        String result = modal.getNamedExit();
        if (result.equals("ok")) {
            panel.readAllToCurrent();
            return true;
        }
        return false;
    }

    void initScripts() {
        String name;
        int j;
        Vector<String> nnames;
        Iterator<ExportData> iterC;
        Collection<ExportData> colC;
        this.mExportDataPool = new ExportDataPool();
        String preClass = this.mFileProperties.mPreScriptClass;
        String preName = this.mFileProperties.mPreScriptName;
        ++this.mClassSetting;
        Collection<String> collectionKlasse = this.mExportDataPool.getKlassenHashMap().values();
        Iterator<String> iterKlasse = collectionKlasse.iterator();
        int i = 0;
        String klasse = "";
        this.jComboBoxPreName.removeAllItems();
        this.jComboBoxPreClass.removeAllItems();
        this.jComboBoxPostName.removeAllItems();
        this.jComboBoxPostClass.removeAllItems();
        this.jComboBoxActionName.removeAllItems();
        this.jComboBoxActionClass.removeAllItems();
        while (iterKlasse.hasNext()) {
            String item = iterKlasse.next();
            this.jComboBoxPreClass.addItem(item);
            this.jComboBoxPostClass.addItem(item);
            this.jComboBoxActionClass.addItem(item);
            ++i;
        }
        if (this.mFileProperties.mPreScriptClass != null && this.mFileProperties.mPreScriptClass.length() != 0) {
            this.jComboBoxPreClass.setSelectedItem(this.mFileProperties.mPreScriptClass);
            colC = this.mExportDataPool.getMapForKlasse(this.mFileProperties.mPreScriptClass).values();
            iterC = colC.iterator();
            nnames = new Vector<String>();
            while (iterC.hasNext()) {
                nnames.addElement(iterC.next().mName);
            }
            Collections.sort(nnames, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    return s1.compareTo(s2);
                }
            });
            this.jComboBoxPreName.addItem("");
            for (j = 0; j < nnames.size(); ++j) {
                name = (String)nnames.elementAt(j);
                this.jComboBoxPreName.addItem(name);
            }
            if (this.mFileProperties.mPreScriptName != null && this.mFileProperties.mPreScriptName.length() != 0) {
                this.jComboBoxPreName.setSelectedItem(this.mFileProperties.mPreScriptName);
            }
        } else {
            this.jComboBoxPreClass.setSelectedIndex(-1);
            this.jComboBoxPreName.setSelectedIndex(-1);
        }
        if (this.mFileProperties.mPostScriptClass != null && this.mFileProperties.mPostScriptClass.length() != 0) {
            this.jComboBoxPostClass.setSelectedItem(this.mFileProperties.mPostScriptClass);
            colC = this.mExportDataPool.getMapForKlasse(this.mFileProperties.mPostScriptClass).values();
            iterC = colC.iterator();
            nnames = new Vector();
            while (iterC.hasNext()) {
                nnames.addElement(iterC.next().mName);
            }
            Collections.sort(nnames, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    return s1.compareTo(s2);
                }
            });
            this.jComboBoxPostName.addItem("");
            for (j = 0; j < nnames.size(); ++j) {
                name = (String)nnames.elementAt(j);
                this.jComboBoxPostName.addItem(name);
            }
            if (this.mFileProperties.mPostScriptName != null && this.mFileProperties.mPostScriptName.length() != 0) {
                this.jComboBoxPostName.setSelectedItem(this.mFileProperties.mPostScriptName);
            }
        } else {
            this.jComboBoxPostClass.setSelectedIndex(-1);
            this.jComboBoxPostName.setSelectedIndex(-1);
        }
        if (this.mFileProperties.mActionScriptClass != null && this.mFileProperties.mActionScriptClass.length() != 0) {
            this.jComboBoxActionClass.setSelectedItem(this.mFileProperties.mActionScriptClass);
            colC = this.mExportDataPool.getMapForKlasse(this.mFileProperties.mActionScriptClass).values();
            iterC = colC.iterator();
            nnames = new Vector();
            while (iterC.hasNext()) {
                nnames.addElement(iterC.next().mName);
            }
            Collections.sort(nnames, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    return s1.compareTo(s2);
                }
            });
            this.jComboBoxActionName.addItem("");
            for (j = 0; j < nnames.size(); ++j) {
                name = (String)nnames.elementAt(j);
                this.jComboBoxActionName.addItem(name);
            }
            if (this.mFileProperties.mActionScriptName != null && this.mFileProperties.mActionScriptName.length() != 0) {
                this.jComboBoxActionName.setSelectedItem(this.mFileProperties.mActionScriptName);
            }
        } else {
            this.jComboBoxActionClass.setSelectedIndex(-1);
            this.jComboBoxActionName.setSelectedIndex(-1);
        }
        --this.mClassSetting;
    }
}

