/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi.sound;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.gui.panels.LogPanel;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityString;
import de.malban.util.XMLSupport;
import de.malban.vide.dissy.DASM6809;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;

public class Explosion
implements Serializable {
    transient LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    public byte[] bytes = new byte[4];
    public String name = "";

    String getBytesString() {
        StringBuilder s = new StringBuilder();
        s.append("$").append(String.format("%02X", this.bytes[0])).append(",");
        s.append("$").append(String.format("%02X", this.bytes[1])).append(",");
        s.append("$").append(String.format("%02X", this.bytes[2])).append(",");
        s.append("$").append(String.format("%02X", this.bytes[3])).append("");
        return s.toString();
    }

    void setBytes(String a) {
        String[] numbers = a.split(",");
        int count = 0;
        for (int i = 0; i < numbers.length; ++i) {
            String ss = numbers[i];
            if ((ss = ss.trim()).length() <= 0) continue;
            int value = DASM6809.toNumber(ss) & 0xFF;
            this.bytes[count] = (byte)value;
            ++count;
        }
    }

    public boolean toXML(StringBuilder s, String tag) {
        s.append("<").append(tag).append(">\n");
        boolean ok = true;
        ok &= XMLSupport.addElement(s, "name", this.name);
        s.append("</").append(tag).append(">\n");
        return ok &= XMLSupport.addElement(s, "bytes", this.getBytesString());
    }

    public boolean fromXML(StringBuilder xml, XMLSupport xmlSupport) {
        int errorCode = 0;
        this.name = xmlSupport.getStringElement("name", xml);
        errorCode |= xmlSupport.errorCode;
        String b = xmlSupport.getStringElement("bytes", xml);
        this.setBytes(b);
        return (errorCode |= xmlSupport.errorCode) == 0;
    }

    public boolean saveAsXML(String filename) {
        StringBuilder xml = new StringBuilder();
        boolean ok = this.toXML(xml, "Explosion");
        if (!ok) {
            this.log.addLog("Explosion save 'toXML' return false", LogPanel.WARN);
            return false;
        }
        ok = UtilityFiles.createTextFile(filename, xml.toString());
        if (!ok) {
            this.log.addLog("Explosion create file '" + filename + "' return false", LogPanel.WARN);
            return false;
        }
        return true;
    }

    public static Explosion loadExplosion(String filename) {
        Explosion w = new Explosion();
        if (w.loadFromXML(filename)) {
            return w;
        }
        return null;
    }

    public boolean loadFromXML(String filename) {
        String xml = UtilityString.readTextFileToOneString(new File(filename));
        boolean ok = this.fromXML(new StringBuilder(xml), new XMLSupport());
        if (!ok) {
            this.log.addLog("Explosion load from xml '" + filename + "' return false", LogPanel.WARN);
            return false;
        }
        return true;
    }

    public static Explosion getExplosion(String name) {
        Explosion expl = Explosion.loadExplosion(Global.mainPathPrefix + "xml" + File.separator + "explosions" + File.separator + name + ".xml");
        if (expl == null) {
            expl = new Explosion();
        }
        return expl;
    }

    public static ArrayList<String> getExplosionList() {
        ArrayList<String> explosions = new ArrayList<String>();
        String path = Global.mainPathPrefix + "xml" + File.separator + "explosions";
        ArrayList<String> files = UtilityFiles.getXMLFileList(path);
        for (String name : files) {
            explosions.add(UtilityString.replace(name.toLowerCase(), ".xml", ""));
        }
        return explosions;
    }
}

