/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi.sound;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.gui.panels.LogPanel;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityString;
import de.malban.util.XMLSupport;
import de.malban.vide.dissy.DASM6809;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;

public class Instrument
implements Serializable {
    transient LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    public byte[] adsr = new byte[32];
    public byte[] twang = new byte[8];
    public String name = "";

    String getADSRAsString() {
        StringBuilder s = new StringBuilder();
        s.append("$").append(String.format("%01X", this.adsr[0])).append(String.format("%01X", this.adsr[1])).append(",");
        s.append("$").append(String.format("%01X", this.adsr[2])).append(String.format("%01X", this.adsr[3])).append(",");
        s.append("$").append(String.format("%01X", this.adsr[4])).append(String.format("%01X", this.adsr[5])).append(",");
        s.append("$").append(String.format("%01X", this.adsr[6])).append(String.format("%01X", this.adsr[7])).append(",");
        s.append("$").append(String.format("%01X", this.adsr[8])).append(String.format("%01X", this.adsr[9])).append(",");
        s.append("$").append(String.format("%01X", this.adsr[10])).append(String.format("%01X", this.adsr[11])).append(",");
        s.append("$").append(String.format("%01X", this.adsr[12])).append(String.format("%01X", this.adsr[13])).append(",");
        s.append("$").append(String.format("%01X", this.adsr[14])).append(String.format("%01X", this.adsr[15])).append(",");
        s.append("$").append(String.format("%01X", this.adsr[16])).append(String.format("%01X", this.adsr[17])).append(",");
        s.append("$").append(String.format("%01X", this.adsr[18])).append(String.format("%01X", this.adsr[19])).append(",");
        s.append("$").append(String.format("%01X", this.adsr[20])).append(String.format("%01X", this.adsr[21])).append(",");
        s.append("$").append(String.format("%01X", this.adsr[22])).append(String.format("%01X", this.adsr[23])).append(",");
        s.append("$").append(String.format("%01X", this.adsr[24])).append(String.format("%01X", this.adsr[25])).append(",");
        s.append("$").append(String.format("%01X", this.adsr[26])).append(String.format("%01X", this.adsr[27])).append(",");
        s.append("$").append(String.format("%01X", this.adsr[28])).append(String.format("%01X", this.adsr[29])).append(",");
        s.append("$").append(String.format("%01X", this.adsr[30])).append(String.format("%01X", this.adsr[31])).append("");
        return s.toString();
    }

    String getTWANGAsString() {
        StringBuilder s = new StringBuilder();
        s.append("$").append(String.format("%02X", this.twang[0])).append(",");
        s.append("$").append(String.format("%02X", this.twang[1])).append(",");
        s.append("$").append(String.format("%02X", this.twang[2])).append(",");
        s.append("$").append(String.format("%02X", this.twang[3])).append(",");
        s.append("$").append(String.format("%02X", this.twang[4])).append(",");
        s.append("$").append(String.format("%02X", this.twang[5])).append(",");
        s.append("$").append(String.format("%02X", this.twang[6])).append(",");
        s.append("$").append(String.format("%02X", this.twang[7])).append("");
        return s.toString();
    }

    void setADSR(String a) {
        String[] numbers = a.split(",");
        int count = 0;
        for (int i = 0; i < numbers.length; ++i) {
            String ss = numbers[i];
            if ((ss = ss.trim()).length() <= 0) continue;
            int value = DASM6809.toNumber(ss) & 0xFF;
            this.adsr[count * 2 + 0] = (byte)(value >> 4);
            this.adsr[count * 2 + 1] = (byte)(value & 0xF);
            ++count;
        }
    }

    void setTWANG(String t) {
        String[] numbers = t.split(",");
        int count = 0;
        for (int i = 0; i < numbers.length; ++i) {
            String ss = numbers[i];
            if ((ss = ss.trim()).length() <= 0) continue;
            int value = DASM6809.toNumber(ss) & 0xFF;
            this.twang[count++] = (byte)value;
            if (count >= 8) break;
        }
    }

    public boolean toXML(StringBuilder s, String tag) {
        s.append("<").append(tag).append(">\n");
        boolean ok = true;
        ok &= XMLSupport.addElement(s, "name", this.name);
        ok &= XMLSupport.addElement(s, "adsr", this.getADSRAsString());
        s.append("</").append(tag).append(">\n");
        return ok &= XMLSupport.addElement(s, "twang", this.getTWANGAsString());
    }

    public boolean fromXML(StringBuilder xml, XMLSupport xmlSupport) {
        int errorCode = 0;
        this.name = xmlSupport.getStringElement("name", xml);
        errorCode |= xmlSupport.errorCode;
        String adsr = xmlSupport.getStringElement("adsr", xml);
        errorCode |= xmlSupport.errorCode;
        String twang = xmlSupport.getStringElement("twang", xml);
        this.setADSR(adsr);
        this.setTWANG(twang);
        return (errorCode |= xmlSupport.errorCode) == 0;
    }

    public boolean saveAsXML(String filename) {
        StringBuilder xml = new StringBuilder();
        boolean ok = this.toXML(xml, "Instrument");
        if (!ok) {
            this.log.addLog("Instrument save 'toXML' return false", LogPanel.WARN);
            return false;
        }
        ok = UtilityFiles.createTextFile(filename, xml.toString());
        if (!ok) {
            this.log.addLog("Instrument create file '" + filename + "' return false", LogPanel.WARN);
            return false;
        }
        return true;
    }

    public static Instrument loadInstrument(String filename) {
        Instrument w = new Instrument();
        if (w.loadFromXML(filename)) {
            return w;
        }
        return null;
    }

    public boolean loadFromXML(String filename) {
        String xml = UtilityString.readTextFileToOneString(new File(filename));
        boolean ok = this.fromXML(new StringBuilder(xml), new XMLSupport());
        if (!ok) {
            this.log.addLog("Instrument load from xml '" + filename + "' return false", LogPanel.WARN);
            return false;
        }
        return true;
    }

    public static Instrument getInstrument(String name) {
        Instrument instr = Instrument.loadInstrument(Global.mainPathPrefix + "xml" + File.separator + "instruments" + File.separator + name + ".xml");
        if (instr == null) {
            instr = new Instrument();
        }
        return instr;
    }

    public static ArrayList<String> getInstrumentList() {
        ArrayList<String> instruments = new ArrayList<String>();
        String path = Global.mainPathPrefix + "xml" + File.separator + "instruments";
        ArrayList<String> files = UtilityFiles.getXMLFileList(path);
        for (String name : files) {
            instruments.add(UtilityString.replace(name.toLowerCase(), ".xml", ""));
        }
        return instruments;
    }
}

