/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi.sound;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.config.TinyLogInterface;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSATableModel;
import de.malban.gui.components.CSATablePanel;
import de.malban.gui.components.CSAView;
import de.malban.gui.components.DoubleClickAction;
import de.malban.gui.components.ModalInternalFrame;
import de.malban.gui.dialogs.InternalFrameFileChoser;
import de.malban.gui.dialogs.QuickHelpModal;
import de.malban.gui.panels.LogPanel;
import de.malban.sound.tinysound.Sound;
import de.malban.sound.tinysound.TinySound;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityString;
import de.malban.vide.dissy.DASM6809;
import de.malban.vide.vedi.VediPanel;
import de.malban.vide.vedi.sound.Instrument;
import de.malban.vide.vedi.sound.InstrumentEditor;
import de.malban.vide.vedi.sound.Mod2Vectrex;
import de.malban.vide.vedi.sound.ibxm.IBXMPlayerJPanel;
import de.malban.vide.vedi.sound.ibxm.Sample;
import de.muntjak.tinylookandfeel.Theme;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;

public class ModJPanel
extends JPanel
implements Windowable {
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    String currentModFile = "";
    String pathOnly = "";
    TinyLogInterface tinyLog = null;
    private int mClassSetting = 0;
    private CSAView mParent = null;
    private JMenuItem mParentMenuItem = null;
    ArrayList<InstrumentHandle> instrumentHandles = new ArrayList();
    static ArrayList<VectrexInstrument> vectrexInstruments = new ArrayList();
    CSATableModel csaModel;
    String lastImagePath = Global.mainPathPrefix;
    boolean[] voicePlay = new boolean[4];
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private CSATablePanel cSATablePanel1;
    private IBXMPlayerJPanel iBXMPlayerJPanel1;
    private JButton jButton2;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButtonCancel;
    private JButton jButtonCreate;
    private JButton jButtonLoad;
    private JCheckBox jCheckBoxIndirectOutput;
    private JCheckBox jCheckBoxV1;
    private JCheckBox jCheckBoxV2;
    private JCheckBox jCheckBoxV3;
    private JCheckBox jCheckBoxV4;
    private JComboBox jComboBox1;
    private JComboBox jComboBox2;
    private JComboBox jComboBox3;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelv1;
    private JLabel jLabelv2;
    private JLabel jLabelv3;
    private JLabel jLabelv4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton10;
    private JRadioButton jRadioButton11;
    private JRadioButton jRadioButton12;
    private JRadioButton jRadioButton2;
    private JRadioButton jRadioButton3;
    private JRadioButton jRadioButton4;
    private JRadioButton jRadioButton5;
    private JRadioButton jRadioButton6;
    private JRadioButton jRadioButton7;
    private JRadioButton jRadioButton8;
    private JRadioButton jRadioButton9;
    private JTextField jTextField1;
    private JTextField jTextFieldADSR1;
    private JTextField jTextFieldADSR2;
    private JTextField jTextFieldADSR3;
    private JTextField jTextFieldTWANG1;
    private JTextField jTextFieldTWANG2;
    private JTextField jTextFieldTWANG3;
    ModalInternalFrame modelDialog;
    boolean standalone = false;
    private PropertyChangeListener pListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ModJPanel.this.updateMyUI();
        }
    };

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void closing() {
        this.deinit();
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText("Sound: Mod to Vectrex");
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    void deinit() {
        this.iBXMPlayerJPanel1.stop();
        this.removeUIListerner();
    }

    void initModFile(String filename) {
        File file = new File(filename);
        if (file.isDirectory()) {
            this.pathOnly = file.toString();
        } else {
            this.pathOnly = file.getParent();
            if (this.pathOnly == null) {
                this.pathOnly = "";
            }
            this.currentModFile = filename;
        }
        if (this.pathOnly.length() != 0) {
            this.pathOnly = this.pathOnly + File.separator;
        }
        this.iBXMPlayerJPanel1.setModfile(this.currentModFile);
        this.cSATablePanel1.setTableStyleSwitchingEnabled(false);
        JComboBox<Object> comboBox = new JComboBox<Object>(vectrexInstruments.toArray());
        DefaultCellEditor editor = new DefaultCellEditor(comboBox);
        Vector<String> in = this.iBXMPlayerJPanel1.getInstruments();
        if (this.currentModFile.length() != 0) {
            for (int i = 0; i < in.size(); ++i) {
                InstrumentHandle ins = new InstrumentHandle();
                ins.name = in.elementAt(i).substring(4);
                ins.no = DASM6809.toNumber(in.elementAt(i).substring(0, 3));
                ins.vectrex = VectrexInstrument.SILENCE;
                Sample sample = this.iBXMPlayerJPanel1.getInstrumentSample(ins.no);
                ins.length = sample.getSampleData().length * 2;
                this.instrumentHandles.add(ins);
            }
            Mod2Vectrex infoCollector = new Mod2Vectrex();
            infoCollector.collectInfo(filename, this.instrumentHandles);
            this.jLabelv1.setText("" + this.getVoiceUsage(this.instrumentHandles, 0));
            this.jLabelv2.setText("" + this.getVoiceUsage(this.instrumentHandles, 1));
            this.jLabelv3.setText("" + this.getVoiceUsage(this.instrumentHandles, 2));
            this.jLabelv4.setText("" + this.getVoiceUsage(this.instrumentHandles, 3));
        } else {
            this.jLabelv1.setText("");
            this.jLabelv2.setText("");
            this.jLabelv3.setText("");
            this.jLabelv4.setText("");
        }
        this.csaModel = CSATableModel.buildTableModel(new ModTableModel());
        this.cSATablePanel1.setModel(this.csaModel);
        this.cSATablePanel1.getTable().setDefaultEditor(VectrexInstrument.class, editor);
        this.cSATablePanel1.setHeaderEnabled(false);
        this.cSATablePanel1.setDoubleClickAction(new DoubleClickAction(){

            @Override
            public void doIt() {
                int[] rows = ModJPanel.this.cSATablePanel1.getSelectedRows();
                if (rows.length > 0) {
                    ModJPanel.this.playInstrument(rows[0]);
                }
            }
        });
        if (this.currentModFile.length() != 0) {
            this.updateVoicePlay();
        }
    }

    public ModJPanel(String filename, TinyLogInterface tl) {
        this.initComponents();
        this.initInstrumentCombo();
        this.tinyLog = tl;
        if (filename != null) {
            this.jPanel3.setVisible(false);
            this.initModFile(filename);
        } else {
            filename = "";
            this.initModFile(filename);
        }
        UIManager.addPropertyChangeListener(this.pListener);
        this.updateMyUI();
    }

    int getVoiceUsage(ArrayList<InstrumentHandle> instrumentHandles, int voice) {
        int sum = 0;
        for (InstrumentHandle h : instrumentHandles) {
            sum += h.usage[voice];
        }
        return sum;
    }

    void playInstrument(int instrument) {
        System.out.println("Playing: " + this.instrumentHandles.get((int)instrument).name);
        Sample sample = this.iBXMPlayerJPanel1.getInstrumentSample(this.instrumentHandles.get((int)instrument).no);
        short[] dataOrg = sample.getSampleData();
        AudioFormat FORMAT = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, sample.c2Rate, 16, 1, 2, 44100.0f, false);
        byte[] sampleData = new byte[dataOrg.length * 2];
        for (int i = 0; i < dataOrg.length; ++i) {
            sampleData[i * 2 + 0] = (byte)(dataOrg[i] & 0xFF);
            sampleData[i * 2 + 1] = (byte)(dataOrg[i] >> 8 & 0xFF);
        }
        AudioInputStream audioStream = new AudioInputStream(new ByteArrayInputStream(sampleData), FORMAT, sampleData.length);
        Sound s = TinySound.loadSound(audioStream, false);
        s.play();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.jButtonCreate = new JButton();
        this.jButtonCancel = new JButton();
        this.jButton6 = new JButton();
        this.iBXMPlayerJPanel1 = new IBXMPlayerJPanel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jRadioButton3 = new JRadioButton();
        this.jRadioButton4 = new JRadioButton();
        this.jLabel3 = new JLabel();
        this.jRadioButton5 = new JRadioButton();
        this.jRadioButton6 = new JRadioButton();
        this.jRadioButton7 = new JRadioButton();
        this.jRadioButton8 = new JRadioButton();
        this.jLabel4 = new JLabel();
        this.jRadioButton9 = new JRadioButton();
        this.jRadioButton10 = new JRadioButton();
        this.jRadioButton11 = new JRadioButton();
        this.jRadioButton12 = new JRadioButton();
        this.jLabel5 = new JLabel();
        this.jTextFieldADSR1 = new JTextField();
        this.jLabel7 = new JLabel();
        this.jTextFieldTWANG1 = new JTextField();
        this.jLabel8 = new JLabel();
        this.jLabelv1 = new JLabel();
        this.jLabelv2 = new JLabel();
        this.jLabelv3 = new JLabel();
        this.jLabelv4 = new JLabel();
        this.jCheckBoxV1 = new JCheckBox();
        this.jCheckBoxV2 = new JCheckBox();
        this.jCheckBoxV3 = new JCheckBox();
        this.jCheckBoxV4 = new JCheckBox();
        this.jLabel9 = new JLabel();
        this.jCheckBoxIndirectOutput = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.jTextFieldADSR2 = new JTextField();
        this.jTextFieldADSR3 = new JTextField();
        this.jLabel10 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jComboBox2 = new JComboBox();
        this.jComboBox3 = new JComboBox();
        this.jLabel11 = new JLabel();
        this.jTextFieldTWANG2 = new JTextField();
        this.jTextFieldTWANG3 = new JTextField();
        this.jLabel12 = new JLabel();
        this.jButton7 = new JButton();
        this.jButton2 = new JButton();
        this.jLabel13 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jPanel2 = new JPanel();
        this.cSATablePanel1 = new CSATablePanel();
        this.jPanel3 = new JPanel();
        this.jLabel14 = new JLabel();
        this.jButtonLoad = new JButton();
        this.jButtonCreate.setText("create source");
        this.jButtonCreate.setName("create");
        this.jButtonCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModJPanel.this.jButtonCreateActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModJPanel.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButton6.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/information.png")));
        this.jButton6.setText("info");
        this.jButton6.setPreferredSize(new Dimension(72, 20));
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModJPanel.this.jButton6ActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Conversion settings\n"));
        this.jLabel1.setText("Mods have 4 voices, the PSG has only three voices, therefor you can decide which voice(s) to convert:");
        this.jLabel2.setText("as PSG voice 1:");
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText("mod 1");
        this.buttonGroup1.add(this.jRadioButton2);
        this.jRadioButton2.setText("mod 2");
        this.jRadioButton2.setToolTipText("");
        this.buttonGroup1.add(this.jRadioButton3);
        this.jRadioButton3.setText("mod 3");
        this.buttonGroup1.add(this.jRadioButton4);
        this.jRadioButton4.setText("mod 4");
        this.jLabel3.setText("as PSG voice 2:");
        this.buttonGroup2.add(this.jRadioButton5);
        this.jRadioButton5.setText("mod 1");
        this.buttonGroup2.add(this.jRadioButton6);
        this.jRadioButton6.setSelected(true);
        this.jRadioButton6.setText("mod 2");
        this.jRadioButton6.setToolTipText("");
        this.buttonGroup2.add(this.jRadioButton7);
        this.jRadioButton7.setText("mod 3");
        this.buttonGroup2.add(this.jRadioButton8);
        this.jRadioButton8.setText("mod 4");
        this.jLabel4.setText("as PSG voice 3:");
        this.buttonGroup3.add(this.jRadioButton9);
        this.jRadioButton9.setText("mod 1");
        this.buttonGroup3.add(this.jRadioButton10);
        this.jRadioButton10.setText("mod 2");
        this.jRadioButton10.setToolTipText("");
        this.buttonGroup3.add(this.jRadioButton11);
        this.jRadioButton11.setSelected(true);
        this.jRadioButton11.setText("mod 3");
        this.buttonGroup3.add(this.jRadioButton12);
        this.jRadioButton12.setText("mod 4");
        this.jLabel5.setText("ADSR (32 nibble) 1:");
        this.jTextFieldADSR1.setFont(new Font("Courier New", 1, 10));
        this.jTextFieldADSR1.setText("$ff,$ed,$cb,$a9,$87,$65,$43,$21,$00,$00,$00,$00,$00,$00,$00,$00");
        this.jTextFieldADSR1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModJPanel.this.jTextFieldADSR1ActionPerformed(evt);
            }
        });
        this.jLabel7.setText("TWANG (8 byte) 1:");
        this.jTextFieldTWANG1.setFont(new Font("Courier New", 1, 10));
        this.jTextFieldTWANG1.setText("$ff,$ff,$00,$00,$00,$00,$00,$00");
        this.jLabel8.setText("voice usages:");
        this.jLabelv1.setHorizontalAlignment(0);
        this.jLabelv1.setText("0");
        this.jLabelv1.setHorizontalTextPosition(0);
        this.jLabelv2.setHorizontalAlignment(0);
        this.jLabelv2.setText("0");
        this.jLabelv2.setHorizontalTextPosition(0);
        this.jLabelv3.setHorizontalAlignment(0);
        this.jLabelv3.setText("0");
        this.jLabelv3.setHorizontalTextPosition(0);
        this.jLabelv4.setHorizontalAlignment(0);
        this.jLabelv4.setText("0");
        this.jLabelv4.setHorizontalTextPosition(0);
        this.jCheckBoxV1.setSelected(true);
        this.jCheckBoxV1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModJPanel.this.jCheckBoxV1ActionPerformed(evt);
            }
        });
        this.jCheckBoxV2.setSelected(true);
        this.jCheckBoxV2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModJPanel.this.jCheckBoxV2ActionPerformed(evt);
            }
        });
        this.jCheckBoxV3.setSelected(true);
        this.jCheckBoxV3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModJPanel.this.jCheckBoxV3ActionPerformed(evt);
            }
        });
        this.jCheckBoxV4.setSelected(true);
        this.jCheckBoxV4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModJPanel.this.jCheckBoxV4ActionPerformed(evt);
            }
        });
        this.jLabel9.setText("play voices");
        this.jCheckBoxIndirectOutput.setSelected(true);
        this.jCheckBoxIndirectOutput.setText("indirect output");
        this.jCheckBoxIndirectOutput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModJPanel.this.jCheckBoxIndirectOutputActionPerformed(evt);
            }
        });
        this.jLabel6.setText("ADSR (32 nibble) 2:");
        this.jTextFieldADSR2.setFont(new Font("Courier New", 1, 10));
        this.jTextFieldADSR2.setText("$ff,$ed,$cb,$a9,$87,$65,$43,$21,$00,$00,$00,$00,$00,$00,$00,$00");
        this.jTextFieldADSR2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModJPanel.this.jTextFieldADSR2ActionPerformed(evt);
            }
        });
        this.jTextFieldADSR3.setFont(new Font("Courier New", 1, 10));
        this.jTextFieldADSR3.setText("$ff,$ed,$cb,$a9,$87,$65,$43,$21,$00,$00,$00,$00,$00,$00,$00,$00");
        this.jTextFieldADSR3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModJPanel.this.jTextFieldADSR3ActionPerformed(evt);
            }
        });
        this.jLabel10.setText("ADSR (32 nibble) 3:");
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModJPanel.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jComboBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModJPanel.this.jComboBox2ActionPerformed(evt);
            }
        });
        this.jComboBox3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModJPanel.this.jComboBox3ActionPerformed(evt);
            }
        });
        this.jLabel11.setText("TWANG (8 byte) 2:");
        this.jTextFieldTWANG2.setFont(new Font("Courier New", 1, 10));
        this.jTextFieldTWANG2.setText("$ff,$ff,$00,$00,$00,$00,$00,$00");
        this.jTextFieldTWANG3.setFont(new Font("Courier New", 1, 10));
        this.jTextFieldTWANG3.setText("$ff,$ff,$00,$00,$00,$00,$00,$00");
        this.jLabel12.setText("TWANG (8 byte) 3:");
        this.jButton7.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/ipod.png")));
        this.jButton7.setText("instrument edit");
        this.jButton7.setPreferredSize(new Dimension(150, 20));
        this.jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModJPanel.this.jButton7ActionPerformed(evt);
            }
        });
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/wand.png")));
        this.jButton2.setToolTipText("refresh (after configuration)");
        this.jButton2.setMargin(new Insets(2, 2, 2, 2));
        this.jButton2.setPreferredSize(new Dimension(37, 20));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModJPanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jLabel13.setHorizontalAlignment(11);
        this.jLabel13.setText("default speed:");
        this.jTextField1.setText("10");
        this.jTextField1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModJPanel.this.jTextField1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel8).addComponent(this.jLabel9).addComponent(this.jLabel2).addComponent(this.jLabel3)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButton1).addComponent(this.jRadioButton5).addComponent(this.jRadioButton9).addComponent(this.jLabelv1, -2, 44, -2).addComponent(this.jCheckBoxV1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButton2).addComponent(this.jRadioButton6).addComponent(this.jRadioButton10).addComponent(this.jLabelv2, -2, 44, -2).addComponent(this.jCheckBoxV2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButton3).addComponent(this.jRadioButton7).addComponent(this.jRadioButton11).addComponent(this.jLabelv3, -2, 44, -2).addComponent(this.jCheckBoxV3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButton4).addComponent(this.jRadioButton8).addComponent(this.jRadioButton12).addComponent(this.jLabelv4, -2, 44, -2).addComponent(this.jCheckBoxV4)).addContainerGap(467, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 232, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jLabel13, -2, 139, -2).addGap(4, 4, 4))).addComponent(this.jTextField1, -2, 34, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel12).addComponent(this.jLabel11).addComponent(this.jLabel7).addComponent(this.jLabel10).addComponent(this.jLabel6).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldADSR1, -2, 438, -2).addComponent(this.jTextFieldADSR2, -2, 438, -2).addComponent(this.jTextFieldADSR3, -2, 438, -2).addComponent(this.jTextFieldTWANG1, -2, 300, -2).addComponent(this.jTextFieldTWANG2, -2, 300, -2).addComponent(this.jTextFieldTWANG3, -2, 300, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBox1, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBox2, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBox3, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jCheckBoxIndirectOutput)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jButton2, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton7, -1, -1, -2))))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, 0).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jRadioButton1).addComponent(this.jRadioButton2).addComponent(this.jRadioButton3).addComponent(this.jRadioButton4))).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField1, -2, 21, -2).addComponent(this.jLabel13)))).addGap(0, 0, 0).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jRadioButton5).addComponent(this.jRadioButton6).addComponent(this.jRadioButton7).addComponent(this.jRadioButton8)).addGap(0, 0, 0).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jRadioButton9).addComponent(this.jRadioButton10).addComponent(this.jRadioButton11).addComponent(this.jRadioButton12)).addGap(0, 0, 0).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.jLabelv1).addComponent(this.jLabelv2).addComponent(this.jLabelv3).addComponent(this.jLabelv4)).addGap(0, 0, 0).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxV1).addComponent(this.jCheckBoxV2).addComponent(this.jCheckBoxV3).addComponent(this.jCheckBoxV4).addComponent(this.jLabel9))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton2, -2, -1, -2).addComponent(this.jButton7, -2, 21, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 7, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBox1, -2, 21, -2).addComponent(this.jTextFieldADSR1, -2, 21, -2).addComponent(this.jLabel5)).addGap(4, 4, 4).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBox2, -2, 21, -2).addComponent(this.jTextFieldADSR2, -2, 21, -2).addComponent(this.jLabel6)).addGap(4, 4, 4).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBox3, -2, 21, -2).addComponent(this.jTextFieldADSR3, -2, 21, -2).addComponent(this.jLabel10)).addGap(6, 6, 6).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jTextFieldTWANG1, -2, 21, -2)).addGap(4, 4, 4).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.jTextFieldTWANG2, -2, 21, -2)).addGap(4, 4, 4).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(this.jTextFieldTWANG3, -2, 21, -2).addComponent(this.jCheckBoxIndirectOutput)).addGap(4, 4, 4)));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cSATablePanel1, -1, -1, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cSATablePanel1, GroupLayout.Alignment.TRAILING, -1, 273, Short.MAX_VALUE));
        this.jLabel14.setText("load mod file");
        this.jButtonLoad.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_go.png")));
        this.jButtonLoad.setToolTipText("load YM");
        this.jButtonLoad.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModJPanel.this.jButtonLoadActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel14).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonLoad).addGap(0, 0, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButtonLoad).addComponent(this.jLabel14)).addGap(0, 3, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButton6, -2, 84, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonCancel).addGap(34, 34, 34).addComponent(this.jButtonCreate)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.iBXMPlayerJPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel3, -2, -1, -2).addGap(0, 0, 0).addComponent(this.iBXMPlayerJPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCreate, -2, 21, -2).addComponent(this.jButtonCancel, -2, 21, -2).addComponent(this.jButton6, -2, 21, -2)).addGap(2, 2, 2)));
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.iBXMPlayerJPanel1.stop();
        Configuration.getConfiguration().getMainFrame().removePanel(this);
        if (this.tinyLog instanceof VediPanel) {
            ((VediPanel)this.tinyLog).returnFromModPanel(false);
        }
    }

    private void jButtonCreateActionPerformed(ActionEvent evt) {
        this.iBXMPlayerJPanel1.stop();
        Mod2Vectrex.DEFAULT_SPEED = (byte)DASM6809.toNumber(this.jTextField1.getText());
        this.createSource();
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        QuickHelpModal.showHelpHtmlFile(Global.mainPathPrefix + "help" + File.separator + "mod.html");
    }

    private void jTextFieldADSR1ActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxV1ActionPerformed(ActionEvent evt) {
        this.updateVoicePlay();
    }

    private void jCheckBoxV2ActionPerformed(ActionEvent evt) {
        this.updateVoicePlay();
    }

    private void jCheckBoxV3ActionPerformed(ActionEvent evt) {
        this.updateVoicePlay();
    }

    private void jCheckBoxV4ActionPerformed(ActionEvent evt) {
        this.updateVoicePlay();
    }

    private void jCheckBoxIndirectOutputActionPerformed(ActionEvent evt) {
    }

    private void jTextFieldADSR2ActionPerformed(ActionEvent evt) {
    }

    private void jTextFieldADSR3ActionPerformed(ActionEvent evt) {
    }

    private void jButton7ActionPerformed(ActionEvent evt) {
        InstrumentEditor.showInstrumentPanelNoModal(this.tinyLog);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.initInstrumentCombo();
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        if (this.jComboBox1.getSelectedIndex() == -1) {
            return;
        }
        String selname = this.jComboBox1.getSelectedItem().toString();
        ArrayList<String> list2 = Instrument.getInstrumentList();
        for (String name : list2) {
            String comboName = UtilityString.replace(name.toLowerCase(), ".xml", "");
            if (!selname.equals(comboName)) continue;
            Instrument ins = Instrument.getInstrument(comboName);
            this.jTextFieldADSR1.setText(ins.getADSRAsString());
            this.jTextFieldTWANG1.setText(ins.getTWANGAsString());
            return;
        }
    }

    private void jComboBox2ActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        if (this.jComboBox2.getSelectedIndex() == -1) {
            return;
        }
        String selname = this.jComboBox2.getSelectedItem().toString();
        ArrayList<String> list2 = Instrument.getInstrumentList();
        for (String name : list2) {
            String comboName = UtilityString.replace(name.toLowerCase(), ".xml", "");
            if (!selname.equals(comboName)) continue;
            Instrument ins = Instrument.getInstrument(comboName);
            this.jTextFieldADSR2.setText(ins.getADSRAsString());
            this.jTextFieldTWANG2.setText(ins.getTWANGAsString());
            return;
        }
    }

    private void jComboBox3ActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        if (this.jComboBox3.getSelectedIndex() == -1) {
            return;
        }
        String selname = this.jComboBox3.getSelectedItem().toString();
        ArrayList<String> list2 = Instrument.getInstrumentList();
        for (String name : list2) {
            String comboName = UtilityString.replace(name.toLowerCase(), ".xml", "");
            if (!selname.equals(comboName)) continue;
            Instrument ins = Instrument.getInstrument(comboName);
            this.jTextFieldADSR3.setText(ins.getADSRAsString());
            this.jTextFieldTWANG3.setText(ins.getTWANGAsString());
            return;
        }
    }

    private void jTextField1ActionPerformed(ActionEvent evt) {
    }

    private void jButtonLoadActionPerformed(ActionEvent evt) {
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        fc.setMultiSelectionEnabled(true);
        if (this.lastImagePath.length() != 0) {
            fc.setCurrentDirectory(new File(this.lastImagePath));
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Mod-Files", "mod");
        fc.setFileFilter(filter);
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        File[] files = fc.getSelectedFiles();
        String fullPath = files == null || files.length == 1 ? fc.getSelectedFile().getAbsolutePath() : files[0].getAbsolutePath();
        this.lastImagePath = fullPath;
        this.initModFile(fullPath);
    }

    void updateVoicePlay() {
        this.voicePlay[0] = this.jCheckBoxV1.isSelected();
        this.voicePlay[1] = this.jCheckBoxV2.isSelected();
        this.voicePlay[2] = this.jCheckBoxV3.isSelected();
        this.voicePlay[3] = this.jCheckBoxV4.isSelected();
        this.iBXMPlayerJPanel1.setVoicePlay(this.voicePlay);
    }

    public static boolean showModPanel(String fileName, TinyLogInterface tl) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        ModJPanel panel = new ModJPanel(fileName, tl);
        ArrayList<JButton> eb = new ArrayList<JButton>();
        eb.add(panel.jButtonCreate);
        eb.add(panel.jButtonCancel);
        ModalInternalFrame modal = new ModalInternalFrame("Mod 2 Vectrex", frame.getRootPane(), frame, panel, null, null, eb);
        modal.setResizable(true);
        panel.modelDialog = modal;
        modal.setVisible(true);
        String result = modal.getNamedExit();
        return result.equals("create");
    }

    public static void showModPanelNoModal(String fileName, TinyLogInterface tl) {
        ModJPanel.showModPanelNoModal(fileName, tl, false);
    }

    public static void showModPanelNoModal(String fileName, TinyLogInterface tl, boolean sa) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        ModJPanel panel = new ModJPanel(fileName, tl);
        panel.standalone = sa;
        ArrayList<JButton> eb = new ArrayList<JButton>();
        eb.add(panel.jButtonCreate);
        eb.add(panel.jButtonCancel);
        Configuration.getConfiguration().getMainFrame().addAsWindow(panel, 800, 800, "Sound: Mod to Vectrex");
    }

    void createSource() {
        String nameOnly;
        int li;
        if (this.standalone) {
            InternalFrameFileChoser fc = new InternalFrameFileChoser();
            fc.setDialogTitle("Select save directory");
            fc.setCurrentDirectory(new File(Global.mainPathPrefix));
            fc.setFileSelectionMode(1);
            int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
            if (r != 0) {
                return;
            }
            String lastPath = fc.getSelectedFile().getAbsolutePath();
            Path p = Paths.get(lastPath, new String[0]);
            String newName = p.toString();
            if (!newName.endsWith(File.separator)) {
                newName = newName + File.separator;
            }
            this.pathOnly = newName;
        }
        if ((li = (nameOnly = Paths.get(this.currentModFile, new String[0]).getFileName().toString()).lastIndexOf(".")) >= 0) {
            nameOnly = nameOnly.substring(0, li);
        }
        Mod2Vectrex m2v = new Mod2Vectrex();
        int v0 = 0;
        int v1 = 1;
        int v2 = 2;
        v0 = this.jRadioButton1.isSelected() ? 0 : (this.jRadioButton2.isSelected() ? 1 : (this.jRadioButton3.isSelected() ? 2 : 3));
        v1 = this.jRadioButton5.isSelected() ? 0 : (this.jRadioButton6.isSelected() ? 1 : (this.jRadioButton7.isSelected() ? 2 : 3));
        v2 = this.jRadioButton9.isSelected() ? 0 : (this.jRadioButton10.isSelected() ? 1 : (this.jRadioButton11.isSelected() ? 2 : 3));
        m2v.vectrexModMapping[0] = v0;
        m2v.vectrexModMapping[1] = v1;
        m2v.vectrexModMapping[2] = v2;
        String currentOut = this.pathOnly + Paths.get(this.currentModFile, new String[0]).getFileName().toString();
        String result = m2v.doIt(this.currentModFile, currentOut, this.instrumentHandles, this.jTextFieldADSR1.getText(), this.jTextFieldADSR2.getText(), this.jTextFieldADSR3.getText(), this.jTextFieldTWANG1.getText(), this.jTextFieldTWANG2.getText(), this.jTextFieldTWANG3.getText(), this.jCheckBoxIndirectOutput.isSelected());
        this.tinyLog.printMessage(result);
        Path include2 = Paths.get(Global.mainPathPrefix, "template", "VECTREX.I");
        UtilityFiles.copyOneFile(include2.toString(), this.pathOnly + "VECTREX.I");
        Path digital = Paths.get(Global.mainPathPrefix, "template", "modPlayer.i");
        UtilityFiles.copyOneFile(digital.toString(), this.pathOnly + "modPlayer.i");
        Path template = Paths.get(Global.mainPathPrefix, "template", "modPlayMain.template");
        String exampleMain = UtilityString.readTextFileToOneString(new File(template.toString()));
        exampleMain = UtilityString.replace(exampleMain, "#MOD_NAME#", "" + nameOnly.toUpperCase());
        exampleMain = UtilityString.replace(exampleMain, "#MOD_NAME_ASM#", "" + nameOnly + ".asm");
        UtilityFiles.createTextFile(this.pathOnly + nameOnly + "Main.asm", exampleMain);
        if (this.tinyLog instanceof VediPanel) {
            ((VediPanel)this.tinyLog).returnFromModPanel(true);
        }
        if (this.standalone) {
            VediPanel.openInVedi(this.pathOnly + nameOnly + "Main.asm");
        }
    }

    void initInstrumentCombo() {
        ArrayList<String> list2 = Instrument.getInstrumentList();
        ++this.mClassSetting;
        this.jComboBox1.removeAllItems();
        this.jComboBox2.removeAllItems();
        this.jComboBox3.removeAllItems();
        int selIndex1 = -1;
        int selIndex2 = -1;
        int selIndex3 = -1;
        int index = 0;
        String nameSel1 = "";
        if (this.jComboBox1.getSelectedIndex() != -1) {
            nameSel1 = this.jComboBox1.getSelectedItem().toString();
        }
        String nameSel2 = "";
        if (this.jComboBox2.getSelectedIndex() != -1) {
            nameSel2 = this.jComboBox2.getSelectedItem().toString();
        }
        String nameSel3 = "";
        if (this.jComboBox3.getSelectedIndex() != -1) {
            nameSel3 = this.jComboBox3.getSelectedItem().toString();
        }
        for (String name : list2) {
            String comboName = UtilityString.replace(name.toLowerCase(), ".xml", "");
            this.jComboBox1.addItem(comboName);
            if (comboName.equals(nameSel1.toLowerCase())) {
                selIndex1 = index;
            }
            this.jComboBox2.addItem(comboName);
            if (comboName.equals(nameSel2.toLowerCase())) {
                selIndex2 = index;
            }
            this.jComboBox3.addItem(comboName);
            if (comboName.equals(nameSel3.toLowerCase())) {
                selIndex3 = index;
            }
            ++index;
        }
        this.jComboBox1.setSelectedIndex(selIndex1);
        this.jComboBox2.setSelectedIndex(selIndex2);
        this.jComboBox3.setSelectedIndex(selIndex3);
        --this.mClassSetting;
    }

    public void removeUIListerner() {
        UIManager.removePropertyChangeListener(this.pListener);
    }

    void updateMyUI() {
        int fontSize = Theme.textFieldFont.getFont().getSize();
        int rowHeight = fontSize + 2;
        this.cSATablePanel1.setRowHeight(fontSize + 1);
        this.cSATablePanel1.getTable().setFont(new Font("Courier New", 1, fontSize - 1));
        this.cSATablePanel1.setColumnWidth(0, 5);
        this.cSATablePanel1.setColumnWidth(1, 100);
        this.cSATablePanel1.setColumnWidth(2, 10);
        this.cSATablePanel1.setColumnWidth(3, 160);
        this.cSATablePanel1.setColumnWidth(4, 60);
        this.cSATablePanel1.setColumnWidth(5, 5);
    }

    @Override
    public void deIconified() {
    }

    static {
        vectrexInstruments.add(VectrexInstrument.SILENCE);
        vectrexInstruments.add(VectrexInstrument.NOTE);
        vectrexInstruments.add(VectrexInstrument.BASS);
        vectrexInstruments.add(VectrexInstrument.HIHAT);
        vectrexInstruments.add(VectrexInstrument.SNARE);
    }

    public class ModTableModel
    extends AbstractTableModel {
        String[] columns = new String[]{"No", "Name", "SampleLength", "Used #", "VectrexName", "VectrexByte"};

        @Override
        public String getColumnName(int col) {
            return this.columns[col];
        }

        @Override
        public int getRowCount() {
            return ModJPanel.this.instrumentHandles.size();
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        String pad(int v, int p) {
            String ret = "" + v;
            if (v < 10) {
                ret = "   " + ret;
            } else if (v < 100) {
                ret = "  " + ret;
            } else if (v < 1000) {
                ret = " " + ret;
            }
            return ret;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return ModJPanel.this.instrumentHandles.get((int)row).no;
            }
            if (col == 1) {
                return ModJPanel.this.instrumentHandles.get((int)row).name;
            }
            if (col == 2) {
                return ModJPanel.this.instrumentHandles.get((int)row).length;
            }
            if (col == 3) {
                int sum = ModJPanel.this.instrumentHandles.get((int)row).usage[0] + ModJPanel.this.instrumentHandles.get((int)row).usage[1] + ModJPanel.this.instrumentHandles.get((int)row).usage[2] + ModJPanel.this.instrumentHandles.get((int)row).usage[3];
                String r = "" + sum + "";
                if (sum < 10) {
                    r = r + "   ";
                } else if (sum < 100) {
                    r = r + "  ";
                } else if (sum < 1000) {
                    r = r + " ";
                }
                r = r + "(";
                r = r + "0:" + this.pad(ModJPanel.this.instrumentHandles.get((int)row).usage[0], 4);
                r = r + " 1:" + this.pad(ModJPanel.this.instrumentHandles.get((int)row).usage[1], 4);
                r = r + " 2:" + this.pad(ModJPanel.this.instrumentHandles.get((int)row).usage[2], 4);
                r = r + " 3:" + this.pad(ModJPanel.this.instrumentHandles.get((int)row).usage[3], 4);
                r = r + ")";
                return r;
            }
            if (col == 4) {
                return ModJPanel.this.instrumentHandles.get((int)row).vectrex.name;
            }
            if (col == 5) {
                if (ModJPanel.this.instrumentHandles.get((int)row).vectrex.vectrexByte == 256) {
                    return "$xx";
                }
                if (ModJPanel.this.instrumentHandles.get((int)row).vectrex.isNoise) {
                    return "$" + String.format("%02X", ModJPanel.this.instrumentHandles.get((int)row).vectrex.vectrexByte & 0xFF) + "+64";
                }
                return "$" + String.format("%02X", ModJPanel.this.instrumentHandles.get((int)row).vectrex.vectrexByte & 0xFF);
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == 4) {
                return VectrexInstrument.class;
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 4;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            if (aValue instanceof VectrexInstrument && col == 4) {
                ModJPanel.this.instrumentHandles.get((int)row).vectrex = (VectrexInstrument)aValue;
            }
        }
    }

    class InstrumentHandle {
        int no;
        String name;
        int length;
        int[] usage = new int[4];
        VectrexInstrument vectrex;

        public InstrumentHandle() {
            this.usage[0] = 0;
            this.usage[1] = 0;
            this.usage[2] = 0;
            this.usage[3] = 0;
        }
    }

    static class VectrexInstrument {
        public static final VectrexInstrument SILENCE = new VectrexInstrument("Silence", 63, true, false, false);
        public static final VectrexInstrument NOTE = new VectrexInstrument("Note", 0, false, true, false);
        public static final VectrexInstrument BASS = new VectrexInstrument("Bass drum", 63, false, false, true);
        public static final VectrexInstrument HIHAT = new VectrexInstrument("HiHat drum", 1, false, false, true);
        public static final VectrexInstrument SNARE = new VectrexInstrument("Snare drum", 47, false, false, true);
        String name;
        byte vectrexByte;
        boolean isSilent;
        boolean isNote;
        boolean isNoise;

        public VectrexInstrument(String na, byte b, boolean s, boolean n, boolean x) {
            this.name = na;
            this.vectrexByte = b;
            this.isSilent = s;
            this.isNote = n;
            this.isNoise = x;
        }

        public String toString() {
            return this.name;
        }
    }
}

