/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi.sound;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.config.TinyLogInterface;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.HotKey;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAView;
import de.malban.gui.dialogs.InternalFrameFileChoser;
import de.malban.gui.panels.LogPanel;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityString;
import de.malban.vide.dissy.DASM6809;
import de.malban.vide.vecx.devices.VecSpeechDevice;
import de.malban.vide.vecx.devices.VecVoiceSamples;
import de.malban.vide.vecx.devices.VecVoxSamples;
import de.malban.vide.vedi.VediPanel;
import de.malban.vide.vedi.sound.NavalTranslationSP0256AL2;
import de.malban.vide.vedi.sound.NavalTranslationSpeakJet;
import de.muntjak.tinylookandfeel.Theme;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;

public class VecSpeechPanel
extends JPanel
implements Windowable {
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    TinyLogInterface tinyLog = null;
    private int mClassSetting = 0;
    private CSAView mParent = null;
    private JMenuItem mParentMenuItem = null;
    String home = "";
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JButton jButtonCreate;
    private JButton jButtonPlayVectrex;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBox3;
    private JCheckBox jCheckBox4;
    private JCheckBox jCheckBox5;
    private JCheckBox jCheckBoxAutoPause;
    private JCheckBox jCheckBoxNaval;
    private JCheckBox jCheckBoxPhrasealator;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JRadioButton jRadioButtonVecVoice;
    private JRadioButton jRadioButtonVecVox;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JTable jTable1;
    private JTable jTable2;
    private JTextArea jTextArea3;
    private JTextArea jTextAreaInputText;
    private JTextArea jTextAreaTranslation;
    private JTextField jTextField1;
    private JTextField jTextField2;
    HashMap<String, String> phrasealatorMap = new HashMap();
    boolean standalone = false;
    private PropertyChangeListener pListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            VecSpeechPanel.this.updateMyUI();
        }
    };

    @Override
    public void closing() {
        this.removeUIListerner();
    }

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText("Sound: Vox/Voice Editor");
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public VecSpeechPanel(TinyLogInterface tl) {
        this.initComponents();
        if (Global.getOSName().toUpperCase().contains("MAC")) {
            HotKey.addMacDefaults(this.jTextAreaInputText);
            HotKey.addMacDefaults(this.jTextAreaTranslation);
            HotKey.addMacDefaults(this.jTextArea3);
        }
        this.tinyLog = tl;
        this.jTable1.setModel(new VecVoxTableModel());
        this.jTable2.setModel(new VecVoxSpecialTableModel());
        this.loadPhrases();
        UIManager.addPropertyChangeListener(this.pListener);
        this.updateMyUI();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jButtonCreate = new JButton();
        this.jRadioButtonVecVoice = new JRadioButton();
        this.jRadioButtonVecVox = new JRadioButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jLabel1 = new JLabel();
        this.jButtonPlayVectrex = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTextAreaInputText = new JTextArea();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.jTextAreaTranslation = new JTextArea();
        this.jLabel4 = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.jTextArea3 = new JTextArea();
        this.jCheckBox1 = new JCheckBox();
        this.jCheckBoxPhrasealator = new JCheckBox();
        this.jCheckBoxNaval = new JCheckBox();
        this.jCheckBoxAutoPause = new JCheckBox();
        this.jScrollPane5 = new JScrollPane();
        this.jTable2 = new JTable();
        this.jLabel5 = new JLabel();
        this.jCheckBox2 = new JCheckBox();
        this.jCheckBox3 = new JCheckBox();
        this.jTextField1 = new JTextField();
        this.jCheckBox4 = new JCheckBox();
        this.jTextField2 = new JTextField();
        this.jCheckBox5 = new JCheckBox();
        this.jButtonCreate.setText("create source");
        this.jButtonCreate.setName("create");
        this.jButtonCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VecSpeechPanel.this.jButtonCreateActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonVecVoice);
        this.jRadioButtonVecVoice.setText("VecVoice");
        this.jRadioButtonVecVoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VecSpeechPanel.this.jRadioButtonVecVoiceActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonVecVox);
        this.jRadioButtonVecVox.setSelected(true);
        this.jRadioButtonVecVox.setText("VecVox");
        this.jRadioButtonVecVox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VecSpeechPanel.this.jRadioButtonVecVoxActionPerformed(evt);
            }
        });
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                VecSpeechPanel.this.jTable1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jLabel1.setText("\"phonemes\"");
        this.jButtonPlayVectrex.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/control_play_blue.png")));
        this.jButtonPlayVectrex.setToolTipText("Play current sample!");
        this.jButtonPlayVectrex.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonPlayVectrex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VecSpeechPanel.this.jButtonPlayVectrexActionPerformed(evt);
            }
        });
        this.jTextAreaInputText.setColumns(20);
        this.jTextAreaInputText.setRows(5);
        this.jTextAreaInputText.setText("fxburp \\RESET \\P3 \\P3 \nfxdanger\nfxalarm\nfxrobotdroid\nfxmonths\nfxnumbers\n");
        this.jTextAreaInputText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                VecSpeechPanel.this.jTextAreaInputTextKeyTyped(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                VecSpeechPanel.this.jTextAreaInputTextKeyReleased(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTextAreaInputText);
        this.jLabel2.setText("Text");
        this.jLabel3.setText("Translation");
        this.jTextAreaTranslation.setColumns(20);
        this.jTextAreaTranslation.setRows(5);
        this.jScrollPane3.setViewportView(this.jTextAreaTranslation);
        this.jLabel4.setText("Code");
        this.jTextArea3.setColumns(20);
        this.jTextArea3.setRows(5);
        this.jScrollPane4.setViewportView(this.jTextArea3);
        this.jCheckBox1.setSelected(true);
        this.jCheckBox1.setText("create full example");
        this.jCheckBoxPhrasealator.setSelected(true);
        this.jCheckBoxPhrasealator.setText("Phrasealator");
        this.jCheckBoxPhrasealator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VecSpeechPanel.this.jCheckBoxPhrasealatorActionPerformed(evt);
            }
        });
        this.jCheckBoxNaval.setSelected(true);
        this.jCheckBoxNaval.setText("Naval rules");
        this.jCheckBoxNaval.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VecSpeechPanel.this.jCheckBoxNavalActionPerformed(evt);
            }
        });
        this.jCheckBoxAutoPause.setSelected(true);
        this.jCheckBoxAutoPause.setText("auto pause");
        this.jCheckBoxAutoPause.setToolTipText("insert a short pause for each \"space\"");
        this.jCheckBoxAutoPause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VecSpeechPanel.this.jCheckBoxAutoPauseActionPerformed(evt);
            }
        });
        this.jTable2.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                VecSpeechPanel.this.jTable2MouseClicked(evt);
            }
        });
        this.jScrollPane5.setViewportView(this.jTable2);
        this.jLabel5.setText("Speakjet commands");
        this.jCheckBox2.setSelected(true);
        this.jCheckBox2.setText("use jetphones");
        this.jCheckBox2.setToolTipText("in generated sources use the atariVox \"JetPhones.inc\" for better readability.");
        this.jCheckBox3.setSelected(true);
        this.jCheckBox3.setText("blend enable");
        this.jCheckBox3.setEnabled(false);
        this.jCheckBox3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VecSpeechPanel.this.jCheckBox3ActionPerformed(evt);
            }
        });
        this.jTextField1.setText("15");
        this.jTextField1.setEnabled(false);
        this.jCheckBox4.setSelected(true);
        this.jCheckBox4.setText("suppress silence");
        this.jCheckBox4.setEnabled(false);
        this.jCheckBox4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VecSpeechPanel.this.jCheckBox4ActionPerformed(evt);
            }
        });
        this.jTextField2.setText("1");
        this.jTextField2.setEnabled(false);
        this.jCheckBox5.setSelected(true);
        this.jCheckBox5.setText("align phases");
        this.jCheckBox5.setEnabled(false);
        this.jCheckBox5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VecSpeechPanel.this.jCheckBox5ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jCheckBox3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1, -2, 42, -2).addGap(18, 18, 18).addComponent(this.jCheckBox4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField2, -2, 42, -2).addGap(18, 18, 18).addComponent(this.jCheckBox5)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jScrollPane3, -2, 202, -2)).addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jScrollPane4, -2, 191, -2))).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jRadioButtonVecVoice).addGap(18, 18, 18).addComponent(this.jRadioButtonVecVox).addGap(18, 18, 18).addComponent(this.jButtonPlayVectrex)).addComponent(this.jLabel2)).addGap(29, 29, 29).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxNaval).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBoxPhrasealator).addGap(18, 18, 18).addComponent(this.jCheckBoxAutoPause)))).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, -2, 403, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jScrollPane1, -1, 289, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jCheckBox1).addGap(18, 18, 18))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane5, -1, 289, Short.MAX_VALUE).addComponent(this.jLabel5))).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBox2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCreate))).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonPlayVectrex, GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonVecVoice).addComponent(this.jRadioButtonVecVox))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jCheckBoxNaval)).addGap(5, 5, 5).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane4).addComponent(this.jScrollPane3))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jCheckBoxPhrasealator).addComponent(this.jCheckBoxAutoPause).addComponent(this.jLabel5)).addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 416, Short.MAX_VALUE).addComponent(this.jScrollPane5, -1, 416, Short.MAX_VALUE)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCreate).addComponent(this.jCheckBox1).addComponent(this.jCheckBox2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox3).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jCheckBox4).addComponent(this.jTextField2, -2, 21, -2).addComponent(this.jCheckBox5)).addGap(9, 9, 9)))));
    }

    private void jButtonCreateActionPerformed(ActionEvent evt) {
        this.createSource();
        if (this.tinyLog instanceof VediPanel) {
            VediPanel vedi = (VediPanel)this.tinyLog;
            vedi.refreshTree();
        }
    }

    private void jButtonPlayVectrexActionPerformed(ActionEvent evt) {
        this.doIt();
        VecSpeechDevice.blendEnable = this.jCheckBox3.isSelected();
        VecSpeechDevice.blendLen = UtilityString.Int0(this.jTextField1.getText());
        VecSpeechDevice.removeSilence = this.jCheckBox4.isSelected();
        VecSpeechDevice.maxNoise = UtilityString.Int0(this.jTextField2.getText());
        VecSpeechDevice.alignBlendToAmplitude = this.jCheckBox5.isSelected();
        VecSpeechDevice.resetWaveCollector();
        VecSpeechDevice.saveWave = true;
        this.playSpeech();
    }

    private void jTextAreaInputTextKeyTyped(KeyEvent evt) {
    }

    private void jCheckBoxAutoPauseActionPerformed(ActionEvent evt) {
        this.loadPhrases();
        this.doIt();
    }

    private void jTextAreaInputTextKeyReleased(KeyEvent evt) {
        this.doIt();
    }

    private void jTable1MouseClicked(MouseEvent evt) {
        JTable table = (JTable)evt.getSource();
        Point p = evt.getPoint();
        int row = table.rowAtPoint(p);
        int col = table.columnAtPoint(p);
        if (this.jRadioButtonVecVox.isSelected()) {
            if (evt.getClickCount() == 2) {
                VecVoxSamples.SpeakJetMSA sa = VecVoxSamples.getAllSamples()[row];
                if (evt.getButton() == 3) {
                    VecVoxSamples.playSample(sa.code);
                } else {
                    int pos = this.jTextAreaInputText.getCaretPosition();
                    this.jTextAreaInputText.insert("\\" + sa.phoneme + " ", pos);
                    this.doIt();
                }
            }
        } else if (this.jRadioButtonVecVoice.isSelected() && evt.getClickCount() == 2) {
            VecVoiceSamples.SP0256AL sa = VecVoiceSamples.getAllSamples()[row];
            if (evt.getButton() == 3) {
                VecVoiceSamples.playSample(sa.code);
            } else {
                int pos = this.jTextAreaInputText.getCaretPosition();
                this.jTextAreaInputText.insert("\\" + sa.phoneme + " ", pos);
                this.doIt();
            }
        }
    }

    private void jTable2MouseClicked(MouseEvent evt) {
        JTable table = (JTable)evt.getSource();
        Point p = evt.getPoint();
        int row = table.rowAtPoint(p);
        int col = table.columnAtPoint(p);
        if (evt.getClickCount() == 2) {
            VecVoxSamples.SpeakSpecials sa = VecVoxSamples.getAllSpecials().get(row);
            int pos = this.jTextAreaInputText.getCaretPosition();
            String insert = sa.mnemonic + " ";
            if (sa.codes.contains(" x ")) {
                String[] addi = sa.codes.split(" ");
                String a = addi[addi.length - 1].substring(1);
                a = UtilityString.replace(a, ")", "");
                insert = insert + " \\" + a + " ";
            }
            this.jTextAreaInputText.insert(insert, pos);
            this.doIt();
        }
    }

    private void jCheckBoxPhrasealatorActionPerformed(ActionEvent evt) {
        this.loadPhrases();
        this.doIt();
    }

    private void jCheckBoxNavalActionPerformed(ActionEvent evt) {
        this.doIt();
    }

    private void jRadioButtonVecVoiceActionPerformed(ActionEvent evt) {
        this.jCheckBoxPhrasealator.setEnabled(false);
        this.jCheckBoxPhrasealator.setSelected(false);
        this.jCheckBox2.setEnabled(false);
        this.jScrollPane5.setVisible(false);
        this.jLabel5.setVisible(false);
        this.jTable1.setModel(new VecVoiceTableModel());
        this.loadPhrases();
        this.doIt();
    }

    private void jRadioButtonVecVoxActionPerformed(ActionEvent evt) {
        this.jCheckBoxPhrasealator.setEnabled(true);
        this.jCheckBoxPhrasealator.setSelected(true);
        this.jCheckBox2.setEnabled(false);
        this.jButtonCreate.setEnabled(true);
        this.jScrollPane5.setVisible(true);
        this.jLabel5.setVisible(true);
        this.jTable1.setModel(new VecVoxTableModel());
        this.loadPhrases();
        this.doIt();
    }

    private void jCheckBox4ActionPerformed(ActionEvent evt) {
        VecSpeechDevice.removeSilence = this.jCheckBox4.isSelected();
        VecSpeechDevice.maxNoise = UtilityString.Int0(this.jTextField2.getText());
    }

    private void jCheckBox3ActionPerformed(ActionEvent evt) {
        VecSpeechDevice.blendEnable = this.jCheckBox3.isSelected();
        VecSpeechDevice.blendLen = UtilityString.Int0(this.jTextField1.getText());
    }

    private void jCheckBox5ActionPerformed(ActionEvent evt) {
        VecSpeechDevice.alignBlendToAmplitude = this.jCheckBox5.isSelected();
    }

    private void outPutMnemonicsSP0256Al2(ArrayList<String> mnemonics) {
        int count = 0;
        StringBuilder out1 = new StringBuilder();
        StringBuilder out2 = new StringBuilder();
        for (String m : mnemonics) {
            if (count != 0) {
                out1.append(" ");
                out2.append(", ");
            }
            out1.append(m);
            out2.append(this.getCodeStringSP0256Al2(m));
            if (count++ != 4) continue;
            count = 0;
            out1.append("\n");
            out2.append("\n");
        }
        this.jTextAreaTranslation.setText(out1.toString());
        this.jTextArea3.setText(out2.toString());
    }

    private void outPutMnemonicsSpeakJet(ArrayList<String> mnemonics) {
        int count = 0;
        StringBuilder out1 = new StringBuilder();
        StringBuilder out2 = new StringBuilder();
        for (String m : mnemonics) {
            if (count != 0) {
                out1.append(" ");
                out2.append(", ");
            }
            out1.append(m);
            out2.append(this.getCodeStringSpeakJet(m));
            if (count++ != 4) continue;
            count = 0;
            out1.append("\n");
            out2.append("\n");
        }
        this.jTextAreaTranslation.setText(out1.toString());
        this.jTextArea3.setText(out2.toString());
    }

    private String getCodeStringSP0256Al2(String mnemonic) {
        String unescape = UtilityString.replace(mnemonic, "\\", "");
        HashMap<String, String> codeMap = VecVoiceSamples.getCodeMap();
        if (UtilityString.isDecNumber(unescape)) {
            return unescape;
        }
        String code2 = codeMap.get(unescape);
        if (code2 == null) {
            return "ERROR";
        }
        int pos = code2.indexOf(" x ");
        if (pos != -1) {
            code2 = code2.substring(0, pos).trim();
        }
        if ((code2 = code2.trim()).endsWith(",")) {
            code2 = code2.substring(0, code2.length() - 1);
            code2 = code2.trim();
        }
        return code2;
    }

    private String getCodeStringSpeakJet(String mnemonic) {
        String unescape = UtilityString.replace(mnemonic, "\\", "");
        HashMap<String, String> codeMap = VecVoxSamples.getCodeMap();
        String code2 = codeMap.get(unescape);
        if (code2 == null) {
            return "ERROR";
        }
        int pos = code2.indexOf(" x ");
        if (pos != -1) {
            code2 = code2.substring(0, pos).trim();
        }
        if ((code2 = code2.trim()).endsWith(",")) {
            code2 = code2.substring(0, code2.length() - 1);
            code2 = code2.trim();
        }
        return code2;
    }

    public static void showVecSpeechPanelNoModal(TinyLogInterface tl, String path) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        VecSpeechPanel panel = new VecSpeechPanel(tl);
        panel.home = path;
        if (path == null) {
            panel.standalone = true;
        }
        Configuration.getConfiguration().getMainFrame().addAsWindow(panel, 1024, 600, "Sound: Vox/Voice Editor");
    }

    boolean loadPhrases() {
        if (!this.jCheckBoxPhrasealator.isSelected()) {
            return true;
        }
        this.phrasealatorMap = new HashMap();
        try {
            String[] twoSides;
            Vector<String> strings = UtilityString.readTextFileToString(new File(Global.mainPathPrefix + "template" + File.separator + "Phrasealator.Dic"));
            ArrayList<String> iterativePhrase = new ArrayList<String>();
            for (int i = 0; i < strings.size(); ++i) {
                String line = strings.elementAt(i);
                twoSides = line.split("=");
                if (twoSides.length != 2) continue;
                twoSides[1] = twoSides[1].replace("\\Fast ", "\\FAST ");
                twoSides[1] = twoSides[1].replace("\\Slow ", "\\SLOW ");
                twoSides[1] = twoSides[1].replace("\\Soft ", "\\SOFT ");
                twoSides[1] = twoSides[1].replace("\\Stress ", "\\STRESS ");
                twoSides[1] = twoSides[1].replace("\\Reset ", "\\RESET ");
                if (this.containsWithoutSlash(twoSides[1])) {
                    iterativePhrase.add(line);
                    continue;
                }
                this.phrasealatorMap.put(twoSides[0].trim().toUpperCase(), twoSides[1].trim().toUpperCase());
            }
            for (String line : iterativePhrase) {
                twoSides = line.split("=");
                String from = twoSides[0];
                String to = twoSides[1];
                to = to.replace("\\Fast ", "\\FAST ");
                to = to.replace("\\Slow ", "\\SLOW ");
                to = to.replace("\\Soft ", "\\SOFT ");
                to = to.replace("\\Stress ", "\\STRESS ");
                to = to.replace("\\Reset ", "\\RESET ");
                to = to.replace(",", " \\P2 ");
                to = to.replace("  ", " ");
                String[] subs = to.split(" ");
                String newTo = "";
                for (String s : subs) {
                    String mapped = this.phrasealatorMap.get(s.toUpperCase());
                    if (mapped != null) {
                        newTo = newTo + " " + mapped;
                        if (!this.jCheckBoxAutoPause.isSelected()) continue;
                        newTo = newTo + " \\P2";
                        continue;
                    }
                    newTo = newTo + " " + s.toUpperCase();
                }
                newTo = newTo.replace("  ", " ");
                newTo = newTo.trim();
                this.phrasealatorMap.put(from.toUpperCase(), newTo.toUpperCase());
            }
        }
        catch (Throwable e) {
            this.log.addLog(e, LogPanel.WARN);
            return false;
        }
        return true;
    }

    ArrayList<String> applySP0256Al2Translation() {
        ArrayList<String> out = new ArrayList<String>();
        String text = this.getCleanInput();
        String[] phrases = text.toUpperCase().split(" ");
        boolean doPause = false;
        for (String phrase2 : phrases) {
            if (phrase2.length() == 0) continue;
            if (doPause && this.jCheckBoxAutoPause.isSelected()) {
                out.add("\\PA4");
            }
            if (phrase2.startsWith("\\")) {
                if (phrase2.startsWith("\\$")) {
                    phrase2 = this.unhex(phrase2);
                }
                out.add(phrase2);
                continue;
            }
            doPause = true;
            if (!this.jCheckBoxNaval.isSelected()) continue;
            out.addAll(this.doSP0256Al2Naval(phrase2));
        }
        out.add("\\VOICE_TERM");
        return out;
    }

    ArrayList<String> applySpeakJetTranslation() {
        ArrayList<String> out = new ArrayList<String>();
        String text = this.getCleanInput();
        String[] phrases = text.toUpperCase().split(" ");
        boolean doPause = false;
        String lastPhrase = "";
        for (String phrase2 : phrases) {
            String t;
            if (phrase2.length() == 0) continue;
            if (doPause && !lastPhrase.toUpperCase().contains("\\") && this.jCheckBoxAutoPause.isSelected()) {
                out.add("\\P5");
            }
            lastPhrase = phrase2;
            if (phrase2.startsWith("\\")) {
                if (phrase2.startsWith("\\$")) {
                    phrase2 = this.unhex(phrase2);
                }
                out.add(phrase2);
                continue;
            }
            doPause = true;
            if (this.jCheckBoxPhrasealator.isSelected() && (t = this.phrasealatorMap.get(phrase2)) != null) {
                String[] codes;
                for (String code2 : codes = t.split(" ")) {
                    if (code2.trim().length() == 0) continue;
                    out.add(code2);
                }
                continue;
            }
            if (!this.jCheckBoxNaval.isSelected()) continue;
            out.addAll(this.doSpeakJetNaval(phrase2));
        }
        out.add("\\VOX_TERM");
        return out;
    }

    String unhex(String phrase2) {
        String ret = "\\";
        String work = phrase2.substring(1);
        ret = ret + DASM6809.toNumber(work);
        return ret;
    }

    boolean containsLowerCase(String l) {
        return !l.toUpperCase().equals(l);
    }

    boolean containsWithoutSlash(String l) {
        String[] a;
        l = l.trim();
        l = l.replace(",", " ");
        l = l.replace("  ", " ");
        for (String aa : a = l.split(" ")) {
            if (aa.trim().length() == 0 || aa.startsWith("\\")) continue;
            return true;
        }
        return false;
    }

    ArrayList<String> doSpeakJetNaval(String word) {
        String[] codes;
        String navelCodes = NavalTranslationSpeakJet.xlate_word(word);
        ArrayList<String> out = new ArrayList<String>();
        for (String code2 : codes = navelCodes.split(" ")) {
            int c;
            if (code2.trim().length() == 0 || (c = UtilityString.IntX(code2.trim(), -1)) == -1 || c < 128) continue;
            out.add("\\" + VecVoxSamples.getAllSamples()[c - 128].phoneme);
        }
        return out;
    }

    ArrayList<String> doSP0256Al2Naval(String word) {
        String[] codes;
        String navelCodes = NavalTranslationSP0256AL2.xlate_word(word);
        ArrayList<String> out = new ArrayList<String>();
        for (String code2 : codes = navelCodes.split(" ")) {
            int c;
            if (code2.trim().length() == 0 || (c = UtilityString.IntX(code2.trim(), -1)) == -1 || c > 63) continue;
            out.add("\\" + VecVoiceSamples.getAllSamples()[c].phoneme);
        }
        return out;
    }

    String getCleanInput() {
        String text = this.jTextAreaInputText.getText();
        ArrayList out = new ArrayList();
        text = text.replace(",", " \\P2 ");
        text = text.replace(".", " \\P2 ");
        text = text.replace(";", " \\P2 ");
        text = text.replace("\"", "");
        text = text.replace("\n", " ");
        text = text.replace("\r", " ");
        text = text.replace("\t", " ");
        return text;
    }

    void doIt() {
        if (!this.jRadioButtonVecVox.isSelected()) {
            ArrayList<String> mnemonics = this.applySP0256Al2Translation();
            this.outPutMnemonicsSP0256Al2(mnemonics);
        } else {
            ArrayList<String> mnemonics = this.applySpeakJetTranslation();
            this.outPutMnemonicsSpeakJet(mnemonics);
        }
    }

    void createSource() {
        String pathOnly;
        if (this.standalone) {
            InternalFrameFileChoser fc = new InternalFrameFileChoser();
            fc.setDialogTitle("Select save directory");
            fc.setFileSelectionMode(1);
            fc.setCurrentDirectory(new File(Global.mainPathPrefix));
            int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
            if (r != 0) {
                return;
            }
            this.home = fc.getSelectedFile().getAbsolutePath();
            if (!this.home.endsWith(File.separator)) {
                this.home = this.home + File.separator;
            }
        }
        if (this.jRadioButtonVecVox.isSelected()) {
            pathOnly = Paths.get(this.home, new String[0]).toString();
            if (pathOnly.length() != 0) {
                pathOnly = pathOnly + File.separator;
            }
            Path include2 = Paths.get(Global.mainPathPrefix, "template", "VECTREX.I");
            UtilityFiles.copyOneFile(include2.toString(), pathOnly + "VECTREX.I");
            Path serial = Paths.get(Global.mainPathPrefix, "template", "ser_ji.i");
            UtilityFiles.copyOneFile(serial.toString(), pathOnly + "ser_ji.i");
            Path vecVox = Paths.get(Global.mainPathPrefix, "template", "vecvox.i");
            UtilityFiles.copyOneFile(vecVox.toString(), pathOnly + "vecvox.i");
            if (this.jCheckBox2.isSelected()) {
                Path jetPhones = Paths.get(Global.mainPathPrefix, "template", "jetphones.inc");
                UtilityFiles.copyOneFile(jetPhones.toString(), pathOnly + "jetphones.inc");
            }
            String vectrexData = this.generateVectrexData(this.jCheckBox2.isSelected());
            UtilityFiles.createTextFile(pathOnly + "speechData.i", vectrexData);
            if (this.jCheckBox1.isSelected()) {
                Path template = Paths.get(Global.mainPathPrefix, "template", "vecVoxMain.template");
                String exampleMain = UtilityString.readTextFileToOneString(new File(template.toString()));
                UtilityFiles.createTextFile(pathOnly + "vecVoxMain.asm", exampleMain);
            }
            if (this.tinyLog instanceof VediPanel) {
                ((VediPanel)this.tinyLog).returnFromVecVoxPanel(1);
            }
            if (this.jCheckBox1.isSelected() && this.standalone) {
                VediPanel.openInVedi(pathOnly + "vecVoxMain.asm");
            }
        } else if (this.jRadioButtonVecVoice.isSelected()) {
            pathOnly = Paths.get(this.home, new String[0]).toString();
            if (pathOnly.length() != 0) {
                pathOnly = pathOnly + File.separator;
            }
            Path include3 = Paths.get(Global.mainPathPrefix, "template", "VECTREX.I");
            UtilityFiles.copyOneFile(include3.toString(), pathOnly + "VECTREX.I");
            Path serial = Paths.get(Global.mainPathPrefix, "template", "ser_ji.i");
            UtilityFiles.copyOneFile(serial.toString(), pathOnly + "ser_ji.i");
            Path vecVox = Paths.get(Global.mainPathPrefix, "template", "vecvoice.i");
            UtilityFiles.copyOneFile(vecVox.toString(), pathOnly + "vecvoice.i");
            String vectrexData = this.generateVectrexVecVoiceData();
            UtilityFiles.createTextFile(pathOnly + "speechData.i", vectrexData);
            if (this.jCheckBox1.isSelected()) {
                Path template = Paths.get(Global.mainPathPrefix, "template", "vecVoiceMain.template");
                String exampleMain = UtilityString.readTextFileToOneString(new File(template.toString()));
                UtilityFiles.createTextFile(pathOnly + "vecVoiceMain.asm", exampleMain);
            }
            if (this.tinyLog instanceof VediPanel) {
                ((VediPanel)this.tinyLog).returnFromVecVoxPanel(2);
            }
            if (this.jCheckBox1.isSelected() && this.standalone) {
                VediPanel.openInVedi(pathOnly + "vecVoiceMain.asm");
            }
        }
    }

    void playSpeech() {
        String text = this.jTextArea3.getText();
        text = UtilityString.replace(text, ",", " ");
        text = UtilityString.replaceWhiteSpaces(text, ",");
        text = UtilityString.replace(text, " ", ",");
        text = UtilityString.replace(text, ",,", ",");
        String[] splitter = text.split(",");
        ArrayList<Integer> param = new ArrayList<Integer>();
        for (String one : splitter) {
            if (one.trim().length() == 0) continue;
            param.add(UtilityString.Int0(one.trim()));
        }
        VecSpeechDevice.speak(param, this.jRadioButtonVecVoice.isSelected());
    }

    String generateVectrexVecVoiceData() {
        this.doIt();
        StringBuilder ret = new StringBuilder();
        ret.append("speechData:\n");
        String text = this.jTextArea3.getText();
        text = UtilityString.replace(text, ",", " ");
        text = UtilityString.replaceWhiteSpaces(text, ",");
        text = UtilityString.replace(text, " ", ",");
        text = UtilityString.replace(text, ",,", ",");
        String[] splitter = text.split(",");
        int count = 0;
        for (String one : splitter) {
            if (one.trim().length() == 0) continue;
            int code2 = UtilityString.Int0(one.trim());
            if (count == 0) {
                ret.append(" db ");
            } else {
                ret.append(", ");
            }
            ret.append("" + code2);
            if (++count != 10) continue;
            ret.append("\n");
            count = 0;
        }
        return ret.toString();
    }

    String generateVectrexData(boolean useJetPhones) {
        this.doIt();
        StringBuilder ret = new StringBuilder();
        if (useJetPhones) {
            ret.append(" include \"jetphones.inc\"\n\n");
        }
        ret.append("speechData:\n");
        String text = this.jTextArea3.getText();
        text = UtilityString.replace(text, ",", " ");
        text = UtilityString.replaceWhiteSpaces(text, ",");
        text = UtilityString.replace(text, " ", ",");
        text = UtilityString.replace(text, ",,", ",");
        String[] splitter = text.split(",");
        int count = 0;
        boolean wasSpecial = false;
        for (String one : splitter) {
            if (one.trim().length() == 0) continue;
            int code2 = UtilityString.Int0(one.trim());
            if (count == 0) {
                ret.append(" db ");
            } else {
                ret.append(", ");
            }
            if (useJetPhones) {
                if (!wasSpecial) {
                    ret.append(VecVoxSamples.getMnemonic(code2));
                } else {
                    ret.append("" + code2);
                }
                wasSpecial = false;
                if (code2 == 20) {
                    wasSpecial = true;
                }
                if (code2 == 21) {
                    wasSpecial = true;
                }
                if (code2 == 22) {
                    wasSpecial = true;
                }
                if (code2 == 23) {
                    wasSpecial = true;
                }
                if (code2 == 26) {
                    wasSpecial = true;
                }
                if (code2 == 30) {
                    wasSpecial = true;
                }
            } else {
                ret.append("" + code2);
            }
            if (++count != 10) continue;
            ret.append("\n");
            count = 0;
        }
        return ret.toString();
    }

    public void removeUIListerner() {
        UIManager.removePropertyChangeListener(this.pListener);
    }

    void updateMyUI() {
        int fontSize = Theme.textFieldFont.getFont().getSize();
        int rowHeight = fontSize + 2;
        this.jTable1.setRowHeight(rowHeight);
        this.jTable2.setRowHeight(rowHeight);
    }

    @Override
    public void deIconified() {
    }

    public class VecVoiceTableModel
    extends AbstractTableModel {
        String[] columns = new String[]{"\"Mnemonic\"", "Code", "Example"};

        @Override
        public String getColumnName(int col) {
            return this.columns[col];
        }

        @Override
        public int getRowCount() {
            return VecVoiceSamples.getAllSamples().length;
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < 0 || row > 63) {
                return "";
            }
            if (col == 0) {
                return VecVoiceSamples.getAllSamples()[row].phoneme;
            }
            if (col == 1) {
                return "" + VecVoiceSamples.getAllSamples()[row].code;
            }
            if (col == 2) {
                return VecVoiceSamples.getAllSamples()[row].sampleWords;
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    public class VecVoxTableModel
    extends AbstractTableModel {
        String[] columns = new String[]{"\"Mnemonic\"", "Code", "Example"};

        @Override
        public String getColumnName(int col) {
            return this.columns[col];
        }

        @Override
        public int getRowCount() {
            return VecVoxSamples.getAllSamples().length;
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < 0 || row > 128) {
                return "";
            }
            if (col == 0) {
                return VecVoxSamples.getAllSamples()[row].phoneme;
            }
            if (col == 1) {
                return "" + VecVoxSamples.getAllSamples()[row].code;
            }
            if (col == 2) {
                return VecVoxSamples.getAllSamples()[row].sampleWords;
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    public class VecVoxSpecialTableModel
    extends AbstractTableModel {
        String[] columns = new String[]{"\"Mnemonic\"", "Code(s)"};

        @Override
        public String getColumnName(int col) {
            return this.columns[col];
        }

        @Override
        public int getRowCount() {
            return VecVoxSamples.getAllSpecials().size();
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < 0 || row > 128) {
                return "";
            }
            if (col == 0) {
                return VecVoxSamples.getAllSpecials().get((int)row).mnemonic;
            }
            if (col == 1) {
                return "" + VecVoxSamples.getAllSpecials().get((int)row).codes;
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

