/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi.sound;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.config.TinyLogInterface;
import de.malban.gui.panels.LogPanel;
import de.malban.util.UtilityFiles;
import de.malban.vide.vedi.sound.DoubleLinkedList;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import net.sourceforge.lhadecompressor.LhaEntry;
import net.sourceforge.lhadecompressor.LhaFile;

public class YmSound {
    TinyLogInterface tl;
    int current_working_register = 0;
    String file_name = "";
    String song_name = "";
    int DATA_TAB = 40;
    int MIN_PHRASE_LEN = 2;
    int MAX_PHRASE_LEN = 16;
    int PHRASES_MAX_DEPTH = 10;
    int VECTREX_DECODER = 1;
    int PHRASE_OPTIMIZER = 2;
    int OLD_STYLE = 0;
    int ENCODE_START = 0;
    int ENCODE_END = 14;
    boolean packed = true;
    boolean init = false;
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    String pathFull = "";
    String pathOnly = "";
    String filenameOnly = "";
    String filenameBaseOnly = "";
    boolean SHANNON = true;
    boolean RLE_USED = true;
    boolean USE_PHRASE = true;
    boolean OPTIMAL_PHRASE = true;
    public int attribut = 0;
    public int samples = 0;
    public int loopStart = 0;
    public String author = "";
    public String comment = "";
    public boolean interleave = true;
    public int vbl_len = 0;
    public int externalFrequency = 0;
    public int playerFrequency = 0;
    public int futureDataLength = 0;
    public String unpackedName = "";
    public byte[][] out_buf = new byte[16][];
    String version = "";
    int bitsSaved = 0;
    public static final int BIT = 0;
    public static final int CODE = 1;
    DoubleLinkedList list = new DoubleLinkedList();
    byte current_out;
    byte current_out_bit;
    byte current_out_bit_counter;
    BufferedWriter dbOutFile = null;
    int byte_out_counter = 0;
    public static final int _MAX_PHRASE_LEN_ = 100;
    public static final int PHRASES_MAX = 100;
    public static final int VALID_BYTE = 1;
    public static final int VALID_PHRASE = 2;
    public static final int VALID_RLE_BYTE = 3;
    public static final int VALID_RLE_PHRASE = 4;
    public static final int VALID_ENCODED_BYTE = 5;
    public static final int VALID_ENCODED_PHRASE = 6;
    public static final int VALID_ENCODED_RLE_BYTE = 7;
    public static final int VALID_ENCODED_RLE_PHRASE = 8;
    public static final int INVALID = 0;
    public static final int VALID = 1;
    public static final int ENCODED = 2;
    public static final int RLE = 4;
    public static final int RLE_ENCODED = 6;
    phrase[][] alternating_phrases = new phrase[2][];
    int phrase_toggler;
    String[] type_string = new String[]{"INVALID", "VALID_BYTE", "VALID_PHRASE", "VALID_RLE_BYTE", "VALID_RLE_PHRASE", "VALID_ENCODED_BYTE", "VALID_ENCODED_PHRASE", "VALID_ENCODED_RLE_BYTE", "VALID_ENCODED_RLE_PHRASE"};
    public static boolean dontShanonSingleByteUsages = true;
    public static boolean enableAmlitude5thBit = false;

    public YmSound(String filename, TinyLogInterface tinl) {
        byte[] buf;
        this.tl = tinl;
        if (filename.length() == 0) {
            this.attribut = 1;
            this.author = "VIDE";
            this.externalFrequency = 2000000;
            this.playerFrequency = 50;
            this.packed = false;
            this.init = true;
            this.version = "YM6!";
            this.vbl_len = 1;
            for (int i = 0; i < 16; ++i) {
                this.out_buf[i] = new byte[1];
            }
            return;
        }
        Path path = Paths.get(filename, new String[0]);
        long orglen = 0L;
        orglen = (int)new File(filename).length();
        try {
            buf = Files.readAllBytes(path);
            if (buf.length > 8) {
                if (buf[2] == 45 && buf[3] == 108 && buf[6] == 45) {
                    this.packed = true;
                    this.unpackedName = YmSound.unpackYMLharc(filename);
                    if (this.unpackedName == null) {
                        this.log.addLog("YM - unpack error...", LogPanel.WARN);
                        return;
                    }
                    this.tl.printMessageSU(filename + " unpacked to: " + this.unpackedName);
                } else {
                    this.unpackedName = filename;
                    this.packed = false;
                }
            }
        }
        catch (Throwable e) {
            this.log.addLog("YM - error reading file ('" + filename + "').", LogPanel.WARN);
            return;
        }
        path = Paths.get(this.unpackedName, new String[0]);
        try {
            buf = Files.readAllBytes(path);
        }
        catch (Throwable e) {
            this.log.addLog("YM - error reading unpacked file ('" + this.unpackedName + "').", LogPanel.WARN);
            return;
        }
        int len = buf.length;
        Path p = Paths.get(filename, new String[0]);
        this.pathFull = p.toString();
        this.pathOnly = p.getParent().toString();
        this.filenameOnly = p.getFileName().toString();
        this.filenameBaseOnly = this.filenameOnly.substring(0, this.filenameOnly.length() - 3);
        String format = "";
        format = format + (char)buf[0];
        format = format + (char)buf[1];
        format = format + (char)buf[2];
        format = format + (char)buf[3];
        this.tl.printMessageSU("Length of file: " + len + "(" + orglen + ")");
        this.version = format.toUpperCase();
        if (format.toUpperCase().equals("YM2!")) {
            this.tl.printMessageSU("YM2! format");
            this.vbl_len = this.convert_ym2(this.out_buf, buf, len);
        } else if (format.toUpperCase().equals("YM3!")) {
            this.tl.printMessageSU("YM3! format");
            this.vbl_len = this.convert_ym3(this.out_buf, buf, len);
        } else if (format.toUpperCase().equals("YM3b")) {
            this.tl.printMessageSU("YM3b format");
            this.vbl_len = this.convert_ym3b(this.out_buf, buf, len);
        } else if (format.toUpperCase().equals("YM4!")) {
            this.tl.printMessageSU("YM4! format");
            this.vbl_len = this.convert_ym4(this.out_buf, buf);
        } else if (format.toUpperCase().equals("YM5!")) {
            this.tl.printMessageSU("YM5! format");
            this.vbl_len = this.convert_ym5(this.out_buf, buf);
        } else if (format.toUpperCase().equals("YM6!")) {
            this.tl.printMessageSU("YM6! format");
            this.tl.printMessageSU("I have found no documentation for this format, for now");
            this.tl.printMessageSU("YM5! is assumed for this. - works most of the time...");
            this.vbl_len = this.convert_ym5(this.out_buf, buf);
        } else {
            this.tl.printMessageSU("Unkown or unsupported format!");
            return;
        }
        if (this.vbl_len == 0) {
            this.tl.printMessageSU("Unsupported format!\n");
            this.log.addLog("YM - Unsupported format! ('" + this.unpackedName + "').", LogPanel.WARN);
            return;
        }
        this.init = true;
    }

    public static String unpackYMLharc(String filename) {
        try {
            int BUFFSER_SIZE = 4096;
            byte[] buff = new byte[BUFFSER_SIZE];
            LhaFile file = new LhaFile(filename);
            Iterator iter = file.entryIterator();
            File dst = null;
            while (iter.hasNext()) {
                int len;
                LhaEntry entry = (LhaEntry)iter.next();
                String dstName = Global.mainPathPrefix + "tmp" + File.separator + entry.getFile().getName();
                dst = new File(dstName);
                if (entry.getMethod().equals("-lhd-")) continue;
                BufferedInputStream in = new BufferedInputStream(file.getInputStream(entry), BUFFSER_SIZE);
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dst), BUFFSER_SIZE);
                while ((len = ((InputStream)in).read(buff, 0, BUFFSER_SIZE)) >= 0) {
                    ((OutputStream)out).write(buff, 0, len);
                }
                ((OutputStream)out).flush();
                ((OutputStream)out).close();
            }
            file.close();
            if (dst != null) {
                return dst.toString();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    public String buildASM(boolean[] regsUsed) {
        BufferedWriter bw;
        if (!this.init) {
            return null;
        }
        int li = this.unpackedName.lastIndexOf(".");
        if (li < 0) {
            this.log.addLog("YM - filename error ('" + this.unpackedName + "').", LogPanel.WARN);
            return null;
        }
        String name_out_raw = this.unpackedName.substring(0, li);
        name_out_raw = name_out_raw + ".asm";
        File file = new File(name_out_raw);
        try {
            FileWriter fw = new FileWriter(file.getAbsoluteFile());
            bw = new BufferedWriter(fw);
        }
        catch (Throwable e) {
            this.log.addLog("YM - Error openening output file! ('" + name_out_raw + "').", LogPanel.WARN);
            return null;
        }
        this.init_bit_out(bw);
        int overall_used_bits = 0;
        BufferedWriter outFile = this.get_dbOutFile();
        try {
            int ym_register;
            if (outFile != null) {
                outFile.write("" + this.file_name + "_start: \n");
                outFile.write(" DW " + this.vbl_len + " ; vbl_len \n");
            }
            this.tl.printMessageSU("");
            this.tl.printMessageSU("Start packing data...");
            this.bitsSaved = 0;
            for (ym_register = this.ENCODE_START; ym_register < this.ENCODE_END; ++ym_register) {
                if (!regsUsed[ym_register]) continue;
                this.current_working_register = ym_register;
                abstract_buffer abuffer = this.build_abstract(this.out_buf[ym_register], this.vbl_len);
                if (this.USE_PHRASE) {
                    this.abstract_search_insert_phrases_optimal(abuffer);
                }
                if (this.SHANNON) {
                    this.abstract_Shannon(abuffer);
                }
                if (this.RLE_USED) {
                    this.abstract_RLE(abuffer);
                }
                int used_bits = this.get_bits_used_from_abstract_complete(abuffer);
                this.abstract_out(abuffer);
                this.tl.printMessageSU("Register " + this.current_working_register + " -> Bytes used: " + (used_bits + 7) / 8 + " ");
                overall_used_bits += used_bits;
                this.delete_abstract(abuffer);
                this.tl.printMessageSU("");
            }
            this.tl.printMessageSU("Bytes used alltogether (best guess :-)): " + ((overall_used_bits += 560) + 7) / 8 + " ");
            if (outFile != null) {
                outFile.write("" + this.file_name + "_data: \n");
                outFile.write(" DW " + this.file_name + "_start \n");
                for (ym_register = this.ENCODE_START; ym_register < this.ENCODE_END; ++ym_register) {
                    if (!regsUsed[ym_register]) continue;
                    outFile.write(" DB $" + String.format("%02X", ym_register) + "\n");
                    if (dontShanonSingleByteUsages) {
                        outFile.write(" DW " + this.file_name + "_reg_" + ym_register + "");
                    } else {
                        outFile.write(" DW " + this.file_name + "_reg_" + ym_register + "-3");
                    }
                    outFile.write(", " + this.file_name + "_pd_" + ym_register + "");
                    outFile.write(", " + this.file_name + "_reg_" + ym_register + "_data\n");
                }
                outFile.write(" DB $" + String.format("%02X", 255) + "\n");
                outFile.write("SONG_DATA EQU " + this.file_name + "_data \n");
                outFile.write("" + this.file_name + "_name: \n DB ");
                for (int i = 0; i < this.song_name.length(); ++i) {
                    byte c = (byte)this.song_name.toUpperCase().charAt(i);
                    if (c > 90) continue;
                    outFile.write("$" + String.format("%02X", c & 0xFF) + ", ");
                }
                outFile.write("$80 \n");
            }
            this.deinit_bit_out();
        }
        catch (Throwable e) {
            this.tl.printMessageSU("... error, see log!");
            this.log.addLog(e, LogPanel.WARN);
            return null;
        }
        this.tl.printMessageSU("YM convert to vectrex - done!");
        if (this.pathOnly.length() > 0) {
            this.pathOnly = this.pathOnly + File.separator;
        }
        String outFileFinal = this.pathOnly + Paths.get(name_out_raw, new String[0]).getFileName().toString();
        UtilityFiles.copyOneFile(name_out_raw, outFileFinal);
        return outFileFinal;
    }

    public static String getByteBinaryString(byte b) {
        StringBuilder sb = new StringBuilder();
        for (int i = 7; i >= 0; --i) {
            sb.append(b >>> i & 1);
        }
        return sb.toString();
    }

    public static String getLongBinaryString(long b) {
        StringBuilder sb = new StringBuilder();
        for (int i = 31; i >= 0; --i) {
            sb.append(b >>> i & 1L);
        }
        return sb.toString();
    }

    String tab(String s, int tab) {
        String ret = s;
        while (ret.length() < tab) {
            ret = ret + ".";
        }
        ret = ret + ": ";
        return ret;
    }

    int convert_ym2(byte[][] out_buf, byte[] in_buf, int len) {
        return this.convert_ym3(out_buf, in_buf, len);
    }

    int convert_ym3(byte[][] out_buf, byte[] in_buf, int len) {
        int todo;
        int pos = 4;
        this.vbl_len = todo = (len - 4) / 14;
        for (int i = 0; i < 16; ++i) {
            out_buf[i] = new byte[this.vbl_len];
        }
        int out_counter = 0;
        this.tl.printMessageSU(this.tab("VBL found", this.DATA_TAB) + todo + "");
        this.song_name = this.file_name;
        while (todo != 0) {
            for (int i = 0; i < 14; ++i) {
                byte[] outer = out_buf[i];
                byte poker = in_buf[pos + i * ((len - 4) / 14)];
                if (i == 1 || i == 3 || i == 5) {
                    poker = (byte)(poker & 0xF);
                }
                if (i == 6) {
                    poker = (byte)(poker & 0x1F);
                }
                if (i == 7) {
                    poker = (byte)(poker & 0x3F);
                }
                if (out_counter >= outer.length) continue;
                outer[out_counter] = poker;
            }
            ++out_counter;
            ++pos;
            --todo;
        }
        return this.vbl_len;
    }

    int convert_ym3b(byte[][] out_buf, byte[] in_buf, int len) {
        return this.convert_ym3(out_buf, in_buf, len);
    }

    int convert_ym4(byte[][] out_buf, byte[] in_buf) {
        int todo;
        int pos = 12;
        int c1 = in_buf[pos++] & 0xFF;
        int c2 = in_buf[pos++] & 0xFF;
        int c3 = in_buf[pos++] & 0xFF;
        int c4 = in_buf[pos++] & 0xFF;
        this.vbl_len = todo = c1 * 256 * 256 * 256 + c2 * 256 * 256 + c3 * 256 + c4;
        for (int i = 0; i < 16; ++i) {
            out_buf[i] = new byte[this.vbl_len];
        }
        int out_counter = 0;
        this.tl.printMessageSU(this.tab("VBL found", this.DATA_TAB) + todo + "");
        int interleave_length = todo;
        c1 = in_buf[pos++] & 0xFF;
        c2 = in_buf[pos++] & 0xFF;
        c3 = in_buf[pos++] & 0xFF;
        c4 = in_buf[pos++] & 0xFF;
        this.attribut = c1 * 256 * 256 * 256 + c2 * 256 * 256 + c3 * 256 + c4;
        this.tl.printMessageSU(this.tab("Attributs found", this.DATA_TAB) + YmSound.getLongBinaryString(this.attribut) + "");
        c1 = in_buf[pos++] & 0xFF;
        c2 = in_buf[pos++] & 0xFF;
        c3 = in_buf[pos++] & 0xFF;
        c4 = in_buf[pos++] & 0xFF;
        this.samples = c1 * 256 * 256 * 256 + c2 * 256 * 256 + c3 * 256 + c4;
        if (this.samples != 0) {
            this.tl.printMessageSU(this.tab("Samples found", this.DATA_TAB) + this.samples + " (not converted!)");
        }
        c1 = in_buf[pos++] & 0xFF;
        c2 = in_buf[pos++] & 0xFF;
        c3 = in_buf[pos++] & 0xFF;
        c4 = in_buf[pos++] & 0xFF;
        this.loopStart = c1 * 256 * 256 * 256 + c2 * 256 * 256 + c3 * 256 + c4;
        this.tl.printMessageSU(this.tab("Frame loop start", this.DATA_TAB) + this.loopStart + "");
        while (this.samples != 0) {
            c1 = in_buf[pos++] & 0xFF;
            c2 = in_buf[pos++] & 0xFF;
            c3 = in_buf[pos++] & 0xFF;
            c4 = in_buf[pos++] & 0xFF;
            long sample_length = c1 * 256 * 256 * 256 + c2 * 256 * 256 + c3 * 256 + c4;
            pos = (int)((long)pos + sample_length);
            --this.samples;
        }
        this.song_name = "";
        char cc = '\u0000';
        do {
            if ((cc = (char)in_buf[pos++]) == '\u0000') continue;
            this.song_name = this.song_name + cc;
        } while (cc != '\u0000');
        this.tl.printMessageSU(this.tab("Name of song", this.DATA_TAB) + this.song_name + "");
        this.author = "";
        do {
            if ((cc = (char)in_buf[pos++]) == '\u0000') continue;
            this.author = this.author + cc;
        } while (cc != '\u0000');
        this.tl.printMessageSU(this.tab("Name of author", this.DATA_TAB) + this.author + "");
        this.comment = "";
        do {
            if ((cc = (char)in_buf[pos++]) == '\u0000') continue;
            this.comment = this.comment + cc;
        } while (cc != '\u0000');
        this.tl.printMessageSU(this.tab("Comment", this.DATA_TAB) + this.comment + "");
        boolean bl = this.interleave = (this.attribut & 1) == 1;
        if (this.interleave) {
            this.tl.printMessageSU("Using interleave format!");
            while (todo != 0) {
                for (int i = 0; i < 16; ++i) {
                    byte poker = in_buf[pos + i * interleave_length];
                    byte[] outer = out_buf[i];
                    if (i == 1 || i == 3 || i == 5) {
                        poker = (byte)(poker & 0xF);
                    }
                    if (i == 6) {
                        poker = (byte)(poker & 0x1F);
                    }
                    if (i == 7) {
                        poker = (byte)(poker & 0x3F);
                    }
                    if (out_counter >= outer.length) continue;
                    outer[out_counter] = poker;
                }
                ++out_counter;
                ++pos;
                --todo;
            }
        } else {
            this.tl.printMessageSU("Using non interleave format!");
            while (todo != 0) {
                for (int i = 0; i < 16; ++i) {
                    byte poker = in_buf[pos++];
                    byte[] outer = out_buf[i];
                    if (i == 1 || i == 3 || i == 5) {
                        poker = (byte)(poker & 0xF);
                    }
                    if (i == 6) {
                        poker = (byte)(poker & 0x1F);
                    }
                    if (i == 7) {
                        poker = (byte)(poker & 0x3F);
                    }
                    if (out_counter >= outer.length) continue;
                    outer[out_counter] = poker;
                }
                ++out_counter;
                --todo;
            }
        }
        return this.vbl_len;
    }

    int convert_ym5(byte[][] out_buf, byte[] in_buf) {
        int todo;
        int pos = 12;
        int out_counter = 0;
        int c1 = in_buf[pos++] & 0xFF;
        int c2 = in_buf[pos++] & 0xFF;
        int c3 = in_buf[pos++] & 0xFF;
        int c4 = in_buf[pos++] & 0xFF;
        this.vbl_len = todo = c1 * 256 * 256 * 256 + c2 * 256 * 256 + c3 * 256 + c4;
        for (int i = 0; i < 16; ++i) {
            out_buf[i] = new byte[this.vbl_len];
        }
        this.tl.printMessageSU(this.tab("VBL found", this.DATA_TAB) + todo + "");
        int interleave_length = todo;
        c1 = in_buf[pos++] & 0xFF;
        c2 = in_buf[pos++] & 0xFF;
        c3 = in_buf[pos++] & 0xFF;
        c4 = in_buf[pos++] & 0xFF;
        this.attribut = c1 * 256 * 256 * 256 + c2 * 256 * 256 + c3 * 256 + c4;
        this.tl.printMessageSU(this.tab("Attributes found", this.DATA_TAB) + YmSound.getLongBinaryString(this.attribut) + "");
        c3 = in_buf[pos++] & 0xFF;
        c4 = in_buf[pos++] & 0xFF;
        this.samples = c3 * 256 + c4;
        if (this.samples != 0) {
            this.tl.printMessageSU(this.tab("Samples found", this.DATA_TAB) + this.samples + " (not converted!)");
        }
        c1 = in_buf[pos++] & 0xFF;
        c2 = in_buf[pos++] & 0xFF;
        c3 = in_buf[pos++] & 0xFF;
        c4 = in_buf[pos++] & 0xFF;
        this.externalFrequency = c1 * 256 * 256 * 256 + c2 * 256 * 256 + c3 * 256 + c4;
        this.tl.printMessageSU(this.tab("YM2149 External frequency in Hz", this.DATA_TAB) + this.externalFrequency + "");
        c3 = in_buf[pos++] & 0xFF;
        c4 = in_buf[pos++] & 0xFF;
        this.playerFrequency = c3 * 256 + c4;
        this.tl.printMessageSU(this.tab("Player frequency in Hz", this.DATA_TAB) + this.playerFrequency + "");
        c1 = in_buf[pos++] & 0xFF;
        c2 = in_buf[pos++] & 0xFF;
        c3 = in_buf[pos++] & 0xFF;
        c4 = in_buf[pos++] & 0xFF;
        this.loopStart = c1 * 256 * 256 * 256 + c2 * 256 * 256 + c3 * 256 + c4;
        this.tl.printMessageSU(this.tab("Vbl number to loop the song", this.DATA_TAB) + this.loopStart + " (unused)");
        c3 = in_buf[pos++] & 0xFF;
        c4 = in_buf[pos++] & 0xFF;
        this.futureDataLength = c3 * 256 + c4;
        this.tl.printMessageSU(this.tab("Size (in bytes) of future data", this.DATA_TAB) + this.futureDataLength + "");
        while (this.samples != 0) {
            c1 = in_buf[pos++] & 0xFF;
            c2 = in_buf[pos++] & 0xFF;
            c3 = in_buf[pos++] & 0xFF;
            c4 = in_buf[pos++] & 0xFF;
            long sample_length = c1 * 256 * 256 * 256 + c2 * 256 * 256 + c3 * 256 + c4;
            pos = (int)((long)pos + sample_length);
            --this.samples;
        }
        this.song_name = "";
        char cc = '\u0000';
        do {
            if ((cc = (char)in_buf[pos++]) == '\u0000') continue;
            this.song_name = this.song_name + cc;
        } while (cc != '\u0000');
        this.tl.printMessageSU(this.tab("Name of song", this.DATA_TAB) + this.song_name + "");
        this.author = "";
        do {
            if ((cc = (char)in_buf[pos++]) == '\u0000') continue;
            this.author = this.author + cc;
        } while (cc != '\u0000');
        this.tl.printMessageSU(this.tab("Name of author", this.DATA_TAB) + this.author + "");
        this.comment = "";
        do {
            if ((cc = (char)in_buf[pos++]) == '\u0000') continue;
            this.comment = this.comment + cc;
        } while (cc != '\u0000');
        this.tl.printMessageSU(this.tab("Comment", this.DATA_TAB) + this.comment + "");
        boolean bl = this.interleave = (this.attribut & 1) == 1;
        if (this.interleave) {
            this.tl.printMessageSU("Using interleave format!");
            while (todo != 0) {
                for (int i = 0; i < 16; ++i) {
                    byte poker = in_buf[pos + i * interleave_length];
                    byte[] outer = out_buf[i];
                    if (i == 1 || i == 3 || i == 5) {
                        poker = (byte)(poker & 0xF);
                    }
                    if (i == 6) {
                        poker = (byte)(poker & 0x1F);
                    }
                    if (i == 7) {
                        poker = (byte)(poker & 0x3F);
                    }
                    if (out_counter >= outer.length) continue;
                    outer[out_counter] = poker;
                }
                ++out_counter;
                ++pos;
                --todo;
            }
        } else {
            this.tl.printMessageSU("Using non interleave format!");
            while (todo != 0) {
                for (int i = 0; i < 16; ++i) {
                    byte poker = in_buf[pos++];
                    byte[] outer = out_buf[i];
                    if (i == 1 || i == 3 || i == 5) {
                        poker = (byte)(poker & 0xF);
                    }
                    if (i == 6) {
                        poker = (byte)(poker & 0x1F);
                    }
                    if (i == 7) {
                        poker = (byte)(poker & 0x3F);
                    }
                    if (out_counter >= outer.length) continue;
                    outer[out_counter] = poker;
                }
                ++out_counter;
                --todo;
            }
        }
        return this.vbl_len;
    }

    public boolean deleteVBL(int row) {
        if (row > this.out_buf[0].length) {
            return false;
        }
        for (int i = 0; i < this.out_buf.length; ++i) {
            System.arraycopy(this.out_buf[i], row + 1, this.out_buf[i], row, this.out_buf[i].length - (row + 1));
        }
        --this.vbl_len;
        return true;
    }

    public boolean addRow(int row) {
        if (this.out_buf == null) {
            this.out_buf = new byte[16][];
        }
        byte[][] new_out_buf = new byte[16][];
        for (int i = 0; i < 16; ++i) {
            int len = 1;
            if (this.out_buf[i] != null) {
                len = this.out_buf[i].length + 1;
            }
            new_out_buf[i] = new byte[len];
            if (this.out_buf[i] != null && row > 0) {
                System.arraycopy(this.out_buf[i], 0, new_out_buf[i], 0, row);
            }
            new_out_buf[i][row] = i != 7 ? 0 : 63;
            if (this.out_buf[i] != null) {
                System.arraycopy(this.out_buf[i], row, new_out_buf[i], row + 1, this.out_buf[i].length - row);
            }
            this.out_buf[i] = new_out_buf[i];
        }
        ++this.vbl_len;
        return true;
    }

    void shannon(int from_index, int to_index, int bit_count, int coder, int set_count, int[] bytes_used_array, int[] map, Code[] code2) {
        int set_count1;
        int start1;
        if (from_index == to_index) {
            code2[map[from_index]].bit_count = bit_count + 1;
            code2[map[from_index]].code = (coder << 1) + 1;
            return;
        }
        if (from_index + 1 == to_index) {
            code2[map[from_index]].bit_count = bit_count + 1;
            code2[map[from_index]].code = (coder << 1) + 1;
            code2[map[to_index]].bit_count = bit_count + 1;
            code2[map[to_index]].code = coder << 1;
            return;
        }
        int end1 = start1 = from_index;
        int start2 = end1 + 1;
        int end2 = to_index;
        for (set_count1 = bytes_used_array[map[end1]]; set_count1 < set_count / 2; set_count1 += bytes_used_array[map[++end1]]) {
            ++start2;
        }
        int set_count2 = 0;
        for (int i = start2; i <= end2; ++i) {
            set_count2 += bytes_used_array[map[i]];
        }
        if (start1 == end1) {
            code2[map[start1]].bit_count = bit_count + 1;
            code2[map[start1]].code = (coder << 1) + 1;
        } else {
            this.shannon(start1, end1, bit_count + 1, (coder << 1) + 1, set_count1, bytes_used_array, map, code2);
        }
        if (start2 == end2) {
            code2[map[start2]].bit_count = bit_count + 1;
            code2[map[start2]].code = coder << 1;
        } else {
            this.shannon(start2, end2, bit_count + 1, coder << 1, set_count2, bytes_used_array, map, code2);
        }
    }

    Tree get_and_remove_from_list_smallest() {
        DoubleLinkedList.DoubleLinkedListElement listElement = this.list.first;
        Tree found = null;
        while (listElement != null) {
            Tree current = (Tree)listElement.object;
            if (found == null) {
                found = current;
            } else if (found.count > current.count) {
                found = current;
            }
            listElement = listElement.next;
        }
        DoubleLinkedList.d_entferne_aus_liste(found, this.list, true);
        return found;
    }

    void code_tree(Tree htree, int[] map, Code[] code2) {
        if (htree.index != -1) {
            code2[map[htree.index]].bit_count = htree.bit_count;
            code2[map[htree.index]].code = htree.coder;
        } else {
            Tree left = htree.left;
            left.bit_count = htree.bit_count + 1;
            left.coder = htree.coder << 1;
            Tree right = htree.right;
            right.bit_count = htree.bit_count + 1;
            right.coder = (htree.coder << 1) + 1;
            this.code_tree(left, map, code2);
            this.code_tree(right, map, code2);
        }
    }

    public void hstart(int from_index, int to_index, int[] bytes_used_array, int[] map, Code[] code2) {
        for (int i = from_index; i < to_index; ++i) {
            Tree htree = new Tree();
            htree.index = i;
            htree.count = bytes_used_array[map[i]];
            htree.parent = null;
            htree.left = null;
            htree.right = null;
            htree.bit_count = 0;
            htree.coder = 0;
            DoubleLinkedList.d_fuege_in_liste_ein(htree, this.list, 2);
        }
        while (DoubleLinkedList.d_anzahl_liste(this.list) != 1) {
            Tree small1 = this.get_and_remove_from_list_smallest();
            Tree small2 = this.get_and_remove_from_list_smallest();
            Tree htree = new Tree();
            htree.index = -1;
            htree.count = small1.count + small2.count;
            htree.parent = null;
            htree.left = small1;
            htree.right = small2;
            htree.bit_count = 0;
            htree.coder = 0;
            small1.parent = htree;
            small2.parent = htree;
            DoubleLinkedList.d_fuege_in_liste_ein(htree, this.list, 2);
        }
        this.code_tree(this.get_and_remove_from_list_smallest(), map, code2);
    }

    int get_bits_for_counter(int counter) {
        if (counter < 8) {
            return 3;
        }
        if (counter < 16) {
            return 4;
        }
        if (counter < 32) {
            return 5;
        }
        if (counter < 64) {
            return 6;
        }
        if (counter < 128) {
            return 7;
        }
        if (counter < 256) {
            return 8;
        }
        if (counter < 512) {
            return 9;
        }
        if (counter < 1024) {
            return 10;
        }
        if (counter < 2048) {
            return 11;
        }
        if (counter < 4096) {
            return 12;
        }
        if (counter < 8192) {
            return 13;
        }
        if (counter < 16384) {
            return 14;
        }
        if (counter < 32768) {
            return 15;
        }
        if (counter < 65536) {
            return 16;
        }
        return -1;
    }

    long get_RLE_code(int counter) {
        int i;
        long ret = 0L;
        int bits_for_counter = this.get_bits_for_counter(counter);
        int ander = 1;
        for (i = 0; i < bits_for_counter - 2; ++i) {
            ret <<= 1;
            ++ret;
        }
        ret <<= 1;
        for (i = 0; i < bits_for_counter; ++i) {
            ret <<= 1;
            if ((counter & ander) != 0) {
                ++ret;
            }
            ander <<= 1;
        }
        return ret;
    }

    long get_RLE_code_msb(int counter) {
        int i;
        long ret = 0L;
        int bits_for_counter = this.get_bits_for_counter(counter);
        int ander = 1;
        ander <<= bits_for_counter - 1;
        for (i = 0; i < bits_for_counter - 2; ++i) {
            ret <<= 1;
            ++ret;
        }
        ret <<= 1;
        for (i = 0; i < bits_for_counter; ++i) {
            ret <<= 1;
            if ((counter & ander) != 0) {
                ++ret;
            }
            ander >>= 1;
        }
        return ret;
    }

    BufferedWriter get_dbOutFile() {
        return this.dbOutFile;
    }

    void deinit_bit_out() {
        try {
            if (this.dbOutFile != null) {
                this.dbOutFile.close();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.dbOutFile = null;
    }

    void init_bit_out(BufferedWriter outFile) {
        this.dbOutFile = outFile;
        this.current_out = 0;
        this.current_out_bit = 0;
        this.current_out_bit_counter = 0;
    }

    void byte_out(byte b) {
        try {
            this.byte_out_counter = 0;
            if (this.dbOutFile != null) {
                String s = " DB $" + String.format("%02X", b & 0xFF) + "\n";
                this.dbOutFile.write(s, 0, s.length());
            }
            this.current_out_bit_counter = (byte)(this.current_out_bit_counter + 8);
            this.current_out_bit = 0;
            this.current_out = 0;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    void bit_out(int abit) {
        try {
            this.current_out = (byte)(this.current_out << 1);
            this.current_out = (byte)(this.current_out + (abit != 0 ? (byte)1 : 0));
            this.current_out_bit = (byte)(this.current_out_bit + 1);
            this.current_out_bit_counter = (byte)(this.current_out_bit_counter + 1);
            if (this.current_out_bit == 8) {
                if (this.dbOutFile != null) {
                    String s = this.byte_out_counter == 0 ? " DB $" + String.format("%02X", this.current_out & 0xFF) : ", $" + String.format("%02X", this.current_out & 0xFF);
                    this.dbOutFile.write(s, 0, s.length());
                    ++this.byte_out_counter;
                    if (this.byte_out_counter == 10) {
                        this.byte_out_counter = 0;
                        s = "\n";
                        this.dbOutFile.write(s, 0, s.length());
                    }
                }
                this.current_out_bit = 0;
                this.current_out = 0;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    void bit_flush() {
        while (this.current_out_bit != 0) {
            this.bit_out(0);
        }
        try {
            String s = " ; flushed\n";
            this.dbOutFile.write(s, 0, s.length());
            this.byte_out_counter = 0;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    void bits_out_bit_code(int bit_len, int code2) {
        int cb = bit_len;
        while (cb != 0) {
            this.bit_out(code2 & 1 << --cb);
        }
    }

    abstract_buffer abstract_clone(abstract_buffer abuffer) {
        int i;
        abstract_buffer buffer = new abstract_buffer();
        buffer.len = abuffer.len;
        buffer.data = new abstract_data[abuffer.len];
        buffer.phrase_count = abuffer.phrase_count;
        buffer.kind = abuffer.kind;
        abstract_data[] data2 = buffer.data;
        for (i = 0; i < abuffer.len; ++i) {
            data2[i] = new abstract_data();
            data2[i].type = abuffer.data[i].type;
            data2[i].ENCODED_code = abuffer.data[i].ENCODED_code;
            data2[i].bit_length_ENCODED = abuffer.data[i].bit_length_ENCODED;
            data2[i].RLE_code = abuffer.data[i].RLE_code;
            data2[i].bit_length_RLE = abuffer.data[i].bit_length_RLE;
            data2[i].count = abuffer.data[i].count;
            data2[i].original_data = abuffer.data[i].original_data;
            data2[i].phrase_used = abuffer.data[i].phrase_used;
            data2[i].length_in_abstract_data_elements_of_single_element = abuffer.data[i].length_in_abstract_data_elements_of_single_element;
        }
        Code[] code2 = new Code[356];
        int[] bytes_used_array = new int[356];
        int[] map = new int[356];
        phrase[] phrases = new phrase[356];
        for (i = 0; i < 100; ++i) {
            phrases[i] = new phrase();
            if (abuffer.phrases[i].len != 0) {
                for (int j = 0; j < abuffer.phrases[i].len; ++j) {
                    phrases[i].phrase[j] = abuffer.phrases[i].phrase[j];
                }
            }
            phrases[i].len = abuffer.phrases[i].len;
            phrases[i].count = abuffer.phrases[i].count;
        }
        for (i = 0; i < 356; ++i) {
            code2[i] = new Code();
            bytes_used_array[i] = abuffer.codes_used_array[i];
            map[i] = abuffer.map[i];
            code2[i].bit_count = abuffer.code[i].bit_count;
            code2[i].code = abuffer.code[i].code;
        }
        buffer.phrases = phrases;
        buffer.codes_used_array = bytes_used_array;
        buffer.map = map;
        buffer.code = code2;
        buffer.different_codes_used = abuffer.different_codes_used;
        return buffer;
    }

    abstract_buffer build_abstract(byte[] data_buf, int len) {
        int i = 0;
        abstract_buffer buffer = new abstract_buffer();
        buffer.kind = 1;
        buffer.len = len;
        buffer.data = new abstract_data[len];
        buffer.phrase_count = 0;
        abstract_data[] data2 = buffer.data;
        for (i = 0; i < len; ++i) {
            data2[i] = new abstract_data();
            data2[i].type = 1;
            data2[i].ENCODED_code = 0;
            data2[i].bit_length_ENCODED = 0;
            data2[i].RLE_code = 0L;
            data2[i].bit_length_RLE = 0;
            data2[i].count = 1;
            data2[i].original_data = data_buf[i];
            data2[i].phrase_used = 0;
            data2[i].length_in_abstract_data_elements_of_single_element = 1;
        }
        Code[] code2 = new Code[356];
        int[] bytes_used_array = new int[356];
        int[] map = new int[356];
        phrase[] phrases = new phrase[356];
        buffer.phrases = phrases;
        for (i = 0; i < 100; ++i) {
            phrases[i] = new phrase();
            phrases[i].len = 0;
            phrases[i].count = 0;
        }
        for (i = 0; i < 356; ++i) {
            bytes_used_array[i] = 0;
        }
        for (i = 0; i != len; ++i) {
            int n = data2[i].original_data & 0xFF;
            bytes_used_array[n] = bytes_used_array[n] + 1;
        }
        int bytes_used_array_count = 0;
        for (i = 0; i < 356; ++i) {
            code2[i] = new Code();
            if (bytes_used_array[i] == 0) continue;
            ++bytes_used_array_count;
        }
        int remember = -1;
        int map_count = 0;
        for (i = 0; i < 356; ++i) {
            map[i] = -1;
        }
        while (map_count < 356) {
            int most = -1;
            for (i = 0; i < 356; ++i) {
                if (bytes_used_array[i] < most) continue;
                most = bytes_used_array[i];
                remember = i;
            }
            map[map_count] = remember;
            bytes_used_array[remember] = -2;
            ++map_count;
        }
        for (i = 0; i < 356; ++i) {
            bytes_used_array[i] = 0;
        }
        for (i = 0; i != len; ++i) {
            int n = data2[i].original_data & 0xFF;
            bytes_used_array[n] = bytes_used_array[n] + 1;
        }
        buffer.codes_used_array = bytes_used_array;
        buffer.map = map;
        buffer.code = code2;
        buffer.different_codes_used = bytes_used_array_count;
        return buffer;
    }

    void delete_abstract(abstract_buffer buffer) {
        buffer.phrases = null;
        buffer.data = null;
        buffer.code = null;
        buffer.codes_used_array = null;
        buffer.map = null;
    }

    void abstract_Huffman(abstract_buffer buffer) {
        abstract_data[] data2 = buffer.data;
        int len = buffer.len;
        int i = 0;
        buffer.kind = 2;
        this.hstart(0, buffer.different_codes_used, buffer.codes_used_array, buffer.map, buffer.code);
        for (i = 0; i < len; i += data2[i].length_in_abstract_data_elements_of_single_element) {
            if (data2[i].type == 1) {
                data2[i].type = 5;
                if (buffer.code[data2[i].original_data & 0xFF].code > 255) {
                    System.out.println("encode error, code = " + buffer.code[data2[i].original_data & 0xFF].code + " (from " + (data2[i].original_data & 0xFF) + ")\n");
                }
                data2[i].ENCODED_code = buffer.code[data2[i].original_data & 0xFF].code;
                data2[i].bit_length_ENCODED = buffer.code[data2[i].original_data & 0xFF].bit_count;
                continue;
            }
            if (data2[i].type != 2) continue;
            data2[i].type = 6;
            if (buffer.code[data2[i].phrase_used + 256].code > 255) {
                this.log.addLog("Encode error, Huffman code > 255, bigger than 1 byte - exiting!", LogPanel.ERROR);
                return;
            }
            data2[i].ENCODED_code = buffer.code[data2[i].phrase_used + 256].code;
            data2[i].bit_length_ENCODED = buffer.code[data2[i].phrase_used + 256].bit_count;
        }
    }

    void abstract_Shannon(abstract_buffer buffer) {
        abstract_data[] data2 = buffer.data;
        int len = buffer.len;
        buffer.kind = 2;
        this.shannon(0, buffer.different_codes_used, 0, 0, len, buffer.codes_used_array, buffer.map, buffer.code);
        for (int i = 0; i < len; i += data2[i].length_in_abstract_data_elements_of_single_element) {
            if (data2[i].type == 1) {
                data2[i].type = 5;
                if (buffer.code[data2[i].original_data & 0xFF].code > 255 && !dontShanonSingleByteUsages) {
                    this.log.addLog("Encode error, Shannon byte code > 255, bigger than 1 byte - exiting!", LogPanel.ERROR);
                    return;
                }
                data2[i].ENCODED_code = buffer.code[data2[i].original_data & 0xFF].code;
                data2[i].bit_length_ENCODED = buffer.code[data2[i].original_data & 0xFF].bit_count;
                continue;
            }
            if (data2[i].type != 2) continue;
            data2[i].type = 6;
            if (buffer.code[data2[i].phrase_used + 256].code > 255) {
                this.log.addLog("Encode error, Shannon phrase code > 255, bigger than 1 byte - exiting!", LogPanel.ERROR);
                return;
            }
            data2[i].ENCODED_code = buffer.code[data2[i].phrase_used + 256].code;
            data2[i].bit_length_ENCODED = buffer.code[data2[i].phrase_used + 256].bit_count;
        }
    }

    void abstract_RLE(abstract_buffer buffer) {
        buffer.kind = buffer.kind == 2 ? 6 : 4;
        abstract_data[] data2 = buffer.data;
        int len = buffer.len;
        boolean current_out = false;
        boolean current_out_bit = false;
        int current_code = 0;
        int current_bits = 0;
        for (int pos = 0; pos < len; pos += data2[pos].length_in_abstract_data_elements_of_single_element) {
            int counter = 1;
            if (data2[pos].type == 5 || data2[pos].type == 6) {
                current_code = data2[pos].ENCODED_code;
                current_bits = data2[pos].bit_length_ENCODED;
            } else if (data2[pos].type == 1) {
                current_code = data2[pos].original_data & 0xFF;
                current_bits = 8;
            } else if (data2[pos].type == 2) {
                current_code = data2[pos].phrase_used;
                current_bits = 9;
            }
            while (pos + data2[pos].length_in_abstract_data_elements_of_single_element < len && (data2[pos].type == 5 && data2[pos + data2[pos].length_in_abstract_data_elements_of_single_element].type == 5 && data2[pos + data2[pos].length_in_abstract_data_elements_of_single_element].ENCODED_code == data2[pos].ENCODED_code && data2[pos + data2[pos].length_in_abstract_data_elements_of_single_element].bit_length_ENCODED == data2[pos].bit_length_ENCODED || data2[pos].type == 6 && data2[pos + data2[pos].length_in_abstract_data_elements_of_single_element].type == 6 && data2[pos + data2[pos].length_in_abstract_data_elements_of_single_element].ENCODED_code == data2[pos].ENCODED_code && data2[pos + data2[pos].length_in_abstract_data_elements_of_single_element].bit_length_ENCODED == data2[pos].bit_length_ENCODED || data2[pos].type == 1 && data2[pos + data2[pos].length_in_abstract_data_elements_of_single_element].type == 1 && data2[pos + data2[pos].length_in_abstract_data_elements_of_single_element].original_data == data2[pos].original_data || data2[pos].type == 2 && data2[pos + data2[pos].length_in_abstract_data_elements_of_single_element].type == 2 && data2[pos + data2[pos].length_in_abstract_data_elements_of_single_element].phrase_used == data2[pos].phrase_used)) {
                data2[pos].type = 0;
                pos += data2[pos].length_in_abstract_data_elements_of_single_element;
                ++counter;
            }
            if (counter == 1) {
                if (data2[pos].type == 5 || data2[pos].type == 6) {
                    data2[pos].RLE_code = 0L;
                    data2[pos].bit_length_RLE = 1;
                    data2[pos].count = 1;
                    if (data2[pos].type == 5) {
                        data2[pos].type = 7;
                        continue;
                    }
                    if (data2[pos].type != 6) continue;
                    data2[pos].type = 8;
                    continue;
                }
                if (data2[pos].type != 1 && data2[pos].type != 2) continue;
                data2[pos].RLE_code = 0L;
                data2[pos].bit_length_RLE = 1;
                data2[pos].count = 1;
                if (data2[pos].type == 1) {
                    data2[pos].type = 3;
                    continue;
                }
                if (data2[pos].type != 2) continue;
                data2[pos].type = 4;
                continue;
            }
            int bits_for_counter = this.get_bits_for_counter(counter);
            if (data2[pos].type == 5 || data2[pos].type == 6) {
                data2[pos].RLE_code = dontShanonSingleByteUsages ? this.get_RLE_code_msb(counter) : this.get_RLE_code(counter);
                data2[pos].bit_length_RLE = bits_for_counter - 1 + bits_for_counter;
                data2[pos].count = counter;
                if (data2[pos].type == 5) {
                    data2[pos].type = 7;
                    continue;
                }
                if (data2[pos].type != 6) continue;
                data2[pos].type = 8;
                continue;
            }
            if (data2[pos].type != 1 && data2[pos].type != 2) continue;
            data2[pos].RLE_code = dontShanonSingleByteUsages ? this.get_RLE_code_msb(counter) : this.get_RLE_code(counter);
            data2[pos].bit_length_RLE = bits_for_counter - 1 + bits_for_counter;
            data2[pos].count = counter;
            if (data2[pos].type == 1) {
                data2[pos].type = 3;
                continue;
            }
            if (data2[pos].type != 2) continue;
            data2[pos].type = 4;
        }
    }

    int get_bits_used_from_abstract(abstract_buffer buffer) {
        abstract_data[] data2 = buffer.data;
        int len = buffer.len;
        int count = 0;
        for (int i = 0; i < len; i += data2[i].length_in_abstract_data_elements_of_single_element) {
            if (data2[i].type == 1) {
                count += 8;
            }
            if (data2[i].type == 2) {
                count += 9;
            }
            if (data2[i].type == 3) {
                count += 8;
                count += data2[i].bit_length_RLE;
            }
            if (data2[i].type == 4) {
                count += 9;
                count += data2[i].bit_length_RLE;
            }
            if (data2[i].type == 5 || data2[i].type == 6) {
                count += data2[i].bit_length_ENCODED;
            }
            if (data2[i].type != 7 && data2[i].type != 8) continue;
            count += data2[i].bit_length_RLE;
            count += data2[i].bit_length_ENCODED;
        }
        return count;
    }

    int get_bits_used_from_abstract_complete(abstract_buffer buffer) {
        int i;
        int used_bits = this.get_bits_used_from_abstract(buffer);
        for (i = 0; i < buffer.different_codes_used; ++i) {
            used_bits += 24;
        }
        i = 0;
        while (buffer.phrases[i].len != 0) {
            used_bits += 8;
            for (int j = 0; j < buffer.phrases[i].len; ++j) {
                byte outer = (byte)buffer.phrases[i].phrase[j];
                used_bits += 8;
            }
            ++i;
        }
        return used_bits;
    }

    sorted_codes[] abstract_sort_code_with_bits(abstract_buffer buffer) {
        sorted_codes[] sorted = new sorted_codes[buffer.different_codes_used];
        for (int i = 0; i < buffer.different_codes_used; ++i) {
            sorted[i] = new sorted_codes();
            sorted[i].bits = buffer.code[buffer.map[i]].bit_count & 0xFF;
            sorted[i].code = buffer.code[buffer.map[i]].code & 0xFF;
            sorted[i].value = buffer.map[i] & 0xFF & 0xFF;
            sorted[i].map = buffer.map[i];
        }
        Arrays.sort(sorted, new Comparator<sorted_codes>(){

            @Override
            public int compare(sorted_codes p1, sorted_codes p2) {
                if ((p1.bits & 0xFF) < (p2.bits & 0xFF)) {
                    return -1;
                }
                if ((p1.bits & 0xFF) > (p2.bits & 0xFF)) {
                    return 1;
                }
                if ((p1.code & 0xFF) < (p2.code & 0xFF)) {
                    return -1;
                }
                if ((p1.code & 0xFF) > (p2.code & 0xFF)) {
                    return 1;
                }
                return 0;
            }
        });
        return sorted;
    }

    void fprintf(BufferedWriter w, String s) {
        try {
            w.write(s);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    void abstract_out(abstract_buffer buffer) {
        abstract_data[] data2 = buffer.data;
        int len = buffer.len;
        int i = 0;
        int j = 0;
        BufferedWriter outFile = this.get_dbOutFile();
        sorted_codes[] sorted = this.abstract_sort_code_with_bits(buffer);
        if (buffer.kind == 2 || buffer.kind == 6) {
            int code2;
            int bit_count;
            if (outFile != null) {
                this.fprintf(outFile, "; translation data \n");
                this.fprintf(outFile, "; DB $" + String.format("%02X", buffer.different_codes_used & 0xFF) + "; bytes follow \n");
                this.fprintf(outFile, "; bits used, code, real 'byte' \n");
                this.fprintf(outFile, "" + this.file_name + "_reg_" + this.current_working_register + ": \n");
            }
            int iCount = 0;
            for (i = 0; i < buffer.different_codes_used; ++i) {
                bit_count = sorted[i].bits;
                code2 = sorted[i].value;
                if (sorted[i].map >= 256) {
                    bit_count += 128;
                }
                int count = bit_count > 128 ? buffer.codes_used_array[256 + code2] : buffer.codes_used_array[code2];
                if (dontShanonSingleByteUsages && bit_count <= 128) {
                    count = 0;
                }
                if (count <= 0) continue;
                if (dontShanonSingleByteUsages) {
                    if (outFile != null) {
                        this.fprintf(outFile, " DB $" + String.format("%02X", bit_count & 0x7F) + ", $" + String.format("%02X", sorted[i].code & 0xFF) + ", $" + String.format("%02X", buffer.phrases[code2].len & 0xFF) + " ;" + count + " \n");
                    }
                    ++iCount;
                    continue;
                }
                if (outFile == null) continue;
                this.fprintf(outFile, " DB $" + String.format("%02X", bit_count & 0xFF) + ", $" + String.format("%02X", sorted[i].code & 0xFF) + ", $" + String.format("%02X", code2 & 0xFF) + " ;" + count + " \n");
            }
            if (this.USE_PHRASE) {
                if (dontShanonSingleByteUsages) {
                    if (outFile != null) {
                        this.fprintf(outFile, "; phrases follow \n");
                        this.fprintf(outFile, this.file_name + "_pd_" + this.current_working_register + ": \n");
                    }
                    for (i = 0; i < buffer.different_codes_used; ++i) {
                        bit_count = sorted[i].bits;
                        code2 = sorted[i].value;
                        if (sorted[i].map < 256 || buffer.codes_used_array[code2 + 256] <= 0) continue;
                        if (outFile != null) {
                            this.fprintf(outFile, " DB ");
                        }
                        boolean first = true;
                        for (j = 0; j < buffer.phrases[code2].len; ++j) {
                            int outer = buffer.phrases[code2].phrase[j];
                            if (outFile == null) continue;
                            if (first) {
                                this.fprintf(outFile, "$" + String.format("%02X", outer & 0xFF));
                            } else {
                                this.fprintf(outFile, ", $" + String.format("%02X", outer & 0xFF));
                            }
                            first = false;
                        }
                        if (j == 0 || outFile == null) continue;
                        this.fprintf(outFile, "; " + buffer.codes_used_array[code2 + 256] + " \n");
                    }
                } else {
                    if (outFile != null) {
                        this.fprintf(outFile, "; phrases follow \n");
                        this.fprintf(outFile, this.file_name + "_pd_" + this.current_working_register + ": \n");
                    }
                    i = 0;
                    while (buffer.phrases[i].len != 0) {
                        if (buffer.codes_used_array[i + 256] > 0) {
                            if (outFile != null) {
                                this.fprintf(outFile, " DB $" + String.format("%02X", buffer.phrases[i].len & 0xFF));
                            }
                            for (j = 0; j < buffer.phrases[i].len; ++j) {
                                int outer = buffer.phrases[i].phrase[j];
                                if (outFile == null) continue;
                                this.fprintf(outFile, ", $" + String.format("%02X", outer & 0xFF));
                            }
                            if (j != 0 && outFile != null) {
                                this.fprintf(outFile, "; " + buffer.codes_used_array[i + 256] + " \n");
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        if (outFile != null) {
            this.fprintf(outFile, "; data follows \n");
            this.fprintf(outFile, this.file_name + "_reg_" + this.current_working_register + "_data: \n");
        }
        for (i = 0; i < len; i += data2[i].length_in_abstract_data_elements_of_single_element) {
            if (data2[i].type == 1) {
                this.byte_out((byte)data2[i].original_data);
            }
            if (data2[i].type == 2) {
                for (j = 0; j < buffer.phrases[data2[i].phrase_used].len; ++j) {
                    this.byte_out((byte)buffer.phrases[data2[i].phrase_used].phrase[j]);
                }
            }
            if (data2[i].type == 3) {
                this.bits_out_bit_code(data2[i].bit_length_RLE, (int)data2[i].RLE_code);
                this.byte_out((byte)data2[i].original_data);
            }
            if (data2[i].type == 4) {
                this.bits_out_bit_code(data2[i].bit_length_RLE, (int)data2[i].RLE_code);
                for (j = 0; j < buffer.phrases[data2[i].phrase_used].len; ++j) {
                    this.byte_out((byte)buffer.phrases[data2[i].phrase_used].phrase[j]);
                }
            }
            if (data2[i].type == 5) {
                this.bits_out_bit_code(data2[i].bit_length_ENCODED, data2[i].ENCODED_code);
            }
            if (data2[i].type == 6) {
                this.bits_out_bit_code(data2[i].bit_length_ENCODED, data2[i].ENCODED_code);
            }
            if (data2[i].type == 7) {
                if (dontShanonSingleByteUsages) {
                    int max_reg_data_len = 8;
                    if (this.current_working_register == 8 || this.current_working_register == 9 || this.current_working_register == 10) {
                        if (enableAmlitude5thBit) {
                            this.bitsSaved += 3;
                            max_reg_data_len = 5;
                        } else {
                            this.bitsSaved += 4;
                            max_reg_data_len = 4;
                        }
                    } else if (this.current_working_register == 1 || this.current_working_register == 3 || this.current_working_register == 5) {
                        this.bitsSaved += 4;
                        max_reg_data_len = 4;
                    } else if (this.current_working_register == 6) {
                        this.bitsSaved += 3;
                        max_reg_data_len = 5;
                    } else if (this.current_working_register == 7) {
                        this.bitsSaved += 2;
                        max_reg_data_len = 6;
                    } else if (this.current_working_register == 13) {
                        this.bitsSaved += 3;
                        max_reg_data_len = 5;
                    }
                    this.bits_out_bit_code(data2[i].bit_length_RLE, (int)data2[i].RLE_code);
                    this.bits_out_bit_code(1, 0);
                    this.bits_out_bit_code(max_reg_data_len, (byte)data2[i].original_data);
                } else {
                    this.bits_out_bit_code(data2[i].bit_length_RLE, (int)data2[i].RLE_code);
                    this.bits_out_bit_code(data2[i].bit_length_ENCODED, data2[i].ENCODED_code);
                }
            }
            if (data2[i].type != 8) continue;
            this.bits_out_bit_code(data2[i].bit_length_RLE, (int)data2[i].RLE_code);
            if (dontShanonSingleByteUsages) {
                this.bits_out_bit_code(1, 1);
            }
            this.bits_out_bit_code(data2[i].bit_length_ENCODED, data2[i].ENCODED_code);
        }
        this.bit_flush();
    }

    boolean abstract_phrase_already_seen(phrase[] phrases, int[] phrase_codes) {
        int current_phrase = 0;
        while (phrases[current_phrase].len != 0) {
            int i;
            for (i = 0; i < phrases[current_phrase].len && phrases[current_phrase].phrase[i] == phrase_codes[i]; ++i) {
            }
            if (i == phrases[current_phrase].len) {
                if (this.PHRASE_OPTIMIZER != 2) {
                    ++phrases[current_phrase].count;
                }
                return true;
            }
            ++current_phrase;
        }
        return false;
    }

    boolean abstract_phrase_valid(phrase[] phrases, int[] phrase_codes, int phrase_len) {
        int i;
        int first = phrase_codes[0];
        for (i = 0; i < phrase_len && phrase_codes[i] == first; ++i) {
        }
        if (i == phrase_len) {
            return false;
        }
        return !this.abstract_phrase_already_seen(phrases, phrase_codes);
    }

    int abstract_get_phrase_count(abstract_buffer abuffer, int[] phrase_codes, int phrase_len, int start) {
        int counter = 0;
        abstract_data[] data2 = abuffer.data;
        int array_counter = start;
        while (array_counter + phrase_len < abuffer.len) {
            int j;
            for (j = 0; j < phrase_len && data2[array_counter].type == 1 && (phrase_codes[j] & 0xFF) == (data2[array_counter].original_data & 0xFF); ++j) {
                if (array_counter < abuffer.len) {
                    if (j + 1 >= phrase_len) continue;
                    ++array_counter;
                    continue;
                }
                return counter;
            }
            if (j == phrase_len) {
                ++counter;
            }
            ++array_counter;
        }
        return counter;
    }

    phrase abstract_get_best_phrase_used_more_than_once(abstract_buffer abuffer, int phrase_len) {
        int i;
        int[] phrase_codes = new int[100];
        int phrase_count = abuffer.len - (phrase_len - 1);
        if (this.alternating_phrases[this.phrase_toggler] == null) {
            this.alternating_phrases[this.phrase_toggler] = new phrase[phrase_count + 1];
            for (int i2 = 0; i2 < phrase_count + 1; ++i2) {
                this.alternating_phrases[this.phrase_toggler][i2] = new phrase();
            }
        }
        abstract_data[] data2 = abuffer.data;
        this.alternating_phrases[this.phrase_toggler][0].len = 0;
        this.alternating_phrases[this.phrase_toggler][0].count = 0;
        int current_phrase = 0;
        int array_counter = 0;
        int max_count = 1;
        int best_index = -1;
        phrase best = new phrase();
        best.len = 0;
        int other_toggle = (this.phrase_toggler + 1) % 2;
        while (array_counter + phrase_len < abuffer.len) {
            boolean valid = true;
            if (this.alternating_phrases[other_toggle] != null) {
                valid = false;
                i = 0;
                while (this.alternating_phrases[other_toggle][i].len != 0) {
                    if (this.alternating_phrases[other_toggle][i].start == array_counter) {
                        valid = true;
                        break;
                    }
                    ++i;
                }
            }
            if (valid) {
                for (i = 0; i < phrase_len; ++i) {
                    if (data2[array_counter + i].type != 1) {
                        valid = false;
                        break;
                    }
                    phrase_codes[i] = data2[array_counter + i].original_data & 0xFF;
                }
                if (!valid) {
                    ++array_counter;
                    continue;
                }
                if (this.abstract_phrase_valid(this.alternating_phrases[this.phrase_toggler], phrase_codes, phrase_len)) {
                    if (this.PHRASE_OPTIMIZER == 0) {
                        this.alternating_phrases[this.phrase_toggler][current_phrase].len = phrase_len;
                        this.alternating_phrases[this.phrase_toggler][current_phrase].count = 1;
                        this.alternating_phrases[this.phrase_toggler][current_phrase].start = array_counter;
                        for (i = 0; i < phrase_len; ++i) {
                            this.alternating_phrases[this.phrase_toggler][current_phrase].phrase[i] = phrase_codes[i];
                        }
                        this.alternating_phrases[this.phrase_toggler][++current_phrase].len = 0;
                        this.alternating_phrases[this.phrase_toggler][current_phrase].count = 0;
                    } else {
                        int count = this.abstract_get_phrase_count(abuffer, phrase_codes, phrase_len, array_counter + 1);
                        if (count > 1) {
                            this.alternating_phrases[this.phrase_toggler][current_phrase].len = phrase_len;
                            this.alternating_phrases[this.phrase_toggler][current_phrase].count = count;
                            this.alternating_phrases[this.phrase_toggler][current_phrase].start = array_counter;
                            for (i = 0; i < phrase_len; ++i) {
                                this.alternating_phrases[this.phrase_toggler][current_phrase].phrase[i] = phrase_codes[i];
                            }
                            if (count > max_count) {
                                max_count = count;
                                best_index = current_phrase;
                            }
                            this.alternating_phrases[this.phrase_toggler][++current_phrase].len = 0;
                            this.alternating_phrases[this.phrase_toggler][current_phrase].count = 0;
                        }
                    }
                }
            }
            ++array_counter;
        }
        if (this.PHRASE_OPTIMIZER == 0) {
            for (i = 0; i < current_phrase; ++i) {
                if (this.alternating_phrases[this.phrase_toggler][i].count <= max_count) continue;
                max_count = this.alternating_phrases[this.phrase_toggler][i].count;
                best_index = i;
            }
        }
        if (best_index != -1) {
            best.len = this.alternating_phrases[this.phrase_toggler][best_index].len;
            best.count = this.alternating_phrases[this.phrase_toggler][best_index].count;
            for (i = 0; i < phrase_len; ++i) {
                best.phrase[i] = this.alternating_phrases[this.phrase_toggler][best_index].phrase[i];
            }
        }
        if (this.PHRASE_OPTIMIZER != 2) {
            this.phrase_toggler = (this.phrase_toggler + 1) % 2;
        }
        return best;
    }

    void abstract_reset_buffer(abstract_buffer ubuffer, abstract_buffer obuffer) {
        int i;
        ubuffer.len = obuffer.len;
        ubuffer.phrase_count = obuffer.phrase_count;
        abstract_data[] data2 = ubuffer.data;
        for (i = 0; i < obuffer.len; ++i) {
            data2[i].type = obuffer.data[i].type;
            data2[i].ENCODED_code = obuffer.data[i].ENCODED_code;
            data2[i].bit_length_ENCODED = obuffer.data[i].bit_length_ENCODED;
            data2[i].RLE_code = obuffer.data[i].RLE_code;
            data2[i].bit_length_RLE = obuffer.data[i].bit_length_RLE;
            data2[i].count = obuffer.data[i].count;
            data2[i].original_data = obuffer.data[i].original_data;
            data2[i].phrase_used = obuffer.data[i].phrase_used;
            data2[i].length_in_abstract_data_elements_of_single_element = obuffer.data[i].length_in_abstract_data_elements_of_single_element;
        }
        for (i = 0; i < 100; ++i) {
            if (obuffer.phrases[i].len != 0) {
                for (int j = 0; j < obuffer.phrases[i].len; ++j) {
                    ubuffer.phrases[i].phrase[j] = obuffer.phrases[i].phrase[j];
                }
            }
            ubuffer.phrases[i].len = obuffer.phrases[i].len;
            ubuffer.phrases[i].count = obuffer.phrases[i].count;
        }
        for (i = 0; i < 356; ++i) {
            ubuffer.codes_used_array[i] = obuffer.codes_used_array[i];
            ubuffer.map[i] = obuffer.map[i];
            ubuffer.code[i].bit_count = obuffer.code[i].bit_count;
            ubuffer.code[i].code = obuffer.code[i].code;
        }
        ubuffer.different_codes_used = obuffer.different_codes_used;
    }

    void abstract_apply_phrase(abstract_buffer abuffer, phrase aphrase) {
        int phrase_count;
        if ((phrase_count = abuffer.phrase_count++) >= 100) {
            return;
        }
        for (int i = 0; i < aphrase.len; ++i) {
            abuffer.phrases[phrase_count].phrase[i] = aphrase.phrase[i];
        }
        abuffer.phrases[phrase_count].count = 0;
        abuffer.phrases[phrase_count].len = aphrase.len;
        abstract_data[] data2 = abuffer.data;
        for (int data_pointer = 0; data_pointer < abuffer.len; ++data_pointer) {
            int j;
            int search_start = data_pointer;
            for (j = 0; data_pointer < abuffer.len && j < aphrase.len && data2[data_pointer].type == 1 && (data2[data_pointer].original_data & 0xFF) == (aphrase.phrase[j] & 0xFF); ++j, ++data_pointer) {
            }
            if (j != aphrase.len) continue;
            j = 0;
            data_pointer = search_start;
            while (j < aphrase.len) {
                if (j == 0) {
                    data2[data_pointer].type = 2;
                    data2[data_pointer].phrase_used = phrase_count;
                    data2[data_pointer].length_in_abstract_data_elements_of_single_element = aphrase.len;
                    ++abuffer.phrases[phrase_count].count;
                } else {
                    data2[data_pointer].type = 0;
                }
                ++j;
                ++data_pointer;
            }
            --data_pointer;
        }
        for (int i = 0; i < aphrase.len; ++i) {
            int current_code;
            int n = current_code = aphrase.phrase[i];
            abuffer.codes_used_array[n] = abuffer.codes_used_array[n] - (abuffer.phrases[phrase_count].count - 1);
        }
        abuffer.codes_used_array[256 + phrase_count] = aphrase.len * abuffer.phrases[phrase_count].count;
        ++abuffer.different_codes_used;
        int[] bytes_used_array = new int[356];
        int map_count = 0;
        for (int i = 0; i < 356; ++i) {
            abuffer.map[i] = -1;
            bytes_used_array[i] = abuffer.codes_used_array[i];
        }
        int remember = -1;
        while (map_count < 356) {
            int most = -1;
            for (int i = 0; i < 356; ++i) {
                if (bytes_used_array[i] < most) continue;
                most = bytes_used_array[i];
                remember = i;
            }
            abuffer.map[map_count] = remember;
            bytes_used_array[remember] = -2;
            ++map_count;
        }
    }

    phrase abstract_get_best_single_phrase(abstract_buffer abuffer) {
        int phrase_len;
        int used_bits_without_phrase;
        phrase phrase_to_remember = new phrase();
        phrase_to_remember.len = 0;
        abstract_buffer local_buffer = this.abstract_clone(abuffer);
        int minimum_bits_so_far = used_bits_without_phrase = this.get_bits_used_from_abstract_complete(local_buffer);
        String message = "Testing phrase with len: ";
        this.alternating_phrases[0] = null;
        this.alternating_phrases[1] = null;
        this.phrase_toggler = 0;
        for (phrase_len = this.MIN_PHRASE_LEN; phrase_len < this.MAX_PHRASE_LEN; ++phrase_len) {
            int used_bits;
            message = message + " " + phrase_len + " ";
            phrase best_phrase = this.abstract_get_best_phrase_used_more_than_once(local_buffer, phrase_len);
            if (best_phrase.len == 0) continue;
            this.abstract_apply_phrase(local_buffer, best_phrase);
            if (this.SHANNON) {
                this.abstract_Shannon(local_buffer);
            }
            if (this.RLE_USED) {
                this.abstract_RLE(local_buffer);
            }
            if (minimum_bits_so_far > (used_bits = this.get_bits_used_from_abstract_complete(local_buffer))) {
                minimum_bits_so_far = used_bits;
                phrase_to_remember.len = best_phrase.len;
                phrase_to_remember.count = best_phrase.count;
                for (int i = 0; i < best_phrase.len; ++i) {
                    phrase_to_remember.phrase[i] = best_phrase.phrase[i];
                }
            }
            this.abstract_reset_buffer(local_buffer, abuffer);
        }
        this.delete_abstract(local_buffer);
        message = message + " " + phrase_len + " ";
        this.tl.printMessageSU(message);
        return phrase_to_remember;
    }

    void abstract_search_insert_phrases(abstract_buffer abuffer) {
        abstract_buffer local_buffer = this.abstract_clone(abuffer);
        if (this.SHANNON) {
            this.abstract_Shannon(local_buffer);
        }
        if (this.RLE_USED) {
            this.abstract_RLE(local_buffer);
        }
        int used_bits = this.get_bits_used_from_abstract_complete(local_buffer);
        this.tl.printMessageSU("Non Phrase: Reg: " + this.current_working_register + ", bytes used: " + (7 + used_bits) / 8);
        this.delete_abstract(local_buffer);
        phrase[] phrases = new phrase[100];
        for (int phrases_depth = 0; phrases_depth < this.PHRASES_MAX_DEPTH; ++phrases_depth) {
            phrase aphrase = this.abstract_get_best_single_phrase(abuffer);
            if (aphrase.len == 0) {
                this.tl.printWarningSU("No phrase found!");
                continue;
            }
            phrases[phrases_depth].len = aphrase.len;
            phrases[phrases_depth].count = aphrase.count;
            for (int i = 0; i < aphrase.len; ++i) {
                phrases[phrases_depth].phrase[i] = aphrase.phrase[i];
            }
            this.abstract_apply_phrase(abuffer, aphrase);
            local_buffer = this.abstract_clone(abuffer);
            if (this.SHANNON) {
                this.abstract_Shannon(local_buffer);
            }
            if (this.RLE_USED) {
                this.abstract_RLE(local_buffer);
            }
            used_bits = this.get_bits_used_from_abstract_complete(local_buffer);
            this.delete_abstract(local_buffer);
            this.tl.printMessageSU("Last result of test: Reg: " + this.current_working_register + ", Depth: " + phrases_depth + ", phrase_len: " + aphrase.len + ", bytes used: " + (7 + used_bits) / 8);
        }
    }

    void abstract_search_insert_phrases_optimal(abstract_buffer abuffer) {
        phrase aphrase;
        int used_bits_last;
        int used_bits;
        abstract_buffer local_buffer = this.abstract_clone(abuffer);
        if (this.SHANNON) {
            this.abstract_Shannon(local_buffer);
        }
        if (this.RLE_USED) {
            this.abstract_RLE(local_buffer);
        }
        int best_used = used_bits = this.get_bits_used_from_abstract_complete(local_buffer);
        this.tl.printMessageSU("Non Phrase: Reg: " + this.current_working_register + ", bytes used: " + (7 + used_bits) / 8);
        int phrases_depth = 0;
        boolean phrase_used = false;
        this.delete_abstract(local_buffer);
        do {
            used_bits_last = used_bits;
            aphrase = this.abstract_get_best_single_phrase(abuffer);
            if (aphrase.len == 0) {
                this.tl.printWarningSU("No phrase found!");
                continue;
            }
            local_buffer = this.abstract_clone(abuffer);
            this.abstract_apply_phrase(local_buffer, aphrase);
            if (this.SHANNON) {
                this.abstract_Shannon(local_buffer);
            }
            if (this.RLE_USED) {
                this.abstract_RLE(local_buffer);
            }
            used_bits = this.get_bits_used_from_abstract_complete(local_buffer);
            this.delete_abstract(local_buffer);
            if (used_bits < used_bits_last) {
                this.abstract_apply_phrase(abuffer, aphrase);
                this.tl.printMessageSU("Last result of test: Reg: " + this.current_working_register + ", Depth: " + phrases_depth + ", phrase_len: " + aphrase.len + ", bytes used: " + (7 + used_bits) / 8);
                best_used = used_bits;
                phrase_used = true;
            }
            ++phrases_depth;
        } while (used_bits < used_bits_last && phrases_depth < 100);
        if (phrase_used) {
            this.tl.printMessageSU("Optimum reached: Reg: " + this.current_working_register + ", Depth: " + phrases_depth + ", phrase_len: " + aphrase.len + ", bytes used: " + (7 + best_used) / 8);
        } else {
            this.tl.printMessageSU("Optimum reached: Reg: " + this.current_working_register + ", bytes used: " + (7 + best_used) / 8 + " (no phrase used) ");
        }
    }

    void print_abstract(abstract_buffer abuffer) {
        int i;
        for (i = 0; i < abuffer.len; ++i) {
            System.out.println("" + i + ".--- ");
            System.out.println("type      :%s " + this.type_string[abuffer.data[i].type]);
            System.out.println("count     :%i " + abuffer.data[i].count);
            System.out.println("odata     :%i " + (abuffer.data[i].original_data & 0xFF));
            System.out.println("phrase    :%i " + abuffer.data[i].phrase_used);
            System.out.println("data_len  :%i " + abuffer.data[i].length_in_abstract_data_elements_of_single_element);
        }
        System.out.println("");
        System.out.println("Other abstract data: ");
        System.out.println("len        :%i " + abuffer.len);
        System.out.println("#phrases   :%i " + abuffer.phrase_count);
        System.out.println("codes used :%i " + abuffer.different_codes_used);
        System.out.println("kind       :%i " + abuffer.kind);
        System.out.println("\n");
        System.out.println("Phrases: ");
        for (i = 0; i < abuffer.phrase_count; ++i) {
            System.out.println("Phrase " + i + ": ");
            for (int j = 0; j < abuffer.phrases[i].len; ++j) {
                System.out.println("" + abuffer.phrases[i].phrase[j] + " ");
            }
            System.out.println(" ");
        }
    }

    class sorted_codes {
        int bits;
        int code;
        int value;
        int map;

        sorted_codes() {
        }
    }

    class Code {
        int bit_count;
        int code;

        Code() {
        }
    }

    class abstract_buffer {
        abstract_data[] data;
        int len;
        phrase[] phrases;
        int phrase_count;
        int[] codes_used_array;
        int[] map;
        Code[] code;
        int different_codes_used;
        int kind;

        abstract_buffer() {
        }
    }

    class abstract_data {
        int type;
        int bit_length_ENCODED;
        int ENCODED_code;
        int bit_length_RLE;
        long RLE_code;
        int count;
        int length_in_abstract_data_elements_of_single_element;
        int original_data;
        int phrase_used;

        abstract_data() {
        }
    }

    class phrase {
        int[] phrase = new int[100];
        int len;
        int count;
        int start;

        phrase() {
        }
    }

    static class Tree {
        int count;
        int index;
        Tree parent;
        Tree left;
        Tree right;
        int bit_count;
        int coder;

        Tree() {
        }
    }
}

