/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi.sound.ibxm;

import de.malban.vide.vedi.sound.ibxm.Channel;
import de.malban.vide.vedi.sound.ibxm.GlobalVol;
import de.malban.vide.vedi.sound.ibxm.Module;
import de.malban.vide.vedi.sound.ibxm.Note;
import de.malban.vide.vedi.sound.ibxm.Pattern;

public class IBXM {
    public static final String VERSION = "a61 (c)2011 mumart@gmail.com";
    private static final int OVERSAMPLE = 2;
    public static int IBXM_MAXBUFFER = 14293;
    public Module module;
    private int[] rampBuffer;
    private Channel[] channels;
    private int interpolation;
    private int filtL;
    private int filtR;
    private int sampleRate;
    private int tickLen;
    private int rampLen;
    private int rampRate;
    private int seqPos;
    private int breakSeqPos;
    private int row;
    private int nextRow;
    private int tick;
    private int speed;
    private int plCount;
    private int plChannel;
    private GlobalVol globalVol;
    private Note note;
    boolean[] playVoices = new boolean[0];

    public IBXM(Module module, int sampleRate) {
        this.module = module;
        this.sampleRate = sampleRate;
        this.interpolation = 1;
        if (sampleRate * 2 < 16000) {
            throw new IllegalArgumentException("Unsupported sampling rate!");
        }
        this.rampLen = 256;
        while (this.rampLen * 1024 > sampleRate * 2) {
            this.rampLen /= 2;
        }
        this.rampBuffer = new int[this.rampLen * 2];
        this.rampRate = 256 / this.rampLen;
        this.channels = new Channel[module.numChannels];
        this.globalVol = new GlobalVol();
        this.note = new Note();
        this.setSequencePos(0);
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public void setInterpolation(int interpolation) {
        this.interpolation = interpolation;
    }

    public int getMixBufferLength() {
        return this.sampleRate * 2 * 5 / 32 + this.rampLen * 2;
    }

    public void setSequencePos(int pos) {
        int idx;
        if (pos >= this.module.sequenceLength) {
            pos = 0;
        }
        this.breakSeqPos = pos;
        this.nextRow = 0;
        this.tick = 1;
        this.globalVol.volume = this.module.defaultGVol;
        this.speed = this.module.defaultSpeed > 0 ? this.module.defaultSpeed : 6;
        this.setTempo(this.module.defaultTempo > 0 ? this.module.defaultTempo : 125);
        this.plChannel = -1;
        this.plCount = -1;
        for (idx = 0; idx < this.module.numChannels; ++idx) {
            this.channels[idx] = new Channel(this.module, idx, this.sampleRate * 2, this.globalVol);
        }
        int end2 = this.rampLen * 2;
        for (idx = 0; idx < end2; ++idx) {
            this.rampBuffer[idx] = 0;
        }
        this.filtR = 0;
        this.filtL = 0;
        this.tick();
    }

    public int calculateSongDuration() {
        int duration = 0;
        this.setSequencePos(0);
        boolean songEnd = false;
        while (!songEnd) {
            duration += this.tickLen / 2;
            songEnd = this.tick();
        }
        this.setSequencePos(0);
        return duration;
    }

    public int seek(int samplePos) {
        this.setSequencePos(0);
        int currentPos = 0;
        while (samplePos - currentPos >= this.tickLen) {
            for (int idx = 0; idx < this.module.numChannels; ++idx) {
                this.channels[idx].updateSampleIdx(this.tickLen);
            }
            currentPos += this.tickLen / 2;
            this.tick();
        }
        return currentPos;
    }

    public int getAudio(int[] outputBuffer) {
        int outIdx = 0;
        int outEp1 = this.tickLen + this.rampLen << 1;
        while (outIdx < outEp1) {
            outputBuffer[outIdx++] = 0;
        }
        for (int chanIdx = 0; chanIdx < this.module.numChannels; ++chanIdx) {
            if (this.playVoices.length > chanIdx && !this.playVoices[chanIdx]) continue;
            Channel chan = this.channels[chanIdx];
            chan.resample(outputBuffer, 0, this.tickLen + this.rampLen, this.interpolation);
            chan.updateSampleIdx(this.tickLen);
        }
        this.volumeRamp(outputBuffer);
        this.tick();
        return this.downsample(outputBuffer, this.tickLen);
    }

    public void setVoicePlay(boolean[] voicePlay) {
        this.playVoices = new boolean[voicePlay.length];
        int c = 0;
        for (boolean b : voicePlay) {
            this.playVoices[c++] = b;
        }
    }

    private void setTempo(int tempo) {
        this.tickLen = this.sampleRate * 2 * 5 / (tempo * 2) & 0xFFFFFFFE;
    }

    private void volumeRamp(int[] mixBuffer) {
        int offset = 0;
        for (int a1 = 0; a1 < 256; a1 += this.rampRate) {
            int a2 = 256 - a1;
            int s1 = mixBuffer[offset] * a1;
            int s2 = this.rampBuffer[offset] * a2;
            mixBuffer[offset++] = s1 + s2 >> 8;
            s1 = mixBuffer[offset] * a1;
            s2 = this.rampBuffer[offset] * a2;
            mixBuffer[offset++] = s1 + s2 >> 8;
        }
        System.arraycopy(mixBuffer, this.tickLen << 1, this.rampBuffer, 0, offset);
    }

    private int downsample(int[] buf, int count) {
        int fl = this.filtL;
        int fr = this.filtR;
        int inIdx = 0;
        int outIdx = 0;
        while (outIdx < count) {
            int outL = fl + (buf[inIdx++] >> 1);
            int outR = fr + (buf[inIdx++] >> 1);
            fl = buf[inIdx++] >> 2;
            fr = buf[inIdx++] >> 2;
            buf[outIdx++] = outL + fl;
            buf[outIdx++] = outR + fr;
        }
        this.filtL = fl;
        this.filtR = fr;
        return count >> 1;
    }

    private boolean tick() {
        boolean songEnd = false;
        if (--this.tick <= 0) {
            this.tick = this.speed;
            songEnd = this.row();
        } else {
            for (int idx = 0; idx < this.module.numChannels; ++idx) {
                this.channels[idx].tick();
            }
        }
        return songEnd;
    }

    private boolean row() {
        boolean songEnd = false;
        if (this.breakSeqPos >= 0) {
            if (this.breakSeqPos >= this.module.sequenceLength) {
                this.nextRow = 0;
                this.breakSeqPos = 0;
            }
            while (this.module.sequence[this.breakSeqPos] >= this.module.numPatterns) {
                ++this.breakSeqPos;
                if (this.breakSeqPos < this.module.sequenceLength) continue;
                this.nextRow = 0;
                this.breakSeqPos = 0;
            }
            if (this.breakSeqPos <= this.seqPos) {
                songEnd = true;
            }
            this.seqPos = this.breakSeqPos;
            for (int idx = 0; idx < this.module.numChannels; ++idx) {
                this.channels[idx].plRow = 0;
            }
            this.breakSeqPos = -1;
        }
        Pattern pattern = this.module.patterns[this.module.sequence[this.seqPos]];
        this.row = this.nextRow;
        if (this.row >= pattern.numRows) {
            this.row = 0;
        }
        this.nextRow = this.row + 1;
        if (this.nextRow >= pattern.numRows) {
            this.breakSeqPos = this.seqPos + 1;
            this.nextRow = 0;
        }
        int noteIdx = this.row * this.module.numChannels;
        block11: for (int chanIdx = 0; chanIdx < this.module.numChannels; ++chanIdx) {
            Channel channel = this.channels[chanIdx];
            pattern.getNote(noteIdx + chanIdx, this.note);
            if (this.note.effect == 14) {
                this.note.effect = 0x70 | this.note.param >> 4;
                this.note.param &= 0xF;
            }
            if (this.note.effect == 147) {
                this.note.effect = 0xF0 | this.note.param >> 4;
                this.note.param &= 0xF;
            }
            if (this.note.effect == 0 && this.note.param > 0) {
                this.note.effect = 138;
            }
            channel.row(this.note);
            switch (this.note.effect) {
                case 129: {
                    if (this.note.param <= 0) continue block11;
                    this.tick = this.speed = this.note.param;
                    continue block11;
                }
                case 11: 
                case 130: {
                    if (this.plCount >= 0) continue block11;
                    this.breakSeqPos = this.note.param;
                    this.nextRow = 0;
                    continue block11;
                }
                case 13: 
                case 131: {
                    if (this.plCount >= 0) continue block11;
                    this.breakSeqPos = this.seqPos + 1;
                    this.nextRow = (this.note.param >> 4) * 10 + (this.note.param & 0xF);
                    continue block11;
                }
                case 15: {
                    if (this.note.param <= 0) continue block11;
                    if (this.note.param < 32) {
                        this.tick = this.speed = this.note.param;
                        continue block11;
                    }
                    this.setTempo(this.note.param);
                    continue block11;
                }
                case 148: {
                    if (this.note.param <= 32) continue block11;
                    this.setTempo(this.note.param);
                    continue block11;
                }
                case 118: 
                case 251: {
                    if (this.note.param == 0) {
                        channel.plRow = this.row;
                    }
                    if (channel.plRow >= this.row) continue block11;
                    if (this.plCount < 0) {
                        this.plCount = this.note.param;
                        this.plChannel = chanIdx;
                    }
                    if (this.plChannel != chanIdx) continue block11;
                    if (this.plCount == 0) {
                        channel.plRow = this.row + 1;
                    } else {
                        this.nextRow = channel.plRow;
                        this.breakSeqPos = -1;
                    }
                    --this.plCount;
                    continue block11;
                }
                case 126: 
                case 254: {
                    this.tick = this.speed + this.speed * this.note.param;
                }
            }
        }
        return songEnd;
    }
}

