/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi.sound.ibxm;

import de.malban.vide.vedi.sound.ibxm.Envelope;
import de.malban.vide.vedi.sound.ibxm.Instrument;
import de.malban.vide.vedi.sound.ibxm.Pattern;
import de.malban.vide.vedi.sound.ibxm.Sample;
import java.io.UnsupportedEncodingException;

public class Module {
    public String songName = "Blank";
    public int numChannels = 4;
    public int numInstruments = 1;
    public int numPatterns = 1;
    public int sequenceLength = 1;
    public int restartPos = 0;
    public int defaultGVol = 64;
    public int defaultSpeed = 6;
    public int defaultTempo = 125;
    public int c2Rate = 8287;
    public int gain = 64;
    public boolean linearPeriods = false;
    public boolean fastVolSlides = false;
    public int[] defaultPanning = new int[]{51, 204, 204, 51};
    public int[] sequence = new int[]{0};
    public Pattern[] patterns = new Pattern[]{new Pattern(4, 64)};
    public Instrument[] instruments = new Instrument[]{new Instrument(), new Instrument()};
    private static final int[] keyToPeriod = new int[]{29020, 27392, 25855, 24403, 23034, 21741, 20521, 19369, 18282, 17256, 16287, 15373, 14510, 13696};

    public Module() {
    }

    public Module(byte[] moduleData) {
        if (Module.isoLatin1(moduleData, 0, 17).equals("Extended Module: ")) {
            this.loadXM(moduleData);
        } else if (Module.isoLatin1(moduleData, 44, 4).equals("SCRM")) {
            this.loadS3M(moduleData);
        } else {
            this.loadMOD(moduleData);
        }
    }

    private void loadMOD(byte[] moduleData) {
        int patIdx;
        this.songName = Module.isoLatin1(moduleData, 0, 20);
        this.sequenceLength = moduleData[950] & 0x7F;
        this.restartPos = moduleData[951] & 0x7F;
        if (this.restartPos >= this.sequenceLength) {
            this.restartPos = 0;
        }
        this.sequence = new int[128];
        for (int seqIdx = 0; seqIdx < 128; ++seqIdx) {
            this.sequence[seqIdx] = patIdx = moduleData[952 + seqIdx] & 0x7F;
            if (patIdx < this.numPatterns) continue;
            this.numPatterns = patIdx + 1;
        }
        switch (Module.ushortbe(moduleData, 1082)) {
            case 19233: 
            case 19246: 
            case 21556: {
                this.numChannels = 4;
                this.c2Rate = 8287;
                this.gain = 64;
                break;
            }
            case 18510: {
                this.numChannels = moduleData[1080] - 48;
                this.c2Rate = 8363;
                this.gain = 32;
                break;
            }
            case 17224: {
                this.numChannels = (moduleData[1080] - 48) * 10;
                this.numChannels += moduleData[1081] - 48;
                this.c2Rate = 8363;
                this.gain = 32;
                break;
            }
            default: {
                throw new IllegalArgumentException("MOD Format not recognised!");
            }
        }
        this.defaultGVol = 64;
        this.defaultSpeed = 6;
        this.defaultTempo = 125;
        this.defaultPanning = new int[this.numChannels];
        for (int idx = 0; idx < this.numChannels; ++idx) {
            this.defaultPanning[idx] = 51;
            if ((idx & 3) != 1 && (idx & 3) != 2) continue;
            this.defaultPanning[idx] = 204;
        }
        int moduleDataIdx = 1084;
        this.patterns = new Pattern[this.numPatterns];
        for (patIdx = 0; patIdx < this.numPatterns; ++patIdx) {
            Pattern pattern = this.patterns[patIdx] = new Pattern(this.numChannels, 64);
            for (int patDataIdx = 0; patDataIdx < pattern.data.length; patDataIdx += 5) {
                int period = (moduleData[moduleDataIdx] & 0xF) << 8;
                if ((period = (period | moduleData[moduleDataIdx + 1] & 0xFF) * 4) > 112) {
                    int key = 0;
                    int oct = 0;
                    while (period < 14510) {
                        period *= 2;
                        ++oct;
                    }
                    while (key < 12) {
                        int d1 = keyToPeriod[key] - period;
                        int d2 = period - keyToPeriod[key + 1];
                        if (d2 >= 0) {
                            if (d2 >= d1) break;
                            ++key;
                            break;
                        }
                        ++key;
                    }
                    pattern.data[patDataIdx] = (byte)(oct * 12 + key);
                }
                int ins = (moduleData[moduleDataIdx + 2] & 0xF0) >> 4;
                pattern.data[patDataIdx + 1] = (byte)(ins |= moduleData[moduleDataIdx] & 0x10);
                int effect = moduleData[moduleDataIdx + 2] & 0xF;
                int param = moduleData[moduleDataIdx + 3] & 0xFF;
                if (param == 0 && (effect < 3 || effect == 10)) {
                    effect = 0;
                }
                if (param == 0 && (effect == 5 || effect == 6)) {
                    effect -= 2;
                }
                if (effect == 8 && this.numChannels == 4) {
                    param = 0;
                    effect = 0;
                }
                pattern.data[patDataIdx + 3] = (byte)effect;
                pattern.data[patDataIdx + 4] = (byte)param;
                moduleDataIdx += 4;
            }
        }
        this.numInstruments = 31;
        this.instruments = new Instrument[this.numInstruments + 1];
        this.instruments[0] = new Instrument();
        for (int instIdx = 1; instIdx <= this.numInstruments; ++instIdx) {
            Instrument instrument = this.instruments[instIdx] = new Instrument();
            Sample sample = instrument.samples[0];
            instrument.name = Module.isoLatin1(moduleData, instIdx * 30 - 10, 22);
            int sampleLength = Module.ushortbe(moduleData, instIdx * 30 + 12) * 2;
            int fineTune = (moduleData[instIdx * 30 + 14] & 0xF) << 4;
            sample.fineTune = fineTune < 128 ? fineTune : fineTune - 256;
            int volume = moduleData[instIdx * 30 + 15] & 0x7F;
            sample.volume = volume <= 64 ? volume : 64;
            sample.panning = -1;
            sample.c2Rate = this.c2Rate;
            int loopStart = Module.ushortbe(moduleData, instIdx * 30 + 16) * 2;
            int loopLength = Module.ushortbe(moduleData, instIdx * 30 + 18) * 2;
            short[] sampleData = new short[sampleLength];
            if (moduleDataIdx + sampleLength > moduleData.length) {
                sampleLength = moduleData.length - moduleDataIdx;
            }
            if (loopStart + loopLength > sampleLength) {
                loopLength = sampleLength - loopStart;
            }
            if (loopLength < 4) {
                loopStart = sampleLength;
                loopLength = 0;
            }
            int end2 = sampleLength;
            for (int idx = 0; idx < end2; ++idx) {
                sampleData[idx] = (short)(moduleData[moduleDataIdx++] << 8);
            }
            sample.setSampleData(sampleData, loopStart, loopLength, false);
        }
    }

    private void loadS3M(byte[] moduleData) {
        boolean signedSamples;
        this.songName = Module.codePage850(moduleData, 0, 28);
        this.sequenceLength = Module.ushortle(moduleData, 32);
        this.numInstruments = Module.ushortle(moduleData, 34);
        this.numPatterns = Module.ushortle(moduleData, 36);
        int flags = Module.ushortle(moduleData, 38);
        int version2 = Module.ushortle(moduleData, 40);
        this.fastVolSlides = (flags & 0x40) == 64 || version2 == 4864;
        boolean bl = signedSamples = Module.ushortle(moduleData, 42) == 1;
        if (Module.intle(moduleData, 44) != 1297236819) {
            throw new IllegalArgumentException("Not an S3M file!");
        }
        this.defaultGVol = moduleData[48] & 0xFF;
        this.defaultSpeed = moduleData[49] & 0xFF;
        this.defaultTempo = moduleData[50] & 0xFF;
        this.c2Rate = 8363;
        this.gain = moduleData[51] & 0x7F;
        boolean stereoMode = (moduleData[51] & 0x80) == 128;
        boolean defaultPan = (moduleData[53] & 0xFF) == 252;
        int[] channelMap = new int[32];
        for (int chanIdx = 0; chanIdx < 32; ++chanIdx) {
            channelMap[chanIdx] = -1;
            if ((moduleData[64 + chanIdx] & 0xFF) >= 16) continue;
            ++this.numChannels;
        }
        this.sequence = new int[this.sequenceLength];
        for (int seqIdx = 0; seqIdx < this.sequenceLength; ++seqIdx) {
            this.sequence[seqIdx] = moduleData[96 + seqIdx] & 0xFF;
        }
        int moduleDataIdx = 96 + this.sequenceLength;
        this.instruments = new Instrument[this.numInstruments + 1];
        this.instruments[0] = new Instrument();
        for (int instIdx = 1; instIdx <= this.numInstruments; ++instIdx) {
            int idx;
            int end2;
            boolean sixteenBit;
            boolean loopOn;
            Instrument instrument = this.instruments[instIdx] = new Instrument();
            Sample sample = instrument.samples[0];
            int instOffset = Module.ushortle(moduleData, moduleDataIdx) << 4;
            moduleDataIdx += 2;
            instrument.name = Module.codePage850(moduleData, instOffset + 48, 28);
            if (moduleData[instOffset] != 1 || Module.ushortle(moduleData, instOffset + 76) != 17235) continue;
            int sampleOffset = (moduleData[instOffset + 13] & 0xFF) << 20;
            sampleOffset += Module.ushortle(moduleData, instOffset + 14) << 4;
            int sampleLength = Module.intle(moduleData, instOffset + 16);
            int loopStart = Module.intle(moduleData, instOffset + 20);
            int loopLength = Module.intle(moduleData, instOffset + 24) - loopStart;
            sample.volume = moduleData[instOffset + 28] & 0xFF;
            sample.panning = -1;
            boolean packed = moduleData[instOffset + 30] != 0;
            boolean bl2 = loopOn = (moduleData[instOffset + 31] & 1) == 1;
            if (loopStart + loopLength > sampleLength) {
                loopLength = sampleLength - loopStart;
            }
            if (loopLength < 1 || !loopOn) {
                loopStart = sampleLength;
                loopLength = 0;
            }
            boolean stereo = (moduleData[instOffset + 31] & 2) == 2;
            boolean bl3 = sixteenBit = (moduleData[instOffset + 31] & 4) == 4;
            if (packed) {
                throw new IllegalArgumentException("Packed samples not supported!");
            }
            sample.c2Rate = Module.intle(moduleData, instOffset + 32);
            short[] sampleData = new short[loopStart + loopLength];
            if (sixteenBit) {
                if (signedSamples) {
                    end2 = sampleData.length;
                    for (idx = 0; idx < end2; ++idx) {
                        sampleData[idx] = (short)(moduleData[sampleOffset] & 0xFF | moduleData[sampleOffset + 1] << 8);
                        sampleOffset += 2;
                    }
                } else {
                    end2 = sampleData.length;
                    for (idx = 0; idx < end2; ++idx) {
                        int sam = moduleData[sampleOffset] & 0xFF | (moduleData[sampleOffset + 1] & 0xFF) << 8;
                        sampleData[idx] = (short)(sam - 32768);
                        sampleOffset += 2;
                    }
                }
            } else if (signedSamples) {
                end2 = sampleData.length;
                for (idx = 0; idx < end2; ++idx) {
                    sampleData[idx] = (short)(moduleData[sampleOffset++] << 8);
                }
            } else {
                end2 = sampleData.length;
                for (idx = 0; idx < end2; ++idx) {
                    sampleData[idx] = (short)((moduleData[sampleOffset++] & 0xFF) - 128 << 8);
                }
            }
            sample.setSampleData(sampleData, loopStart, loopLength, false);
        }
        this.patterns = new Pattern[this.numPatterns];
        for (int patIdx = 0; patIdx < this.numPatterns; ++patIdx) {
            Pattern pattern = this.patterns[patIdx] = new Pattern(this.numChannels, 64);
            int inOffset = (Module.ushortle(moduleData, moduleDataIdx) << 4) + 2;
            int rowIdx = 0;
            while (rowIdx < 64) {
                int chanIdx;
                int token;
                if ((token = moduleData[inOffset++] & 0xFF) == 0) {
                    ++rowIdx;
                    continue;
                }
                int noteKey = 0;
                int noteIns = 0;
                if ((token & 0x20) == 32) {
                    noteKey = moduleData[inOffset++] & 0xFF;
                    noteIns = moduleData[inOffset++] & 0xFF;
                    if (noteKey < 254) {
                        noteKey = (noteKey >> 4) * 12 + (noteKey & 0xF) + 1;
                    }
                    if (noteKey == 255) {
                        noteKey = 0;
                    }
                }
                int noteVol = 0;
                if ((token & 0x40) == 64 && (noteVol = (moduleData[inOffset++] & 0x7F) + 16) > 80) {
                    noteVol = 0;
                }
                int noteEffect = 0;
                int noteParam = 0;
                if ((token & 0x80) == 128) {
                    noteEffect = moduleData[inOffset++] & 0xFF;
                    noteParam = moduleData[inOffset++] & 0xFF;
                    if (noteEffect < 1 || noteEffect >= 64) {
                        noteParam = 0;
                        noteEffect = 0;
                    }
                    if (noteEffect > 0) {
                        noteEffect += 128;
                    }
                }
                if ((chanIdx = channelMap[token & 0x1F]) < 0) continue;
                int noteOffset = (rowIdx * this.numChannels + chanIdx) * 5;
                pattern.data[noteOffset] = (byte)noteKey;
                pattern.data[noteOffset + 1] = (byte)noteIns;
                pattern.data[noteOffset + 2] = (byte)noteVol;
                pattern.data[noteOffset + 3] = (byte)noteEffect;
                pattern.data[noteOffset + 4] = (byte)noteParam;
            }
            moduleDataIdx += 2;
        }
        this.defaultPanning = new int[this.numChannels];
        for (int chanIdx = 0; chanIdx < 32; ++chanIdx) {
            int panFlags;
            if (channelMap[chanIdx] < 0) continue;
            int panning = 7;
            if (stereoMode) {
                panning = 12;
                if ((moduleData[64 + chanIdx] & 0xFF) < 8) {
                    panning = 3;
                }
            }
            if (defaultPan && ((panFlags = moduleData[moduleDataIdx + chanIdx] & 0xFF) & 0x20) == 32) {
                panning = panFlags & 0xF;
            }
            this.defaultPanning[channelMap[chanIdx]] = panning * 17;
        }
    }

    private void loadXM(byte[] moduleData) {
        if (Module.ushortle(moduleData, 58) != 260) {
            throw new IllegalArgumentException("XM format version must be 0x0104!");
        }
        this.songName = Module.codePage850(moduleData, 17, 20);
        boolean deltaEnv = Module.isoLatin1(moduleData, 38, 20).startsWith("DigiBooster Pro");
        int dataOffset = 60 + Module.intle(moduleData, 60);
        this.sequenceLength = Module.ushortle(moduleData, 64);
        this.restartPos = Module.ushortle(moduleData, 66);
        this.numChannels = Module.ushortle(moduleData, 68);
        this.numPatterns = Module.ushortle(moduleData, 70);
        this.numInstruments = Module.ushortle(moduleData, 72);
        this.linearPeriods = (Module.ushortle(moduleData, 74) & 1) > 0;
        this.defaultGVol = 64;
        this.defaultSpeed = Module.ushortle(moduleData, 76);
        this.defaultTempo = Module.ushortle(moduleData, 78);
        this.c2Rate = 8363;
        this.gain = 64;
        this.defaultPanning = new int[this.numChannels];
        for (int idx = 0; idx < this.numChannels; ++idx) {
            this.defaultPanning[idx] = 128;
        }
        this.sequence = new int[this.sequenceLength];
        for (int seqIdx = 0; seqIdx < this.sequenceLength; ++seqIdx) {
            int entry = moduleData[80 + seqIdx] & 0xFF;
            this.sequence[seqIdx] = entry < this.numPatterns ? entry : 0;
        }
        this.patterns = new Pattern[this.numPatterns];
        for (int patIdx = 0; patIdx < this.numPatterns; ++patIdx) {
            if (moduleData[dataOffset + 4] != 0) {
                throw new IllegalArgumentException("Unknown pattern packing type!");
            }
            int numRows = Module.ushortle(moduleData, dataOffset + 5);
            int numNotes = numRows * this.numChannels;
            Pattern pattern = this.patterns[patIdx] = new Pattern(this.numChannels, numRows);
            int patternDataLength = Module.ushortle(moduleData, dataOffset + 7);
            dataOffset += Module.intle(moduleData, dataOffset);
            int nextOffset = dataOffset + patternDataLength;
            if (patternDataLength > 0) {
                int patternDataOffset = 0;
                for (int note = 0; note < numNotes; ++note) {
                    byte fxp;
                    int flags = moduleData[dataOffset];
                    if ((flags & 0x80) == 0) {
                        flags = 31;
                    } else {
                        ++dataOffset;
                    }
                    byte key = (flags & 1) > 0 ? moduleData[dataOffset++] : (byte)0;
                    pattern.data[patternDataOffset++] = key;
                    byte ins = (flags & 2) > 0 ? moduleData[dataOffset++] : (byte)0;
                    pattern.data[patternDataOffset++] = ins;
                    byte vol = (flags & 4) > 0 ? moduleData[dataOffset++] : (byte)0;
                    pattern.data[patternDataOffset++] = vol;
                    byte fxc = (flags & 8) > 0 ? moduleData[dataOffset++] : (byte)0;
                    byte by = fxp = (flags & 0x10) > 0 ? moduleData[dataOffset++] : (byte)0;
                    if (fxc >= 64) {
                        fxp = 0;
                        fxc = 0;
                    }
                    pattern.data[patternDataOffset++] = fxc;
                    pattern.data[patternDataOffset++] = fxp;
                }
            }
            dataOffset = nextOffset;
        }
        this.instruments = new Instrument[this.numInstruments + 1];
        this.instruments[0] = new Instrument();
        for (int insIdx = 1; insIdx <= this.numInstruments; ++insIdx) {
            Instrument instrument = this.instruments[insIdx] = new Instrument();
            instrument.name = Module.codePage850(moduleData, dataOffset + 4, 22);
            instrument.numSamples = Module.ushortle(moduleData, dataOffset + 27);
            int numSamples = instrument.numSamples;
            if (numSamples > 0) {
                instrument.samples = new Sample[numSamples];
                for (int keyIdx = 0; keyIdx < 96; ++keyIdx) {
                    instrument.keyToSample[keyIdx + 1] = moduleData[dataOffset + 33 + keyIdx] & 0xFF;
                }
                Envelope volEnv = instrument.volumeEnvelope = new Envelope();
                volEnv.pointsTick = new int[12];
                volEnv.pointsAmpl = new int[12];
                int pointTick = 0;
                for (int point = 0; point < 12; ++point) {
                    int pointOffset = dataOffset + 129 + point * 4;
                    volEnv.pointsTick[point] = pointTick = (deltaEnv ? pointTick : 0) + Module.ushortle(moduleData, pointOffset);
                    volEnv.pointsAmpl[point] = Module.ushortle(moduleData, pointOffset + 2);
                }
                Envelope panEnv = instrument.panningEnvelope = new Envelope();
                panEnv.pointsTick = new int[12];
                panEnv.pointsAmpl = new int[12];
                pointTick = 0;
                for (int point = 0; point < 12; ++point) {
                    int pointOffset = dataOffset + 177 + point * 4;
                    panEnv.pointsTick[point] = pointTick = (deltaEnv ? pointTick : 0) + Module.ushortle(moduleData, pointOffset);
                    panEnv.pointsAmpl[point] = Module.ushortle(moduleData, pointOffset + 2);
                }
                volEnv.numPoints = moduleData[dataOffset + 225] & 0xFF;
                if (volEnv.numPoints > 12) {
                    volEnv.numPoints = 0;
                }
                panEnv.numPoints = moduleData[dataOffset + 226] & 0xFF;
                if (panEnv.numPoints > 12) {
                    panEnv.numPoints = 0;
                }
                volEnv.sustainTick = volEnv.pointsTick[moduleData[dataOffset + 227]];
                volEnv.loopStartTick = volEnv.pointsTick[moduleData[dataOffset + 228]];
                volEnv.loopEndTick = volEnv.pointsTick[moduleData[dataOffset + 229]];
                panEnv.sustainTick = panEnv.pointsTick[moduleData[dataOffset + 230]];
                panEnv.loopStartTick = panEnv.pointsTick[moduleData[dataOffset + 231]];
                panEnv.loopEndTick = panEnv.pointsTick[moduleData[dataOffset + 232]];
                volEnv.enabled = volEnv.numPoints > 0 && (moduleData[dataOffset + 233] & 1) > 0;
                volEnv.sustain = (moduleData[dataOffset + 233] & 2) > 0;
                volEnv.looped = (moduleData[dataOffset + 233] & 4) > 0;
                panEnv.enabled = panEnv.numPoints > 0 && (moduleData[dataOffset + 234] & 1) > 0;
                panEnv.sustain = (moduleData[dataOffset + 234] & 2) > 0;
                panEnv.looped = (moduleData[dataOffset + 234] & 4) > 0;
                instrument.vibratoType = moduleData[dataOffset + 235] & 0xFF;
                instrument.vibratoSweep = moduleData[dataOffset + 236] & 0xFF;
                instrument.vibratoDepth = moduleData[dataOffset + 237] & 0xFF;
                instrument.vibratoRate = moduleData[dataOffset + 238] & 0xFF;
                instrument.volumeFadeOut = Module.ushortle(moduleData, dataOffset + 239);
            }
            dataOffset += Module.intle(moduleData, dataOffset);
            int sampleHeaderOffset = dataOffset;
            dataOffset += numSamples * 40;
            for (int samIdx = 0; samIdx < numSamples; ++samIdx) {
                int outIdx;
                int ampl;
                Sample sample = instrument.samples[samIdx] = new Sample();
                int sampleDataBytes = Module.intle(moduleData, sampleHeaderOffset);
                int sampleLoopStart = Module.intle(moduleData, sampleHeaderOffset + 4);
                int sampleLoopLength = Module.intle(moduleData, sampleHeaderOffset + 8);
                sample.volume = moduleData[sampleHeaderOffset + 12];
                sample.fineTune = moduleData[sampleHeaderOffset + 13];
                sample.c2Rate = 8363;
                boolean looped = (moduleData[sampleHeaderOffset + 14] & 3) > 0;
                boolean pingPong = (moduleData[sampleHeaderOffset + 14] & 2) > 0;
                boolean sixteenBit = (moduleData[sampleHeaderOffset + 14] & 0x10) > 0;
                sample.panning = moduleData[sampleHeaderOffset + 15] & 0xFF;
                sample.relNote = moduleData[sampleHeaderOffset + 16];
                sample.name = Module.codePage850(moduleData, sampleHeaderOffset + 18, 22);
                sampleHeaderOffset += 40;
                int sampleDataLength = sampleDataBytes;
                if (sixteenBit) {
                    sampleDataLength /= 2;
                    sampleLoopStart /= 2;
                    sampleLoopLength /= 2;
                }
                if (!looped || sampleLoopStart + sampleLoopLength > sampleDataLength) {
                    sampleLoopStart = sampleDataLength;
                    sampleLoopLength = 0;
                }
                short[] sampleData = new short[sampleDataLength];
                if (sixteenBit) {
                    ampl = 0;
                    for (outIdx = 0; outIdx < sampleDataLength; ++outIdx) {
                        int inIdx = dataOffset + outIdx * 2;
                        ampl = (short)(ampl + (moduleData[inIdx] & 0xFF));
                        sampleData[outIdx] = ampl = (int)((short)(ampl + ((moduleData[inIdx + 1] & 0xFF) << 8)));
                    }
                } else {
                    ampl = 0;
                    for (outIdx = 0; outIdx < sampleDataLength; ++outIdx) {
                        ampl = (byte)(ampl + (moduleData[dataOffset + outIdx] & 0xFF));
                        sampleData[outIdx] = (short)(ampl << 8);
                    }
                }
                sample.setSampleData(sampleData, sampleLoopStart, sampleLoopLength, pingPong);
                dataOffset += sampleDataBytes;
            }
        }
    }

    private static int ushortbe(byte[] buf, int offset) {
        return (buf[offset] & 0xFF) << 8 | buf[offset + 1] & 0xFF;
    }

    private static int ushortle(byte[] buf, int offset) {
        return buf[offset] & 0xFF | (buf[offset + 1] & 0xFF) << 8;
    }

    private static int intle(byte[] buf, int offset) {
        int value = buf[offset] & 0xFF;
        value |= (buf[offset + 1] & 0xFF) << 8;
        value |= (buf[offset + 2] & 0xFF) << 16;
        return value |= (buf[offset + 3] & 0x7F) << 24;
    }

    private static String isoLatin1(byte[] buf, int offset, int len) {
        char[] str = new char[len];
        for (int idx = 0; idx < len; ++idx) {
            int c = buf[offset + idx] & 0xFF;
            str[idx] = (char)(c < 32 ? 32 : (char)c);
        }
        return new String(str);
    }

    private static String codePage850(byte[] buf, int offset, int len) {
        try {
            char[] str = new String(buf, offset, len, "Cp850").toCharArray();
            for (int idx = 0; idx < str.length; ++idx) {
                str[idx] = str[idx] < ' ' ? 32 : str[idx];
            }
            return new String(str);
        }
        catch (UnsupportedEncodingException e) {
            return Module.isoLatin1(buf, offset, len);
        }
    }

    public void toStringBuffer(StringBuffer out) {
        out.append("Song Name: " + this.songName + '\n' + "Num Channels: " + this.numChannels + '\n' + "Num Instruments: " + this.numInstruments + '\n' + "Num Patterns: " + this.numPatterns + '\n' + "Sequence Length: " + this.sequenceLength + '\n' + "Restart Pos: " + this.restartPos + '\n' + "Default Speed: " + this.defaultSpeed + '\n' + "Default Tempo: " + this.defaultTempo + '\n' + "Linear Periods: " + this.linearPeriods + '\n');
        out.append("Sequence: ");
        for (int seqIdx = 0; seqIdx < this.sequence.length; ++seqIdx) {
            out.append(this.sequence[seqIdx] + ", ");
        }
        out.append('\n');
        for (int patIdx = 0; patIdx < this.patterns.length; ++patIdx) {
            out.append("Pattern " + patIdx + ":\n");
            this.patterns[patIdx].toStringBuffer(out);
        }
        for (int insIdx = 1; insIdx < this.instruments.length; ++insIdx) {
            out.append("Instrument " + insIdx + ":\n");
            this.instruments[insIdx].toStringBuffer(out);
        }
    }
}

