/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.ThemeDescription;
import de.muntjak.tinylookandfeel.TinyLookAndFeel;
import de.muntjak.tinylookandfeel.TinyUtils;
import de.muntjak.tinylookandfeel.util.BooleanReference;
import de.muntjak.tinylookandfeel.util.ColorRoutines;
import de.muntjak.tinylookandfeel.util.ColoredFont;
import de.muntjak.tinylookandfeel.util.HSBReference;
import de.muntjak.tinylookandfeel.util.IntReference;
import de.muntjak.tinylookandfeel.util.SBReference;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import javax.swing.plaf.InsetsUIResource;

public class Theme {
    private static final boolean DEBUG = false;
    public static final FilenameFilter THEMES_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(Theme.FILE_EXTENSION);
        }
    };
    public static final int ERROR_NONE = 1;
    public static final int ERROR_NULL_ARGUMENT = 2;
    public static final int ERROR_FILE_NOT_FOUND = 3;
    public static final int ERROR_IO_EXCEPTION = 4;
    public static final int ERROR_NO_TINYLAF_THEME = 5;
    public static final int ERROR_WIN99_STYLE = 6;
    public static final int ERROR_INVALID_THEME_DESCRIPTION = 7;
    private static final int DEFAULT_SCROLL_SIZE = 17;
    public static int errorCode = 1;
    protected static final Properties MAC_FONT_MAPPINGS = new Properties();
    protected static final Properties LINUX_FONT_MAPPINGS = new Properties();
    protected static final int YQ_STYLE = 2;
    public static final String DEFAULT_THEME = "Default.theme";
    public static final String FILE_EXTENSION = ".theme";
    static final URL YQ_URL = Theme.getYQ_URL();
    static final URI YQ_URI = Theme.getYQ_URI();
    protected static final int FILE_ID_1 = 4660;
    protected static final int FILE_ID_2 = 8756;
    public static final int FILE_ID_3A = 12852;
    protected static final int FILE_ID_3B = 12853;
    protected static final int FILE_ID_3C = 12854;
    protected static final int FILE_ID_3D = 12855;
    protected static final int FILE_ID_3E = 12856;
    protected static final int FILE_ID_3F = 12857;
    protected static final int FILE_ID_4 = 16384;
    protected static final int FILE_ID_4B = 16385;
    protected static final int FILE_ID_4C = 16386;
    protected static final int FILE_ID_4D = 16387;
    protected static final int FILE_ID_4E = 16388;
    public static int fileID;
    public static SBReference mainColor;
    public static SBReference disColor;
    public static SBReference backColor;
    public static SBReference frameColor;
    public static SBReference sub1Color;
    public static SBReference sub2Color;
    public static SBReference sub3Color;
    public static SBReference sub4Color;
    public static SBReference sub5Color;
    public static SBReference sub6Color;
    public static SBReference sub7Color;
    public static SBReference sub8Color;
    public static ColoredFont plainFont;
    public static ColoredFont boldFont;
    public static ColoredFont buttonFont;
    public static SBReference buttonFontColor;
    public static ColoredFont labelFont;
    public static SBReference labelFontColor;
    public static ColoredFont comboFont;
    public static ColoredFont listFont;
    public static ColoredFont menuFont;
    public static SBReference menuFontColor;
    public static ColoredFont menuItemFont;
    public static SBReference menuItemFontColor;
    public static ColoredFont passwordFont;
    public static ColoredFont radioFont;
    public static SBReference radioFontColor;
    public static ColoredFont checkFont;
    public static SBReference checkFontColor;
    public static ColoredFont tableFont;
    public static SBReference tableFontColor;
    public static ColoredFont tableHeaderFont;
    public static SBReference tableHeaderFontColor;
    public static ColoredFont textAreaFont;
    public static ColoredFont textFieldFont;
    public static ColoredFont textPaneFont;
    public static ColoredFont titledBorderFont;
    public static SBReference titledBorderFontColor;
    public static ColoredFont toolTipFont;
    public static ColoredFont treeFont;
    public static ColoredFont tabFont;
    public static SBReference tabFontColor;
    public static ColoredFont editorFont;
    public static ColoredFont frameTitleFont;
    public static ColoredFont internalFrameTitleFont;
    public static ColoredFont internalPaletteTitleFont;
    public static ColoredFont progressBarFont;
    public static SBReference progressColor;
    public static SBReference progressTrackColor;
    public static SBReference progressBorderColor;
    public static SBReference progressDarkColor;
    public static SBReference progressLightColor;
    public static SBReference progressSelectForeColor;
    public static SBReference progressSelectBackColor;
    public static SBReference textBgColor;
    public static SBReference textSelectedBgColor;
    public static SBReference textDisabledBgColor;
    public static SBReference textNonEditableBgColor;
    public static SBReference textTextColor;
    public static SBReference textSelectedTextColor;
    public static SBReference textBorderColor;
    public static SBReference textBorderDisabledColor;
    public static SBReference textCaretColor;
    public static SBReference textPaneBgColor;
    public static SBReference editorPaneBgColor;
    public static SBReference desktopPaneBgColor;
    public static InsetsUIResource textInsets;
    public static SBReference comboBorderColor;
    public static SBReference comboBorderDisabledColor;
    public static SBReference comboSelectedBgColor;
    public static SBReference comboSelectedTextColor;
    public static SBReference comboFocusBgColor;
    public static SBReference comboArrowColor;
    public static SBReference comboArrowDisabledColor;
    public static SBReference comboButtColor;
    public static SBReference comboButtRolloverColor;
    public static SBReference comboButtPressedColor;
    public static SBReference comboButtDisabledColor;
    public static SBReference comboButtBorderColor;
    public static SBReference comboButtBorderDisabledColor;
    public static SBReference comboBgColor;
    public static SBReference comboTextColor;
    public static IntReference comboSpreadLight;
    public static IntReference comboSpreadLightDisabled;
    public static IntReference comboSpreadDark;
    public static IntReference comboSpreadDarkDisabled;
    public static InsetsUIResource comboInsets;
    public static BooleanReference comboRollover;
    public static BooleanReference comboFocus;
    public static SBReference listBgColor;
    public static SBReference listTextColor;
    public static SBReference listSelectedBgColor;
    public static SBReference listSelectedTextColor;
    public static SBReference listFocusBorderColor;
    public static SBReference menuBarColor;
    public static SBReference menuRolloverBgColor;
    public static SBReference menuRolloverFgColor;
    public static SBReference menuDisabledFgColor;
    public static SBReference menuItemDisabledFgColor;
    public static SBReference menuItemRolloverColor;
    public static SBReference menuItemSelectedTextColor;
    public static SBReference menuBorderColor;
    public static SBReference menuPopupColor;
    public static SBReference menuInnerHilightColor;
    public static SBReference menuInnerShadowColor;
    public static SBReference menuOuterHilightColor;
    public static SBReference menuOuterShadowColor;
    public static SBReference menuIconColor;
    public static SBReference menuIconRolloverColor;
    public static SBReference menuIconDisabledColor;
    public static SBReference menuSeparatorColor;
    public static BooleanReference menuRollover;
    public static BooleanReference menuPopupShadow;
    public static BooleanReference menuAllowTwoIcons;
    public static SBReference toolBarColor;
    public static SBReference toolBarDarkColor;
    public static SBReference toolBarLightColor;
    public static SBReference toolButtColor;
    public static SBReference toolButtSelectedColor;
    public static SBReference toolButtRolloverColor;
    public static SBReference toolButtPressedColor;
    public static SBReference toolBorderColor;
    public static SBReference toolBorderSelectedColor;
    public static SBReference toolBorderRolloverColor;
    public static SBReference toolBorderPressedColor;
    public static SBReference toolGripDarkColor;
    public static SBReference toolGripLightColor;
    public static SBReference toolSeparatorColor;
    public static InsetsUIResource toolMargin;
    public static BooleanReference toolFocus;
    public static BooleanReference toolRollover;
    public static SBReference buttonNormalColor;
    public static SBReference buttonRolloverBgColor;
    public static SBReference buttonPressedColor;
    public static SBReference buttonDisabledColor;
    public static SBReference buttonRolloverColor;
    public static SBReference buttonDefaultColor;
    public static SBReference buttonCheckColor;
    public static SBReference buttonCheckDisabledColor;
    public static SBReference buttonBorderColor;
    public static SBReference buttonBorderDisabledColor;
    public static SBReference buttonDisabledFgColor;
    public static SBReference checkDisabledFgColor;
    public static SBReference radioDisabledFgColor;
    public static SBReference toggleSelectedBg;
    public static BooleanReference buttonRolloverBorder;
    public static BooleanReference buttonFocus;
    public static BooleanReference buttonFocusBorder;
    public static BooleanReference buttonEnter;
    public static BooleanReference shiftButtonText;
    public static InsetsUIResource buttonMargin;
    public static IntReference buttonSpreadLight;
    public static IntReference buttonSpreadLightDisabled;
    public static IntReference buttonSpreadDark;
    public static IntReference buttonSpreadDarkDisabled;
    public static InsetsUIResource checkMargin;
    public static SBReference tabPaneBorderColor;
    public static SBReference tabNormalColor;
    public static SBReference tabSelectedColor;
    public static SBReference tabDisabledColor;
    public static SBReference tabDisabledSelectedColor;
    public static SBReference tabDisabledTextColor;
    public static SBReference tabBorderColor;
    public static SBReference tabRolloverColor;
    public static SBReference tabPaneDisabledBorderColor;
    public static SBReference tabDisabledBorderColor;
    public static BooleanReference tabRollover;
    public static BooleanReference tabFocus;
    public static BooleanReference ignoreSelectedBg;
    public static BooleanReference fixedTabs;
    public static InsetsUIResource tabInsets;
    public static InsetsUIResource tabAreaInsets;
    public static BooleanReference sliderRolloverEnabled;
    public static BooleanReference sliderFocusEnabled;
    public static SBReference sliderThumbColor;
    public static SBReference sliderThumbRolloverColor;
    public static SBReference sliderThumbPressedColor;
    public static SBReference sliderThumbDisabledColor;
    public static SBReference sliderBorderColor;
    public static SBReference sliderDarkColor;
    public static SBReference sliderLightColor;
    public static SBReference sliderBorderDisabledColor;
    public static SBReference sliderTrackColor;
    public static SBReference sliderTrackBorderColor;
    public static SBReference sliderTrackDarkColor;
    public static SBReference sliderTrackLightColor;
    public static SBReference sliderTickColor;
    public static SBReference sliderTickDisabledColor;
    public static SBReference sliderFocusColor;
    public static BooleanReference spinnerRollover;
    public static SBReference spinnerButtColor;
    public static SBReference spinnerButtRolloverColor;
    public static SBReference spinnerButtPressedColor;
    public static SBReference spinnerButtDisabledColor;
    public static SBReference spinnerBorderColor;
    public static SBReference spinnerBorderDisabledColor;
    public static SBReference spinnerArrowColor;
    public static SBReference spinnerArrowDisabledColor;
    public static IntReference spinnerSpreadLight;
    public static IntReference spinnerSpreadLightDisabled;
    public static IntReference spinnerSpreadDark;
    public static IntReference spinnerSpreadDarkDisabled;
    public static SBReference scrollTrackColor;
    public static SBReference scrollTrackDisabledColor;
    public static SBReference scrollTrackBorderColor;
    public static SBReference scrollTrackBorderDisabledColor;
    public static SBReference scrollThumbColor;
    public static SBReference scrollThumbRolloverColor;
    public static SBReference scrollThumbPressedColor;
    public static SBReference scrollThumbDisabledColor;
    public static SBReference scrollButtColor;
    public static SBReference scrollButtRolloverColor;
    public static SBReference scrollButtPressedColor;
    public static SBReference scrollButtDisabledColor;
    public static SBReference scrollArrowColor;
    public static SBReference scrollArrowDisabledColor;
    public static SBReference scrollGripLightColor;
    public static SBReference scrollGripDarkColor;
    public static SBReference scrollBorderColor;
    public static SBReference scrollBorderLightColor;
    public static SBReference scrollBorderDisabledColor;
    public static SBReference scrollLightDisabledColor;
    public static SBReference scrollPaneBorderColor;
    public static IntReference scrollSpreadLight;
    public static IntReference scrollSpreadLightDisabled;
    public static IntReference scrollSpreadDark;
    public static IntReference scrollSpreadDarkDisabled;
    public static BooleanReference scrollRollover;
    public static IntReference scrollSize;
    public static SBReference treeBgColor;
    public static SBReference treeTextColor;
    public static SBReference treeTextBgColor;
    public static SBReference treeSelectedTextColor;
    public static SBReference treeSelectedBgColor;
    public static SBReference treeLineColor;
    public static SBReference frameCaptionColor;
    public static SBReference frameCaptionDisabledColor;
    public static SBReference frameBorderColor;
    public static SBReference frameLightColor;
    public static SBReference frameBorderDisabledColor;
    public static SBReference frameLightDisabledColor;
    public static SBReference frameTitleColor;
    public static SBReference frameTitleShadowColor;
    public static SBReference frameTitleDisabledColor;
    public static SBReference frameButtColor;
    public static SBReference frameButtRolloverColor;
    public static SBReference frameButtPressedColor;
    public static SBReference frameButtDisabledColor;
    public static SBReference frameButtCloseColor;
    public static SBReference frameButtCloseRolloverColor;
    public static SBReference frameButtClosePressedColor;
    public static SBReference frameButtCloseDisabledColor;
    public static SBReference frameButtBorderColor;
    public static SBReference frameButtBorderDisabledColor;
    public static IntReference frameButtSpreadLight;
    public static IntReference frameButtSpreadDark;
    public static IntReference frameButtSpreadLightDisabled;
    public static IntReference frameButtSpreadDarkDisabled;
    public static SBReference frameButtCloseBorderColor;
    public static SBReference frameButtCloseDarkColor;
    public static SBReference frameButtCloseLightColor;
    public static SBReference frameButtCloseBorderDisabledColor;
    public static IntReference frameButtCloseSpreadLight;
    public static IntReference frameButtCloseSpreadLightDisabled;
    public static IntReference frameButtCloseSpreadDark;
    public static IntReference frameButtCloseSpreadDarkDisabled;
    public static SBReference frameSymbolColor;
    public static SBReference frameSymbolPressedColor;
    public static SBReference frameSymbolDisabledColor;
    public static SBReference frameSymbolDarkColor;
    public static SBReference frameSymbolLightColor;
    public static SBReference frameSymbolDarkDisabledColor;
    public static SBReference frameSymbolLightDisabledColor;
    public static SBReference frameSymbolCloseColor;
    public static SBReference frameSymbolClosePressedColor;
    public static SBReference frameSymbolCloseDisabledColor;
    public static SBReference frameSymbolCloseDarkColor;
    public static SBReference frameSymbolCloseDarkDisabledColor;
    public static IntReference frameSpreadDark;
    public static IntReference frameSpreadLight;
    public static IntReference frameSpreadDarkDisabled;
    public static IntReference frameSpreadLightDisabled;
    public static SBReference tableBackColor;
    public static SBReference tableHeaderBackColor;
    public static SBReference tableHeaderRolloverBackColor;
    public static SBReference tableHeaderRolloverColor;
    public static SBReference tableHeaderArrowColor;
    public static SBReference tableGridColor;
    public static SBReference tableSelectedBackColor;
    public static SBReference tableSelectedForeColor;
    public static SBReference tableBorderDarkColor;
    public static SBReference tableBorderLightColor;
    public static SBReference tableHeaderDarkColor;
    public static SBReference tableHeaderLightColor;
    public static SBReference tableFocusBorderColor;
    public static SBReference tableAlternateRowColor;
    private static final int hue = 51;
    public static HSBReference[] colorizer;
    public static BooleanReference[] colorize;
    public static SBReference separatorColor;
    public static SBReference tipBorderColor;
    public static SBReference tipBorderDis;
    public static SBReference tipBgColor;
    public static SBReference tipBgDis;
    public static SBReference tipTextColor;
    public static SBReference tipTextDis;
    public static SBReference titledBorderColor;
    public static SBReference splitPaneButtonColor;
    public static SBReference splitPaneHightlight;
    public static SBReference splitPaneDarkShadow;

    private Theme() {
    }

    private static URI getYQ_URI() {
        try {
            return new URI("file:/YQ%20Theme");
        }
        catch (URISyntaxException ex) {
            System.err.println("Exception creating YQ URI:\n" + ex);
            return null;
        }
    }

    private static URL getYQ_URL() {
        try {
            return new URL("file:/YQ%20Theme");
        }
        catch (MalformedURLException ex) {
            System.err.println("Exception creating YQ URL:\n" + ex);
            return null;
        }
    }

    public static ThemeDescription[] getAvailableThemes() {
        ThemeDescription td;
        int i;
        File dir;
        File[] files;
        Vector<ThemeDescription> themes = new Vector<ThemeDescription>();
        if (YQ_URI != null) {
            themes.add(new ThemeDescription(YQ_URI));
        }
        try {
            String userDir = TinyUtils.getSystemProperty("user.home");
            if (userDir != null && (files = (dir = new File(userDir)).listFiles(THEMES_FILTER)) != null && files.length > 0) {
                for (i = 0; i < files.length; ++i) {
                    td = new ThemeDescription(files[i].toURI());
                    if (!td.isValid()) continue;
                    themes.add(td);
                }
            }
        }
        catch (SecurityException userDir) {
            // empty catch block
        }
        try {
            String workDir = TinyUtils.getSystemProperty("user.dir");
            if (workDir != null && (files = (dir = new File(workDir)).listFiles(THEMES_FILTER)) != null && files.length > 0) {
                for (i = 0; i < files.length; ++i) {
                    td = new ThemeDescription(files[i].toURI());
                    if (!td.isValid()) continue;
                    themes.add(td);
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        Theme.addResourceTheme("/themes/Forest.theme", themes);
        Theme.addResourceTheme("/themes/Golden.theme", themes);
        Theme.addResourceTheme("/themes/Nightly.theme", themes);
        Theme.addResourceTheme("/themes/Plastic.theme", themes);
        Theme.addResourceTheme("/themes/Silver.theme", themes);
        Theme.addResourceTheme("/themes/Unicode.theme", themes);
        if (themes.isEmpty()) {
            return new ThemeDescription[0];
        }
        return themes.toArray(new ThemeDescription[themes.size()]);
    }

    private static void addResourceTheme(String path, Vector themes) {
        ThemeDescription td;
        URL url = TinyLookAndFeel.class.getResource(path);
        if (url != null && (td = new ThemeDescription(url)).isValid() && !themes.contains(td)) {
            themes.add(td);
        }
    }

    private static void printThemes(Vector themes) {
        System.out.println(themes.size() + " themes:");
        for (ThemeDescription td : themes) {
            System.out.println("  " + td.getURL().toExternalForm());
            System.out.println("  '" + td.getName() + "' valid: " + td.isValid());
        }
    }

    public static String getPlatformFont(String fontFamily) {
        if (TinyUtils.isOSMac()) {
            String replacement = MAC_FONT_MAPPINGS.getProperty(fontFamily);
            return replacement != null ? replacement : fontFamily;
        }
        if (TinyUtils.isOSLinux()) {
            String replacement = LINUX_FONT_MAPPINGS.getProperty(fontFamily);
            return replacement != null ? replacement : fontFamily;
        }
        return fontFamily;
    }

    private static void loadFontMappings() {
        URL url = Theme.class.getResource("/de/muntjak/tinylookandfeel/MacFontMappings.properties");
        if (url != null) {
            try {
                MAC_FONT_MAPPINGS.load(url.openStream());
            }
            catch (IOException ex) {
                System.err.println(Theme.class.getName() + ": Unable to locate MacFontMappings.properties.");
            }
        } else {
            System.err.println(Theme.class.getName() + ": Unable to locate MacFontMappings.properties.");
        }
        url = Theme.class.getResource("/de/muntjak/tinylookandfeel/LinuxFontMappings.properties");
        if (url != null) {
            try {
                LINUX_FONT_MAPPINGS.load(url.openStream());
            }
            catch (IOException ex) {
                System.err.println(Theme.class.getName() + ": Unable to locate LinuxFontMappings.properties.");
            }
        } else {
            System.err.println(Theme.class.getName() + ": Unable to locate LinuxFontMappings.properties.");
        }
    }

    private static void initData() {
        Theme.loadFontMappings();
        mainColor = new SBReference(new Color(0, 106, 255), 0, 0, 1, true);
        disColor = new SBReference(new Color(143, 142, 139), 0, 0, 1, true);
        backColor = new SBReference(new Color(236, 233, 216), 0, 0, 1, true);
        frameColor = new SBReference(new Color(0, 85, 255), 0, 0, 1, true);
        sub1Color = new SBReference(new Color(197, 213, 252), 0, 0, 1);
        sub2Color = new SBReference(new Color(34, 161, 34), 0, 0, 1);
        sub3Color = new SBReference(new Color(231, 232, 245), 0, 0, 1);
        sub4Color = new SBReference(new Color(227, 92, 60), 0, 0, 1);
        sub5Color = new SBReference(new Color(120, 123, 189), 0, 0, 1);
        sub6Color = new SBReference(new Color(248, 179, 48), 0, 0, 1);
        sub7Color = new SBReference(new Color(175, 105, 125), 0, 0, 1);
        sub8Color = new SBReference(new Color(255, 255, 255), 0, 0, 1);
        buttonFontColor = new SBReference();
        labelFontColor = new SBReference();
        menuFontColor = new SBReference();
        menuItemFontColor = new SBReference();
        radioFontColor = new SBReference();
        checkFontColor = new SBReference();
        tableFontColor = new SBReference();
        tableHeaderFontColor = new SBReference();
        titledBorderFontColor = new SBReference();
        tabFontColor = new SBReference();
        plainFont = new ColoredFont("Tahoma", 0, 11);
        boldFont = new ColoredFont("Tahoma", 1, 11);
        buttonFont = new ColoredFont(buttonFontColor);
        labelFont = new ColoredFont(labelFontColor);
        passwordFont = new ColoredFont();
        comboFont = new ColoredFont();
        listFont = new ColoredFont();
        menuFont = new ColoredFont(menuFontColor);
        menuItemFont = new ColoredFont(menuItemFontColor);
        radioFont = new ColoredFont(radioFontColor);
        checkFont = new ColoredFont(checkFontColor);
        tableFont = new ColoredFont(tableFontColor);
        tableHeaderFont = new ColoredFont(tableHeaderFontColor);
        textAreaFont = new ColoredFont();
        textFieldFont = new ColoredFont();
        textPaneFont = new ColoredFont();
        titledBorderFont = new ColoredFont(titledBorderFontColor);
        toolTipFont = new ColoredFont();
        treeFont = new ColoredFont();
        tabFontColor = new SBReference();
        tabFont = new ColoredFont(tabFontColor);
        tabFont.setBoldFont(false);
        editorFont = new ColoredFont();
        frameTitleFont = new ColoredFont("Trebuchet MS", 1, 13);
        internalFrameTitleFont = new ColoredFont("Trebuchet MS", 1, 13);
        internalPaletteTitleFont = new ColoredFont("Trebuchet MS", 1, 12);
        progressBarFont = new ColoredFont();
        progressColor = new SBReference(new Color(44, 212, 43), 43, 19, 7);
        progressTrackColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        progressBorderColor = new SBReference(new Color(104, 104, 104), -100, -54, 3);
        progressDarkColor = new SBReference(new Color(190, 190, 190), -100, -16, 3);
        progressLightColor = new SBReference(new Color(238, 238, 238), -100, 40, 3);
        progressSelectForeColor = new SBReference(new Color(0, 0, 0), 0, -100, 3);
        progressSelectBackColor = new SBReference(new Color(0, 0, 0), 0, -100, 3);
        textBgColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        textPaneBgColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        editorPaneBgColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        desktopPaneBgColor = new SBReference(new Color(212, 210, 194), 0, -10, 3);
        textTextColor = new SBReference(new Color(0, 0, 0), 0, -100, 3);
        textCaretColor = new SBReference(new Color(0, 0, 0), 0, -100, 3);
        textSelectedBgColor = new SBReference(new Color(43, 107, 197), -36, -6, 2);
        textSelectedTextColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        textDisabledBgColor = new SBReference(new Color(240, 237, 224), 0, 20, 3);
        textNonEditableBgColor = new SBReference(new Color(240, 237, 224), 0, 20, 3);
        textBorderColor = new SBReference(new Color(128, 152, 186), -70, 23, 2);
        textBorderDisabledColor = new SBReference(new Color(201, 198, 184), 0, -15, 3);
        textInsets = new InsetsUIResource(2, 3, 2, 3);
        buttonRolloverBorder = new BooleanReference(true);
        buttonFocus = new BooleanReference(false);
        buttonFocusBorder = new BooleanReference(true);
        buttonEnter = new BooleanReference(true);
        shiftButtonText = new BooleanReference(true);
        buttonNormalColor = new SBReference(new Color(231, 232, 245), 0, 0, 8);
        buttonRolloverBgColor = new SBReference(new Color(239, 240, 248), 0, 33, 8);
        buttonPressedColor = new SBReference(new Color(217, 218, 230), 0, -6, 8);
        buttonDisabledColor = new SBReference(new Color(245, 244, 235), 0, 48, 3);
        buttonBorderColor = new SBReference(new Color(21, 61, 117), -30, -46, 2);
        buttonBorderDisabledColor = new SBReference(new Color(201, 198, 184), 0, -15, 3);
        buttonDisabledFgColor = new SBReference(new Color(143, 142, 139), 0, 0, 4);
        checkDisabledFgColor = new SBReference(new Color(143, 142, 139), 0, 0, 4);
        radioDisabledFgColor = new SBReference(new Color(143, 142, 139), 0, 0, 4);
        toggleSelectedBg = new SBReference(new Color(160, 182, 235), 38, -12, 6);
        buttonMargin = new InsetsUIResource(2, 12, 2, 12);
        buttonRolloverColor = new SBReference(new Color(248, 179, 48), 0, 0, 11);
        buttonDefaultColor = new SBReference(new Color(160, 182, 235), 38, -12, 6);
        buttonCheckColor = new SBReference(new Color(34, 161, 34), 0, 0, 7);
        buttonCheckDisabledColor = new SBReference(new Color(208, 205, 190), 0, -12, 3);
        checkMargin = new InsetsUIResource(2, 2, 2, 2);
        buttonSpreadLight = new IntReference(20);
        buttonSpreadDark = new IntReference(3);
        buttonSpreadLightDisabled = new IntReference(20);
        buttonSpreadDarkDisabled = new IntReference(1);
        scrollRollover = new BooleanReference(true);
        scrollSize = new IntReference(17);
        scrollTrackColor = new SBReference(new Color(249, 249, 247), -50, 76, 3);
        scrollTrackDisabledColor = new SBReference(new Color(249, 249, 247), -50, 76, 3);
        scrollTrackBorderColor = new SBReference(new Color(234, 231, 218), -23, 0, 3);
        scrollTrackBorderDisabledColor = new SBReference(new Color(234, 231, 218), -23, 0, 3);
        scrollThumbColor = new SBReference(new Color(197, 213, 252), 0, 0, 6);
        scrollThumbRolloverColor = new SBReference(new Color(226, 234, 254), 0, 50, 6);
        scrollThumbPressedColor = new SBReference(new Color(187, 202, 239), 0, -5, 6);
        scrollThumbDisabledColor = new SBReference(new Color(238, 238, 231), 0, -3, 6);
        scrollGripLightColor = new SBReference(new Color(238, 243, 254), 0, 71, 6);
        scrollGripDarkColor = new SBReference(new Color(171, 185, 219), 0, -13, 6);
        scrollButtColor = new SBReference(new Color(197, 213, 252), 0, 0, 6);
        scrollButtRolloverColor = new SBReference(new Color(226, 234, 254), 0, 50, 6);
        scrollButtPressedColor = new SBReference(new Color(187, 202, 239), 0, -5, 6);
        scrollButtDisabledColor = new SBReference(new Color(238, 237, 231), -48, 29, 3);
        scrollSpreadLight = new IntReference(20);
        scrollSpreadDark = new IntReference(2);
        scrollSpreadLightDisabled = new IntReference(20);
        scrollSpreadDarkDisabled = new IntReference(1);
        scrollArrowColor = new SBReference(new Color(77, 100, 132), -74, -18, 2);
        scrollArrowDisabledColor = new SBReference(new Color(193, 193, 193), -100, -15, 3);
        scrollBorderColor = new SBReference(new Color(212, 210, 194), 0, -10, 6);
        scrollBorderLightColor = new SBReference(new Color(255, 255, 255), 0, 100, 6);
        scrollBorderDisabledColor = new SBReference(new Color(232, 230, 220), -41, 0, 3);
        scrollLightDisabledColor = new SBReference(new Color(232, 230, 220), -41, 0, 3);
        scrollPaneBorderColor = new SBReference(new Color(201, 198, 184), 0, -15, 3);
        tabPaneBorderColor = new SBReference(new Color(143, 160, 183), -78, 28, 2);
        tabNormalColor = new SBReference(new Color(242, 240, 238), 0, 69, 3);
        tabSelectedColor = new SBReference(new Color(251, 251, 250), 0, 91, 3);
        tabDisabledColor = new SBReference(new Color(244, 242, 232), 0, 40, 3);
        tabDisabledSelectedColor = new SBReference(new Color(251, 251, 247), 0, 80, 3);
        tabDisabledTextColor = new SBReference(new Color(188, 187, 185), 0, 40, 4);
        tabBorderColor = new SBReference(new Color(143, 160, 183), -78, 28, 2);
        tabRolloverColor = new SBReference(new Color(255, 199, 59), 0, 0, 11);
        tabPaneDisabledBorderColor = new SBReference(new Color(208, 205, 190), 0, -12, 3);
        tabDisabledBorderColor = new SBReference(new Color(208, 205, 190), 0, -12, 3);
        tabRollover = new BooleanReference(true);
        tabFocus = new BooleanReference(true);
        ignoreSelectedBg = new BooleanReference(false);
        fixedTabs = new BooleanReference(true);
        tabInsets = new InsetsUIResource(1, 6, 4, 6);
        tabAreaInsets = new InsetsUIResource(4, 2, 0, 0);
        sliderRolloverEnabled = new BooleanReference(true);
        sliderFocusEnabled = new BooleanReference(true);
        sliderThumbColor = new SBReference(new Color(245, 244, 235), 0, 49, 3);
        sliderThumbRolloverColor = new SBReference(new Color(233, 166, 0), 100, -26, 11);
        sliderThumbPressedColor = new SBReference(new Color(244, 243, 239), -50, 50, 3);
        sliderThumbDisabledColor = new SBReference(new Color(245, 243, 234), 0, 45, 3);
        sliderBorderColor = new SBReference(new Color(176, 189, 207), -76, 50, 2);
        sliderDarkColor = new SBReference(new Color(119, 130, 146), -89, 4, 2);
        sliderLightColor = new SBReference(new Color(27, 155, 27), 16, -7, 7);
        sliderBorderDisabledColor = new SBReference(new Color(214, 212, 198), -6, -9, 3);
        sliderTrackColor = new SBReference(new Color(240, 237, 224), 0, 20, 3);
        sliderTrackBorderColor = new SBReference(new Color(157, 156, 150), -53, -32, 3);
        sliderTrackDarkColor = new SBReference(new Color(242, 241, 232), -22, 39, 3);
        sliderTrackLightColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        sliderTickColor = new SBReference(new Color(118, 117, 108), 0, -50, 3);
        sliderTickDisabledColor = new SBReference(new Color(174, 174, 171), 0, 28, 4);
        sliderFocusColor = new SBReference(new Color(113, 112, 104), 0, -52, 3);
        spinnerRollover = new BooleanReference(false);
        spinnerButtColor = new SBReference(new Color(198, 213, 250), 0, 0, 6);
        spinnerButtRolloverColor = new SBReference(new Color(232, 238, 254), 0, 60, 6);
        spinnerButtPressedColor = new SBReference(new Color(175, 190, 224), 0, -11, 6);
        spinnerButtDisabledColor = new SBReference(new Color(242, 240, 228), 0, 30, 3);
        spinnerSpreadLight = new IntReference(20);
        spinnerSpreadDark = new IntReference(3);
        spinnerSpreadLightDisabled = new IntReference(20);
        spinnerSpreadDarkDisabled = new IntReference(1);
        spinnerBorderColor = new SBReference(new Color(128, 152, 186), -70, 23, 2);
        spinnerBorderDisabledColor = new SBReference(new Color(215, 212, 197), 0, -9, 3);
        spinnerArrowColor = new SBReference(new Color(77, 100, 132), -74, -18, 2);
        spinnerArrowDisabledColor = new SBReference(new Color(212, 210, 194), 0, -10, 3);
        comboBorderColor = new SBReference(new Color(128, 152, 186), -70, 23, 2);
        comboBorderDisabledColor = new SBReference(new Color(201, 198, 184), 0, -15, 3);
        comboSelectedBgColor = new SBReference(new Color(43, 107, 197), -36, -6, 2);
        comboSelectedTextColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        comboFocusBgColor = new SBReference(new Color(43, 107, 197), 0, 0, 1);
        comboBgColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        comboTextColor = new SBReference(new Color(0, 0, 0), 0, -100, 3);
        comboButtColor = new SBReference(new Color(197, 213, 252), 0, 0, 6);
        comboButtRolloverColor = new SBReference(new Color(226, 234, 254), 0, 50, 6);
        comboButtPressedColor = new SBReference(new Color(175, 190, 224), 0, -11, 6);
        comboButtDisabledColor = new SBReference(new Color(238, 237, 231), -48, 29, 3);
        comboSpreadLight = new IntReference(20);
        comboSpreadDark = new IntReference(3);
        comboSpreadLightDisabled = new IntReference(20);
        comboSpreadDarkDisabled = new IntReference(1);
        comboButtBorderColor = new SBReference(new Color(212, 210, 194), 0, -10, 6);
        comboButtBorderDisabledColor = new SBReference(new Color(232, 230, 220), -41, 0, 3);
        comboArrowColor = new SBReference(new Color(77, 100, 132), -74, -18, 2);
        comboArrowDisabledColor = new SBReference(new Color(203, 200, 186), 0, -14, 3);
        comboInsets = new InsetsUIResource(2, 2, 2, 2);
        comboRollover = new BooleanReference(false);
        comboFocus = new BooleanReference(false);
        menuBarColor = new SBReference(new Color(238, 237, 230), -43, 28, 3);
        menuItemSelectedTextColor = new SBReference(new Color(0, 0, 0), 0, -100, 3);
        menuPopupColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        menuRolloverBgColor = new SBReference(new Color(189, 208, 234), -50, 66, 2);
        menuRolloverFgColor = new SBReference(new Color(0, 0, 0), 0, -100, 3);
        menuDisabledFgColor = new SBReference(new Color(143, 142, 139), 0, 0, 4);
        menuItemDisabledFgColor = new SBReference(new Color(143, 142, 139), 0, 0, 4);
        menuItemRolloverColor = new SBReference(new Color(189, 208, 234), -50, 66, 2);
        menuBorderColor = new SBReference(new Color(173, 170, 153), 4, -28, 3);
        menuInnerHilightColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        menuInnerShadowColor = new SBReference(new Color(213, 212, 207), -70, -7, 3);
        menuOuterHilightColor = new SBReference(new Color(173, 170, 153), 4, -28, 3);
        menuOuterShadowColor = new SBReference(new Color(173, 170, 153), 4, -28, 3);
        menuIconColor = new SBReference(new Color(0, 0, 0), 0, -100, 3);
        menuIconRolloverColor = new SBReference(new Color(0, 0, 0), 0, -100, 3);
        menuIconDisabledColor = new SBReference(new Color(165, 163, 151), 0, -30, 3);
        menuSeparatorColor = new SBReference(new Color(173, 170, 153), 4, -28, 3);
        menuRollover = new BooleanReference(true);
        menuPopupShadow = new BooleanReference(false);
        menuAllowTwoIcons = new BooleanReference(false);
        toolBarColor = new SBReference(new Color(239, 237, 229), -35, 28, 3);
        toolBarLightColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        toolBarDarkColor = new SBReference(new Color(214, 210, 187), 10, -11, 3);
        toolButtColor = new SBReference(new Color(239, 237, 229), -35, 28, 3);
        toolButtSelectedColor = new SBReference(new Color(243, 242, 239), -51, 52, 3);
        toolButtRolloverColor = new SBReference(new Color(251, 251, 248), -30, 81, 3);
        toolButtPressedColor = new SBReference(new Color(225, 224, 218), -58, -2, 3);
        toolGripDarkColor = new SBReference(new Color(167, 167, 163), -70, -27, 3);
        toolGripLightColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        toolSeparatorColor = new SBReference(new Color(167, 167, 163), -70, -27, 3);
        toolBorderColor = new SBReference(new Color(239, 237, 229), -35, 28, 3);
        toolBorderPressedColor = new SBReference(new Color(122, 144, 174), -76, 16, 2);
        toolBorderRolloverColor = new SBReference(new Color(122, 144, 174), -76, 16, 2);
        toolBorderSelectedColor = new SBReference(new Color(122, 144, 174), -76, 16, 2);
        toolMargin = new InsetsUIResource(5, 5, 5, 5);
        toolFocus = new BooleanReference(false);
        toolRollover = new BooleanReference(true);
        listBgColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        listTextColor = new SBReference(new Color(0, 0, 0), 0, -100, 3);
        listSelectedBgColor = new SBReference(new Color(43, 107, 197), -36, -6, 2);
        listSelectedTextColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        listFocusBorderColor = new SBReference(new Color(179, 211, 255), 100, 70, 2);
        treeBgColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        treeTextColor = new SBReference(new Color(0, 0, 0), 0, -100, 3);
        treeTextBgColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        treeSelectedTextColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        treeSelectedBgColor = new SBReference(new Color(43, 107, 197), -36, -6, 2);
        treeLineColor = new SBReference(new Color(208, 205, 190), 0, -12, 3);
        frameCaptionColor = new SBReference(new Color(13, 94, 255), 0, 5, 5);
        frameCaptionDisabledColor = new SBReference(new Color(122, 159, 223), -25, 41, 5);
        frameBorderColor = new SBReference(new Color(0, 60, 161), 0, -30, 5);
        frameLightColor = new SBReference(new Color(0, 68, 184), 0, -20, 5);
        frameBorderDisabledColor = new SBReference(new Color(74, 125, 212), -25, 20, 5);
        frameLightDisabledColor = new SBReference(new Color(99, 144, 233), -25, 30, 5);
        frameTitleColor = new SBReference(new Color(255, 255, 255), 0, 100, 5);
        frameTitleShadowColor = new SBReference(new Color(0, 43, 128), 0, -50, 5);
        frameTitleDisabledColor = new SBReference(new Color(216, 226, 248), -29, 82, 5);
        frameButtColor = new SBReference(new Color(13, 94, 255), 0, 5, 5);
        frameButtRolloverColor = new SBReference(new Color(51, 119, 255), 0, 20, 5);
        frameButtPressedColor = new SBReference(new Color(0, 68, 204), 0, -20, 5);
        frameButtDisabledColor = new SBReference(new Color(63, 120, 233), -21, 16, 5);
        frameButtSpreadLight = new IntReference(8);
        frameButtSpreadDark = new IntReference(2);
        frameButtSpreadLightDisabled = new IntReference(5);
        frameButtSpreadDarkDisabled = new IntReference(2);
        frameButtCloseColor = new SBReference(new Color(227, 92, 60), 0, 0, 9);
        frameButtCloseRolloverColor = new SBReference(new Color(233, 125, 99), 0, 20, 9);
        frameButtClosePressedColor = new SBReference(new Color(193, 78, 51), 0, -15, 9);
        frameButtCloseDisabledColor = new SBReference(new Color(175, 105, 125), 0, 0, 12);
        frameButtCloseSpreadLight = new IntReference(8);
        frameButtCloseSpreadDark = new IntReference(2);
        frameButtCloseSpreadLightDisabled = new IntReference(5);
        frameButtCloseSpreadDarkDisabled = new IntReference(2);
        frameButtBorderColor = new SBReference(new Color(255, 255, 255), 0, 100, 5);
        frameButtBorderDisabledColor = new SBReference(new Color(190, 206, 238), -42, 68, 5);
        frameSymbolColor = new SBReference(new Color(255, 255, 255), 0, 100, 5);
        frameSymbolPressedColor = new SBReference(new Color(255, 255, 255), 0, 100, 5);
        frameSymbolDisabledColor = new SBReference(new Color(255, 255, 255), 0, 100, 5);
        frameSymbolDarkColor = new SBReference(new Color(255, 255, 255), 0, 100, 5);
        frameSymbolLightColor = new SBReference(new Color(13, 94, 255), 0, 5, 5);
        frameSymbolDarkDisabledColor = new SBReference(new Color(255, 255, 255), 0, 100, 5);
        frameSymbolLightDisabledColor = new SBReference(new Color(63, 120, 233), -21, 16, 5);
        frameButtCloseBorderColor = new SBReference(new Color(255, 255, 255), 0, 100, 5);
        frameButtCloseDarkColor = new SBReference(new Color(174, 51, 20), 50, -32, 9);
        frameButtCloseLightColor = new SBReference(new Color(226, 88, 55), 11, -2, 9);
        frameButtCloseBorderDisabledColor = new SBReference(new Color(190, 206, 238), -42, 68, 5);
        frameSymbolCloseColor = new SBReference(new Color(255, 255, 255), 0, 100, 5);
        frameSymbolClosePressedColor = new SBReference(new Color(231, 180, 168), -24, 50, 9);
        frameSymbolCloseDisabledColor = new SBReference(new Color(255, 255, 255), 0, 100, 5);
        frameSymbolCloseDarkColor = new SBReference(new Color(227, 92, 60), 0, 0, 9);
        frameSymbolCloseDarkDisabledColor = new SBReference(new Color(175, 105, 125), 0, 0, 12);
        frameSpreadDark = new IntReference(3);
        frameSpreadLight = new IntReference(2);
        frameSpreadDarkDisabled = new IntReference(2);
        frameSpreadLightDisabled = new IntReference(2);
        tableBackColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        tableHeaderBackColor = new SBReference(new Color(236, 233, 216), 0, 0, 3);
        tableHeaderRolloverBackColor = new SBReference(new Color(249, 248, 243), 0, 70, 3);
        tableHeaderRolloverColor = new SBReference(new Color(248, 179, 48), 0, 0, 11);
        tableGridColor = new SBReference(new Color(167, 166, 160), -50, -28, 3);
        tableHeaderArrowColor = new SBReference(new Color(167, 166, 160), -50, -28, 3);
        tableSelectedBackColor = new SBReference(new Color(213, 211, 204), -50, -8, 3);
        tableSelectedForeColor = new SBReference(new Color(0, 0, 0), 0, -100, 3);
        tableBorderDarkColor = new SBReference(new Color(167, 166, 160), -50, -28, 3);
        tableBorderLightColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        tableHeaderDarkColor = new SBReference(new Color(189, 186, 173), 0, -20, 3);
        tableHeaderLightColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        tableFocusBorderColor = new SBReference(new Color(185, 184, 177), -50, -20, 3);
        tableAlternateRowColor = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        for (int i = 0; i < 20; ++i) {
            Theme.colorizer[i] = new HSBReference(51, 25, 0, 3);
            Theme.colorize[i] = new BooleanReference(false);
        }
        separatorColor = new SBReference(new Color(167, 167, 163), -70, -27, 3);
        tipBorderColor = new SBReference(new Color(0, 0, 0), 0, -100, 3);
        tipBorderDis = new SBReference(new Color(143, 141, 139), 0, 0, 4);
        tipBgColor = new SBReference(new Color(255, 255, 225), 0, 0, 1);
        tipBgDis = new SBReference(new Color(236, 233, 216), 0, 0, 3);
        tipTextColor = new SBReference(new Color(0, 0, 0), 0, -100, 3);
        tipTextDis = new SBReference(new Color(143, 141, 139), 0, 0, 4);
        titledBorderColor = new SBReference(new Color(165, 163, 151), 0, -30, 3);
        splitPaneButtonColor = new SBReference(new Color(170, 168, 156), 0, -28, 3);
        splitPaneHightlight = new SBReference(new Color(255, 255, 255), 0, 100, 3);
        splitPaneDarkShadow = new SBReference(new Color(213, 212, 207), -70, -7, 3);
    }

    public static void loadYQTheme() {
        mainColor.update(new Color(0, 106, 255), 0, 0, 1);
        disColor.update(new Color(143, 142, 139), 0, 0, 1);
        backColor.update(new Color(236, 233, 216), 0, 0, 1);
        frameColor.update(new Color(0, 85, 255), 0, 0, 1);
        sub1Color.update(new Color(197, 213, 252), 0, 0, 1);
        sub2Color.update(new Color(34, 161, 34), 0, 0, 1);
        sub3Color.update(new Color(231, 232, 245), 0, 0, 1);
        sub4Color.update(new Color(227, 92, 60), 0, 0, 1);
        sub5Color.update(new Color(120, 123, 189), 0, 0, 1);
        sub6Color.update(new Color(248, 179, 48), 0, 0, 1);
        sub7Color.update(new Color(175, 105, 125), 0, 0, 1);
        sub8Color.update(new Color(255, 255, 255), 0, 0, 1);
        buttonFontColor.update(Color.BLACK);
        labelFontColor.update(Color.BLACK);
        menuFontColor.update(Color.BLACK);
        menuItemFontColor.update(Color.BLACK);
        radioFontColor.update(Color.BLACK);
        checkFontColor.update(Color.BLACK);
        tableFontColor.update(Color.BLACK);
        tableHeaderFontColor.update(Color.BLACK);
        titledBorderFontColor.update(Color.BLACK);
        tabFontColor.update(Color.BLACK);
        plainFont.update("Tahoma", 0, 11);
        boldFont.update("Tahoma", 1, 11);
        buttonFont.update(buttonFontColor);
        labelFont.update(labelFontColor);
        passwordFont.update((SBReference)null);
        comboFont.update((SBReference)null);
        listFont.update((SBReference)null);
        menuFont.update(menuFontColor);
        menuItemFont.update(menuItemFontColor);
        radioFont.update(radioFontColor);
        checkFont.update(checkFontColor);
        tableFont.update(tableFontColor);
        tableHeaderFont.update(tableHeaderFontColor);
        textAreaFont.update((SBReference)null);
        textFieldFont.update((SBReference)null);
        textPaneFont.update((SBReference)null);
        titledBorderFont.update(titledBorderFontColor);
        toolTipFont.update((SBReference)null);
        treeFont.update((SBReference)null);
        tabFontColor.update(Color.BLACK);
        tabFont.update(tabFontColor);
        tabFont.setBoldFont(false);
        editorFont.update((SBReference)null);
        frameTitleFont.update("Trebuchet MS", 1, 13);
        internalFrameTitleFont.update("Trebuchet MS", 1, 13);
        internalPaletteTitleFont.update("Trebuchet MS", 1, 12);
        progressBarFont.update((SBReference)null);
        progressColor.update(new Color(44, 212, 43), 43, 19, 7);
        progressTrackColor.update(new Color(255, 255, 255), 0, 100, 3);
        progressBorderColor.update(new Color(104, 104, 104), -100, -54, 3);
        progressDarkColor.update(new Color(190, 190, 190), -100, -16, 3);
        progressLightColor.update(new Color(238, 238, 238), -100, 40, 3);
        progressSelectForeColor.update(new Color(0, 0, 0), 0, -100, 3);
        progressSelectBackColor.update(new Color(0, 0, 0), 0, -100, 3);
        textBgColor.update(new Color(255, 255, 255), 0, 100, 3);
        textPaneBgColor.update(new Color(255, 255, 255), 0, 100, 3);
        editorPaneBgColor.update(new Color(255, 255, 255), 0, 100, 3);
        desktopPaneBgColor.update(new Color(212, 210, 194), 0, -10, 3);
        textTextColor.update(new Color(0, 0, 0), 0, -100, 3);
        textCaretColor.update(new Color(0, 0, 0), 0, -100, 3);
        textSelectedBgColor.update(new Color(43, 107, 197), -36, -6, 2);
        textSelectedTextColor.update(new Color(255, 255, 255), 0, 100, 3);
        textDisabledBgColor.update(new Color(240, 237, 224), 0, 20, 3);
        textNonEditableBgColor.update(new Color(240, 237, 224), 0, 20, 3);
        textBorderColor.update(new Color(128, 152, 186), -70, 23, 2);
        textBorderDisabledColor.update(new Color(201, 198, 184), 0, -15, 3);
        Theme.textInsets.top = 2;
        Theme.textInsets.left = 3;
        Theme.textInsets.bottom = 2;
        Theme.textInsets.right = 3;
        buttonRolloverBorder.setValue(true);
        buttonFocus.setValue(false);
        buttonFocusBorder.setValue(true);
        buttonEnter.setValue(true);
        shiftButtonText.setValue(true);
        buttonNormalColor.update(new Color(231, 232, 245), 0, 0, 8);
        buttonRolloverBgColor.update(new Color(239, 240, 248), 0, 33, 8);
        buttonPressedColor.update(new Color(217, 218, 230), 0, -6, 8);
        buttonDisabledColor.update(new Color(245, 244, 235), 0, 48, 3);
        buttonBorderColor.update(new Color(21, 61, 117), -30, -46, 2);
        buttonBorderDisabledColor.update(new Color(201, 198, 184), 0, -15, 3);
        buttonDisabledFgColor.update(new Color(143, 142, 139), 0, 0, 4);
        checkDisabledFgColor.update(new Color(143, 142, 139), 0, 0, 4);
        radioDisabledFgColor.update(new Color(143, 142, 139), 0, 0, 4);
        toggleSelectedBg.update(new Color(160, 182, 235), 38, -12, 6);
        Theme.buttonMargin.top = 2;
        Theme.buttonMargin.left = 12;
        Theme.buttonMargin.bottom = 2;
        Theme.buttonMargin.right = 12;
        buttonRolloverColor.update(new Color(248, 179, 48), 0, 0, 11);
        buttonDefaultColor.update(new Color(160, 182, 235), 38, -12, 6);
        buttonCheckColor.update(new Color(34, 161, 34), 0, 0, 7);
        buttonCheckDisabledColor.update(new Color(208, 205, 190), 0, -12, 3);
        Theme.checkMargin.top = 2;
        Theme.checkMargin.left = 2;
        Theme.checkMargin.bottom = 2;
        Theme.checkMargin.right = 2;
        buttonSpreadLight.setValue(20);
        buttonSpreadDark.setValue(3);
        buttonSpreadLightDisabled.setValue(20);
        buttonSpreadDarkDisabled.setValue(1);
        scrollRollover.setValue(true);
        scrollSize.setValue(17);
        scrollTrackColor.update(new Color(249, 249, 247), -50, 76, 3);
        scrollTrackDisabledColor.update(new Color(249, 249, 247), -50, 76, 3);
        scrollTrackBorderColor.update(new Color(234, 231, 218), -23, 0, 3);
        scrollTrackBorderDisabledColor.update(new Color(234, 231, 218), -23, 0, 3);
        scrollThumbColor.update(new Color(197, 213, 252), 0, 0, 6);
        scrollThumbRolloverColor.update(new Color(226, 234, 254), 0, 50, 6);
        scrollThumbPressedColor.update(new Color(187, 202, 239), 0, -5, 6);
        scrollThumbDisabledColor.update(new Color(238, 238, 231), 0, -3, 6);
        scrollGripLightColor.update(new Color(238, 243, 254), 0, 71, 6);
        scrollGripDarkColor.update(new Color(171, 185, 219), 0, -13, 6);
        scrollButtColor.update(new Color(197, 213, 252), 0, 0, 6);
        scrollButtRolloverColor.update(new Color(226, 234, 254), 0, 50, 6);
        scrollButtPressedColor.update(new Color(187, 202, 239), 0, -5, 6);
        scrollButtDisabledColor.update(new Color(238, 237, 231), -48, 29, 3);
        scrollSpreadLight.setValue(20);
        scrollSpreadDark.setValue(2);
        scrollSpreadLightDisabled.setValue(20);
        scrollSpreadDarkDisabled.setValue(1);
        scrollArrowColor.update(new Color(77, 100, 132), -74, -18, 2);
        scrollArrowDisabledColor.update(new Color(193, 193, 193), -100, -15, 3);
        scrollBorderColor.update(new Color(212, 210, 194), 0, -10, 6);
        scrollBorderLightColor.update(new Color(255, 255, 255), 0, 100, 6);
        scrollBorderDisabledColor.update(new Color(232, 230, 220), -41, 0, 3);
        scrollLightDisabledColor.update(new Color(232, 230, 220), -41, 0, 3);
        scrollPaneBorderColor.update(new Color(201, 198, 184), 0, -15, 3);
        tabPaneBorderColor.update(new Color(143, 160, 183), -78, 28, 2);
        tabNormalColor.update(new Color(242, 240, 238), 0, 69, 3);
        tabSelectedColor.update(new Color(251, 251, 250), 0, 91, 3);
        tabDisabledColor.update(new Color(244, 242, 232), 0, 40, 3);
        tabDisabledSelectedColor.update(new Color(251, 251, 247), 0, 80, 3);
        tabDisabledTextColor.update(new Color(188, 187, 185), 0, 40, 4);
        tabBorderColor.update(new Color(143, 160, 183), -78, 28, 2);
        tabRolloverColor.update(new Color(255, 199, 59), 0, 0, 11);
        tabRollover.setValue(true);
        tabFocus.setValue(true);
        ignoreSelectedBg.setValue(false);
        fixedTabs.setValue(true);
        Theme.tabInsets.top = 1;
        Theme.tabInsets.left = 6;
        Theme.tabInsets.bottom = 4;
        Theme.tabInsets.right = 6;
        Theme.tabAreaInsets.top = 4;
        Theme.tabAreaInsets.left = 2;
        Theme.tabAreaInsets.bottom = 0;
        Theme.tabAreaInsets.right = 0;
        sliderRolloverEnabled.setValue(true);
        sliderFocusEnabled.setValue(true);
        sliderThumbColor.update(new Color(245, 244, 235), 0, 49, 3);
        sliderThumbRolloverColor.update(new Color(233, 166, 0), 100, -26, 11);
        sliderThumbPressedColor.update(new Color(244, 243, 239), -50, 50, 3);
        sliderThumbDisabledColor.update(new Color(245, 243, 234), 0, 45, 3);
        sliderBorderColor.update(new Color(176, 189, 207), -76, 50, 2);
        sliderDarkColor.update(new Color(119, 130, 146), -89, 4, 2);
        sliderLightColor.update(new Color(27, 155, 27), 16, -7, 7);
        sliderBorderDisabledColor.update(new Color(214, 212, 198), -6, -9, 3);
        sliderTrackColor.update(new Color(240, 237, 224), 0, 20, 3);
        sliderTrackBorderColor.update(new Color(157, 156, 150), -53, -32, 3);
        sliderTrackDarkColor.update(new Color(242, 241, 232), -22, 39, 3);
        sliderTrackLightColor.update(new Color(255, 255, 255), 0, 100, 3);
        sliderTickColor.update(new Color(118, 117, 108), 0, -50, 3);
        sliderTickDisabledColor.update(new Color(174, 174, 171), 0, 28, 4);
        sliderFocusColor.update(new Color(113, 112, 104), 0, -52, 3);
        spinnerRollover.setValue(false);
        spinnerButtColor.update(new Color(198, 213, 250), 0, 0, 6);
        spinnerButtRolloverColor.update(new Color(232, 238, 254), 0, 60, 6);
        spinnerButtPressedColor.update(new Color(175, 190, 224), 0, -11, 6);
        spinnerButtDisabledColor.update(new Color(242, 240, 228), 0, 30, 3);
        spinnerSpreadLight.setValue(20);
        spinnerSpreadDark.setValue(3);
        spinnerSpreadLightDisabled.setValue(20);
        spinnerSpreadDarkDisabled.setValue(1);
        spinnerBorderColor.update(new Color(128, 152, 186), -70, 23, 2);
        spinnerBorderDisabledColor.update(new Color(215, 212, 197), 0, -9, 3);
        spinnerArrowColor.update(new Color(77, 100, 132), -74, -18, 2);
        spinnerArrowDisabledColor.update(new Color(212, 210, 194), 0, -10, 3);
        comboBorderColor.update(new Color(128, 152, 186), -70, 23, 2);
        comboBorderDisabledColor.update(new Color(201, 198, 184), 0, -15, 3);
        comboSelectedBgColor.update(new Color(43, 107, 197), -36, -6, 2);
        comboSelectedTextColor.update(new Color(255, 255, 255), 0, 100, 3);
        comboFocusBgColor.update(new Color(43, 107, 197), 0, 0, 1);
        comboBgColor.update(new Color(255, 255, 255), 0, 100, 3);
        comboTextColor.update(new Color(0, 0, 0), 0, -100, 3);
        comboButtColor.update(new Color(197, 213, 252), 0, 0, 6);
        comboButtRolloverColor.update(new Color(226, 234, 254), 0, 50, 6);
        comboButtPressedColor.update(new Color(175, 190, 224), 0, -11, 6);
        comboButtDisabledColor.update(new Color(238, 237, 231), -48, 29, 3);
        comboSpreadLight.setValue(20);
        comboSpreadDark.setValue(3);
        comboSpreadLightDisabled.setValue(20);
        comboSpreadDarkDisabled.setValue(1);
        comboButtBorderColor.update(new Color(212, 210, 194), 0, -10, 6);
        comboButtBorderDisabledColor.update(new Color(232, 230, 220), -41, 0, 3);
        comboArrowColor.update(new Color(77, 100, 132), -74, -18, 2);
        comboArrowDisabledColor.update(new Color(203, 200, 186), 0, -14, 3);
        Theme.comboInsets.top = 2;
        Theme.comboInsets.left = 2;
        Theme.comboInsets.bottom = 2;
        Theme.comboInsets.right = 2;
        comboRollover.setValue(false);
        comboFocus.setValue(false);
        menuBarColor.update(new Color(238, 237, 230), -43, 28, 3);
        menuItemSelectedTextColor.update(new Color(0, 0, 0), 0, -100, 3);
        menuPopupColor.update(new Color(255, 255, 255), 0, 100, 3);
        menuRolloverBgColor.update(new Color(189, 208, 234), -50, 66, 2);
        menuRolloverFgColor.update(new Color(0, 0, 0), 0, -100, 3);
        menuDisabledFgColor.update(new Color(143, 142, 139), 0, 0, 4);
        menuItemDisabledFgColor.update(new Color(143, 142, 139), 0, 0, 4);
        menuItemRolloverColor.update(new Color(189, 208, 234), -50, 66, 2);
        menuBorderColor.update(new Color(173, 170, 153), 4, -28, 3);
        menuInnerHilightColor.update(new Color(255, 255, 255), 0, 100, 3);
        menuInnerShadowColor.update(new Color(213, 212, 207), -70, -7, 3);
        menuOuterHilightColor.update(new Color(173, 170, 153), 4, -28, 3);
        menuOuterShadowColor.update(new Color(173, 170, 153), 4, -28, 3);
        menuIconColor.update(new Color(0, 0, 0), 0, -100, 3);
        menuIconRolloverColor.update(new Color(0, 0, 0), 0, -100, 3);
        menuIconDisabledColor.update(new Color(165, 163, 151), 0, -30, 3);
        menuSeparatorColor.update(new Color(173, 170, 153), 4, -28, 3);
        menuRollover.setValue(true);
        menuPopupShadow.setValue(false);
        menuAllowTwoIcons.setValue(false);
        toolBarColor.update(new Color(239, 237, 229), -35, 28, 3);
        toolBarLightColor.update(new Color(255, 255, 255), 0, 100, 3);
        toolBarDarkColor.update(new Color(214, 210, 187), 10, -11, 3);
        toolButtColor.update(new Color(239, 237, 229), -35, 28, 3);
        toolButtSelectedColor.update(new Color(243, 242, 239), -51, 52, 3);
        toolButtRolloverColor.update(new Color(251, 251, 248), -30, 81, 3);
        toolButtPressedColor.update(new Color(225, 224, 218), -58, -2, 3);
        toolGripDarkColor.update(new Color(167, 167, 163), -70, -27, 3);
        toolGripLightColor.update(new Color(255, 255, 255), 0, 100, 3);
        toolSeparatorColor.update(new Color(167, 167, 163), -70, -27, 3);
        toolBorderColor.update(new Color(239, 237, 229), -35, 28, 3);
        toolBorderPressedColor.update(new Color(122, 144, 174), -76, 16, 2);
        toolBorderRolloverColor.update(new Color(122, 144, 174), -76, 16, 2);
        toolBorderSelectedColor.update(new Color(122, 144, 174), -76, 16, 2);
        Theme.toolMargin.top = 5;
        Theme.toolMargin.left = 5;
        Theme.toolMargin.bottom = 5;
        Theme.toolMargin.right = 5;
        toolFocus.setValue(false);
        toolRollover.setValue(true);
        listBgColor.update(new Color(255, 255, 255), 0, 100, 3);
        listTextColor.update(new Color(0, 0, 0), 0, -100, 3);
        listSelectedBgColor.update(new Color(43, 107, 197), -36, -6, 2);
        listSelectedTextColor.update(new Color(255, 255, 255), 0, 100, 3);
        listFocusBorderColor.update(new Color(179, 211, 255), 100, 70, 2);
        treeBgColor.update(new Color(255, 255, 255), 0, 100, 3);
        treeTextColor.update(new Color(0, 0, 0), 0, -100, 3);
        treeTextBgColor.update(new Color(255, 255, 255), 0, 100, 3);
        treeSelectedTextColor.update(new Color(255, 255, 255), 0, 100, 3);
        treeSelectedBgColor.update(new Color(43, 107, 197), -36, -6, 2);
        treeLineColor.update(new Color(208, 205, 190), 0, -12, 3);
        frameCaptionColor.update(new Color(13, 94, 255), 0, 5, 5);
        frameCaptionDisabledColor.update(new Color(122, 159, 223), -25, 41, 5);
        frameBorderColor.update(new Color(0, 60, 161), 0, -30, 5);
        frameLightColor.update(new Color(0, 68, 184), 0, -20, 5);
        frameBorderDisabledColor.update(new Color(74, 125, 212), -25, 20, 5);
        frameLightDisabledColor.update(new Color(99, 144, 233), -25, 30, 5);
        frameTitleColor.update(new Color(255, 255, 255), 0, 100, 5);
        frameTitleShadowColor.update(new Color(0, 43, 128), 0, -50, 5);
        frameTitleDisabledColor.update(new Color(216, 226, 248), -29, 82, 5);
        frameButtColor.update(new Color(13, 94, 255), 0, 5, 5);
        frameButtRolloverColor.update(new Color(51, 119, 255), 0, 20, 5);
        frameButtPressedColor.update(new Color(0, 68, 204), 0, -20, 5);
        frameButtDisabledColor.update(new Color(63, 120, 233), -21, 16, 5);
        frameButtSpreadLight.setValue(8);
        frameButtSpreadDark.setValue(2);
        frameButtSpreadLightDisabled.setValue(5);
        frameButtSpreadDarkDisabled.setValue(2);
        frameButtCloseColor.update(new Color(227, 92, 60), 0, 0, 9);
        frameButtCloseRolloverColor.update(new Color(233, 125, 99), 0, 20, 9);
        frameButtClosePressedColor.update(new Color(193, 78, 51), 0, -15, 9);
        frameButtCloseDisabledColor.update(new Color(175, 105, 125), 0, 0, 12);
        frameButtCloseSpreadLight.setValue(8);
        frameButtCloseSpreadDark.setValue(2);
        frameButtCloseSpreadLightDisabled.setValue(5);
        frameButtCloseSpreadDarkDisabled.setValue(2);
        frameButtBorderColor.update(new Color(255, 255, 255), 0, 100, 5);
        frameButtBorderDisabledColor.update(new Color(190, 206, 238), -42, 68, 5);
        frameSymbolColor.update(new Color(255, 255, 255), 0, 100, 5);
        frameSymbolPressedColor.update(new Color(255, 255, 255), 0, 100, 5);
        frameSymbolDisabledColor.update(new Color(255, 255, 255), 0, 100, 5);
        frameSymbolDarkColor.update(new Color(255, 255, 255), 0, 100, 5);
        frameSymbolLightColor.update(new Color(13, 94, 255), 0, 5, 5);
        frameSymbolDarkDisabledColor.update(new Color(255, 255, 255), 0, 100, 5);
        frameSymbolLightDisabledColor.update(new Color(63, 120, 233), -21, 16, 5);
        frameButtCloseBorderColor.update(new Color(255, 255, 255), 0, 100, 5);
        frameButtCloseDarkColor.update(new Color(174, 51, 20), 50, -32, 9);
        frameButtCloseLightColor.update(new Color(226, 88, 55), 11, -2, 9);
        frameButtCloseBorderDisabledColor.update(new Color(190, 206, 238), -42, 68, 5);
        frameSymbolCloseColor.update(new Color(255, 255, 255), 0, 100, 5);
        frameSymbolClosePressedColor.update(new Color(231, 180, 168), -24, 50, 9);
        frameSymbolCloseDisabledColor.update(new Color(255, 255, 255), 0, 100, 5);
        frameSymbolCloseDarkColor.update(new Color(227, 92, 60), 0, 0, 9);
        frameSymbolCloseDarkDisabledColor.update(new Color(175, 105, 125), 0, 0, 12);
        frameSpreadDark.setValue(3);
        frameSpreadLight.setValue(2);
        frameSpreadDarkDisabled.setValue(2);
        frameSpreadLightDisabled.setValue(2);
        tableBackColor.update(new Color(255, 255, 255), 0, 100, 3);
        tableHeaderBackColor.update(new Color(236, 233, 216), 0, 0, 3);
        tableHeaderRolloverBackColor.update(new Color(249, 248, 243), 0, 70, 3);
        tableHeaderRolloverColor.update(new Color(248, 179, 48), 0, 0, 11);
        tableGridColor.update(new Color(167, 166, 160), -50, -28, 3);
        tableHeaderArrowColor.update(new Color(167, 166, 160), -50, -28, 3);
        tableSelectedBackColor.update(new Color(213, 211, 204), -50, -8, 3);
        tableSelectedForeColor.update(new Color(0, 0, 0), 0, -100, 3);
        tableBorderDarkColor.update(new Color(167, 166, 160), -50, -28, 3);
        tableBorderLightColor.update(new Color(255, 255, 255), 0, 100, 3);
        tableHeaderDarkColor.update(new Color(189, 186, 173), 0, -20, 3);
        tableHeaderLightColor.update(new Color(255, 255, 255), 0, 100, 3);
        tableFocusBorderColor.update(new Color(185, 184, 177), -50, -20, 3);
        tableAlternateRowColor.update(new Color(255, 255, 255), 0, 100, 3);
        for (int i = 0; i < 20; ++i) {
            colorizer[i].setHue(51);
            colorizer[i].setSaturation(25);
            colorizer[i].setBrightness(0);
            colorizer[i].setReference(3);
            colorize[i].setValue(false);
        }
        separatorColor.update(new Color(167, 167, 163), -70, -27, 3);
        tipBorderColor.update(new Color(0, 0, 0), 0, -100, 3);
        tipBorderDis.update(new Color(143, 141, 139), 0, 0, 4);
        tipBgColor.update(new Color(255, 255, 225), 0, 0, 1);
        tipBgDis.update(new Color(236, 233, 216), 0, 0, 3);
        tipTextColor.update(new Color(0, 0, 0), 0, -100, 3);
        tipTextDis.update(new Color(143, 141, 139), 0, 0, 4);
        titledBorderColor.update(new Color(165, 163, 151), 0, -30, 3);
        splitPaneButtonColor.update(new Color(170, 168, 156), 0, -28, 3);
    }

    public static boolean loadTheme(File f) {
        errorCode = 1;
        if (f == null) {
            errorCode = 2;
            return false;
        }
        try {
            return Theme.loadTheme(new FileInputStream(f));
        }
        catch (FileNotFoundException ex) {
            System.out.println("Theme.loadTheme(File) : " + ex);
            errorCode = 3;
        }
        catch (IOException ex) {
            System.out.println("Theme.loadTheme(File) : " + ex);
            errorCode = 4;
        }
        return false;
    }

    public static boolean loadTheme(ThemeDescription td) {
        if (td == null) {
            errorCode = 2;
            return false;
        }
        if (td.isValid()) {
            return Theme.loadTheme(td.getURL());
        }
        errorCode = 7;
        return false;
    }

    public static boolean loadTheme(URL url) {
        errorCode = 1;
        if (url == null) {
            errorCode = 2;
            return false;
        }
        if (YQ_URL != null && url.equals(YQ_URL)) {
            Theme.loadYQTheme();
            return true;
        }
        try {
            return Theme.loadTheme(url.openStream());
        }
        catch (FileNotFoundException ex) {
            errorCode = 3;
        }
        catch (IOException ex) {
            System.out.println("Theme.loadTheme(URL) : " + ex);
            errorCode = 4;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean loadTheme(InputStream istream) throws IOException {
        FilterInputStream in = null;
        try {
            Color c;
            in = new DataInputStream(new BufferedInputStream(istream));
            fileID = ((DataInputStream)in).readInt();
            if (fileID != 12852 && fileID != 12853 && fileID != 12854 && fileID != 12855 && fileID != 12856 && fileID != 12857 && fileID != 16384 && fileID != 16385 && fileID != 16386 && fileID != 16387 && fileID != 16388 && fileID != 8756 && fileID != 4660) {
                errorCode = 5;
                boolean bl = false;
                return bl;
            }
            int derivedStyle = ((DataInputStream)in).readInt();
            if (derivedStyle != 2) {
                errorCode = 6;
                boolean bl = false;
                return bl;
            }
            mainColor.load((DataInputStream)in);
            disColor.load((DataInputStream)in);
            backColor.load((DataInputStream)in);
            frameColor.load((DataInputStream)in);
            sub1Color.load((DataInputStream)in);
            sub2Color.load((DataInputStream)in);
            sub3Color.load((DataInputStream)in);
            sub4Color.load((DataInputStream)in);
            sub5Color.load((DataInputStream)in);
            sub6Color.load((DataInputStream)in);
            sub7Color.load((DataInputStream)in);
            sub8Color.load((DataInputStream)in);
            plainFont.load((DataInputStream)in);
            boldFont.load((DataInputStream)in);
            buttonFont.load((DataInputStream)in);
            passwordFont.load((DataInputStream)in);
            labelFont.load((DataInputStream)in);
            comboFont.load((DataInputStream)in);
            if (fileID == 4660) {
                ColoredFont.loadDummyData((DataInputStream)in);
            }
            listFont.load((DataInputStream)in);
            menuFont.load((DataInputStream)in);
            menuItemFont.load((DataInputStream)in);
            radioFont.load((DataInputStream)in);
            checkFont.load((DataInputStream)in);
            tableFont.load((DataInputStream)in);
            tableHeaderFont.load((DataInputStream)in);
            textAreaFont.load((DataInputStream)in);
            textFieldFont.load((DataInputStream)in);
            textPaneFont.load((DataInputStream)in);
            titledBorderFont.load((DataInputStream)in);
            toolTipFont.load((DataInputStream)in);
            treeFont.load((DataInputStream)in);
            tabFont.load((DataInputStream)in);
            editorFont.load((DataInputStream)in);
            frameTitleFont.load((DataInputStream)in);
            if (fileID >= 12852) {
                internalFrameTitleFont.load((DataInputStream)in);
                internalPaletteTitleFont.load((DataInputStream)in);
            }
            if (fileID != 4660) {
                progressBarFont.load((DataInputStream)in);
            }
            buttonFontColor.load((DataInputStream)in);
            buttonFont.setSBReference(buttonFontColor);
            labelFontColor.load((DataInputStream)in);
            labelFont.setSBReference(labelFontColor);
            menuFontColor.load((DataInputStream)in);
            menuFont.setSBReference(menuFontColor);
            menuItemFontColor.load((DataInputStream)in);
            menuItemFont.setSBReference(menuItemFontColor);
            radioFontColor.load((DataInputStream)in);
            radioFont.setSBReference(radioFontColor);
            checkFontColor.load((DataInputStream)in);
            checkFont.setSBReference(checkFontColor);
            tableFontColor.load((DataInputStream)in);
            tableFont.setSBReference(tableFontColor);
            tableHeaderFontColor.load((DataInputStream)in);
            tableHeaderFont.setSBReference(tableHeaderFontColor);
            tabFontColor.load((DataInputStream)in);
            tabFont.setSBReference(tabFontColor);
            titledBorderFontColor.load((DataInputStream)in);
            titledBorderFont.setSBReference(titledBorderFontColor);
            if (fileID < 12854) {
                SBReference.loadDummyData((DataInputStream)in);
            }
            progressColor.load((DataInputStream)in);
            progressTrackColor.load((DataInputStream)in);
            progressBorderColor.load((DataInputStream)in);
            progressDarkColor.load((DataInputStream)in);
            progressLightColor.load((DataInputStream)in);
            if (fileID != 4660) {
                progressSelectForeColor.load((DataInputStream)in);
                progressSelectBackColor.load((DataInputStream)in);
            }
            textBgColor.load((DataInputStream)in);
            textTextColor.load((DataInputStream)in);
            if (fileID >= 12852) {
                textCaretColor.load((DataInputStream)in);
                editorPaneBgColor.load((DataInputStream)in);
                textPaneBgColor.load((DataInputStream)in);
                desktopPaneBgColor.load((DataInputStream)in);
            }
            textSelectedBgColor.load((DataInputStream)in);
            textSelectedTextColor.load((DataInputStream)in);
            textDisabledBgColor.load((DataInputStream)in);
            if (fileID < 16384) {
                textNonEditableBgColor.update(textDisabledBgColor);
            } else {
                textNonEditableBgColor.load((DataInputStream)in);
            }
            textBorderColor.load((DataInputStream)in);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)in);
                SBReference.loadDummyData((DataInputStream)in);
            }
            textBorderDisabledColor.load((DataInputStream)in);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)in);
                SBReference.loadDummyData((DataInputStream)in);
            }
            Theme.textInsets.top = ((DataInputStream)in).readInt();
            Theme.textInsets.left = ((DataInputStream)in).readInt();
            Theme.textInsets.bottom = ((DataInputStream)in).readInt();
            Theme.textInsets.right = ((DataInputStream)in).readInt();
            buttonRolloverBorder.setValue(((DataInputStream)in).readBoolean());
            buttonFocus.setValue(((DataInputStream)in).readBoolean());
            if (fileID >= 12852) {
                buttonFocusBorder.setValue(((DataInputStream)in).readBoolean());
                buttonEnter.setValue(((DataInputStream)in).readBoolean());
            }
            if (fileID >= 12855) {
                shiftButtonText.setValue(((DataInputStream)in).readBoolean());
            }
            buttonNormalColor.load((DataInputStream)in);
            buttonRolloverBgColor.load((DataInputStream)in);
            buttonPressedColor.load((DataInputStream)in);
            buttonDisabledColor.load((DataInputStream)in);
            buttonBorderColor.load((DataInputStream)in);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)in);
                SBReference.loadDummyData((DataInputStream)in);
            }
            buttonBorderDisabledColor.load((DataInputStream)in);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)in);
                SBReference.loadDummyData((DataInputStream)in);
            }
            Theme.buttonMargin.top = ((DataInputStream)in).readInt();
            Theme.buttonMargin.left = ((DataInputStream)in).readInt();
            Theme.buttonMargin.bottom = ((DataInputStream)in).readInt();
            Theme.buttonMargin.right = ((DataInputStream)in).readInt();
            if (fileID >= 12853) {
                Theme.checkMargin.top = ((DataInputStream)in).readInt();
                Theme.checkMargin.left = ((DataInputStream)in).readInt();
                Theme.checkMargin.bottom = ((DataInputStream)in).readInt();
                Theme.checkMargin.right = ((DataInputStream)in).readInt();
            } else {
                Theme.checkMargin.top = 2;
                Theme.checkMargin.left = 2;
                Theme.checkMargin.bottom = 2;
                Theme.checkMargin.right = 2;
            }
            buttonRolloverColor.load((DataInputStream)in);
            buttonDefaultColor.load((DataInputStream)in);
            buttonCheckColor.load((DataInputStream)in);
            buttonCheckDisabledColor.load((DataInputStream)in);
            buttonDisabledFgColor.load((DataInputStream)in);
            checkDisabledFgColor.load((DataInputStream)in);
            radioDisabledFgColor.load((DataInputStream)in);
            if (fileID >= 16385) {
                toggleSelectedBg.load((DataInputStream)in);
            } else {
                toggleSelectedBg.update(buttonPressedColor);
            }
            buttonSpreadLight.setValue(((DataInputStream)in).readInt());
            buttonSpreadDark.setValue(((DataInputStream)in).readInt());
            buttonSpreadLightDisabled.setValue(((DataInputStream)in).readInt());
            buttonSpreadDarkDisabled.setValue(((DataInputStream)in).readInt());
            if (fileID < 12852) {
                Theme.buttonMargin.top = Math.max(0, Theme.buttonMargin.top - 2);
                Theme.buttonMargin.left = Math.max(0, Theme.buttonMargin.left - 2);
                Theme.buttonMargin.bottom = Math.max(0, Theme.buttonMargin.bottom - 2);
                Theme.buttonMargin.right = Math.max(0, Theme.buttonMargin.right - 2);
            }
            scrollRollover.setValue(((DataInputStream)in).readBoolean());
            if (fileID >= 16387) {
                scrollSize.setValue(((DataInputStream)in).readInt());
            } else {
                scrollSize.setValue(17);
            }
            scrollTrackColor.load((DataInputStream)in);
            scrollTrackDisabledColor.load((DataInputStream)in);
            scrollTrackBorderColor.load((DataInputStream)in);
            scrollTrackBorderDisabledColor.load((DataInputStream)in);
            scrollThumbColor.load((DataInputStream)in);
            scrollThumbRolloverColor.load((DataInputStream)in);
            scrollThumbPressedColor.load((DataInputStream)in);
            scrollThumbDisabledColor.load((DataInputStream)in);
            scrollGripLightColor.load((DataInputStream)in);
            scrollGripDarkColor.load((DataInputStream)in);
            scrollButtColor.load((DataInputStream)in);
            scrollButtRolloverColor.load((DataInputStream)in);
            scrollButtPressedColor.load((DataInputStream)in);
            scrollButtDisabledColor.load((DataInputStream)in);
            scrollSpreadLight.setValue(((DataInputStream)in).readInt());
            scrollSpreadDark.setValue(((DataInputStream)in).readInt());
            scrollSpreadLightDisabled.setValue(((DataInputStream)in).readInt());
            scrollSpreadDarkDisabled.setValue(((DataInputStream)in).readInt());
            scrollArrowColor.load((DataInputStream)in);
            scrollArrowDisabledColor.load((DataInputStream)in);
            scrollBorderColor.load((DataInputStream)in);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)in);
            }
            scrollBorderLightColor.load((DataInputStream)in);
            scrollBorderDisabledColor.load((DataInputStream)in);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)in);
            }
            scrollLightDisabledColor.load((DataInputStream)in);
            scrollPaneBorderColor.load((DataInputStream)in);
            tabPaneBorderColor.load((DataInputStream)in);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)in);
                SBReference.loadDummyData((DataInputStream)in);
            }
            tabNormalColor.load((DataInputStream)in);
            tabSelectedColor.load((DataInputStream)in);
            if (fileID >= 12852) {
                tabDisabledColor.load((DataInputStream)in);
                tabDisabledSelectedColor.load((DataInputStream)in);
                tabDisabledTextColor.load((DataInputStream)in);
            }
            tabBorderColor.load((DataInputStream)in);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)in);
                SBReference.loadDummyData((DataInputStream)in);
            }
            tabRolloverColor.load((DataInputStream)in);
            if (fileID >= 16384) {
                tabDisabledBorderColor.load((DataInputStream)in);
                tabPaneDisabledBorderColor.load((DataInputStream)in);
            } else {
                tabDisabledBorderColor.update(tabBorderColor);
                tabPaneDisabledBorderColor.update(tabPaneBorderColor);
            }
            int leftInset = -1;
            if (fileID < 12852) {
                leftInset = ((DataInputStream)in).readInt();
            }
            tabRollover.setValue(((DataInputStream)in).readBoolean());
            if (fileID >= 12856) {
                tabFocus.setValue(((DataInputStream)in).readBoolean());
            } else {
                tabFocus.setValue(true);
            }
            ignoreSelectedBg.setValue(((DataInputStream)in).readBoolean());
            if (fileID >= 12854) {
                fixedTabs.setValue(((DataInputStream)in).readBoolean());
            }
            if (fileID < 12852) {
                ((DataInputStream)in).readInt();
                ((DataInputStream)in).readInt();
                ((DataInputStream)in).readInt();
                ((DataInputStream)in).readInt();
            }
            if (fileID >= 12852) {
                Theme.tabInsets.top = ((DataInputStream)in).readInt();
                Theme.tabInsets.left = ((DataInputStream)in).readInt();
                Theme.tabInsets.bottom = ((DataInputStream)in).readInt();
                Theme.tabInsets.right = ((DataInputStream)in).readInt();
                Theme.tabAreaInsets.top = ((DataInputStream)in).readInt();
                Theme.tabAreaInsets.left = ((DataInputStream)in).readInt();
                Theme.tabAreaInsets.bottom = ((DataInputStream)in).readInt();
                Theme.tabAreaInsets.right = ((DataInputStream)in).readInt();
                if (leftInset > -1) {
                    Theme.tabAreaInsets.left = leftInset;
                }
            }
            sliderRolloverEnabled.setValue(((DataInputStream)in).readBoolean());
            if (fileID >= 12856) {
                sliderFocusEnabled.setValue(((DataInputStream)in).readBoolean());
            } else {
                sliderFocusEnabled.setValue(true);
            }
            sliderThumbColor.load((DataInputStream)in);
            sliderThumbRolloverColor.load((DataInputStream)in);
            sliderThumbPressedColor.load((DataInputStream)in);
            sliderThumbDisabledColor.load((DataInputStream)in);
            sliderBorderColor.load((DataInputStream)in);
            sliderDarkColor.load((DataInputStream)in);
            sliderLightColor.load((DataInputStream)in);
            if (fileID < 12852) {
                sliderLightColor.update(buttonCheckColor);
            }
            sliderBorderDisabledColor.load((DataInputStream)in);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)in);
                SBReference.loadDummyData((DataInputStream)in);
            }
            sliderTrackColor.load((DataInputStream)in);
            sliderTrackBorderColor.load((DataInputStream)in);
            sliderTrackDarkColor.load((DataInputStream)in);
            sliderTrackLightColor.load((DataInputStream)in);
            sliderTickColor.load((DataInputStream)in);
            sliderTickDisabledColor.load((DataInputStream)in);
            if (fileID >= 12856) {
                sliderFocusColor.load((DataInputStream)in);
            }
            spinnerRollover.setValue(((DataInputStream)in).readBoolean());
            spinnerButtColor.load((DataInputStream)in);
            spinnerButtRolloverColor.load((DataInputStream)in);
            spinnerButtPressedColor.load((DataInputStream)in);
            spinnerButtDisabledColor.load((DataInputStream)in);
            spinnerSpreadLight.setValue(((DataInputStream)in).readInt());
            spinnerSpreadDark.setValue(((DataInputStream)in).readInt());
            spinnerSpreadLightDisabled.setValue(((DataInputStream)in).readInt());
            spinnerSpreadDarkDisabled.setValue(((DataInputStream)in).readInt());
            spinnerBorderColor.load((DataInputStream)in);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)in);
                SBReference.loadDummyData((DataInputStream)in);
            }
            spinnerBorderDisabledColor.load((DataInputStream)in);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)in);
                SBReference.loadDummyData((DataInputStream)in);
            }
            spinnerArrowColor.load((DataInputStream)in);
            spinnerArrowDisabledColor.load((DataInputStream)in);
            comboBorderColor.load((DataInputStream)in);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)in);
                SBReference.loadDummyData((DataInputStream)in);
            }
            comboBorderDisabledColor.load((DataInputStream)in);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)in);
                SBReference.loadDummyData((DataInputStream)in);
            }
            comboSelectedBgColor.load((DataInputStream)in);
            comboSelectedTextColor.load((DataInputStream)in);
            comboFocusBgColor.load((DataInputStream)in);
            if (fileID >= 12852) {
                comboBgColor.load((DataInputStream)in);
                comboTextColor.load((DataInputStream)in);
            } else {
                comboBgColor.update(textBgColor);
                comboTextColor.update(textTextColor);
            }
            comboButtColor.load((DataInputStream)in);
            comboButtRolloverColor.load((DataInputStream)in);
            comboButtPressedColor.load((DataInputStream)in);
            comboButtDisabledColor.load((DataInputStream)in);
            comboSpreadLight.setValue(((DataInputStream)in).readInt());
            comboSpreadDark.setValue(((DataInputStream)in).readInt());
            comboSpreadLightDisabled.setValue(((DataInputStream)in).readInt());
            comboSpreadDarkDisabled.setValue(((DataInputStream)in).readInt());
            comboButtBorderColor.load((DataInputStream)in);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)in);
                SBReference.loadDummyData((DataInputStream)in);
            }
            comboButtBorderDisabledColor.load((DataInputStream)in);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)in);
                SBReference.loadDummyData((DataInputStream)in);
            }
            comboArrowColor.load((DataInputStream)in);
            comboArrowDisabledColor.load((DataInputStream)in);
            Theme.comboInsets.top = ((DataInputStream)in).readInt();
            Theme.comboInsets.left = ((DataInputStream)in).readInt();
            Theme.comboInsets.bottom = ((DataInputStream)in).readInt();
            Theme.comboInsets.right = ((DataInputStream)in).readInt();
            comboRollover.setValue(((DataInputStream)in).readBoolean());
            comboFocus.setValue(((DataInputStream)in).readBoolean());
            menuBarColor.load((DataInputStream)in);
            menuItemSelectedTextColor.load((DataInputStream)in);
            menuPopupColor.load((DataInputStream)in);
            menuRolloverBgColor.load((DataInputStream)in);
            menuItemRolloverColor.load((DataInputStream)in);
            menuBorderColor.load((DataInputStream)in);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)in);
                SBReference.loadDummyData((DataInputStream)in);
            }
            menuIconColor.load((DataInputStream)in);
            menuIconRolloverColor.load((DataInputStream)in);
            menuIconDisabledColor.load((DataInputStream)in);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)in);
            }
            menuSeparatorColor.load((DataInputStream)in);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)in);
                ((DataInputStream)in).readInt();
                ((DataInputStream)in).readInt();
                ((DataInputStream)in).readInt();
                ((DataInputStream)in).readInt();
            }
            menuRollover.setValue(((DataInputStream)in).readBoolean());
            if (fileID >= 12852) {
                menuInnerHilightColor.load((DataInputStream)in);
                menuInnerShadowColor.load((DataInputStream)in);
                menuOuterHilightColor.load((DataInputStream)in);
                menuOuterShadowColor.load((DataInputStream)in);
                menuRolloverFgColor.load((DataInputStream)in);
                menuDisabledFgColor.load((DataInputStream)in);
            } else {
                menuRolloverFgColor.update(menuFont.getSBReference());
                menuDisabledFgColor.update(buttonDisabledFgColor);
            }
            if (fileID >= 16384) {
                menuItemDisabledFgColor.load((DataInputStream)in);
            } else {
                menuItemDisabledFgColor.update(menuDisabledFgColor);
            }
            if (fileID > 16385) {
                menuPopupShadow.setValue(((DataInputStream)in).readBoolean());
                menuAllowTwoIcons.setValue(((DataInputStream)in).readBoolean());
            } else {
                menuPopupShadow.setValue(false);
                menuAllowTwoIcons.setValue(false);
            }
            toolBarColor.load((DataInputStream)in);
            toolBarLightColor.load((DataInputStream)in);
            toolBarDarkColor.load((DataInputStream)in);
            if (fileID >= 12852) {
                toolButtColor.load((DataInputStream)in);
                toolButtRolloverColor.load((DataInputStream)in);
                toolButtPressedColor.load((DataInputStream)in);
                toolButtSelectedColor.load((DataInputStream)in);
            } else {
                toolButtSelectedColor.load((DataInputStream)in);
                toolButtRolloverColor.load((DataInputStream)in);
                toolButtPressedColor.load((DataInputStream)in);
                toolButtColor.update(toolButtSelectedColor);
            }
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)in);
                SBReference.loadDummyData((DataInputStream)in);
            }
            toolBorderColor.load((DataInputStream)in);
            if (fileID >= 12852) {
                toolBorderRolloverColor.load((DataInputStream)in);
            } else {
                toolBorderRolloverColor.update(toolBorderColor);
            }
            toolBorderPressedColor.load((DataInputStream)in);
            toolBorderSelectedColor.load((DataInputStream)in);
            toolRollover.setValue(((DataInputStream)in).readBoolean());
            toolFocus.setValue(((DataInputStream)in).readBoolean());
            if (fileID >= 12852) {
                toolGripDarkColor.load((DataInputStream)in);
                toolGripLightColor.load((DataInputStream)in);
                toolSeparatorColor.load((DataInputStream)in);
                if (fileID < 16384) {
                    SBReference.loadDummyData((DataInputStream)in);
                }
                Theme.toolMargin.top = ((DataInputStream)in).readInt();
                Theme.toolMargin.left = ((DataInputStream)in).readInt();
                Theme.toolMargin.bottom = ((DataInputStream)in).readInt();
                Theme.toolMargin.right = ((DataInputStream)in).readInt();
            } else {
                Theme.toolMargin.top = 5;
                Theme.toolMargin.left = 5;
                Theme.toolMargin.bottom = 5;
                Theme.toolMargin.right = 5;
            }
            listSelectedBgColor.load((DataInputStream)in);
            listSelectedTextColor.load((DataInputStream)in);
            if (fileID >= 12852) {
                listBgColor.load((DataInputStream)in);
                listTextColor.load((DataInputStream)in);
            }
            if (fileID >= 16384) {
                listFocusBorderColor.load((DataInputStream)in);
            } else {
                listFocusBorderColor.update(new Color(213, 211, 209), 0, 0, 1);
            }
            treeBgColor.load((DataInputStream)in);
            treeTextColor.load((DataInputStream)in);
            treeTextBgColor.load((DataInputStream)in);
            treeSelectedTextColor.load((DataInputStream)in);
            treeSelectedBgColor.load((DataInputStream)in);
            if (fileID >= 12852) {
                treeLineColor.load((DataInputStream)in);
            }
            frameCaptionColor.load((DataInputStream)in);
            frameCaptionDisabledColor.load((DataInputStream)in);
            frameBorderColor.load((DataInputStream)in);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)in);
            }
            frameLightColor.load((DataInputStream)in);
            frameBorderDisabledColor.load((DataInputStream)in);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)in);
            }
            frameLightDisabledColor.load((DataInputStream)in);
            frameTitleColor.load((DataInputStream)in);
            if (fileID > 16385) {
                frameTitleShadowColor.load((DataInputStream)in);
            } else {
                frameTitleShadowColor.update(frameCaptionColor);
                if (ColorRoutines.isColorDarker(frameTitleColor.getColor(), frameCaptionColor.getColor())) {
                    frameTitleShadowColor.setBrightness(-8);
                } else {
                    frameTitleShadowColor.setBrightness(-50);
                }
            }
            frameTitleDisabledColor.load((DataInputStream)in);
            frameButtColor.load((DataInputStream)in);
            frameButtRolloverColor.load((DataInputStream)in);
            frameButtPressedColor.load((DataInputStream)in);
            frameButtDisabledColor.load((DataInputStream)in);
            frameButtSpreadDark.setValue(((DataInputStream)in).readInt());
            frameButtSpreadLight.setValue(((DataInputStream)in).readInt());
            frameButtSpreadDarkDisabled.setValue(((DataInputStream)in).readInt());
            frameButtSpreadLightDisabled.setValue(((DataInputStream)in).readInt());
            frameButtCloseColor.load((DataInputStream)in);
            frameButtCloseRolloverColor.load((DataInputStream)in);
            frameButtClosePressedColor.load((DataInputStream)in);
            frameButtCloseDisabledColor.load((DataInputStream)in);
            frameButtCloseSpreadDark.setValue(((DataInputStream)in).readInt());
            frameButtCloseSpreadLight.setValue(((DataInputStream)in).readInt());
            frameButtCloseSpreadDarkDisabled.setValue(((DataInputStream)in).readInt());
            frameButtCloseSpreadLightDisabled.setValue(((DataInputStream)in).readInt());
            frameButtBorderColor.load((DataInputStream)in);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)in);
                SBReference.loadDummyData((DataInputStream)in);
            }
            frameButtBorderDisabledColor.load((DataInputStream)in);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)in);
                SBReference.loadDummyData((DataInputStream)in);
            }
            frameSymbolColor.load((DataInputStream)in);
            frameSymbolPressedColor.load((DataInputStream)in);
            frameSymbolDisabledColor.load((DataInputStream)in);
            frameSymbolDarkColor.load((DataInputStream)in);
            frameSymbolLightColor.load((DataInputStream)in);
            if (fileID >= 16384) {
                frameSymbolDarkDisabledColor.load((DataInputStream)in);
                frameSymbolLightDisabledColor.load((DataInputStream)in);
            } else {
                c = ColorRoutines.getAverage(frameSymbolDarkColor.getColor(), frameSymbolColor.getColor());
                frameSymbolDarkDisabledColor.update(c, 0, 0, 1);
                c = ColorRoutines.getAverage(frameSymbolLightColor.getColor(), frameSymbolColor.getColor());
                frameSymbolLightDisabledColor.update(c, 0, 0, 1);
            }
            frameButtCloseBorderColor.load((DataInputStream)in);
            frameButtCloseDarkColor.load((DataInputStream)in);
            frameButtCloseLightColor.load((DataInputStream)in);
            frameButtCloseBorderDisabledColor.load((DataInputStream)in);
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)in);
                SBReference.loadDummyData((DataInputStream)in);
            }
            frameSymbolCloseColor.load((DataInputStream)in);
            frameSymbolClosePressedColor.load((DataInputStream)in);
            frameSymbolCloseDisabledColor.load((DataInputStream)in);
            frameSymbolCloseDarkColor.load((DataInputStream)in);
            if (fileID >= 16384) {
                frameSymbolCloseDarkDisabledColor.load((DataInputStream)in);
            } else {
                c = ColorRoutines.getAverage(frameSymbolCloseDarkColor.getColor(), frameSymbolCloseColor.getColor());
                frameSymbolCloseDarkDisabledColor.update(c, 0, 0, 1);
            }
            if (fileID < 16384) {
                SBReference.loadDummyData((DataInputStream)in);
            }
            frameSpreadDark.setValue(((DataInputStream)in).readInt());
            frameSpreadLight.setValue(((DataInputStream)in).readInt());
            frameSpreadDarkDisabled.setValue(((DataInputStream)in).readInt());
            frameSpreadLightDisabled.setValue(((DataInputStream)in).readInt());
            tableBackColor.load((DataInputStream)in);
            tableHeaderBackColor.load((DataInputStream)in);
            if (fileID >= 12857) {
                tableHeaderArrowColor.load((DataInputStream)in);
                tableHeaderRolloverBackColor.load((DataInputStream)in);
                tableHeaderRolloverColor.load((DataInputStream)in);
            }
            tableGridColor.load((DataInputStream)in);
            tableSelectedBackColor.load((DataInputStream)in);
            tableSelectedForeColor.load((DataInputStream)in);
            if (fileID >= 12852) {
                tableBorderDarkColor.load((DataInputStream)in);
                tableBorderLightColor.load((DataInputStream)in);
                tableHeaderDarkColor.load((DataInputStream)in);
                tableHeaderLightColor.load((DataInputStream)in);
            }
            if (fileID >= 16384) {
                tableFocusBorderColor.load((DataInputStream)in);
            } else {
                tableFocusBorderColor.update(tableSelectedBackColor);
            }
            if (fileID >= 16388) {
                tableAlternateRowColor.load((DataInputStream)in);
            } else {
                tableAlternateRowColor.update(tableBackColor);
            }
            if (fileID >= 12852) {
                for (int i = 0; i < colorizer.length; ++i) {
                    colorizer[i].load((DataInputStream)in);
                    colorize[i].setValue(((DataInputStream)in).readBoolean());
                }
            } else {
                int i;
                SBReference.loadDummyData((DataInputStream)in);
                SBReference.loadDummyData((DataInputStream)in);
                SBReference.loadDummyData((DataInputStream)in);
                SBReference.loadDummyData((DataInputStream)in);
                SBReference.loadDummyData((DataInputStream)in);
                ((DataInputStream)in).readBoolean();
                ((DataInputStream)in).readBoolean();
                ((DataInputStream)in).readBoolean();
                ((DataInputStream)in).readBoolean();
                ((DataInputStream)in).readBoolean();
                for (i = 0; i < 15; ++i) {
                    ((DataInputStream)in).readBoolean();
                }
                for (i = 0; i < colorizer.length; ++i) {
                    colorize[i].setValue(false);
                }
            }
            if (fileID >= 12852) {
                separatorColor.load((DataInputStream)in);
                if (fileID < 16384) {
                    SBReference.loadDummyData((DataInputStream)in);
                }
            }
            tipBorderColor.load((DataInputStream)in);
            tipBgColor.load((DataInputStream)in);
            if (fileID >= 12854) {
                tipBorderDis.load((DataInputStream)in);
                tipBgDis.load((DataInputStream)in);
                tipTextColor.load((DataInputStream)in);
                tipTextDis.load((DataInputStream)in);
            }
            titledBorderColor.load((DataInputStream)in);
            if (fileID >= 16384) {
                splitPaneButtonColor.load((DataInputStream)in);
            } else {
                splitPaneButtonColor.update(scrollArrowColor);
            }
            try {
                splitPaneHightlight.load((DataInputStream)in);
                splitPaneDarkShadow.load((DataInputStream)in);
            }
            catch (Exception exception) {
                // empty catch block
            }
            in.close();
            return true;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw ex;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean saveTheme(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument to Theme.saveTheme(String) is null");
        }
        return Theme.saveTheme(new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean saveTheme(File f) {
        FilterOutputStream out = null;
        try {
            boolean i;
            out = new DataOutputStream(new FileOutputStream(f));
            ((DataOutputStream)out).writeInt(16388);
            ((DataOutputStream)out).writeInt(2);
            mainColor.save((DataOutputStream)out);
            disColor.save((DataOutputStream)out);
            backColor.save((DataOutputStream)out);
            frameColor.save((DataOutputStream)out);
            sub1Color.save((DataOutputStream)out);
            sub2Color.save((DataOutputStream)out);
            sub3Color.save((DataOutputStream)out);
            sub4Color.save((DataOutputStream)out);
            sub5Color.save((DataOutputStream)out);
            sub6Color.save((DataOutputStream)out);
            sub7Color.save((DataOutputStream)out);
            sub8Color.save((DataOutputStream)out);
            plainFont.save((DataOutputStream)out);
            boldFont.save((DataOutputStream)out);
            buttonFont.save((DataOutputStream)out);
            passwordFont.save((DataOutputStream)out);
            labelFont.save((DataOutputStream)out);
            comboFont.save((DataOutputStream)out);
            listFont.save((DataOutputStream)out);
            menuFont.save((DataOutputStream)out);
            menuItemFont.save((DataOutputStream)out);
            radioFont.save((DataOutputStream)out);
            checkFont.save((DataOutputStream)out);
            tableFont.save((DataOutputStream)out);
            tableHeaderFont.save((DataOutputStream)out);
            textAreaFont.save((DataOutputStream)out);
            textFieldFont.save((DataOutputStream)out);
            textPaneFont.save((DataOutputStream)out);
            titledBorderFont.save((DataOutputStream)out);
            toolTipFont.save((DataOutputStream)out);
            treeFont.save((DataOutputStream)out);
            tabFont.save((DataOutputStream)out);
            editorFont.save((DataOutputStream)out);
            frameTitleFont.save((DataOutputStream)out);
            internalFrameTitleFont.save((DataOutputStream)out);
            internalPaletteTitleFont.save((DataOutputStream)out);
            progressBarFont.save((DataOutputStream)out);
            buttonFontColor.save((DataOutputStream)out);
            labelFontColor.save((DataOutputStream)out);
            menuFontColor.save((DataOutputStream)out);
            menuItemFontColor.save((DataOutputStream)out);
            radioFontColor.save((DataOutputStream)out);
            checkFontColor.save((DataOutputStream)out);
            tableFontColor.save((DataOutputStream)out);
            tableHeaderFontColor.save((DataOutputStream)out);
            tabFontColor.save((DataOutputStream)out);
            titledBorderFontColor.save((DataOutputStream)out);
            progressColor.save((DataOutputStream)out);
            progressTrackColor.save((DataOutputStream)out);
            progressBorderColor.save((DataOutputStream)out);
            progressDarkColor.save((DataOutputStream)out);
            progressLightColor.save((DataOutputStream)out);
            progressSelectForeColor.save((DataOutputStream)out);
            progressSelectBackColor.save((DataOutputStream)out);
            textBgColor.save((DataOutputStream)out);
            textTextColor.save((DataOutputStream)out);
            textCaretColor.save((DataOutputStream)out);
            editorPaneBgColor.save((DataOutputStream)out);
            textPaneBgColor.save((DataOutputStream)out);
            desktopPaneBgColor.save((DataOutputStream)out);
            textSelectedBgColor.save((DataOutputStream)out);
            textSelectedTextColor.save((DataOutputStream)out);
            textDisabledBgColor.save((DataOutputStream)out);
            textNonEditableBgColor.save((DataOutputStream)out);
            textBorderColor.save((DataOutputStream)out);
            textBorderDisabledColor.save((DataOutputStream)out);
            ((DataOutputStream)out).writeInt(Theme.textInsets.top);
            ((DataOutputStream)out).writeInt(Theme.textInsets.left);
            ((DataOutputStream)out).writeInt(Theme.textInsets.bottom);
            ((DataOutputStream)out).writeInt(Theme.textInsets.right);
            ((DataOutputStream)out).writeBoolean(buttonRolloverBorder.getValue());
            ((DataOutputStream)out).writeBoolean(buttonFocus.getValue());
            ((DataOutputStream)out).writeBoolean(buttonFocusBorder.getValue());
            ((DataOutputStream)out).writeBoolean(buttonEnter.getValue());
            ((DataOutputStream)out).writeBoolean(shiftButtonText.getValue());
            buttonNormalColor.save((DataOutputStream)out);
            buttonRolloverBgColor.save((DataOutputStream)out);
            buttonPressedColor.save((DataOutputStream)out);
            buttonDisabledColor.save((DataOutputStream)out);
            buttonBorderColor.save((DataOutputStream)out);
            buttonBorderDisabledColor.save((DataOutputStream)out);
            ((DataOutputStream)out).writeInt(Theme.buttonMargin.top);
            ((DataOutputStream)out).writeInt(Theme.buttonMargin.left);
            ((DataOutputStream)out).writeInt(Theme.buttonMargin.bottom);
            ((DataOutputStream)out).writeInt(Theme.buttonMargin.right);
            ((DataOutputStream)out).writeInt(Theme.checkMargin.top);
            ((DataOutputStream)out).writeInt(Theme.checkMargin.left);
            ((DataOutputStream)out).writeInt(Theme.checkMargin.bottom);
            ((DataOutputStream)out).writeInt(Theme.checkMargin.right);
            buttonRolloverColor.save((DataOutputStream)out);
            buttonDefaultColor.save((DataOutputStream)out);
            buttonCheckColor.save((DataOutputStream)out);
            buttonCheckDisabledColor.save((DataOutputStream)out);
            buttonDisabledFgColor.save((DataOutputStream)out);
            checkDisabledFgColor.save((DataOutputStream)out);
            radioDisabledFgColor.save((DataOutputStream)out);
            toggleSelectedBg.save((DataOutputStream)out);
            ((DataOutputStream)out).writeInt(buttonSpreadLight.getValue());
            ((DataOutputStream)out).writeInt(buttonSpreadDark.getValue());
            ((DataOutputStream)out).writeInt(buttonSpreadLightDisabled.getValue());
            ((DataOutputStream)out).writeInt(buttonSpreadDarkDisabled.getValue());
            ((DataOutputStream)out).writeBoolean(scrollRollover.getValue());
            ((DataOutputStream)out).writeInt(scrollSize.getValue());
            scrollTrackColor.save((DataOutputStream)out);
            scrollTrackDisabledColor.save((DataOutputStream)out);
            scrollTrackBorderColor.save((DataOutputStream)out);
            scrollTrackBorderDisabledColor.save((DataOutputStream)out);
            scrollThumbColor.save((DataOutputStream)out);
            scrollThumbRolloverColor.save((DataOutputStream)out);
            scrollThumbPressedColor.save((DataOutputStream)out);
            scrollThumbDisabledColor.save((DataOutputStream)out);
            scrollGripLightColor.save((DataOutputStream)out);
            scrollGripDarkColor.save((DataOutputStream)out);
            scrollButtColor.save((DataOutputStream)out);
            scrollButtRolloverColor.save((DataOutputStream)out);
            scrollButtPressedColor.save((DataOutputStream)out);
            scrollButtDisabledColor.save((DataOutputStream)out);
            ((DataOutputStream)out).writeInt(scrollSpreadLight.getValue());
            ((DataOutputStream)out).writeInt(scrollSpreadDark.getValue());
            ((DataOutputStream)out).writeInt(scrollSpreadLightDisabled.getValue());
            ((DataOutputStream)out).writeInt(scrollSpreadDarkDisabled.getValue());
            scrollArrowColor.save((DataOutputStream)out);
            scrollArrowDisabledColor.save((DataOutputStream)out);
            scrollBorderColor.save((DataOutputStream)out);
            scrollBorderLightColor.save((DataOutputStream)out);
            scrollBorderDisabledColor.save((DataOutputStream)out);
            scrollLightDisabledColor.save((DataOutputStream)out);
            scrollPaneBorderColor.save((DataOutputStream)out);
            tabPaneBorderColor.save((DataOutputStream)out);
            tabNormalColor.save((DataOutputStream)out);
            tabSelectedColor.save((DataOutputStream)out);
            tabDisabledColor.save((DataOutputStream)out);
            tabDisabledSelectedColor.save((DataOutputStream)out);
            tabDisabledTextColor.save((DataOutputStream)out);
            tabBorderColor.save((DataOutputStream)out);
            tabRolloverColor.save((DataOutputStream)out);
            tabDisabledBorderColor.save((DataOutputStream)out);
            tabPaneDisabledBorderColor.save((DataOutputStream)out);
            ((DataOutputStream)out).writeBoolean(tabRollover.getValue());
            ((DataOutputStream)out).writeBoolean(tabFocus.getValue());
            ((DataOutputStream)out).writeBoolean(ignoreSelectedBg.getValue());
            ((DataOutputStream)out).writeBoolean(fixedTabs.getValue());
            ((DataOutputStream)out).writeInt(Theme.tabInsets.top);
            ((DataOutputStream)out).writeInt(Theme.tabInsets.left);
            ((DataOutputStream)out).writeInt(Theme.tabInsets.bottom);
            ((DataOutputStream)out).writeInt(Theme.tabInsets.right);
            ((DataOutputStream)out).writeInt(Theme.tabAreaInsets.top);
            ((DataOutputStream)out).writeInt(Theme.tabAreaInsets.left);
            ((DataOutputStream)out).writeInt(Theme.tabAreaInsets.bottom);
            ((DataOutputStream)out).writeInt(Theme.tabAreaInsets.right);
            ((DataOutputStream)out).writeBoolean(sliderRolloverEnabled.getValue());
            ((DataOutputStream)out).writeBoolean(sliderFocusEnabled.getValue());
            sliderThumbColor.save((DataOutputStream)out);
            sliderThumbRolloverColor.save((DataOutputStream)out);
            sliderThumbPressedColor.save((DataOutputStream)out);
            sliderThumbDisabledColor.save((DataOutputStream)out);
            sliderBorderColor.save((DataOutputStream)out);
            sliderDarkColor.save((DataOutputStream)out);
            sliderLightColor.save((DataOutputStream)out);
            sliderBorderDisabledColor.save((DataOutputStream)out);
            sliderTrackColor.save((DataOutputStream)out);
            sliderTrackBorderColor.save((DataOutputStream)out);
            sliderTrackDarkColor.save((DataOutputStream)out);
            sliderTrackLightColor.save((DataOutputStream)out);
            sliderTickColor.save((DataOutputStream)out);
            sliderTickDisabledColor.save((DataOutputStream)out);
            sliderFocusColor.save((DataOutputStream)out);
            ((DataOutputStream)out).writeBoolean(spinnerRollover.getValue());
            spinnerButtColor.save((DataOutputStream)out);
            spinnerButtRolloverColor.save((DataOutputStream)out);
            spinnerButtPressedColor.save((DataOutputStream)out);
            spinnerButtDisabledColor.save((DataOutputStream)out);
            ((DataOutputStream)out).writeInt(spinnerSpreadLight.getValue());
            ((DataOutputStream)out).writeInt(spinnerSpreadDark.getValue());
            ((DataOutputStream)out).writeInt(spinnerSpreadLightDisabled.getValue());
            ((DataOutputStream)out).writeInt(spinnerSpreadDarkDisabled.getValue());
            spinnerBorderColor.save((DataOutputStream)out);
            spinnerBorderDisabledColor.save((DataOutputStream)out);
            spinnerArrowColor.save((DataOutputStream)out);
            spinnerArrowDisabledColor.save((DataOutputStream)out);
            comboBorderColor.save((DataOutputStream)out);
            comboBorderDisabledColor.save((DataOutputStream)out);
            comboSelectedBgColor.save((DataOutputStream)out);
            comboSelectedTextColor.save((DataOutputStream)out);
            comboFocusBgColor.save((DataOutputStream)out);
            comboBgColor.save((DataOutputStream)out);
            comboTextColor.save((DataOutputStream)out);
            comboButtColor.save((DataOutputStream)out);
            comboButtRolloverColor.save((DataOutputStream)out);
            comboButtPressedColor.save((DataOutputStream)out);
            comboButtDisabledColor.save((DataOutputStream)out);
            ((DataOutputStream)out).writeInt(comboSpreadLight.getValue());
            ((DataOutputStream)out).writeInt(comboSpreadDark.getValue());
            ((DataOutputStream)out).writeInt(comboSpreadLightDisabled.getValue());
            ((DataOutputStream)out).writeInt(comboSpreadDarkDisabled.getValue());
            comboButtBorderColor.save((DataOutputStream)out);
            comboButtBorderDisabledColor.save((DataOutputStream)out);
            comboArrowColor.save((DataOutputStream)out);
            comboArrowDisabledColor.save((DataOutputStream)out);
            ((DataOutputStream)out).writeInt(Theme.comboInsets.top);
            ((DataOutputStream)out).writeInt(Theme.comboInsets.left);
            ((DataOutputStream)out).writeInt(Theme.comboInsets.bottom);
            ((DataOutputStream)out).writeInt(Theme.comboInsets.right);
            ((DataOutputStream)out).writeBoolean(comboRollover.getValue());
            ((DataOutputStream)out).writeBoolean(comboFocus.getValue());
            menuBarColor.save((DataOutputStream)out);
            menuItemSelectedTextColor.save((DataOutputStream)out);
            menuPopupColor.save((DataOutputStream)out);
            menuRolloverBgColor.save((DataOutputStream)out);
            menuItemRolloverColor.save((DataOutputStream)out);
            menuBorderColor.save((DataOutputStream)out);
            menuIconColor.save((DataOutputStream)out);
            menuIconRolloverColor.save((DataOutputStream)out);
            menuIconDisabledColor.save((DataOutputStream)out);
            menuSeparatorColor.save((DataOutputStream)out);
            ((DataOutputStream)out).writeBoolean(menuRollover.getValue());
            menuInnerHilightColor.save((DataOutputStream)out);
            menuInnerShadowColor.save((DataOutputStream)out);
            menuOuterHilightColor.save((DataOutputStream)out);
            menuOuterShadowColor.save((DataOutputStream)out);
            menuRolloverFgColor.save((DataOutputStream)out);
            menuDisabledFgColor.save((DataOutputStream)out);
            menuItemDisabledFgColor.save((DataOutputStream)out);
            ((DataOutputStream)out).writeBoolean(menuPopupShadow.getValue());
            ((DataOutputStream)out).writeBoolean(menuAllowTwoIcons.getValue());
            toolBarColor.save((DataOutputStream)out);
            toolBarLightColor.save((DataOutputStream)out);
            toolBarDarkColor.save((DataOutputStream)out);
            toolButtColor.save((DataOutputStream)out);
            toolButtRolloverColor.save((DataOutputStream)out);
            toolButtPressedColor.save((DataOutputStream)out);
            toolButtSelectedColor.save((DataOutputStream)out);
            toolBorderColor.save((DataOutputStream)out);
            toolBorderRolloverColor.save((DataOutputStream)out);
            toolBorderPressedColor.save((DataOutputStream)out);
            toolBorderSelectedColor.save((DataOutputStream)out);
            ((DataOutputStream)out).writeBoolean(toolRollover.getValue());
            ((DataOutputStream)out).writeBoolean(toolFocus.getValue());
            toolGripDarkColor.save((DataOutputStream)out);
            toolGripLightColor.save((DataOutputStream)out);
            toolSeparatorColor.save((DataOutputStream)out);
            ((DataOutputStream)out).writeInt(Theme.toolMargin.top);
            ((DataOutputStream)out).writeInt(Theme.toolMargin.left);
            ((DataOutputStream)out).writeInt(Theme.toolMargin.bottom);
            ((DataOutputStream)out).writeInt(Theme.toolMargin.right);
            listSelectedBgColor.save((DataOutputStream)out);
            listSelectedTextColor.save((DataOutputStream)out);
            listBgColor.save((DataOutputStream)out);
            listTextColor.save((DataOutputStream)out);
            listFocusBorderColor.save((DataOutputStream)out);
            treeBgColor.save((DataOutputStream)out);
            treeTextColor.save((DataOutputStream)out);
            treeTextBgColor.save((DataOutputStream)out);
            treeSelectedTextColor.save((DataOutputStream)out);
            treeSelectedBgColor.save((DataOutputStream)out);
            treeLineColor.save((DataOutputStream)out);
            frameCaptionColor.save((DataOutputStream)out);
            frameCaptionDisabledColor.save((DataOutputStream)out);
            frameBorderColor.save((DataOutputStream)out);
            frameLightColor.save((DataOutputStream)out);
            frameBorderDisabledColor.save((DataOutputStream)out);
            frameLightDisabledColor.save((DataOutputStream)out);
            frameTitleColor.save((DataOutputStream)out);
            frameTitleShadowColor.save((DataOutputStream)out);
            frameTitleDisabledColor.save((DataOutputStream)out);
            frameButtColor.save((DataOutputStream)out);
            frameButtRolloverColor.save((DataOutputStream)out);
            frameButtPressedColor.save((DataOutputStream)out);
            frameButtDisabledColor.save((DataOutputStream)out);
            ((DataOutputStream)out).writeInt(frameButtSpreadDark.getValue());
            ((DataOutputStream)out).writeInt(frameButtSpreadLight.getValue());
            ((DataOutputStream)out).writeInt(frameButtSpreadDarkDisabled.getValue());
            ((DataOutputStream)out).writeInt(frameButtSpreadLightDisabled.getValue());
            frameButtCloseColor.save((DataOutputStream)out);
            frameButtCloseRolloverColor.save((DataOutputStream)out);
            frameButtClosePressedColor.save((DataOutputStream)out);
            frameButtCloseDisabledColor.save((DataOutputStream)out);
            ((DataOutputStream)out).writeInt(frameButtCloseSpreadDark.getValue());
            ((DataOutputStream)out).writeInt(frameButtCloseSpreadLight.getValue());
            ((DataOutputStream)out).writeInt(frameButtCloseSpreadDarkDisabled.getValue());
            ((DataOutputStream)out).writeInt(frameButtCloseSpreadLightDisabled.getValue());
            frameButtBorderColor.save((DataOutputStream)out);
            frameButtBorderDisabledColor.save((DataOutputStream)out);
            frameSymbolColor.save((DataOutputStream)out);
            frameSymbolPressedColor.save((DataOutputStream)out);
            frameSymbolDisabledColor.save((DataOutputStream)out);
            frameSymbolDarkColor.save((DataOutputStream)out);
            frameSymbolLightColor.save((DataOutputStream)out);
            frameSymbolDarkDisabledColor.save((DataOutputStream)out);
            frameSymbolLightDisabledColor.save((DataOutputStream)out);
            frameButtCloseBorderColor.save((DataOutputStream)out);
            frameButtCloseDarkColor.save((DataOutputStream)out);
            frameButtCloseLightColor.save((DataOutputStream)out);
            frameButtCloseBorderDisabledColor.save((DataOutputStream)out);
            frameSymbolCloseColor.save((DataOutputStream)out);
            frameSymbolClosePressedColor.save((DataOutputStream)out);
            frameSymbolCloseDisabledColor.save((DataOutputStream)out);
            frameSymbolCloseDarkColor.save((DataOutputStream)out);
            frameSymbolCloseDarkDisabledColor.save((DataOutputStream)out);
            ((DataOutputStream)out).writeInt(frameSpreadDark.getValue());
            ((DataOutputStream)out).writeInt(frameSpreadLight.getValue());
            ((DataOutputStream)out).writeInt(frameSpreadDarkDisabled.getValue());
            ((DataOutputStream)out).writeInt(frameSpreadLightDisabled.getValue());
            tableBackColor.save((DataOutputStream)out);
            tableHeaderBackColor.save((DataOutputStream)out);
            tableHeaderArrowColor.save((DataOutputStream)out);
            tableHeaderRolloverBackColor.save((DataOutputStream)out);
            tableHeaderRolloverColor.save((DataOutputStream)out);
            tableGridColor.save((DataOutputStream)out);
            tableSelectedBackColor.save((DataOutputStream)out);
            tableSelectedForeColor.save((DataOutputStream)out);
            tableBorderDarkColor.save((DataOutputStream)out);
            tableBorderLightColor.save((DataOutputStream)out);
            tableHeaderDarkColor.save((DataOutputStream)out);
            tableHeaderLightColor.save((DataOutputStream)out);
            tableFocusBorderColor.save((DataOutputStream)out);
            tableAlternateRowColor.save((DataOutputStream)out);
            for (i = false; i < colorizer.length; i += 1) {
                colorizer[i].save((DataOutputStream)out);
                ((DataOutputStream)out).writeBoolean(colorize[i].getValue());
            }
            separatorColor.save((DataOutputStream)out);
            tipBorderColor.save((DataOutputStream)out);
            tipBgColor.save((DataOutputStream)out);
            tipBorderDis.save((DataOutputStream)out);
            tipBgDis.save((DataOutputStream)out);
            tipTextColor.save((DataOutputStream)out);
            tipTextDis.save((DataOutputStream)out);
            titledBorderColor.save((DataOutputStream)out);
            splitPaneButtonColor.save((DataOutputStream)out);
            splitPaneHightlight.save((DataOutputStream)out);
            splitPaneDarkShadow.save((DataOutputStream)out);
            i = true;
            return i;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    static {
        colorizer = new HSBReference[20];
        colorize = new BooleanReference[20];
        Theme.initData();
    }
}

