/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyLookAndFeel;
import de.muntjak.tinylookandfeel.util.ColorRoutines;
import de.muntjak.tinylookandfeel.util.DrawRoutines;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalCheckBoxIcon;
import javax.swing.table.TableCellRenderer;

public class TinyCheckBoxIcon
extends MetalCheckBoxIcon {
    private static final HashMap cache = new HashMap();
    private static int checkSize = 13;
    private static final int[][] a = new int[][]{{255, 255, 255, 242, 228, 209, 187, 165, 142, 120, 104}, {255, 255, 242, 228, 209, 187, 165, 142, 120, 104, 86}, {255, 242, 228, 209, 187, 165, 142, 120, 104, 86, 72}, {242, 228, 209, 187, 165, 142, 120, 104, 86, 72, 56}, {228, 209, 187, 165, 142, 120, 104, 86, 72, 56, 42}, {209, 187, 165, 142, 120, 104, 86, 72, 56, 42, 28}, {187, 165, 142, 120, 104, 86, 72, 56, 42, 28, 17}, {165, 142, 120, 104, 86, 72, 56, 42, 28, 17, 9}, {142, 120, 104, 86, 72, 56, 42, 28, 17, 9, 0}, {120, 104, 86, 72, 56, 42, 28, 17, 9, 0, 0}, {104, 86, 72, 56, 42, 28, 17, 9, 0, 0, 0}};

    public static void clearCache() {
        cache.clear();
    }

    @Override
    protected int getControlSize() {
        return this.getIconWidth();
    }

    private void paintFlatCheck(JCheckBox cb, Graphics g, int x, int y) {
        if (cb.isSelected()) {
            if (!cb.isEnabled()) {
                g.setColor(Theme.buttonCheckDisabledColor.getColor());
            } else {
                g.setColor(Theme.buttonCheckColor.getColor());
            }
            this.drawXpCheckMark(g, x, y);
        }
        g.setColor(Theme.buttonBorderColor.getColor());
        g.drawRect(x, y, checkSize - 1, checkSize - 1);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        JCheckBox cb = (JCheckBox)c;
        Container parent = cb.getParent();
        if (cb.isBorderPaintedFlat() || cb instanceof TableCellRenderer || parent instanceof JTable) {
            this.paintFlatCheck(cb, g, x, y);
            return;
        }
        ColorUIResource col = null;
        col = !cb.isEnabled() ? Theme.buttonDisabledColor.getColor() : (cb.getModel().isPressed() ? (cb.getModel().isRollover() ? Theme.buttonPressedColor.getColor() : Theme.buttonNormalColor.getColor()) : (cb.getModel().isRollover() ? Theme.buttonRolloverBgColor.getColor() : Theme.buttonNormalColor.getColor()));
        g.setColor(col);
        if (TinyLookAndFeel.controlPanelInstantiated) {
            this.drawXpCheckNoCache(g, cb, col, x, y, this.getIconWidth(), this.getIconHeight());
        } else {
            this.drawXpCheck(g, cb, col, x, y, this.getIconWidth(), this.getIconHeight());
        }
        if (!cb.isSelected()) {
            return;
        }
        if (!cb.isEnabled()) {
            g.setColor(Theme.buttonCheckDisabledColor.getColor());
        } else {
            g.setColor(Theme.buttonCheckColor.getColor());
        }
        this.drawXpCheckMark(g, x, y);
    }

    private void drawXpCheck(Graphics g, AbstractButton b, Color c, int x, int y, int w, int h) {
        boolean focused;
        boolean rollover;
        boolean pressed = b.getModel().isPressed();
        boolean armed = b.getModel().isArmed();
        boolean enabled = b.isEnabled();
        CheckKey key = new CheckKey(c, pressed, enabled, (rollover = b.getModel().isRollover()) || armed, focused = Theme.buttonFocusBorder.getValue() && !rollover && b.isFocusOwner());
        Object value = cache.get(key);
        if (value != null) {
            g.drawImage((Image)value, x, y, b);
            return;
        }
        BufferedImage img = new BufferedImage(w, h, 2);
        Graphics imgGraphics = ((Image)img).getGraphics();
        int spread1 = Theme.buttonSpreadLight.getValue();
        int spread2 = Theme.buttonSpreadDark.getValue();
        if (!b.isEnabled()) {
            spread1 = Theme.buttonSpreadLightDisabled.getValue();
            spread2 = Theme.buttonSpreadDarkDisabled.getValue();
        }
        int spreadStep1 = spread1 * 5;
        int spreadStep2 = spread2 * 4;
        if (pressed && (rollover || armed)) {
            spreadStep2 *= 2;
        }
        c = ColorRoutines.lighten(c, spreadStep1);
        imgGraphics.setColor(ColorRoutines.darken(c, spreadStep2));
        imgGraphics.fillRect(1, 1, w - 2, h - 2);
        for (int row = 0; row < 11; ++row) {
            for (int col = 0; col < 11; ++col) {
                Color color = new Color(c.getRed(), c.getGreen(), c.getBlue(), 255 - a[col][row]);
                imgGraphics.setColor(color);
                imgGraphics.drawLine(col + 1, row + 1, col + 1, row + 1);
            }
        }
        if (!b.isEnabled()) {
            imgGraphics.setColor(Theme.buttonBorderDisabledColor.getColor());
            imgGraphics.drawRect(0, 0, w - 1, h - 1);
        } else {
            imgGraphics.setColor(Theme.buttonBorderColor.getColor());
            imgGraphics.drawRect(0, 0, w - 1, h - 1);
            if (rollover && Theme.buttonRolloverBorder.getValue() && !pressed) {
                DrawRoutines.drawRolloverCheckBorder(imgGraphics, Theme.buttonRolloverColor.getColor(), 0, 0, w, h);
            } else if (focused && !pressed) {
                DrawRoutines.drawRolloverCheckBorder(imgGraphics, Theme.buttonDefaultColor.getColor(), 0, 0, w, h);
            }
        }
        imgGraphics.dispose();
        g.drawImage(img, x, y, b);
        cache.put(key, img);
    }

    private void drawXpCheckNoCache(Graphics g, AbstractButton b, Color c, int x, int y, int w, int h) {
        boolean pressed = b.getModel().isPressed();
        boolean armed = b.getModel().isArmed();
        boolean enabled = b.isEnabled();
        boolean rollover = b.getModel().isRollover();
        boolean focused = Theme.buttonFocusBorder.getValue() && !rollover && b.isFocusOwner();
        boolean useCachedImage = !pressed && !armed && !rollover && !focused;
        BufferedImage img = null;
        Object key = null;
        if (useCachedImage) {
            key = enabled ? new EnabledCheckKey(c, Theme.buttonBorderColor.getColor()) : new DisabledCheckKey(c, Theme.buttonBorderDisabledColor.getColor());
            Object value = cache.get(key);
            if (value != null) {
                g.drawImage((Image)value, x, y, b);
                return;
            }
            img = new BufferedImage(w, h, 2);
        }
        int spread1 = Theme.buttonSpreadLight.getValue();
        int spread2 = Theme.buttonSpreadDark.getValue();
        if (!enabled) {
            spread1 = Theme.buttonSpreadLightDisabled.getValue();
            spread2 = Theme.buttonSpreadDarkDisabled.getValue();
        }
        int spreadStep1 = spread1 * 5;
        int spreadStep2 = spread2 * 4;
        if (pressed && (rollover || armed)) {
            spreadStep2 *= 2;
        }
        c = ColorRoutines.lighten(c, spreadStep1);
        Graphics graphics = null;
        int bx = x;
        int by = y;
        if (img != null) {
            graphics = ((Image)img).getGraphics();
            Color bg = b.getBackground();
            if (!b.isOpaque()) {
                Container parent;
                bg = parent.getBackground();
                for (parent = b.getParent(); parent != null && !parent.isOpaque(); parent = parent.getParent()) {
                    bg = parent.getBackground();
                }
            }
            graphics.setColor(bg);
            graphics.fillRect(0, 0, w - 1, h - 1);
            bx = 0;
            by = 0;
        } else {
            graphics = g;
            graphics.translate(x, y);
        }
        graphics.setColor(ColorRoutines.darken(c, spreadStep2));
        graphics.fillRect(1, 1, w - 2, h - 2);
        for (int row = 0; row < 11; ++row) {
            for (int col = 0; col < 11; ++col) {
                Color color = new Color(c.getRed(), c.getGreen(), c.getBlue(), 255 - a[col][row]);
                graphics.setColor(color);
                graphics.drawLine(col + 1, row + 1, col + 1, row + 1);
            }
        }
        if (img == null) {
            graphics.translate(-x, -y);
        }
        if (!enabled) {
            graphics.setColor(Theme.buttonBorderDisabledColor.getColor());
            graphics.drawRect(bx, by, w - 1, h - 1);
        } else {
            graphics.setColor(Theme.buttonBorderColor.getColor());
            graphics.drawRect(bx, by, w - 1, h - 1);
            if (rollover && Theme.buttonRolloverBorder.getValue() && !pressed) {
                DrawRoutines.drawRolloverCheckBorder(graphics, Theme.buttonRolloverColor.getColor(), bx, by, w, h);
            } else if (focused && !pressed) {
                DrawRoutines.drawRolloverCheckBorder(graphics, Theme.buttonDefaultColor.getColor(), bx, by, w, h);
            }
        }
        if (img != null) {
            graphics.dispose();
            g.drawImage(img, x, y, b);
            cache.put(key, img);
        }
    }

    private void drawXpCheckMark(Graphics g, int x, int y) {
        g.drawLine(x + 3, y + 5, x + 3, y + 7);
        g.drawLine(x + 4, y + 6, x + 4, y + 8);
        g.drawLine(x + 5, y + 7, x + 5, y + 9);
        g.drawLine(x + 6, y + 6, x + 6, y + 8);
        g.drawLine(x + 7, y + 5, x + 7, y + 7);
        g.drawLine(x + 8, y + 4, x + 8, y + 6);
        g.drawLine(x + 9, y + 3, x + 9, y + 5);
    }

    @Override
    public int getIconWidth() {
        return checkSize;
    }

    @Override
    public int getIconHeight() {
        return checkSize;
    }

    private static class CheckKey {
        private Color c;
        private boolean pressed;
        private boolean enabled;
        private boolean rollover;
        private boolean focused;

        CheckKey(Color c, boolean pressed, boolean enabled, boolean rollover, boolean focused) {
            this.c = c;
            this.pressed = pressed;
            this.enabled = enabled;
            this.rollover = rollover;
            this.focused = focused;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof CheckKey)) {
                return false;
            }
            CheckKey other = (CheckKey)o;
            return this.pressed == other.pressed && this.enabled == other.enabled && this.rollover == other.rollover && this.focused == other.focused && this.c.equals(other.c);
        }

        public int hashCode() {
            return this.c.hashCode() * (this.pressed ? 1 : 2) * (this.enabled ? 4 : 8) * (this.rollover ? 16 : 32);
        }
    }

    private static class DisabledCheckKey {
        int spread1 = Theme.buttonSpreadLightDisabled.getValue();
        int spread2 = Theme.buttonSpreadDarkDisabled.getValue();
        Color c;
        Color back;

        DisabledCheckKey(Color c, Color back) {
            this.c = c;
            this.back = back;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof DisabledCheckKey)) {
                return false;
            }
            DisabledCheckKey other = (DisabledCheckKey)o;
            return this.c.equals(other.c) && this.back.equals(other.back) && this.spread1 == other.spread1 && this.spread2 == other.spread2;
        }

        public int hashCode() {
            return this.c.hashCode() * this.back.hashCode() * this.spread1 * this.spread2;
        }
    }

    private static class EnabledCheckKey {
        int spread1 = Theme.buttonSpreadLight.getValue();
        int spread2 = Theme.buttonSpreadDark.getValue();
        Color c;
        Color back;

        EnabledCheckKey(Color c, Color back) {
            this.c = c;
            this.back = back;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof EnabledCheckKey)) {
                return false;
            }
            EnabledCheckKey other = (EnabledCheckKey)o;
            return this.c.equals(other.c) && this.back.equals(other.back) && this.spread1 == other.spread1 && this.spread2 == other.spread2;
        }

        public int hashCode() {
            return this.c.hashCode() * this.back.hashCode() * this.spread1 * this.spread2;
        }
    }
}

