/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.TinyMenuItemUI;
import de.muntjak.tinylookandfeel.TinyUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyEventPostProcessor;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.ComboPopup;

public class TinyMenuUI
extends TinyMenuItemUI {
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    static final String IS_SYSTEM_MENU_KEY = "isSystemMenu";
    static final AltProcessor ALT_PROCESSOR = new AltProcessor();
    protected ChangeListener changeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected MenuListener menuListener;
    private int lastMnemonic = 0;
    static boolean systemMenuShowing = false;
    private static boolean crossMenuMnemonic = true;
    private static MenuListener sharedMenuListener;

    public static ComponentUI createUI(JComponent x) {
        return new TinyMenuUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        ((JMenu)this.menuItem).setDelay(200);
        crossMenuMnemonic = UIManager.getBoolean("Menu.crossMenuMnemonic");
    }

    @Override
    ActionMap getActionMap() {
        return this.createActionMap();
    }

    @Override
    ActionMap createActionMap() {
        ActionMap am = super.createActionMap();
        if (am != null) {
            am.put("selectMenu", new PostAction((JMenu)this.menuItem, true));
        }
        return am;
    }

    @Override
    protected String getPropertyPrefix() {
        return "Menu";
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (this.changeListener == null) {
            this.changeListener = this.createChangeListener(this.menuItem);
        }
        if (this.changeListener != null) {
            this.menuItem.addChangeListener(this.changeListener);
        }
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        }
        if (TinyUtils.is1dot4() && (this.menuKeyListener = this.createMenuKeyListener(this.menuItem)) != null) {
            this.menuItem.addMenuKeyListener(this.menuKeyListener);
        }
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.updateMnemonicBinding();
    }

    void updateMnemonicBinding() {
        int i;
        int mnemonic = this.menuItem.getModel().getMnemonic();
        int[] shortcutKeys = (int[])UIManager.get("Menu.shortcutKeys");
        if (mnemonic == this.lastMnemonic || shortcutKeys == null) {
            return;
        }
        if (this.lastMnemonic != 0 && this.windowInputMap != null) {
            for (i = 0; i < shortcutKeys.length; ++i) {
                this.windowInputMap.remove(KeyStroke.getKeyStroke(this.lastMnemonic, shortcutKeys[i], false));
            }
        }
        if (mnemonic != 0) {
            if (this.windowInputMap == null) {
                this.windowInputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.windowInputMap);
            }
            for (i = 0; i < shortcutKeys.length; ++i) {
                this.windowInputMap.put(KeyStroke.getKeyStroke(mnemonic, shortcutKeys[i], false), "selectMenu");
            }
        }
        this.lastMnemonic = mnemonic;
    }

    @Override
    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new MouseInputHandler();
    }

    protected ChangeListener createChangeListener(JComponent c) {
        return null;
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener(JComponent c) {
        return new PropertyChangeHandler();
    }

    @Override
    protected void uninstallDefaults() {
        this.menuItem.setArmed(false);
        this.menuItem.setSelected(false);
        this.menuItem.resetKeyboardActions();
        super.uninstallDefaults();
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.changeListener != null) {
            this.menuItem.removeChangeListener(this.changeListener);
            this.changeListener = null;
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        if (this.menuKeyListener != null) {
            this.menuItem.removeMenuKeyListener(this.menuKeyListener);
            this.menuKeyListener = null;
        }
    }

    @Override
    protected MenuDragMouseListener createMenuDragMouseListener(JComponent c) {
        return new MenuDragMouseHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent c) {
        return new MenuKeyHandler();
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        if (((JMenu)this.menuItem).isTopLevelMenu()) {
            Dimension d = c.getPreferredSize();
            return new Dimension(d.width, Short.MAX_VALUE);
        }
        return null;
    }

    protected void setupPostTimer(JMenu menu) {
        Timer timer = new Timer(menu.getDelay(), new PostAction(menu, false));
        timer.setRepeats(false);
        timer.start();
    }

    private static void appendPath(MenuElement[] path, MenuElement elem) {
        MenuElement[] newPath = new MenuElement[path.length + 1];
        System.arraycopy(path, 0, newPath, 0, path.length);
        newPath[path.length] = elem;
        MenuSelectionManager.defaultManager().setSelectedPath(newPath);
    }

    static JPopupMenu getActivePopupMenu() {
        MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
        for (int i = path.length - 1; i >= 0; --i) {
            MenuElement elem = path[i];
            if (!(elem instanceof JPopupMenu)) continue;
            return (JPopupMenu)elem;
        }
        return null;
    }

    static class AltProcessor
    implements KeyEventPostProcessor {
        static boolean altKeyPressed = false;
        static boolean menuCanceledOnPress = false;
        static JRootPane root = null;
        static Window winAncestor = null;

        AltProcessor() {
        }

        void altPressed(KeyEvent ev) {
            MenuSelectionManager msm = MenuSelectionManager.defaultManager();
            MenuElement[] path = msm.getSelectedPath();
            if (path.length > 0 && !(path[0] instanceof ComboPopup)) {
                msm.clearSelectedPath();
                menuCanceledOnPress = true;
                ev.consume();
            } else if (path.length > 0) {
                menuCanceledOnPress = false;
                ev.consume();
            } else {
                JMenu menu;
                JMenuBar mbar;
                menuCanceledOnPress = false;
                JMenuBar jMenuBar = mbar = root != null ? root.getJMenuBar() : null;
                if (mbar == null && winAncestor instanceof JFrame) {
                    mbar = ((JFrame)winAncestor).getJMenuBar();
                }
                JMenu jMenu = menu = mbar != null ? mbar.getMenu(0) : null;
                if (menu != null) {
                    ev.consume();
                }
            }
        }

        void altReleased(KeyEvent ev) {
            if (menuCanceledOnPress) {
                return;
            }
            MenuSelectionManager msm = MenuSelectionManager.defaultManager();
            if (msm.getSelectedPath().length == 0) {
                JMenu menu;
                JMenuBar mbar;
                JMenuBar jMenuBar = mbar = root != null ? root.getJMenuBar() : null;
                if (mbar == null && winAncestor instanceof JFrame) {
                    mbar = ((JFrame)winAncestor).getJMenuBar();
                }
                JMenu jMenu = menu = mbar != null ? mbar.getMenu(0) : null;
                if (menu != null) {
                    MenuElement[] path = new MenuElement[]{mbar, menu};
                    msm.setSelectedPath(path);
                }
            }
        }

        @Override
        public boolean postProcessKeyEvent(KeyEvent ev) {
            if (ev.getKeyCode() == 18) {
                root = SwingUtilities.getRootPane(ev.getComponent());
                if (root != null) {
                    winAncestor = SwingUtilities.getWindowAncestor(root);
                    if (ev.getID() == 401) {
                        if (!altKeyPressed) {
                            this.altPressed(ev);
                        }
                        altKeyPressed = true;
                        return true;
                    }
                    if (ev.getID() == 402) {
                        if (altKeyPressed) {
                            this.altReleased(ev);
                        }
                        altKeyPressed = false;
                    }
                }
            } else {
                altKeyPressed = false;
            }
            return false;
        }
    }

    private class MenuKeyHandler
    implements MenuKeyListener {
        private int[] indexes;
        private char lastMnemonic;
        private int lastIndex;
        private int matches;

        private MenuKeyHandler() {
        }

        @Override
        public void menuKeyTyped(MenuKeyEvent e) {
            JPopupMenu pm;
            if (TinyMenuUI.this.menuItem == null) {
                return;
            }
            if (!crossMenuMnemonic && (pm = TinyMenuUI.getActivePopupMenu()) != null && pm != TinyMenuUI.this.menuItem.getParent()) {
                return;
            }
            int key = TinyMenuUI.this.menuItem.getMnemonic();
            if (key == 0) {
                return;
            }
            MenuElement[] path = e.getPath();
            if (this.lower((char)key) == this.lower(e.getKeyChar())) {
                JPopupMenu popupMenu = ((JMenu)TinyMenuUI.this.menuItem).getPopupMenu();
                MenuElement[] sub = popupMenu.getSubElements();
                if (sub.length > 0) {
                    MenuSelectionManager manager = e.getMenuSelectionManager();
                    MenuElement[] newPath = new MenuElement[path.length + 2];
                    System.arraycopy(path, 0, newPath, 0, path.length);
                    newPath[path.length] = popupMenu;
                    newPath[path.length + 1] = sub[0];
                    manager.setSelectedPath(newPath);
                }
                e.consume();
            }
        }

        @Override
        public void menuKeyPressed(MenuKeyEvent e) {
            if (TinyMenuUI.this.menuItem == null) {
                return;
            }
            char keyChar = e.getKeyChar();
            if (!Character.isLetterOrDigit(keyChar)) {
                return;
            }
            MenuSelectionManager manager = e.getMenuSelectionManager();
            MenuElement[] path = e.getPath();
            MenuElement[] selectedPath = manager.getSelectedPath();
            for (int i = selectedPath.length - 1; i >= 0; --i) {
                if (selectedPath[i] != TinyMenuUI.this.menuItem) continue;
                JPopupMenu popupMenu = ((JMenu)TinyMenuUI.this.menuItem).getPopupMenu();
                MenuElement[] items = popupMenu.getSubElements();
                if (this.indexes == null || this.lastMnemonic != keyChar) {
                    this.matches = 0;
                    this.lastIndex = 0;
                    this.indexes = new int[items.length];
                    for (int j = 0; j < items.length; ++j) {
                        int key = ((JMenuItem)items[j]).getMnemonic();
                        if (this.lower((char)key) != this.lower(keyChar)) continue;
                        this.indexes[this.matches++] = j;
                    }
                    this.lastMnemonic = keyChar;
                }
                if (this.matches != 0) {
                    if (this.matches == 1) {
                        JMenuItem item = (JMenuItem)items[this.indexes[0]];
                        if (!(item instanceof JMenu)) {
                            manager.clearSelectedPath();
                            item.doClick();
                        }
                    } else {
                        if (this.lastIndex == this.matches) {
                            this.lastIndex = 0;
                        }
                        MenuElement menuItem = items[this.indexes[this.lastIndex++]];
                        MenuElement[] newPath = new MenuElement[path.length + 2];
                        System.arraycopy(path, 0, newPath, 0, path.length);
                        newPath[path.length] = popupMenu;
                        newPath[path.length + 1] = menuItem;
                        manager.setSelectedPath(newPath);
                    }
                }
                e.consume();
                return;
            }
        }

        @Override
        public void menuKeyReleased(MenuKeyEvent e) {
        }

        private char lower(char keyChar) {
            return Character.toLowerCase(keyChar);
        }
    }

    private static class MenuHandler
    implements MenuListener {
        private MenuHandler() {
        }

        @Override
        public void menuSelected(MenuEvent e) {
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
            JMenu m = (JMenu)e.getSource();
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            if (manager.isComponentPartOfCurrentMenu(m)) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        private MenuDragMouseHandler() {
        }

        @Override
        public void menuDragMouseEntered(MenuDragMouseEvent e) {
        }

        @Override
        public void menuDragMouseDragged(MenuDragMouseEvent e) {
            Component comp;
            if (!TinyMenuUI.this.menuItem.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = e.getMenuSelectionManager();
            MenuElement[] path = e.getPath();
            Point p = e.getPoint();
            if (p.x >= 0 && p.x < TinyMenuUI.this.menuItem.getWidth() && p.y >= 0 && p.y < TinyMenuUI.this.menuItem.getHeight()) {
                JMenu menu = (JMenu)TinyMenuUI.this.menuItem;
                MenuElement[] selectedPath = manager.getSelectedPath();
                if (selectedPath.length <= 0 || selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
                    if (menu.isTopLevelMenu() || menu.getDelay() == 0 || e.getID() == 506) {
                        TinyMenuUI.appendPath(path, menu.getPopupMenu());
                    } else {
                        manager.setSelectedPath(path);
                        TinyMenuUI.this.setupPostTimer(menu);
                    }
                }
            } else if (e.getID() == 502 && (comp = manager.componentForPoint(e.getComponent(), e.getPoint())) == null) {
                manager.clearSelectedPath();
            }
        }

        @Override
        public void menuDragMouseExited(MenuDragMouseEvent e) {
        }

        @Override
        public void menuDragMouseReleased(MenuDragMouseEvent e) {
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            MenuElement[] selectedPath;
            JMenu menu = (JMenu)TinyMenuUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            if (menu.isTopLevelMenu()) {
                if (menu.isSelected()) {
                    manager.clearSelectedPath();
                } else {
                    Container cnt = menu.getParent();
                    if (cnt != null && cnt instanceof JMenuBar) {
                        MenuElement[] me = new MenuElement[]{(MenuElement)((Object)cnt), menu};
                        manager.setSelectedPath(me);
                    }
                }
            }
            if ((selectedPath = manager.getSelectedPath()).length > 0 && selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
                if (menu.isTopLevelMenu() || menu.getDelay() == 0) {
                    TinyMenuUI.appendPath(selectedPath, menu.getPopupMenu());
                } else {
                    TinyMenuUI.this.setupPostTimer(menu);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            JMenu menu = (JMenu)TinyMenuUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
            if (!e.isConsumed()) {
                manager.clearSelectedPath();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JMenu menu = (JMenu)TinyMenuUI.this.menuItem;
            if (!menu.isEnabled() || systemMenuShowing || menu.getClientProperty(TinyMenuUI.IS_SYSTEM_MENU_KEY) == Boolean.TRUE) {
                return;
            }
            menu.putClientProperty("rollover", Boolean.TRUE);
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            MenuElement[] selectedPath = manager.getSelectedPath();
            if (!menu.isTopLevelMenu()) {
                if (selectedPath.length <= 0 || selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
                    if (menu.getDelay() == 0) {
                        TinyMenuUI.appendPath(TinyMenuUI.this.getPath(), menu.getPopupMenu());
                    } else {
                        manager.setSelectedPath(TinyMenuUI.this.getPath());
                        TinyMenuUI.this.setupPostTimer(menu);
                    }
                }
            } else if (selectedPath.length > 0 && selectedPath[0] == menu.getParent()) {
                MenuElement[] newPath = new MenuElement[]{(MenuElement)((Object)menu.getParent()), menu, menu.getPopupMenu()};
                manager.setSelectedPath(newPath);
            }
            if (menu.isTopLevelMenu()) {
                menu.repaint();
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JMenu menu = (JMenu)TinyMenuUI.this.menuItem;
            if (!menu.isEnabled() || systemMenuShowing || menu.getClientProperty(TinyMenuUI.IS_SYSTEM_MENU_KEY) == Boolean.TRUE) {
                return;
            }
            menu.putClientProperty("rollover", Boolean.FALSE);
            if (menu.isTopLevelMenu()) {
                menu.repaint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            JMenu menu = (JMenu)TinyMenuUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager.defaultManager().processMouseEvent(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop.equals("mnemonic")) {
                TinyMenuUI.this.updateMnemonicBinding();
            }
        }
    }

    private static class PostAction
    extends AbstractAction {
        JMenu menu;
        boolean force = false;

        PostAction(JMenu menu, boolean shouldForce) {
            this.menu = menu;
            this.force = shouldForce;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPopupMenu pm;
            if (!crossMenuMnemonic && (pm = TinyMenuUI.getActivePopupMenu()) != null && pm != this.menu.getParent()) {
                return;
            }
            MenuSelectionManager defaultManager = MenuSelectionManager.defaultManager();
            if (this.force) {
                Container cnt = this.menu.getParent();
                if (cnt != null && cnt instanceof JMenuBar) {
                    MenuElement[] subElements = this.menu.getPopupMenu().getSubElements();
                    MenuElement[] me = subElements.length > 0 ? new MenuElement[]{(MenuElement)((Object)cnt), this.menu, this.menu.getPopupMenu(), subElements[0]} : new MenuElement[]{(MenuElement)((Object)cnt), this.menu, this.menu.getPopupMenu()};
                    defaultManager.setSelectedPath(me);
                }
            } else {
                MenuElement[] path = defaultManager.getSelectedPath();
                if (path.length > 0 && path[path.length - 1] == this.menu) {
                    TinyMenuUI.appendPath(path, this.menu.getPopupMenu());
                }
            }
        }

        @Override
        public boolean isEnabled() {
            return this.menu.getModel().isEnabled();
        }
    }
}

