/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.util.ColorRoutines;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class TinyProgressBarUI
extends BasicProgressBarUI {
    private static final HashMap cache = new HashMap();
    private static final Dimension PREFERRED_YQ_HORIZONTAL = new Dimension(146, 7);
    private static final Dimension PREFERRED_YQ_VERTICAL = new Dimension(7, 146);

    public static void clearCache() {
        cache.clear();
    }

    @Override
    protected Dimension getPreferredInnerHorizontal() {
        return PREFERRED_YQ_HORIZONTAL;
    }

    @Override
    protected Dimension getPreferredInnerVertical() {
        return PREFERRED_YQ_VERTICAL;
    }

    public static ComponentUI createUI(JComponent c) {
        return new TinyProgressBarUI();
    }

    @Override
    protected void paintDeterminate(Graphics g, JComponent c) {
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        if (this.progressBar.getOrientation() == 0) {
            int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
            this.drawXpHorzProgress(g, b.left, b.top, barRectWidth, barRectHeight, amountFull);
            if (this.progressBar.isStringPainted()) {
                g.setFont(c.getFont());
                this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
            }
        } else {
            int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
            this.drawXpVertProgress(g, b.left, b.top, barRectWidth, barRectHeight, amountFull);
            if (this.progressBar.isStringPainted()) {
                g.setFont(c.getFont());
                this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
            }
        }
    }

    private void drawXpHorzProgress(Graphics g, int x, int y, int w, int h, int amountFull) {
        ProgressKey key;
        Object value;
        g.translate(x, y);
        if (!this.progressBar.isOpaque()) {
            g.setColor(this.progressBar.getBackground());
            g.fillRect(0, 0, w, h);
        }
        if ((value = cache.get(key = new ProgressKey(this.progressBar.getForeground(), true, h))) == null) {
            BufferedImage img = new BufferedImage(6, h, 2);
            Graphics imgGraphics = ((Image)img).getGraphics();
            Color c = this.progressBar.getForeground();
            Color c2 = ColorRoutines.lighten(c, 15);
            Color c3 = ColorRoutines.lighten(c, 35);
            Color c4 = ColorRoutines.lighten(c, 60);
            imgGraphics.setColor(c4);
            imgGraphics.drawLine(0, 0, 5, 0);
            imgGraphics.drawLine(0, h - 1, 5, h - 1);
            imgGraphics.setColor(c3);
            imgGraphics.drawLine(0, 1, 5, 1);
            imgGraphics.drawLine(0, h - 2, 5, h - 2);
            imgGraphics.setColor(c2);
            imgGraphics.drawLine(0, 2, 5, 2);
            imgGraphics.drawLine(0, h - 3, 5, h - 3);
            imgGraphics.setColor(c);
            imgGraphics.fillRect(0, 3, 6, h - 6);
            imgGraphics.dispose();
            cache.put(key, img);
            value = img;
        }
        for (int mx = 0; mx < amountFull; mx += 8) {
            if (mx + 6 > w) {
                g.drawImage((Image)value, mx, 0, w - mx, h, this.progressBar);
                continue;
            }
            g.drawImage((Image)value, mx, 0, this.progressBar);
        }
        g.translate(-x, -y);
    }

    private void drawXpVertProgress(Graphics g, int x, int y, int w, int h, int amountFull) {
        ProgressKey key;
        Object value;
        g.translate(x, y);
        if (!this.progressBar.isOpaque()) {
            g.setColor(this.progressBar.getBackground());
            g.fillRect(0, 0, w, h);
        }
        if ((value = cache.get(key = new ProgressKey(this.progressBar.getForeground(), false, w))) == null) {
            BufferedImage img = new BufferedImage(w, 6, 2);
            Graphics imgGraphics = ((Image)img).getGraphics();
            Color c = this.progressBar.getForeground();
            Color c2 = ColorRoutines.lighten(c, 15);
            Color c3 = ColorRoutines.lighten(c, 35);
            Color c4 = ColorRoutines.lighten(c, 60);
            imgGraphics.setColor(c4);
            imgGraphics.drawLine(0, 0, 0, 5);
            imgGraphics.drawLine(w - 1, 0, w - 1, 5);
            imgGraphics.setColor(c3);
            imgGraphics.drawLine(1, 0, 1, 5);
            imgGraphics.drawLine(w - 2, 0, w - 2, 5);
            imgGraphics.setColor(c2);
            imgGraphics.drawLine(2, 0, 2, 5);
            imgGraphics.drawLine(w - 3, 0, w - 3, 5);
            imgGraphics.setColor(c);
            imgGraphics.fillRect(3, 0, w - 6, 6);
            imgGraphics.dispose();
            cache.put(key, img);
            value = img;
        }
        for (int my = 0; my < amountFull; my += 8) {
            if (my + 6 > h) {
                g.drawImage((Image)value, 0, 0, w, h - my, this.progressBar);
                continue;
            }
            g.drawImage((Image)value, 0, h - my - 6, this.progressBar);
        }
        g.translate(-x, -y);
    }

    @Override
    protected void paintIndeterminate(Graphics g, JComponent c) {
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        Rectangle boxRect = new Rectangle();
        try {
            boxRect = this.getBox(boxRect);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (this.progressBar.getOrientation() == 0) {
            this.drawXpHorzProgress(g, b.left, b.top, barRectWidth, barRectHeight, boxRect);
        } else {
            this.drawXpVertProgress(g, b.left, b.top, barRectWidth, barRectHeight, boxRect);
        }
        if (this.progressBar.isStringPainted()) {
            if (this.progressBar.getOrientation() == 0) {
                this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, boxRect.width, b);
            } else {
                this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, boxRect.height, b);
            }
        }
    }

    private void drawXpHorzProgress(Graphics g, int x, int y, int w, int h, Rectangle boxRect) {
        if (!this.progressBar.isOpaque()) {
            g.setColor(this.progressBar.getBackground());
            g.fillRect(x, y, w, h);
        }
        g.translate(boxRect.x, boxRect.y);
        ProgressKey key = new ProgressKey(this.progressBar.getForeground(), true, h);
        Object value = cache.get(key);
        if (value == null) {
            BufferedImage img = new BufferedImage(6, h, 2);
            Graphics imgGraphics = ((Image)img).getGraphics();
            Color c = this.progressBar.getForeground();
            Color c2 = ColorRoutines.lighten(c, 15);
            Color c3 = ColorRoutines.lighten(c, 35);
            Color c4 = ColorRoutines.lighten(c, 60);
            imgGraphics.setColor(c4);
            imgGraphics.drawLine(0, 0, 5, 0);
            imgGraphics.drawLine(0, h - 1, 5, h - 1);
            imgGraphics.setColor(c3);
            imgGraphics.drawLine(0, 1, 5, 1);
            imgGraphics.drawLine(0, h - 2, 5, h - 2);
            imgGraphics.setColor(c2);
            imgGraphics.drawLine(0, 2, 5, 2);
            imgGraphics.drawLine(0, h - 3, 5, h - 3);
            imgGraphics.setColor(c);
            imgGraphics.fillRect(0, 3, 6, h - 6);
            imgGraphics.dispose();
            cache.put(key, img);
            value = img;
        }
        int mx = 0;
        while (mx + 6 < boxRect.width) {
            g.drawImage((Image)value, mx, 0, this.progressBar);
            mx += 8;
        }
        g.translate(-boxRect.x, -boxRect.y);
    }

    private void drawXpVertProgress(Graphics g, int x, int y, int w, int h, Rectangle boxRect) {
        if (!this.progressBar.isOpaque()) {
            g.setColor(this.progressBar.getBackground());
            g.fillRect(x, y, w, h);
        }
        g.translate(boxRect.x, boxRect.y);
        ProgressKey key = new ProgressKey(this.progressBar.getForeground(), false, w);
        Object value = cache.get(key);
        if (value == null) {
            BufferedImage img = new BufferedImage(w, 6, 2);
            Graphics imgGraphics = ((Image)img).getGraphics();
            Color c = this.progressBar.getForeground();
            Color c2 = ColorRoutines.lighten(c, 15);
            Color c3 = ColorRoutines.lighten(c, 35);
            Color c4 = ColorRoutines.lighten(c, 60);
            imgGraphics.setColor(c4);
            imgGraphics.drawLine(0, 0, 0, 5);
            imgGraphics.drawLine(w - 1, 0, w - 1, 5);
            imgGraphics.setColor(c3);
            imgGraphics.drawLine(1, 0, 1, 5);
            imgGraphics.drawLine(w - 2, 0, w - 2, 5);
            imgGraphics.setColor(c2);
            imgGraphics.drawLine(2, 0, 2, 5);
            imgGraphics.drawLine(w - 3, 0, w - 3, 5);
            imgGraphics.setColor(c);
            imgGraphics.fillRect(3, 0, w - 6, 6);
            imgGraphics.dispose();
            cache.put(key, img);
            value = img;
        }
        int my = 0;
        while (my + 6 < boxRect.height) {
            g.drawImage((Image)value, 0, my, this.progressBar);
            my += 8;
        }
        g.translate(-boxRect.x, -boxRect.y);
    }

    @Override
    protected Color getSelectionForeground() {
        return Theme.progressSelectForeColor.getColor();
    }

    @Override
    protected Color getSelectionBackground() {
        return Theme.progressSelectBackColor.getColor();
    }

    @Override
    protected void installDefaults() {
        LookAndFeel.installBorder(this.progressBar, "ProgressBar.border");
        LookAndFeel.installColorsAndFont(this.progressBar, "ProgressBar.background", "ProgressBar.foreground", "ProgressBar.font");
    }

    private static class ProgressKey {
        private Color c;
        private boolean horizontal;
        private int size;

        ProgressKey(Color c, boolean horizontal, int size) {
            this.c = c;
            this.horizontal = horizontal;
            this.size = size;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof ProgressKey)) {
                return false;
            }
            ProgressKey other = (ProgressKey)o;
            return this.size == other.size && this.horizontal == other.horizontal && this.c.equals(other.c);
        }

        public int hashCode() {
            return this.c.hashCode() * (this.horizontal ? 1 : 2) * this.size;
        }
    }
}

