/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyUtils;
import de.muntjak.tinylookandfeel.util.ColorRoutines;
import de.muntjak.tinylookandfeel.util.DrawRoutines;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;

public class TinyTabbedPaneUI
extends BasicTabbedPaneUI {
    int rollover = -1;

    public static ComponentUI createUI(JComponent c) {
        return new TinyTabbedPaneUI();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.tabPane.addMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
    }

    @Override
    protected MouseListener createMouseListener() {
        return new TinyMouseHandler();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
    }

    private boolean scrollableTabLayoutEnabled() {
        return this.tabPane.getTabLayoutPolicy() == 1;
    }

    private void checkRollOver(int tabIndex) {
        if (this.rollover >= this.tabPane.getTabCount()) {
            this.rollover = -1;
        }
        if (tabIndex == this.rollover) {
            return;
        }
        if (this.rollover != -1) {
            this.tabPane.repaint(this.getTabBounds(this.tabPane, this.rollover));
            if (tabIndex == -1) {
                this.rollover = -1;
            }
        }
        if (tabIndex >= 0 && this.tabPane.isEnabledAt(tabIndex)) {
            this.rollover = tabIndex;
            this.tabPane.repaint(this.getTabBounds(this.tabPane, tabIndex));
        }
    }

    @Override
    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            return super.createLayoutManager();
        }
        return new TinyTabbedPaneLayout();
    }

    private int getTabAtLocation(int x, int y) {
        if (TinyUtils.is1dot4()) {
            this.ensureCurrentLayout();
            int tabCount = this.tabPane.getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                if (!this.rects[i].contains(x, y)) continue;
                return i;
            }
            return -1;
        }
        return this.tabForCoordinate(this.tabPane, x, y);
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            BasicTabbedPaneUI.TabbedPaneLayout layout = (BasicTabbedPaneUI.TabbedPaneLayout)this.tabPane.getLayout();
            layout.calculateLayoutInfo();
        }
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        boolean isEnabled = this.tabPane.isEnabled() & this.tabPane.isEnabledAt(tabIndex);
        if (isSelected && !Theme.ignoreSelectedBg.getValue()) {
            if (isEnabled) {
                g.setColor(Theme.tabSelectedColor.getColor());
            } else {
                g.setColor(Theme.tabDisabledSelectedColor.getColor());
            }
        } else if (isEnabled) {
            g.setColor(this.tabPane.getBackgroundAt(tabIndex));
        } else {
            g.setColor(Theme.tabDisabledColor.getColor());
        }
        switch (tabPlacement) {
            case 2: {
                g.fillRect(x + 1, y + 1, w - 1, h - 3);
                break;
            }
            case 4: {
                g.fillRect(x -= 2, y + 1, w - 1, h - 3);
                break;
            }
            case 3: {
                g.fillRect(x + 1, y -= 2, w - 3, h - 1);
                break;
            }
            default: {
                g.fillRect(x + 1, y + 1, w - 3, h - 1);
            }
        }
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        if (!Theme.tabFocus.getValue()) {
            return;
        }
        Rectangle tabRect = rects[tabIndex];
        if (this.tabPane.hasFocus() && isSelected) {
            int h;
            int w;
            int y;
            int x;
            g.setColor(Theme.tabFontColor.getColor());
            switch (tabPlacement) {
                case 2: {
                    x = tabRect.x + 3;
                    y = tabRect.y + 3;
                    w = tabRect.width - 5;
                    h = tabRect.height - 7;
                    break;
                }
                case 4: {
                    x = tabRect.x;
                    y = tabRect.y + 3;
                    w = tabRect.width - 5;
                    h = tabRect.height - 7;
                    break;
                }
                case 3: {
                    x = tabRect.x + 3;
                    y = tabRect.y;
                    w = tabRect.width - 7;
                    h = tabRect.height - 5;
                    break;
                }
                default: {
                    x = tabRect.x + 3;
                    y = tabRect.y + 3;
                    w = tabRect.width - 7;
                    h = tabRect.height - 5;
                }
            }
            BasicGraphicsUtils.drawDashedRect(g, x, y, w, h);
        }
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        boolean isEnabled = this.tabPane.isEnabledAt(tabIndex);
        if (!this.tabPane.isEnabled()) {
            isEnabled = false;
        }
        boolean isRollover = this.rollover == tabIndex;
        this.drawXpTabBorder(g, tabPlacement, x, y, w, h, isSelected, isEnabled, isRollover);
    }

    private void drawXpTabBorder(Graphics g, int tabPlacement, int x, int y, int w, int h, boolean isSelected, boolean isEnabled, boolean isRollover) {
        if (!isEnabled) {
            DrawRoutines.drawXpTabBorder(g, Theme.tabDisabledBorderColor.getColor(), x, y, w, h, tabPlacement);
        } else if (isSelected) {
            DrawRoutines.drawSelectedXpTabBorder(g, Theme.tabBorderColor.getColor(), x, y, w, h, tabPlacement);
        } else if (isRollover && Theme.tabRollover.getValue()) {
            DrawRoutines.drawSelectedXpTabBorder(g, Theme.tabBorderColor.getColor(), x, y, w, h, tabPlacement);
        } else {
            DrawRoutines.drawXpTabBorder(g, Theme.tabBorderColor.getColor(), x, y, w, h, tabPlacement);
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Insets insets = this.tabPane.getInsets();
        int x = insets.left;
        int y = insets.top;
        int w = this.tabPane.getWidth() - insets.right - insets.left;
        int h = this.tabPane.getHeight() - insets.top - insets.bottom;
        if (c.isOpaque()) {
            g.setColor(Theme.backColor.getColor());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        int tabPlacement = this.tabPane.getTabPlacement();
        switch (tabPlacement) {
            case 2: {
                w -= (x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                h -= this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                h -= (y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        this.drawXpContentBorder(g, x, y, w, h);
        try {
            super.paint(g, c);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void drawXpContentBorder(Graphics g, int x, int y, int w, int h) {
        if (this.tabPane.isEnabled()) {
            g.setColor(Theme.tabPaneBorderColor.getColor());
        } else {
            g.setColor(Theme.tabPaneDisabledBorderColor.getColor());
        }
        g.drawRect(x, y, w - 3, h - 3);
        g.setColor(ColorRoutines.darken(Theme.backColor.getColor(), 15));
        g.drawLine(x + w - 2, y + 1, x + w - 2, y + h - 2);
        g.drawLine(x + 1, y + h - 2, x + w - 3, y + h - 2);
    }

    @Override
    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        Rectangle tabRect = this.rects[tabIndex];
        int nudge = 0;
        switch (tabPlacement) {
            case 2: {
                nudge = isSelected ? -1 : 1;
                break;
            }
            case 4: {
                nudge = isSelected ? 1 : -1;
                break;
            }
            default: {
                nudge = 0;
            }
        }
        return nudge;
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        Rectangle tabRect = this.rects[tabIndex];
        int nudge = 0;
        switch (tabPlacement) {
            case 3: {
                nudge = isSelected ? 1 : -1;
                break;
            }
            case 2: 
            case 4: {
                nudge = tabRect.height % 2;
                break;
            }
            default: {
                nudge = isSelected ? -1 : 1;
            }
        }
        return nudge;
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title2, Rectangle textRect, boolean isSelected) {
        g.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            v.paint(g, textRect);
        } else {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                g.setColor(this.tabPane.getForegroundAt(tabIndex));
            } else {
                g.setColor(Theme.tabDisabledTextColor.getColor());
            }
            TinyUtils.drawStringUnderlineCharAt(this.tabPane, g, title2, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
        }
    }

    protected class TinyTabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        protected TinyTabbedPaneLayout() {
            super(TinyTabbedPaneUI.this);
        }

        @Override
        protected void rotateTabRuns(int tabPlacement, int selectedRun) {
            if (!Theme.fixedTabs.getValue()) {
                super.rotateTabRuns(tabPlacement, selectedRun);
            }
        }
    }

    public class TinyMouseHandler
    implements MouseListener,
    MouseMotionListener {
        @Override
        public void mousePressed(MouseEvent e) {
            if (!TinyTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int tabIndex = TinyTabbedPaneUI.this.getTabAtLocation(e.getX(), e.getY());
            if (tabIndex >= 0 && TinyTabbedPaneUI.this.tabPane.isEnabledAt(tabIndex)) {
                if (tabIndex != TinyTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                    TinyTabbedPaneUI.this.tabPane.setSelectedIndex(tabIndex);
                } else if (TinyTabbedPaneUI.this.tabPane.isRequestFocusEnabled()) {
                    TinyTabbedPaneUI.this.tabPane.requestFocus();
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (TinyTabbedPaneUI.this.rollover >= TinyTabbedPaneUI.this.tabPane.getTabCount()) {
                TinyTabbedPaneUI.this.rollover = -1;
            }
            if (TinyTabbedPaneUI.this.rollover != -1) {
                TinyTabbedPaneUI.this.tabPane.repaint(TinyTabbedPaneUI.this.getTabBounds(TinyTabbedPaneUI.this.tabPane, TinyTabbedPaneUI.this.rollover));
                TinyTabbedPaneUI.this.rollover = -1;
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (TinyTabbedPaneUI.this.tabPane == null) {
                return;
            }
            if (!TinyTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            if (TinyUtils.is1dot4() && TinyTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                return;
            }
            TinyTabbedPaneUI.this.checkRollOver(TinyTabbedPaneUI.this.getTabAtLocation(e.getX(), e.getY()));
        }
    }
}

