/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.controlpanel;

import de.muntjak.tinylookandfeel.controlpanel.ControlPanel;
import de.muntjak.tinylookandfeel.controlpanel.ParameterSet;
import de.muntjak.tinylookandfeel.controlpanel.ParameterSetGenerator;
import de.muntjak.tinylookandfeel.controlpanel.SBControl;
import de.muntjak.tinylookandfeel.controlpanel.Selectable;
import java.util.Iterator;
import java.util.Vector;

public class Selection
implements ParameterSetGenerator {
    private Vector selection = new Vector();
    private Vector storedSelection;
    private static ControlPanel controlPanel;
    private static Selection onlyInstance;

    private Selection() {
    }

    public static Selection getSelection(ControlPanel cp) {
        controlPanel = cp;
        if (onlyInstance == null) {
            onlyInstance = new Selection();
        }
        return onlyInstance;
    }

    public void add(Selectable control) {
        this.selection.add(control);
        control.setSelected(true);
        if (!Selection.controlPanel.copyItem.isEnabled()) {
            Selection.controlPanel.copyItem.setEnabled(true);
        }
    }

    public boolean remove(Selectable control) {
        control.setSelected(false);
        boolean retVal = this.selection.remove(control);
        if (this.selection.isEmpty() && Selection.controlPanel.copyItem.isEnabled()) {
            Selection.controlPanel.copyItem.setEnabled(false);
        }
        return retVal;
    }

    public void clearSelection() {
        if (this.selection.isEmpty()) {
            return;
        }
        Iterator ii = this.selection.iterator();
        while (ii.hasNext()) {
            ((Selectable)ii.next()).setSelected(false);
        }
        this.selection.clear();
        if (Selection.controlPanel.copyItem.isEnabled()) {
            Selection.controlPanel.copyItem.setEnabled(false);
        }
    }

    public ParameterSet createParameterSet() {
        this.storedSelection = (Vector)this.selection.clone();
        ParameterSet ps = new ParameterSet(this, "");
        for (Object control : this.storedSelection) {
            if (control instanceof ControlPanel.HSBControl) {
                ps.addParameter((ControlPanel.HSBControl)control);
                continue;
            }
            if (control instanceof SBControl) {
                ps.addParameter((SBControl)control);
                continue;
            }
            if (!(control instanceof ControlPanel.SpreadControl)) continue;
            ps.addParameter((ControlPanel.SpreadControl)control);
        }
        return ps;
    }

    @Override
    public ParameterSet getParameterSet() {
        ParameterSet ps = new ParameterSet(this, "Selection");
        for (Object control : this.storedSelection) {
            if (control instanceof ControlPanel.HSBControl) {
                ps.addParameter((ControlPanel.HSBControl)control);
                continue;
            }
            if (control instanceof SBControl) {
                ps.addParameter((SBControl)control);
                continue;
            }
            if (!(control instanceof ControlPanel.SpreadControl)) continue;
            ps.addParameter((ControlPanel.SpreadControl)control);
        }
        return ps;
    }

    @Override
    public void init(boolean ignored) {
        for (Object control : this.storedSelection) {
            if (control instanceof ControlPanel.HSBControl) {
                ((ControlPanel.HSBControl)control).update();
                continue;
            }
            if (control instanceof SBControl) {
                ((SBControl)control).update();
                continue;
            }
            if (!(control instanceof ControlPanel.SpreadControl)) continue;
            ((ControlPanel.SpreadControl)control).init();
        }
    }
}

