/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.controlpanel;

import de.muntjak.tinylookandfeel.controlpanel.NonSortableTableModel;
import de.muntjak.tinylookandfeel.table.SortableTableData;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JTable;

public class TinyTableModel
extends NonSortableTableModel
implements SortableTableData {
    public TinyTableModel() {
        super(true);
    }

    @Override
    public boolean isColumnSortable(int column) {
        if (this.data.isEmpty()) {
            return false;
        }
        Object val = this.getValueAt(0, column);
        return val instanceof Comparable || val instanceof Boolean;
    }

    @Override
    public boolean supportsMultiColumnSort() {
        return true;
    }

    @Override
    public void sortColumns(final int[] columns, final int[] sortingDirections, JTable table) {
        int i;
        int[] sr = table.getSelectedRows();
        int[] sc = table.getSelectedColumns();
        int rowIndex = 0;
        Iterator ii = this.data.iterator();
        while (ii.hasNext()) {
            ((NonSortableTableModel.Record)ii.next()).setOldRow(rowIndex++);
        }
        if (columns.length == 0) {
            Collections.sort(this.data, new Comparator(){

                public int compare(Object o1, Object o2) {
                    NonSortableTableModel.Record r1 = (NonSortableTableModel.Record)o1;
                    NonSortableTableModel.Record r2 = (NonSortableTableModel.Record)o2;
                    Comparable val1 = (Comparable)r1.getValueAt(0);
                    Comparable val2 = (Comparable)r2.getValueAt(0);
                    return val1.compareTo(val2);
                }
            });
        } else {
            Collections.sort(this.data, new Comparator(){

                public int compare(Object o1, Object o2) {
                    NonSortableTableModel.Record r1 = (NonSortableTableModel.Record)o1;
                    NonSortableTableModel.Record r2 = (NonSortableTableModel.Record)o2;
                    for (int i = 0; i < columns.length; ++i) {
                        Object v1 = r1.getValueAt(columns[i]);
                        Object v2 = r2.getValueAt(columns[i]);
                        int result = 0;
                        if (v1 instanceof Comparable) {
                            result = ((Comparable)v1).compareTo((Comparable)v2);
                        } else if (v1 instanceof Boolean && !v1.equals(v2)) {
                            result = Boolean.TRUE.equals(v1) ? 1 : -1;
                        }
                        if (result == 0) continue;
                        if (sortingDirections[i] == 2) {
                            return -result;
                        }
                        return result;
                    }
                    return 0;
                }
            });
        }
        this.fireTableDataChanged();
        rowIndex = 0;
        ii = this.data.iterator();
        while (ii.hasNext()) {
            ((NonSortableTableModel.Record)ii.next()).setNewRow(rowIndex++);
        }
        Vector temp = (Vector)this.data.clone();
        Collections.sort(temp, new Comparator(){

            public int compare(Object o1, Object o2) {
                NonSortableTableModel.Record r1 = (NonSortableTableModel.Record)o1;
                NonSortableTableModel.Record r2 = (NonSortableTableModel.Record)o2;
                if (r1.getOldRow() > r2.getOldRow()) {
                    return 1;
                }
                return -1;
            }
        });
        for (i = 0; i < sr.length; ++i) {
            int row = ((NonSortableTableModel.Record)temp.get(sr[i])).getNewRow();
            table.addRowSelectionInterval(row, row);
        }
        for (i = 0; i < sc.length; ++i) {
            table.addColumnSelectionInterval(sc[i], sc[i]);
        }
    }
}

