;
;
; Example DS2430A code
;
;
; Copyright (c) 2003 Alex Herbert
;
;



; Memory Base Addresses

GAMCRT  equ     $0000   ; Cartridge ROM ($0000-$7fff = 32k)
RAM     equ     $c800   ; Internal RAM  ($c800-$cbff = 1k)
LASRAM  equ     $c880   ; Free RAM      ($c880-stack)
PWRUP   equ     $f000   ; Executive ROM ($f000-$ffff = 4k)


; PIA Registers

CNTRL   equ     $d000   ; ORB / IRB - Output Register B / Input Register B
DAC     equ     $d001   ; ORA / IRA - Output Register A / Input Register A
DCNTRL  equ     $d002   ; DDRB      - Data Direction Register B
DDAC    equ     $d003   ; DDRA      - Data Direction Register A
T1LOLC  equ     $d004   ; T1C-L     - Timer 1 Counter/Latch Low byte
T1HOC   equ     $d005   ; T1C-H     - Timer 1 Counter High byte
T1LOL   equ     $d006   ; T1L-L     - Timer 1 Latch Low byte
T1HOL   equ     $d007   ; T1L-H     - Timer 1 Latch High byte
T2LOLC  equ     $d008   ; T2C-L     - Timer 2 Counter/Latch Low byte
T2HOC   equ     $d009   ; T2C-H     - Timer 2 Counter High byte
SHIFT   equ     $d00a   ; SR        - Shift Register
ACNTRL  equ     $d00b   ; ACR       - Auxiliary Control Register
PCNTRL  equ     $d00c   ; PCR       - Peripheral Control Register
IFLAG   equ     $d00d   ; IFR       - Interrupt Flag Register
IENABL  equ     $d00e   ; IER       - Interrupt Enable Register


; Direct Page Macros

DP_RAM  macro
        lda     #RAM>>8
        tfr     a,dp
        direct  RAM
        endm

DP_IO   macro
        lda     #CNTRL>>8
        tfr     a,dp
        direct  CNTRL
        endm





; EEPROM constants

EEPROM_CHECKSUM equ     $87             ; any value other than $00 or $e0




; Include the diver files

        include "ds1w.i"
        include "ds2430ls.i"
        include "ds2430v.i"




; Variables (assumes bss segment is defined)

        bss


eeprom_buffer   ds      32              ; 32 byte buffer



; The code (assumes code segment is defined)

        code


eeprom_load
        ldx     #eeprom_buffer          ;
        jsr     ds2430_load             ; load 32 byte eeprom to ram

        ldd     #$0020                  ;
eeload_loop                             ;
        adda    ,x+                     ; sum the bytes
        decb                            ;
        bne     eeload_loop             ;

        cmpa    #EEPROM_CHECKSUM        ; equal to checksum?
        bne     eeprom_format           ; if not, then format the eeprom

        rts                             ; otherwise, return


eeprom_format
        ldu     #eeprom_defaults        ;
        ldx     #eeprom_buffer          ;
        ldb     #$1f                    ;
eeformat_loop                           ; copy default data (rom) to ram
        pulu    a                       ;
        sta     ,x+                     ;
        decb                            ;
        bne     eeformat_loop           ;


eeprom_save
        ldx     #eeprom_buffer          ;
        ldd     #(EEPROM_CHECKSUM<<8)+$1f ;
eesave_loop                             ;
        suba    ,x+                     ; create checksum byte
        decb                            ;
        bne     eesave_loop             ;
        sta     ,x                      ;

        ldx     #eeprom_buffer          ;
        jsr     ds2430_verify           ; compare ram to eeprom
        tsta                            ;
        bne     ds2430_save             ; if different, then update eeprom

        rts



; Data

eeprom_defaults

        ; Put 31 bytes of default data here!




